/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.entity.reentry.EmpnumberAndStartDateEntity;

public class EmpnumberLinkedBuilder {
    private static final Log LOGGER = LogFactory.getLog(EmpnumberLinkedBuilder.class);
    private final DynamicObjectCollection dyColl = new DynamicObjectCollection();
    private final Set<EmpnumberAndStartDateEntity> sourceEmpnumberSet = new HashSet<EmpnumberAndStartDateEntity>(16);
    private final Map<EmpnumberAndStartDateEntity, DynamicObject> headMaps = new HashMap<EmpnumberAndStartDateEntity, DynamicObject>(16);
    private final Map<EmpnumberAndStartDateEntity, DynamicObject> tailMaps = new HashMap<EmpnumberAndStartDateEntity, DynamicObject>(16);
    private final List<LinkedList<EmpnumberAndStartDateEntity>> empnumberLinkedList = new ArrayList<LinkedList<EmpnumberAndStartDateEntity>>(16);
    private final Set<EmpnumberAndStartDateEntity> newestEmpnumberSet = new HashSet<EmpnumberAndStartDateEntity>(16);
    private final Set<EmpnumberAndStartDateEntity> earlyEmpnumberSet = new HashSet<EmpnumberAndStartDateEntity>(16);
    private final Set<EmpnumberAndStartDateEntity> allEmpnumberSet = new HashSet<EmpnumberAndStartDateEntity>(16);
    private final Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> empnumberRelateMap = new HashMap<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity>(16);

    public static EmpnumberLinkedBuilder memoryBuild(DynamicObjectCollection dyColl) {
        EmpnumberLinkedBuilder empnumberLinkedBuilder = new EmpnumberLinkedBuilder();
        empnumberLinkedBuilder.dyColl.addAll((Collection)dyColl);
        empnumberLinkedBuilder.init();
        empnumberLinkedBuilder.addLinkedList();
        return empnumberLinkedBuilder;
    }

    void init() {
        for (DynamicObject dy : this.dyColl) {
            this.headMaps.put(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dy), dy);
            this.tailMaps.put(EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dy), dy);
            this.sourceEmpnumberSet.add(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dy));
        }
    }

    private void addLinkedList() {
        for (int index = 0; !this.headMaps.isEmpty() && !this.tailMaps.isEmpty() && index < this.dyColl.size(); ++index) {
            DynamicObject dy = (DynamicObject)this.dyColl.get(index);
            EmpnumberAndStartDateEntity head = EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dy);
            EmpnumberAndStartDateEntity tail = EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dy);
            if (!this.headMaps.containsKey(head) || !this.tailMaps.containsKey(tail)) continue;
            LinkedList<EmpnumberAndStartDateEntity> linkedList = new LinkedList<EmpnumberAndStartDateEntity>();
            linkedList.addFirst(head);
            linkedList.addLast(tail);
            this.headMaps.remove(head);
            this.tailMaps.remove(tail);
            this.addLastLink(linkedList);
            this.addFirstLink(linkedList);
            this.empnumberLinkedList.add(linkedList);
        }
    }

    private void addLastLink(LinkedList<EmpnumberAndStartDateEntity> linkedList) {
        while (!this.headMaps.isEmpty()) {
            EmpnumberAndStartDateEntity tail = linkedList.getLast();
            DynamicObject nextItem = this.headMaps.get(tail);
            if (nextItem == null) {
                return;
            }
            linkedList.addLast(EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)nextItem));
            this.headMaps.remove(tail);
            this.tailMaps.remove(EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)nextItem));
            this.tailMaps.remove(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)nextItem));
        }
    }

    private void addFirstLink(LinkedList<EmpnumberAndStartDateEntity> linkedList) {
        while (!this.tailMaps.isEmpty()) {
            EmpnumberAndStartDateEntity head = linkedList.getFirst();
            DynamicObject prevItem = this.tailMaps.get(head);
            if (prevItem == null) {
                return;
            }
            linkedList.addFirst(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)prevItem));
            this.tailMaps.remove(head);
            this.headMaps.remove(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)prevItem));
            this.headMaps.remove(EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)prevItem));
        }
    }

    private void addRecordIndexList() {
        this.empnumberLinkedList.forEach(empnumberLinked -> {
            this.newestEmpnumberSet.add((EmpnumberAndStartDateEntity)empnumberLinked.getFirst());
            this.earlyEmpnumberSet.add((EmpnumberAndStartDateEntity)empnumberLinked.getLast());
            this.allEmpnumberSet.addAll((Collection<EmpnumberAndStartDateEntity>)empnumberLinked);
            for (int i = 0; i < empnumberLinked.size() - 1; ++i) {
                this.empnumberRelateMap.put((EmpnumberAndStartDateEntity)empnumberLinked.get(i), (EmpnumberAndStartDateEntity)empnumberLinked.get(i + 1));
            }
        });
    }

    public List<EmpnumberAndStartDateEntity> getEmpnumberLinked(EmpnumberAndStartDateEntity empnumber) {
        for (LinkedList<EmpnumberAndStartDateEntity> empnumberLinked : this.empnumberLinkedList) {
            if (!empnumberLinked.contains(empnumber)) continue;
            return empnumberLinked;
        }
        return null;
    }

    public List<EmpnumberAndStartDateEntity> getEmpnumberLinked(String empnumber) {
        for (LinkedList<EmpnumberAndStartDateEntity> empnumberLinked : this.empnumberLinkedList) {
            for (EmpnumberAndStartDateEntity empnumberAndStartDateEntity : empnumberLinked) {
                if (!HRStringUtils.equals((String)empnumberAndStartDateEntity.getEmpnumber(), (String)empnumber)) continue;
                return empnumberLinked;
            }
        }
        return null;
    }

    public DynamicObjectCollection getDyColl() {
        return this.dyColl;
    }

    public boolean containsSourceEmpnumberSet(EmpnumberAndStartDateEntity empnumber) {
        return this.sourceEmpnumberSet.contains(empnumber);
    }

    public Set<EmpnumberAndStartDateEntity> getNewestEmpnumberSet() {
        return this.newestEmpnumberSet;
    }

    public Set<EmpnumberAndStartDateEntity> getEarlyEmpnumberSet() {
        return this.earlyEmpnumberSet;
    }

    public Set<EmpnumberAndStartDateEntity> getAllEmpnumberSet() {
        return this.allEmpnumberSet;
    }

    public Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> getEmpnumberRelateMap() {
        return this.empnumberRelateMap;
    }

    private void clear() {
        this.headMaps.clear();
        this.tailMaps.clear();
        this.empnumberLinkedList.clear();
        this.newestEmpnumberSet.clear();
        this.earlyEmpnumberSet.clear();
    }

    public void refreshDB(String entityNumber, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        this.clear();
        this.init();
        this.addLinkedList();
        this.queryNewestEmpnumberFromDb(entityNumber, personGenericContext);
        this.queryEarlyEmpnumberFromDb(entityNumber, personGenericContext);
        this.addRecordIndexList();
    }

    private void queryNewestEmpnumberFromDb(String entityNumber, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> newestEmpnumberMap = this.empnumberLinkedList.stream().collect(Collectors.toMap(LinkedList::getFirst, empnumberLinked -> empnumberLinked));
        while (!newestEmpnumberMap.isEmpty()) {
            DynamicObject[] empnumberDyArr = this.queryEmpentrel(newestEmpnumberMap);
            Map<EmpnumberAndStartDateEntity, DynamicObject> existsNumberDyMap = Arrays.stream(empnumberDyArr).collect(Collectors.toMap(EmpnumberAndStartDateEntity::buildEmp, dy -> dy));
            Set<Long> employeeIdSet = Arrays.stream(empnumberDyArr).filter(empentrelDy -> empentrelDy.getLong("employee.id") > 0L).map(empentrelDy -> empentrelDy.getLong("employee.id")).collect(Collectors.toSet());
            DynamicObject[] newestEmpnumberDyArr = this.queryNewestEmpnumberDyArr(employeeIdSet);
            HashMap<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> relaceEmpnumberLinkMap = new HashMap<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>>(16);
            if (newestEmpnumberDyArr != null && newestEmpnumberDyArr.length > 0) {
                Map<Long, List<DynamicObject>> newestEmpnumberDyListMap = Arrays.stream(newestEmpnumberDyArr).collect(Collectors.groupingBy(dy -> dy.getLong("preemployee.id")));
                for (Map.Entry<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> entry : newestEmpnumberMap.entrySet()) {
                    EmpnumberAndStartDateEntity oldempnumberEntity = entry.getKey();
                    LinkedList<EmpnumberAndStartDateEntity> newestEmpnumberList = entry.getValue();
                    DynamicObject empentrelDy2 = existsNumberDyMap.get(oldempnumberEntity);
                    List<DynamicObject> dbEmpnumberDyList = newestEmpnumberDyListMap.get(empentrelDy2.getLong("employee.id"));
                    if (CollectionUtils.isEmpty(dbEmpnumberDyList)) {
                        LOGGER.info("PersonGenericService ==> EmpnumberLinkedBuilder#queryNewestEmpnumberFromDb the entityNumber: {} newestEmpnumber\uff1a {}.", (Object)entityNumber, (Object)oldempnumberEntity);
                        continue;
                    }
                    if (dbEmpnumberDyList.size() > 1) {
                        List errorMsgList = dbEmpnumberDyList.stream().map(dy -> String.format("empnumber:%1$s\uff0coldempnumber:%2$s\uff0cstartdate:%3$s", dy.getString("empnumber"), dy.getString("oldempnumber"), HRDateTimeUtils.formatDate((Date)dy.getDate("startdate")))).collect(Collectors.toList());
                        for (EmpnumberAndStartDateEntity circulaErrrorEmpnumber : newestEmpnumberList) {
                            LOGGER.info("PersonGenericService ==> EmpnumberLinkedBuilder#queryNewestEmpnumberFromDb the entityNumber: {} circularrrorEmpnumber\uff1a {}.", (Object)entityNumber, (Object)circulaErrrorEmpnumber);
                            personGenericContext.addErrorMsg(entityNumber, (Object)circulaErrrorEmpnumber, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\uff08%1$s\uff09\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u591a\u6761\u6570\u636e\uff0c\u51b2\u7a81\u8bb0\u5f55\u4e3a\uff1a%2$s\u3002", (String)"EmpnumberLinkedBuilder_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]), oldempnumberEntity, errorMsgList));
                        }
                        continue;
                    }
                    DynamicObject dbDy = dbEmpnumberDyList.get(0);
                    EmpnumberAndStartDateEntity dbNewestEmpnumber = EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dbDy);
                    newestEmpnumberList.addFirst(dbNewestEmpnumber);
                    relaceEmpnumberLinkMap.put(dbNewestEmpnumber, newestEmpnumberList);
                }
            }
            newestEmpnumberMap.clear();
            newestEmpnumberMap.putAll(relaceEmpnumberLinkMap);
        }
    }

    private DynamicObject[] queryNewestEmpnumberDyArr(Set<Long> employeeIdSet) {
        if (CollectionUtils.isEmpty(employeeIdSet)) {
            return null;
        }
        return HRBaseDaoFactory.getInstance((String)"hrpi_empentrel").query("empnumber,oldempnumber,startdate,employee,preemployee", new QFilter[]{new QFilter("preemployee", "in", employeeIdSet), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
    }

    private void queryEarlyEmpnumberFromDb(String entityNumber, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> earlyEmpnumberMap = this.empnumberLinkedList.stream().collect(Collectors.toMap(LinkedList::getLast, empnumberLinked -> empnumberLinked));
        while (!earlyEmpnumberMap.isEmpty()) {
            DynamicObject[] empnumberDyArr = this.queryEmpentrel(earlyEmpnumberMap);
            Map<EmpnumberAndStartDateEntity, DynamicObject> existsNumberDyMap = Arrays.stream(empnumberDyArr).collect(Collectors.toMap(EmpnumberAndStartDateEntity::buildEmp, dy -> dy));
            Set<Long> preemployeeIdSet = Arrays.stream(empnumberDyArr).filter(empentrelDy -> empentrelDy.getLong("preemployee.id") > 0L).map(empentrelDy -> empentrelDy.getLong("preemployee.id")).collect(Collectors.toSet());
            DynamicObject[] earlyEmpnumberDyArr = this.queryEarlyEmpnumberDyArr(preemployeeIdSet);
            HashMap<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> relaceEmpnumberLinkMap = new HashMap<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>>(16);
            if (earlyEmpnumberDyArr != null && earlyEmpnumberDyArr.length > 0) {
                Map<Long, DynamicObject> earlyEmpnumberDyMap = Arrays.stream(earlyEmpnumberDyArr).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy));
                for (Map.Entry<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> entry : earlyEmpnumberMap.entrySet()) {
                    EmpnumberAndStartDateEntity empnumberEntity = entry.getKey();
                    LinkedList<EmpnumberAndStartDateEntity> earlyEmpnumberList = entry.getValue();
                    DynamicObject empentrelDy2 = existsNumberDyMap.get(empnumberEntity);
                    DynamicObject dbDy = earlyEmpnumberDyMap.get(empentrelDy2.getLong("preemployee.id"));
                    if (dbDy == null) {
                        LOGGER.info("PersonGenericService ==> EmpnumberLinkedBuilder#queryEarlyEmpnumberFromDb the entityNumber: {} earlyEmpnumber\uff1a {}.", (Object)entityNumber, (Object)empnumberEntity);
                        continue;
                    }
                    EmpnumberAndStartDateEntity dbEarlyEmpnumber = EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dbDy);
                    earlyEmpnumberList.addLast(dbEarlyEmpnumber);
                    relaceEmpnumberLinkMap.put(dbEarlyEmpnumber, earlyEmpnumberList);
                }
            }
            earlyEmpnumberMap.clear();
            earlyEmpnumberMap.putAll(relaceEmpnumberLinkMap);
        }
    }

    private DynamicObject[] queryEmpentrel(Map<EmpnumberAndStartDateEntity, LinkedList<EmpnumberAndStartDateEntity>> empnumberMap) {
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberMap.keySet());
        return HRBaseDaoFactory.getInstance((String)"hrpi_empentrel").query("empnumber,startdate,enddate,oldempnumber,preemployee,employee", new QFilter[]{empQfilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
    }

    private DynamicObject[] queryEarlyEmpnumberDyArr(Set<Long> preemployeeIdSet) {
        if (CollectionUtils.isEmpty(preemployeeIdSet)) {
            return null;
        }
        return HRBaseDaoFactory.getInstance((String)"hrpi_empentrel").query("empnumber,oldempnumber,startdate,employee,preemployee", new QFilter[]{new QFilter("employee", "in", preemployeeIdSet), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
    }
}

