/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IScopeCheck;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.entity.validate.ScopeValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hrpi.business.domian.service.generic.validate.IPersonGenericValidateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractPersonGenericSaveValidateService
implements IPersonGenericValidateService {
    private static final Log LOGGER = LogFactory.getLog(AbstractPersonGenericSaveValidateService.class);
    private static final char SPLIT_LEVEL_CHAR = '-';

    @Override
    public void validate(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        this.commonValidate(entityNumber, dyColl, personGenericContext);
        this.dbValidate(entityNumber, dyColl, personGenericContext);
        this.specialValidate(entityNumber, dyColl, personGenericContext);
    }

    protected void commonValidate(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        for (DynamicObject dynamicObject : dyColl) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            try {
                this.mustInputAndScopeValidate(entityNumber, dynamicObject, errorMsgBuilder);
                this.customValidate(entityNumber, dynamicObject, errorMsgBuilder);
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> AbstractPersonGenericValidateService#commonValidate error, the dynamicObject is {}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)dynamicObject));
                LOGGER.error("PersonGenericService ==> AbstractPersonGenericValidateService#commonValidate occur exception", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericValidateService#commonValidate the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, dynamicObject.get(personGenericContext.getErrorKey(entityNumber)), errorMsgBuilder.toString());
        }
    }

    protected void mustInputAndScopeValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        DataEntityPropertyCollection dataEntityProperties = dynamicObject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            Object value;
            boolean enableNull = dataEntityProperty.isEnableNull();
            boolean dbIgnore = dataEntityProperty.isDbIgnore();
            if (!(dataEntityProperty instanceof BasedataProp) && dbIgnore) continue;
            LOGGER.info("mustInputAndScopeValidate#dataEntityProperty {}", (Object)dataEntityProperty);
            Object object = value = dataEntityProperty instanceof BasedataProp ? Long.valueOf(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (BasedataProp)((BasedataProp)dataEntityProperty))) : dataEntityProperty.getValue((Object)dynamicObject);
            if (!(dataEntityProperty instanceof IValidatorHanlder)) continue;
            IValidatorHanlder validatorHanlder = (IValidatorHanlder)dataEntityProperty;
            List validators = validatorHanlder.getValidators();
            boolean isNotEmpty = this.isNotEmpty(enableNull, validatorHanlder, value);
            for (AbstractValidator validator : validators) {
                if (validator instanceof RequiredValidator) {
                    RequiredValidator requiredValidator = (RequiredValidator)validator;
                    if (dataEntityProperty instanceof MuliLangTextProp || isNotEmpty) {
                        String errorMsg;
                        if (!(dataEntityProperty instanceof MuliLangTextProp)) continue;
                        List mustInputLang = null == requiredValidator.getValidateContext() ? new ArrayList() : requiredValidator.getValidateContext().getMustInputLang();
                        ArrayList<String> mustInputLan = new ArrayList<String>();
                        String defaultLanValue = ((ILocaleString)value).getLocaleValue();
                        if (StringUtils.isBlank((CharSequence)defaultLanValue)) {
                            mustInputLan.add(Lang.get().getLangTag().replace('-', '_'));
                        }
                        if (CollectionUtils.isNotEmpty(mustInputLang)) {
                            for (String lan : mustInputLang) {
                                if (StringUtils.isBlank((Object)value)) {
                                    String errorMsg2 = this.buildIsMustErrorMessage(dataEntityProperty);
                                    errorMsgBuilder.append(errorMsg2);
                                    continue;
                                }
                                String valuelan = (String)((ILocaleString)value).get((Object)lan);
                                if (!StringUtils.isBlank((CharSequence)valuelan) || mustInputLan.contains(lan)) continue;
                                mustInputLan.add(lan);
                            }
                            if (mustInputLan.isEmpty()) continue;
                            errorMsg = this.buildIsMustErrorMessage(dataEntityProperty, mustInputLan);
                            errorMsgBuilder.append(errorMsg);
                            continue;
                        }
                        if (enableNull || !this.isEmpty(validatorHanlder, value)) continue;
                        errorMsg = !mustInputLan.isEmpty() ? this.buildIsMustErrorMessage(dataEntityProperty, mustInputLan) : this.buildIsMustErrorMessage(dataEntityProperty);
                        errorMsgBuilder.append(errorMsg);
                        continue;
                    }
                    String errorMsg = this.buildIsMustErrorMessage(dataEntityProperty);
                    errorMsgBuilder.append(errorMsg);
                    continue;
                }
                if (!(validator instanceof ScopeValidator)) continue;
                boolean checkScope = this.checkScope(dataEntityProperty, value);
                if (!isNotEmpty || checkScope) continue;
                IScopeCheck scopeCheck = (IScopeCheck)dataEntityProperty;
                String errMessage = scopeCheck.getDataScopeMessage(value);
                errorMsgBuilder.append(errMessage);
            }
        }
    }

    protected boolean isMustInput(IDataEntityProperty dataEntityProperty) {
        boolean mustInput = false;
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            mustInput = basedataProp.isMustInput();
        } else if (dataEntityProperty instanceof FieldProp) {
            FieldProp fieldProp = (FieldProp)dataEntityProperty;
            mustInput = fieldProp.isMustInput();
        } else if (dataEntityProperty instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dataEntityProperty;
            mustInput = entryProp.isEntryMustInput();
        }
        return mustInput;
    }

    protected boolean isEmpty(IValidatorHanlder validatorHanlder, Object value) {
        return validatorHanlder.getValueComparator().compareValue(value);
    }

    protected boolean isNotEmpty(boolean enableNull, IValidatorHanlder validatorHanlder, Object value) {
        return !(!enableNull && validatorHanlder.getValueComparator().compareValue(value) || enableNull && value == null);
    }

    protected boolean checkScope(IDataEntityProperty dataEntityProperty, Object value) {
        boolean checkScope = true;
        if (dataEntityProperty instanceof IScopeCheck) {
            IScopeCheck scopeCheck = (IScopeCheck)dataEntityProperty;
            checkScope = scopeCheck.checkScope(value);
        }
        return checkScope;
    }

    protected void customValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        IValidatorHanlder validatorHanlder;
        DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
        long id = dynamicObject.getLong("id");
        if (id == 0L) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"id")));
        }
        if (properties.containsKey((Object)"person") && this.isEmpty(validatorHanlder = (IValidatorHanlder)properties.get((Object)"person"), HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person"))) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"person")));
        }
        if (properties.containsKey((Object)"employee") && this.isEmpty(validatorHanlder = (IValidatorHanlder)properties.get((Object)"employee"), HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee"))) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"employee")));
        }
        if (properties.containsKey((Object)"cmpemp") && this.isEmpty(validatorHanlder = (IValidatorHanlder)properties.get((Object)"cmpemp"), HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"cmpemp"))) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"cmpemp")));
        }
        if (properties.containsKey((Object)"depemp") && this.isEmpty(validatorHanlder = (IValidatorHanlder)properties.get((Object)"depemp"), HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"depemp"))) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"depemp")));
        }
    }

    protected String buildIsMustErrorMessage(IDataEntityProperty dataEntityProperty) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"AbstractPersonGenericValidateService_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]), dataEntityProperty.getDisplayName());
    }

    protected String buildIsMustErrorMessage(IDataEntityProperty dataEntityProperty, List<String> langBillParams) {
        String promptLang = ValidateContext.switchLang(langBillParams);
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"AbstractPersonGenericValidateService_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), dataEntityProperty.getDisplayName(), promptLang);
    }

    protected String buildComboScopeErrorMessage(IDataEntityProperty dataEntityProperty) {
        return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u8f93\u5165\u503c\u4e0d\u5728\u8303\u56f4\u5185\u3002", (String)"AbstractPersonGenericValidateService_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]), dataEntityProperty.getDisplayName());
    }

    protected abstract void dbValidate(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    protected abstract void specialValidate(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);
}

