/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.HRPositionServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.util.HrpiEmpposorgrelGenericUtil;
import kd.hrmp.hrpi.business.domian.service.impl.generic.validate.PersonGenericSaveTimeValidateServiceImpl;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.collections.MapUtils;

public class HrpiEmpposorgrelGenericSaveValidateServiceImpl
extends PersonGenericSaveTimeValidateServiceImpl {
    private static final Log LOGGER = LogFactory.getLog(HrpiEmpposorgrelGenericSaveValidateServiceImpl.class);

    public static HrpiEmpposorgrelGenericSaveValidateServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected void customValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        super.customValidate(entityNumber, dynamicObject, errorMsgBuilder);
        this.doApositiontypeCustomValidate(entityNumber, dynamicObject, errorMsgBuilder);
    }

    private void doApositiontypeCustomValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
        String apositiontype = dynamicObject.getString("apositiontype");
        if (HRStringUtils.isEmpty((String)apositiontype)) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"apositiontype")));
            return;
        }
        if (HRStringUtils.equals((String)"0", (String)apositiontype) && HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"stdposition") == 0L) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"stdposition")));
        }
        if (HRStringUtils.equals((String)"2", (String)apositiontype) && HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"job") == 0L) {
            errorMsgBuilder.append(this.buildIsMustErrorMessage((IDataEntityProperty)properties.get((Object)"job")));
        }
    }

    @Override
    protected void specialValidate(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        super.specialValidate(entityNumber, dyColl, personGenericContext);
        ArrayList addDarkPosParam = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        ArrayList addDarkPosByJobParam = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        HashMap addDarkPosMap = Maps.newHashMapWithExpectedSize((int)dyColl.size());
        for (DynamicObject dynamicObject : dyColl) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            try {
                this.doPositionSpecialValidate(dynamicObject, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam);
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> HrpiEmpposorgrelGenericSaveValidateServiceImpl#specialValidate error!", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveValidateServiceImpl#specialValidate the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, (Object)dynamicObject.getLong("id"), errorMsgBuilder.toString());
        }
        this.executePositionValidate(entityNumber, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam, personGenericContext);
    }

    private void doPositionSpecialValidate(DynamicObject dynamicObject, Map<String, DynamicObject> addDarkPosMap, List<Map<String, Object>> addDarkPosParam, List<Map<String, Object>> addDarkPosByJobParam) {
        HrpiEmpposorgrelGenericUtil.doPositionParam(dynamicObject, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam);
    }

    private void executePositionValidate(String entityNumber, Map<String, DynamicObject> addDarkPosMap, List<Map<String, Object>> addDarkPosParam, List<Map<String, Object>> addDarkPosByJobParam, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<String, Map<String, Object>> darkPosMap = HRPositionServiceImpl.getInstance().validateDarkPosByStdPos(addDarkPosParam);
        Map<String, Map<String, Object>> darkPosByJobMap = HRPositionServiceImpl.getInstance().validateDarkPosByJob(addDarkPosByJobParam);
        for (Map.Entry<String, DynamicObject> addDarkPosEntry : addDarkPosMap.entrySet()) {
            Map<String, Object> darkPosByJobResult;
            StringBuilder errorMsgBuilder = new StringBuilder();
            String key = addDarkPosEntry.getKey();
            DynamicObject dynamicObject = addDarkPosEntry.getValue();
            Map<String, Object> darkPosResult = darkPosMap.get(key);
            if (darkPosResult != null && !MapUtils.getBoolean(darkPosResult, (Object)"isSuccess").booleanValue()) {
                errorMsgBuilder.append(MapUtils.getString(darkPosResult, (Object)"errorMsg"));
            }
            if ((darkPosByJobResult = darkPosByJobMap.get(key)) != null && !MapUtils.getBoolean(darkPosByJobResult, (Object)"isSuccess").booleanValue()) {
                errorMsgBuilder.append(MapUtils.getString(darkPosResult, (Object)"errorMsg"));
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveValidateServiceImpl#executePositionValidate the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, dynamicObject.get(personGenericContext.getErrorKey(entityNumber)), errorMsgBuilder.toString());
        }
    }

    private static class Holder {
        static final HrpiEmpposorgrelGenericSaveValidateServiceImpl INSTANCE = new HrpiEmpposorgrelGenericSaveValidateServiceImpl();

        private Holder() {
        }
    }
}

