/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.validate;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.IScopeCheck;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.util.EmpnumberLinkedBuilder;
import kd.hrmp.hrpi.business.domian.service.impl.generic.validate.AbstractPersonGenericSaveValidateService;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.entity.reentry.EmpnumberAndStartDateEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.hrmp.hrpi.common.util.PersonGenericUtil;

public class HrpiReentryrelateGenericSaveValidateServiceImpl
extends AbstractPersonGenericSaveValidateService {
    private static final Log LOGGER = LogFactory.getLog(HrpiReentryrelateGenericSaveValidateServiceImpl.class);
    private static final String NUMBER_MATCH_PATTERN = ".*-R\\d+$";
    private static final String INHERITNUMBER_YES = "2";

    public static HrpiReentryrelateGenericSaveValidateServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected void commonValidate(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        for (DynamicObject dynamicObject : dyColl) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            try {
                this.mustInputAndScopeValidate(entityNumber, dynamicObject, errorMsgBuilder);
                this.customValidate(entityNumber, dynamicObject, errorMsgBuilder);
            }
            catch (Exception e) {
                LOGGER.error("commonValidate occur exception", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#commonValidate the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, (Object)EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dynamicObject), errorMsgBuilder.toString());
        }
    }

    @Override
    protected void mustInputAndScopeValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#mustInputAndScopeValidate {}", (Object)entityNumber);
        DataEntityPropertyCollection dataEntityProperties = dynamicObject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            FieldProp fieldProp;
            Object value;
            boolean enableNull = dataEntityProperty.isEnableNull();
            Object object = value = dataEntityProperty instanceof BasedataProp ? Long.valueOf(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (BasedataProp)((BasedataProp)dataEntityProperty))) : dataEntityProperty.getValue((Object)dynamicObject);
            if (!(dataEntityProperty instanceof IValidatorHanlder)) continue;
            IValidatorHanlder validatorHanlder = (IValidatorHanlder)dataEntityProperty;
            boolean isNotEmpty = this.isNotEmpty(enableNull, validatorHanlder, value);
            if (dataEntityProperty instanceof FieldProp && (fieldProp = (FieldProp)dataEntityProperty).isMustInput() && !isNotEmpty) {
                String errorMsg = this.buildIsMustErrorMessage(dataEntityProperty);
                errorMsgBuilder.append(errorMsg);
            }
            boolean checkScope = this.checkScope(dataEntityProperty, value);
            if (isNotEmpty && !checkScope) {
                IScopeCheck scopeCheck = (IScopeCheck)dataEntityProperty;
                String errMessage = scopeCheck.getDataScopeMessage(value);
                errorMsgBuilder.append(errMessage);
            }
            if (!(dataEntityProperty instanceof ComboProp)) continue;
            ComboProp comboProp = (ComboProp)dataEntityProperty;
            if (!isNotEmpty || comboProp.isExistItem((String)value)) continue;
            String errorMsg = this.buildComboScopeErrorMessage(dataEntityProperty);
            errorMsgBuilder.append(errorMsg);
        }
    }

    @Override
    protected void customValidate(String entityNumber, DynamicObject dynamicObject, StringBuilder errorMsgBuilder) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#customValidate {}", (Object)entityNumber);
    }

    @Override
    protected void dbValidate(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#dbValidate {}", (Object)entityNumber);
        Tuple2<Set<EmpnumberAndStartDateEntity>, Map<EmpnumberAndStartDateEntity, DynamicObject>> empnumberTuple = this.queryAndFilterNumbers(dyColl.stream().map(EmpnumberAndStartDateEntity::buildEmp).collect(Collectors.toSet()));
        Tuple2<Set<EmpnumberAndStartDateEntity>, Map<EmpnumberAndStartDateEntity, DynamicObject>> oldEmpnumberTuple = this.queryAndFilterNumbers(dyColl.stream().map(EmpnumberAndStartDateEntity::buildOldEmp).collect(Collectors.toSet()));
        for (DynamicObject dynamicObject : dyColl) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            EmpnumberAndStartDateEntity empnumberEntity = EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dynamicObject);
            EmpnumberAndStartDateEntity oldempnumberEntity = EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dynamicObject);
            try {
                if (((Set)empnumberTuple.t1).contains(empnumberEntity)) {
                    errorMsgBuilder.append(ResManager.loadKDString((String)"\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u5b58\u5728\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                if (((Set)oldEmpnumberTuple.t1).contains(oldempnumberEntity)) {
                    errorMsgBuilder.append(ResManager.loadKDString((String)"\u201c\u524d\u5de5\u53f7_\u524d\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u5b58\u5728\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                DynamicObject empnumberDy = (DynamicObject)((Map)empnumberTuple.t2).get(empnumberEntity);
                DynamicObject oldEmpnumberDy = (DynamicObject)((Map)oldEmpnumberTuple.t2).get(oldempnumberEntity);
                if (empnumberDy != null && oldEmpnumberDy != null) {
                    Date startdate = empnumberDy.getDate("startdate");
                    Date oldEnddate = oldEmpnumberDy.getDate("enddate");
                    if (oldEnddate == null) {
                        errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\uff08%s\uff09\u7684\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]), oldempnumberEntity));
                    }
                    if (startdate != null && oldEnddate != null && PersonGenericUtil.dateDiff((Date)startdate, (Date)oldEnddate) < 0L) {
                        errorMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\uff08%s\uff09\u7684\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u524d\u5de5\u53f7\u7684\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]), empnumberEntity));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#dbValidate error!", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#dbValidate the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, (Object)empnumberEntity, errorMsgBuilder.toString());
        }
    }

    private Tuple2<Set<EmpnumberAndStartDateEntity>, Map<EmpnumberAndStartDateEntity, DynamicObject>> queryAndFilterNumbers(Set<EmpnumberAndStartDateEntity> empnumberAndStartDateEntitySet) {
        HashSet<EmpnumberAndStartDateEntity> notExistsNumberSet = new HashSet<EmpnumberAndStartDateEntity>();
        HashMap<EmpnumberAndStartDateEntity, DynamicObject> existsNumberDyMap = new HashMap<EmpnumberAndStartDateEntity, DynamicObject>(16);
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberAndStartDateEntitySet);
        DynamicObject[] empnumberDyArr = HRBaseDaoFactory.getInstance((String)"hrpi_empentrel").query("empnumber,startdate,enddate", new QFilter[]{empQfilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
        if (empnumberDyArr != null && empnumberDyArr.length > 0) {
            existsNumberDyMap.putAll(Arrays.stream(empnumberDyArr).collect(Collectors.toMap(EmpnumberAndStartDateEntity::buildEmp, dy -> dy, (k1, k2) -> k1)));
            Set dbExistsNumberSet = existsNumberDyMap.keySet();
            notExistsNumberSet.addAll(empnumberAndStartDateEntitySet.stream().filter(entity -> !dbExistsNumberSet.contains(entity)).collect(Collectors.toSet()));
        } else {
            notExistsNumberSet.addAll(empnumberAndStartDateEntitySet);
        }
        return new Tuple2(notExistsNumberSet, existsNumberDyMap);
    }

    @Override
    protected void specialValidate(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        this.validateEmpnumber(entityNumber, dyColl, personGenericContext);
        this.validateOldEmpnumber(entityNumber, dyColl, personGenericContext);
        EmpnumberLinkedBuilder empnumberLinkedBuilder = EmpnumberLinkedBuilder.memoryBuild(dyColl);
        this.linkedRelateDataValidate(entityNumber, empnumberLinkedBuilder, personGenericContext);
        empnumberLinkedBuilder.refreshDB(entityNumber, personGenericContext);
        personGenericContext.putCustomerParam("empnumberLinkedBuilder", (Object)empnumberLinkedBuilder);
    }

    private void validateEmpnumber(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<EmpnumberAndStartDateEntity, List<DynamicObject>> empNumberDyListMap = dyColl.stream().collect(Collectors.groupingBy(EmpnumberAndStartDateEntity::buildEmp));
        for (Map.Entry<EmpnumberAndStartDateEntity, List<DynamicObject>> entry : empNumberDyListMap.entrySet()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            EmpnumberAndStartDateEntity empnumberEntity = entry.getKey();
            List<DynamicObject> dyList = entry.getValue();
            try {
                if (dyList.size() > 1) {
                    errorMsgBuilder.append(ResManager.loadKDString((String)"\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                } else {
                    DynamicObject dynamicObject = dyList.get(0);
                    String inheritnumber = dynamicObject.getString("inheritnumber");
                    String empnumber = dynamicObject.getString("empnumber");
                    String oldempnumber = dynamicObject.getString("oldempnumber");
                    if (INHERITNUMBER_YES.equals(inheritnumber) && !HRStringUtils.equals((String)empnumber, (String)oldempnumber) && !Pattern.matches(NUMBER_MATCH_PATTERN, oldempnumber)) {
                        errorMsgBuilder.append(ResManager.loadKDString((String)"\u8fd9\u884c\u6570\u636e\u4e0d\u662f\u5de5\u53f7\u590d\u7528\u7684\u4e1a\u52a1\u573a\u666f\uff0c\u8bf7\u586b\u5199\u201c\u5426\u201d\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#validateEmpnumber error!", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#validateEmpnumber the entityNumber: {} has validate error.", (Object)entityNumber);
            personGenericContext.addErrorMsg(entityNumber, (Object)empnumberEntity, errorMsgBuilder.toString());
        }
    }

    private void validateOldEmpnumber(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<EmpnumberAndStartDateEntity, List<DynamicObject>> oldempnumberDyListMap = dyColl.stream().collect(Collectors.groupingBy(EmpnumberAndStartDateEntity::buildOldEmp));
        for (Map.Entry<EmpnumberAndStartDateEntity, List<DynamicObject>> entry : oldempnumberDyListMap.entrySet()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            List<DynamicObject> dyList = entry.getValue();
            try {
                if (dyList.size() > 1) {
                    errorMsgBuilder.append(ResManager.loadKDString((String)"\u201c\u524d\u5de5\u53f7_\u524d\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#validateOldEmpnumber error!", (Throwable)e);
                errorMsgBuilder.append(e.getMessage());
            }
            if (errorMsgBuilder.length() <= 0) continue;
            LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#validateOldEmpnumber the entityNumber: {} has validate error.", (Object)entityNumber);
            for (DynamicObject dynamicObject : dyList) {
                personGenericContext.addErrorMsg(entityNumber, (Object)EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dynamicObject), errorMsgBuilder.toString());
            }
        }
    }

    private void linkedRelateDataValidate(String entityNumber, EmpnumberLinkedBuilder empnumberLinkedBuilder, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Set errorIds = personGenericContext.getErrorIds(entityNumber);
        HashSet<EmpnumberAndStartDateEntity> allErrorIds = new HashSet<EmpnumberAndStartDateEntity>(errorIds);
        for (Object errorId : errorIds) {
            String errorEmpnumberEntityStr = (String)errorId;
            EmpnumberAndStartDateEntity errorEmpnumberEntity = (EmpnumberAndStartDateEntity)SerializationUtils.fromJsonString((String)errorEmpnumberEntityStr, EmpnumberAndStartDateEntity.class);
            List<EmpnumberAndStartDateEntity> empnumberLinked = empnumberLinkedBuilder.getEmpnumberLinked(errorEmpnumberEntity);
            if (CollectionUtils.isEmpty(empnumberLinked)) continue;
            for (EmpnumberAndStartDateEntity releateErrorEmpnumberEntity : empnumberLinked) {
                if (!empnumberLinkedBuilder.containsSourceEmpnumberSet(releateErrorEmpnumberEntity) || errorIds.contains(releateErrorEmpnumberEntity)) continue;
                LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveValidateServiceImpl#specialValidate the entityNumber: {} releateErrorEmpnumber\uff1a {}.", (Object)entityNumber, (Object)releateErrorEmpnumberEntity);
                personGenericContext.addErrorMsg(entityNumber, (Object)releateErrorEmpnumberEntity, String.format(ResManager.loadKDString((String)"\u94fe\u8def\u201c\u5de5\u53f7_\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201d\uff1a%s\uff0c\u5b58\u5728\u5f02\u5e38\u6570\u636e\u3002", (String)"HrpiReentryrelateGenericSaveValidateServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]), releateErrorEmpnumberEntity));
                allErrorIds.add(releateErrorEmpnumberEntity);
            }
        }
        empnumberLinkedBuilder.getDyColl().removeIf(dy -> allErrorIds.contains(EmpnumberAndStartDateEntity.buildEmp((DynamicObject)dy)));
    }

    private static class Holder {
        static final HrpiReentryrelateGenericSaveValidateServiceImpl INSTANCE = new HrpiReentryrelateGenericSaveValidateServiceImpl();

        private Holder() {
        }
    }
}

