/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.openapi.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.domian.service.openapi.ISyncSysUserService;

public class SyncSysUserServiceImpl
implements ISyncSysUserService {
    private static final String SYNCTYPE = "synctype";
    private static final String OPEN_API = "openAPI";
    private static final String PERSONID = "personid";
    private static ThreadPool THREAD\uff3fPOOL = ThreadPools.newFixedThreadPool((String)"SyncSysUserService", (int)5);
    private static final Log LOG = LogFactory.getLog(SyncSysUserServiceImpl.class);

    @Override
    public void syncSysUser(List<Long> personIds) {
        LOG.info("sendChangeInfoSyncToSysUserStart , sync sys_user after openAPI update/save , person size : {}", (Object)personIds.size());
        THREAD\uff3fPOOL.execute(() -> {
            DynamicObject[] baseInfo = HRPIPersonRepository.getPersonInfo4SysUser(personIds);
            if (baseInfo != null && baseInfo.length > 0) {
                ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(baseInfo.length);
                for (DynamicObject dy : baseInfo) {
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    temp.put(PERSONID, dy.getLong("id"));
                    temp.put("number", dy.getString("number"));
                    temp.put("name", dy.getString("name"));
                    temp.put(SYNCTYPE, OPEN_API);
                    userList.add(temp);
                }
                Map<String, Object> result = HRPIOperationServiceImpl.getInstance().syncPersonToSysUer(userList);
                LOG.info(MessageFormat.format("entityName,syncPersonToSysUer:{}", result));
            }
        });
    }

    @Override
    public List<Long> getPersonIdsByOts(List<Object> numbers, String key, String tableEntity) {
        LOG.info("start fill the person id by %s ... ", (Object)tableEntity);
        HRBaseServiceHelper ormHelper = new HRBaseServiceHelper(tableEntity);
        DynamicObject[] objects = ormHelper.query("id," + key, new QFilter[]{new QFilter(key, "in", numbers), new QFilter("iscurrentversion", "=", (Object)"1")});
        return Arrays.stream(objects).map(dy -> (Long)dy.getPkValue()).distinct().collect(Collectors.toList());
    }
}

