/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.reentry.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.service.impl.generic.PersonGenericServiceImpl;
import kd.hrmp.hrpi.business.domian.service.reentry.IReEntryService;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import org.apache.commons.collections.CollectionUtils;

public class ReEntryServiceImpl
implements IReEntryService {
    private static final Log LOGGER = LogFactory.getLog(ReEntryServiceImpl.class);
    private static volatile IReEntryService REENTRYSERVICE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IReEntryService getInstance() {
        try {
            if (null != REENTRYSERVICE) return REENTRYSERVICE;
            Class<ReEntryServiceImpl> clazz = ReEntryServiceImpl.class;
            synchronized (ReEntryServiceImpl.class) {
                if (null != REENTRYSERVICE) return REENTRYSERVICE;
                try {
                    REENTRYSERVICE = new ReEntryServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-ReEntryServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-ReEntryServiceImpl()-fail", t);
                }
                return REENTRYSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,ReEntryServiceImpl-getInstance()-fail", t);
        }
        return REENTRYSERVICE;
    }

    @Override
    public Map<String, List<DynamicObject>> queryPersonDataByEmployeeId(Long employeeId, List<String> entityNumber) {
        if (employeeId == null || employeeId <= 0L || CollectionUtils.isEmpty(entityNumber)) {
            throw new KDException(new ErrorCode("queryPersonDataByEmployeeId", "param is empty"), new Object[0]);
        }
        DynamicObject employee = HRPIEmployeeRepository.getEmployee(employeeId);
        long personId = employee.getLong("person.id");
        if (personId <= 0L) {
            throw new KDException(new ErrorCode("queryPersonDataByEmployeeId#personId", "personId is error"), new Object[0]);
        }
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(entityNumber.size());
        for (String entity : entityNumber) {
            resultMap.put(entity, this.queryEntityData(personId, entity));
        }
        return resultMap;
    }

    private List<DynamicObject> queryEntityData(long personId, String entity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (HRStringUtils.equals((String)"hrpi_person", (String)entity)) {
            qFilterList.add(new QFilter("id", "=", (Object)personId));
        }
        if (properties.containsKey((Object)"person")) {
            qFilterList.add(new QFilter("person", "=", (Object)personId));
        }
        if (properties.containsKey((Object)"iscurrentversion")) {
            qFilterList.add(QFilterUtil.getCurrentQf());
        }
        if (properties.containsKey((Object)"businessstatus")) {
            qFilterList.add(QFilterUtil.getStatusFilters());
        }
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        try {
            dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilterList.toArray(new QFilter[0]));
        }
        catch (Exception exception) {
            LOGGER.error("ReEntryServiceImpl#queryEntityData is exception:{},personId={},entity={}", new Object[]{exception, personId, entity});
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public Map<String, Object> updateReEntryEmpNumberRelate(List<Map<String, Object>> requestMapList) {
        LOGGER.info("updateReEntryEmpNumberRelate start : {} ", requestMapList);
        if (requestMapList == null) {
            return null;
        }
        MainEntityType reentryrelateType = EntityMetadataCache.getDataEntityType((String)"hrpi_reentryrelate_init");
        DynamicObjectCollection reentryrelateCollection = new DynamicObjectCollection((DynamicObjectType)reentryrelateType, null);
        for (Map<String, Object> requestMap : requestMapList) {
            DynamicObject reentryrelateDy = (DynamicObject)reentryrelateType.createInstance();
            reentryrelateDy.set("empnumber", requestMap.get("empnumber"));
            reentryrelateDy.set("oldempnumber", requestMap.get("oldempnumber"));
            reentryrelateDy.set("serviceagescheme", requestMap.get("serviceagescheme"));
            reentryrelateDy.set("inheritnumber", requestMap.get("inheritnumber"));
            reentryrelateDy.set("startdate", requestMap.get("startdate"));
            reentryrelateDy.set("oldstartdate", requestMap.get("oldstartdate"));
            reentryrelateCollection.add((Object)reentryrelateDy);
        }
        if (!CollectionUtils.isEmpty((Collection)reentryrelateCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(reentryrelateCollection);
            return PersonGenericServiceImpl.getInstance().saveBatchStandard(paramMap);
        }
        return null;
    }

    protected Map<String, Object> buildDatasByCollection(DynamicObjectCollection ... collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.length);
        for (DynamicObjectCollection collection : collections) {
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)collection)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collection);
            datas.add(item);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "initialize");
        paramMap.put("mustAllSuccess", false);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }
}

