/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HBSSBaseDataRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.superior.SuperiorRuleConfig;
import kd.hrmp.hrpi.business.domian.service.superior.rule.IHRPIPersonSuperiorFetchRuleService;
import kd.hrmp.hrpi.business.domian.service.superior.util.PersonSuperiorFetchUtil;
import kd.hrmp.hrpi.common.model.charge.QueryTagParam;

public class PersonSuperiorFetchHelper {
    private static final Log LOGGER = LogFactory.getLog(PersonSuperiorFetchHelper.class);
    private static final IChargeApplication CHARGE_APPLICATION = new ChargeApplicationImpl();

    public static Map<Long, List<Map<String, Object>>> getSuperior(Map<String, Object> paramMap, Date queryDate) {
        LOGGER.info("PersonSuperiorFetchHelper#getSuperior paramMap:{}, queryDate:{}", paramMap, (Object)queryDate);
        try {
            DynamicObject[] depemps;
            String queryKey;
            List ids;
            queryDate = PersonSuperiorFetchUtil.handleQueryDate(queryDate);
            if (paramMap.get("person") instanceof List) {
                ids = (List)paramMap.get("person");
                queryKey = "person";
                depemps = HRPIDepempRepository.listDepEmpDysByPerson(new ArrayList<Long>(ids), "adminorg.id,person.id,enddate,employee.laborrelstatus.id");
            } else if (paramMap.get("depemp") instanceof List) {
                ids = (List)paramMap.get("depemp");
                queryKey = "depemp";
                depemps = HRPIDepempRepository.listDepByDepIds(ids, "adminorg.id,person.id,enddate,employee.laborrelstatus.id");
            } else {
                LOGGER.error("param type not suported or param is empty");
                return new HashMap<Long, List<Map<String, Object>>>(0);
            }
            if (depemps == null || depemps.length == 0) {
                LOGGER.error("fetch depemp is empty");
                return new HashMap<Long, List<Map<String, Object>>>(0);
            }
            HashMap<Long, Long> personDepempMap = null;
            if ("person".equals(queryKey)) {
                personDepempMap = new HashMap<Long, Long>(depemps.length);
                paramMap.remove("person");
                LOGGER.info("remove person ids\uff1a{}", paramMap);
            }
            for (DynamicObject depemp : depemps) {
                if (personDepempMap == null) continue;
                personDepempMap.put(depemp.getLong("id"), depemp.getLong("person.id"));
            }
            LOGGER.info("personDepempMap\uff1a{}", personDepempMap);
            Map<String, List<Long>> depempTagMap = PersonSuperiorFetchHelper.getDepempTagMap(depemps, queryDate);
            HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(ids.size());
            for (Map.Entry<String, List<Long>> entry : depempTagMap.entrySet()) {
                Map<String, Object> newParamMap = PersonSuperiorFetchHelper.getNewParamMap(paramMap, "depemp", entry.getValue());
                Map<Long, List<Map<String, Object>>> res = PersonSuperiorFetchHelper.getSuperior(newParamMap, queryDate, entry.getKey());
                if (res == null) continue;
                HashMap<Long, Long> finalPersonDepempMap = personDepempMap;
                res.forEach((key, value) -> result.merge(finalPersonDepempMap != null ? (Long)finalPersonDepempMap.get(key) : key, (List<Map<String, Object>>)value, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("PersonSuperiorFetchHelper#getSuperior ex\uff1a", (Throwable)ex);
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
    }

    private static Map<String, List<Long>> getDepempTagMap(DynamicObject[] depemps, Date queryDate) {
        ArrayList<QueryTagParam> queryTagParamList = new ArrayList<QueryTagParam>(depemps.length);
        ArrayList<Long> depempIds = new ArrayList<Long>(depemps.length);
        for (DynamicObject depemp : depemps) {
            QueryTagParam param = new QueryTagParam();
            Long personId = depemp.getLong("person.id");
            param.setPersonId(personId.longValue());
            param.setDepId(depemp.getLong("adminorg.id"));
            param.setDate(queryDate);
            queryTagParamList.add(param);
            Long depempId = depemp.getLong("id");
            depempIds.add(depempId);
        }
        HashMap<String, List<Long>> depempTagMap = new HashMap<String, List<Long>>(4);
        Object[] chargePersons = CHARGE_APPLICATION.queryChargeTag(queryTagParamList);
        LOGGER.info("queryChargeTag result\uff1a{}", chargePersons);
        if (chargePersons == null || chargePersons.length == 0) {
            depempTagMap.put("2", depempIds);
        } else {
            Arrays.stream(chargePersons).forEach(chargePerson -> {
                String tag = chargePerson.getString("ismain");
                List pers = depempTagMap.computeIfAbsent(tag, val -> new ArrayList());
                pers.add(chargePerson.getLong("chargeperson.id"));
            });
            ArrayList newIds = new ArrayList(depempIds);
            depempTagMap.forEach((key, value) -> newIds.removeAll((Collection<?>)value));
            if (!newIds.isEmpty()) {
                depempTagMap.put("2", newIds);
            }
        }
        return depempTagMap;
    }

    private static Map<String, Object> getNewParamMap(Map<String, Object> paramMap, String queryKey, List<Long> ids) {
        HashMap<String, Object> newParamMap = new HashMap<String, Object>(paramMap);
        newParamMap.put(queryKey, ids);
        return newParamMap;
    }

    private static Map<Long, Date> getDepempQueryDateMap(DynamicObject[] depemps, Date queryDate) {
        Set<Long> labStatusSet = Arrays.stream(depemps).map(val -> val.getLong("employee.laborrelstatus.id")).collect(Collectors.toSet());
        Map<Long, Long> labStatusSetMap = HBSSBaseDataRepository.queryLabStatusPrd(labStatusSet);
        HashMap<Long, Date> map = new HashMap<Long, Date>(depemps.length);
        for (DynamicObject depemp : depemps) {
            Date endDate;
            Long statusId = depemp.getLong("employee.laborrelstatus.id");
            if (labStatusSetMap != null && labStatusSetMap.get(statusId) != 1010L && (endDate = depemp.getDate("enddate")) != null && queryDate.compareTo(endDate) > 0) {
                map.put(depemp.getLong("id"), endDate);
                continue;
            }
            map.put(depemp.getLong("id"), queryDate);
        }
        return map;
    }

    public static Map<Long, List<Map<String, Object>>> getSuperior(Map<String, Object> paramMap, Date queryDate, String tag) {
        LOGGER.info("PersonSuperiorFetchHelper#getSuperior paramMap:{}, queryDate:{},tag:{}", new Object[]{paramMap, queryDate, tag});
        queryDate = PersonSuperiorFetchUtil.handleQueryDate(queryDate);
        HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>();
        List<Map<String, Object>> rules = SuperiorRuleConfig.getSuperiorRule(tag);
        LOGGER.info("tag:{},superiorRule:{}", (Object)tag, rules);
        if (CollectionUtils.isNotEmpty(rules)) {
            for (Map<String, Object> rule : rules) {
                Map<String, Object> newParamMap = PersonSuperiorFetchHelper.getNewParamMap(paramMap, result);
                Map<Long, List<Map<String, Object>>> res = PersonSuperiorFetchHelper.executePlugin(rule, newParamMap, queryDate);
                LOGGER.info("tag:{},rule:{}, match_result:{}", new Object[]{tag, rule, res != null ? res.keySet() : null});
                if (res == null) continue;
                res.forEach(result::putIfAbsent);
            }
        }
        return result;
    }

    private static Map<String, Object> getNewParamMap(Map<String, Object> paramMap, Map<Long, List<Map<String, Object>>> result) {
        boolean existPerson;
        if (result.size() > 0 && ((existPerson = paramMap.get("person") instanceof List) || paramMap.get("depemp") instanceof List)) {
            List ids = null;
            String queryType = null;
            if (existPerson) {
                ids = (List)paramMap.get("person");
                queryType = "person";
            } else if (paramMap.get("depemp") instanceof List) {
                ids = (List)paramMap.get("depemp");
                queryType = "depemp";
            }
            if (ids != null && !ids.isEmpty()) {
                HashMap<String, Object> newParamMap = new HashMap<String, Object>(paramMap);
                Set<Long> hasDataIds = result.keySet();
                List newIds = ids.stream().collect(Collectors.toList());
                newIds.removeIf(val -> hasDataIds.contains(val));
                newParamMap.put(queryType, newIds);
                return newParamMap;
            }
        }
        return paramMap;
    }

    private static Map<Long, List<Map<String, Object>>> executePlugin(Map<String, Object> rule, Map<String, Object> paramMap, Date queryDate) {
        try {
            String className = (String)rule.get("handler");
            if (HRStringUtils.isEmpty((String)className)) {
                LOGGER.info("handler class is null,the rule:{}", rule);
                return null;
            }
            Class<?> clazz = Class.forName(className);
            IHRPIPersonSuperiorFetchRuleService service = (IHRPIPersonSuperiorFetchRuleService)clazz.newInstance();
            Integer searchLevel = (Integer)rule.get("searchlevel");
            if (searchLevel == null || searchLevel < 1) {
                searchLevel = 1;
            }
            return service.getSuperior(paramMap, queryDate, searchLevel);
        }
        catch (Exception ex) {
            LOGGER.error("getSuperior_ex:", (Throwable)ex);
            return null;
        }
    }
}

