/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.handler.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.common.entity.SuperiorEntity;
import kd.hrmp.hrpi.common.entity.SuperiorValidateEntity;

public class SuperiorCommonParamParse {
    private static final Log LOG = LogFactory.getLog(SuperiorCommonParamParse.class);
    private static final SuperiorCommonParamParse SUP_PARSE = new SuperiorCommonParamParse();

    public static SuperiorCommonParamParse getInstance() {
        return SUP_PARSE;
    }

    public String getLatUniqueKey(Map<String, Object> superiorMap) {
        Object repTypeId;
        Object depId;
        Object depObj = superiorMap.get("depemp");
        Object repTypeObj = superiorMap.get("reporttype");
        StringBuilder uniqueKey = new StringBuilder();
        if (depObj instanceof Long) {
            depId = (Long)depObj;
            uniqueKey.append(depId).append("-");
        } else if (depObj instanceof String) {
            depId = (String)depObj;
            uniqueKey.append((String)depId).append("-");
        }
        if (repTypeObj instanceof Long) {
            repTypeId = (Long)repTypeObj;
            uniqueKey.append(repTypeId);
        } else if (repTypeObj instanceof String) {
            repTypeId = (String)repTypeObj;
            uniqueKey.append((String)repTypeId);
        }
        return uniqueKey.toString();
    }

    public String getThreeUniqueKey(Map<String, Object> superiorMap, Long supDepObj) {
        String latUniqueKey = this.getLatUniqueKey(superiorMap);
        StringBuilder threeLatUKey = new StringBuilder(latUniqueKey);
        threeLatUKey.append("-").append(supDepObj);
        return threeLatUKey.toString();
    }

    public String getDyThreeUniqueKey(DynamicObject dynamicObject) {
        long depId = dynamicObject.getLong("depemp.id");
        long repId = dynamicObject.getLong("reporttype.id");
        long supId = dynamicObject.getLong("superiordepemp.id");
        StringBuilder threeLatUKey = new StringBuilder();
        threeLatUKey.append(depId).append("-").append(repId).append("-").append(supId);
        return threeLatUKey.toString();
    }

    public void fieldListValidate(String failKey, Map<String, Object> failMap, Set<Long> dbDepIds, SuperiorValidateEntity superiorValidateEntity, Map<String, Object> nextMap, String tip) {
        List effectDys = superiorValidateEntity.getEffectDys();
        Map repTypeMap = superiorValidateEntity.getRepTypeMap();
        Object superDepObj = nextMap.get("superiordepemp");
        Object depObj = nextMap.get("depemp");
        Object repTypeObj = nextMap.get("reporttype");
        if (superDepObj instanceof List) {
            List superDepIds = (List)superDepObj;
            if (CollectionUtils.isEmpty((Collection)superDepIds)) {
                this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperiorCommonParamParse_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), tip));
            }
            for (Long superDepId : superDepIds) {
                if (dbDepIds.contains(superDepId)) continue;
                this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7[%s]\u4e0d\u5b58\u5728\u3002", (String)"SuperiorCommonParamParse_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]), superDepId));
            }
        } else {
            this.appendMap(failMap, failKey, ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u7a7a\u6216\u683c\u5f0f\u5f02\u5e38\u3002", (String)"SuperiorCommonParamParse_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public Date fieldDateValidate(String failKey, Map<String, Object> failMap, Object endDateObj, String startTip) {
        Date endDate = null;
        if (endDateObj instanceof String) {
            try {
                String dateStr = (String)endDateObj;
                if (HRStringUtils.isEmpty((String)dateStr)) {
                    this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperiorCommonParamParse_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), startTip));
                    return null;
                }
                endDate = HRDateTimeUtils.parseDate((String)dateStr);
            }
            catch (Exception ex) {
                LOG.error("parseDateError");
                this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SuperiorCommonParamParse_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), startTip));
                return null;
            }
        } else if (endDateObj instanceof Date) {
            endDate = (Date)endDateObj;
        }
        if (endDate == null) {
            this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperiorCommonParamParse_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), startTip));
            return null;
        }
        return endDate;
    }

    public boolean fieldLongValidate(String failKey, Map<String, Object> failMap, Set<Long> repTypeSet, Object repTypeObj, String tip) {
        if (repTypeObj instanceof Long) {
            Long repTypeLong = (Long)repTypeObj;
            if (!repTypeSet.contains(repTypeLong)) {
                this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"SuperiorCommonParamParse_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]), tip));
                return false;
            }
        } else if (repTypeObj instanceof String) {
            try {
                String repTypeStr = (String)repTypeObj;
                long repTypeLong = Long.parseLong(repTypeStr);
                if (!repTypeSet.contains(repTypeLong)) {
                    failMap.put(failKey, tip);
                    return false;
                }
            }
            catch (Exception ex) {
                LOG.error("parseLongError");
                this.appendMap(failMap, failKey, ResManager.loadKDString((String)"\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SuperiorCommonParamParse_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        } else {
            this.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperiorCommonParamParse_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), tip));
            return false;
        }
        return true;
    }

    public void appendMap(Map<String, Object> failMap, String failKey, String failInfo) {
        Object failObj = failMap.get(failKey);
        if (Objects.nonNull(failObj)) {
            String failStr = (String)failObj;
            failMap.put(failKey, failStr + failInfo);
        } else {
            failMap.put(failKey, failInfo);
        }
    }

    public void printSaveInfo(SuperiorEntity superiorEntity, Map<String, Object> retMap) {
        DynamicObjectCollection saveDys = superiorEntity.getSaveDys();
        DynamicObjectCollection updateDys = superiorEntity.getUpdateDys();
        DynamicObjectCollection expireDys = superiorEntity.getExpireDys();
        DynamicObjectCollection delDys = superiorEntity.getDelDys();
        DynamicObjectCollection specialUpdateDys = superiorEntity.getSpecialUpdateDys();
        List<Long> saveIds = this.getSaveIds(saveDys, "id");
        List<Long> saveIds1 = this.getSaveIds(updateDys, "boid");
        List<Long> saveIds2 = this.getSaveIds(expireDys, "boid");
        List<Long> saveIds3 = this.getSaveIds(delDys, "boid");
        List<Long> saveIds4 = this.getSaveIds(specialUpdateDys, "boid");
        LOG.info("###{}SuperiorInterface-save->{}->{}->{}->{}->{}-{}", new Object[]{superiorEntity.getMethodType(), saveIds, saveIds1, saveIds2, saveIds3, saveIds4, retMap});
    }

    private List<Long> getSaveIds(DynamicObjectCollection saveDys, String field) {
        List<Long> addIds = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty((Collection)saveDys)) {
            addIds = saveDys.stream().map(dy -> dy.getLong(field)).collect(Collectors.toList());
        }
        return addIds;
    }
}

