/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.handler.common;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.domian.service.superior.handler.common.ISuperiorDataHandler;
import kd.hrmp.hrpi.business.domian.service.superior.handler.common.SuperiorCommonParamParse;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.entity.SuperiorEntity;
import kd.hrmp.hrpi.common.entity.SuperiorValidateEntity;

public class SuperiorHisCommonService
implements ISuperiorDataHandler {
    private static final Log LOGGER = LogFactory.getLog(SuperiorHisCommonService.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hrpi_empsuprel");
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"SuperiorHisCommonService", (int)1);

    public void validateAndSaveDate(SuperiorEntity superiorEntity) {
        this.validateParamLegal(superiorEntity);
        if (!CollectionUtils.isEmpty((Collection)superiorEntity.getSuperiorList())) {
            this.doHandleSuperior(superiorEntity);
        }
    }

    @Override
    public void validateParamLegal(SuperiorEntity superiorEntity) {
        this.commonValidateParamLegal(superiorEntity);
    }

    @Override
    public void doHandleSuperior(SuperiorEntity superiorEntity) {
        this.buildDbAndParamUpdateDys(superiorEntity);
    }

    protected void buildDbAndParamUpdateDys(SuperiorEntity superiorEntity) {
    }

    protected HRBaseServiceHelper getHelper() {
        return HELPER;
    }

    protected void saveData(SuperiorEntity superiorEntity) {
    }

    protected void syncDataToUser(SuperiorEntity superiorEntity) {
        Set personIds = superiorEntity.getPersonIds();
        if (CollectionUtils.isEmpty((Collection)personIds)) {
            return;
        }
        ArrayList userList = new ArrayList(10);
        for (Long personId : personIds) {
            HashMap<String, Object> tmp = new HashMap<String, Object>(4);
            tmp.put("personid", personId);
            tmp.put("synctype", "directorupdate");
            userList.add(tmp);
        }
        THREAD_POOL.execute(() -> {
            try (TXHandle txHandle = TX.requiresNew();){
                HRPIOperationServiceImpl.getInstance().syncPersonToSysUer(userList);
            }
        });
    }

    protected void commonValidateParamLegal(SuperiorEntity superiorEntity) {
        Map failMap = superiorEntity.getFailMap();
        List superiorList = superiorEntity.getSuperiorList();
        String type = superiorEntity.getMethodType();
        Map<Long, DynamicObject> reportMap = this.queryReportTypeBaseData();
        List<Long> orgDepEmpIds = this.queryDepEmpInfo(superiorEntity, superiorList, type);
        this.queryEffectSuperDys(superiorEntity, superiorList, orgDepEmpIds);
        Map<String, List<Map<String, Object>>> repMap = superiorList.stream().collect(Collectors.groupingBy(tmp -> (Long)tmp.get("depemp") + "-" + tmp.get("reporttype")));
        Iterator paramIte = superiorList.iterator();
        while (paramIte.hasNext()) {
            Map nextMap = (Map)paramIte.next();
            HashMap<String, Object> tmpFailMap = new HashMap<String, Object>(4);
            this.validateParamFieldType(nextMap, type, tmpFailMap, reportMap, superiorEntity, repMap);
            if (HRMapUtils.isEmpty(tmpFailMap)) continue;
            failMap.putAll(tmpFailMap);
            paramIte.remove();
        }
    }

    protected String getChildTip() {
        return null;
    }

    protected void validateBusDate(SuperiorValidateEntity superiorValidateEntity, Date compareDate, String dateTip, boolean compareWithDep) {
        SuperiorCommonParamParse paramParse = SuperiorCommonParamParse.getInstance();
        Map nextMap = superiorValidateEntity.getNextMap();
        Map dbDepMap = superiorValidateEntity.getDbDepMap();
        Map failMap = superiorValidateEntity.getFailMap();
        List effectDys = superiorValidateEntity.getEffectDys();
        String failKey = paramParse.getLatUniqueKey(nextMap);
        Object depObj = nextMap.get("depemp");
        Long depId = (Long)depObj;
        DynamicObject empDy = (DynamicObject)dbDepMap.get(depId);
        if (empDy != null) {
            Date dbStartDate = null;
            if (compareWithDep) {
                dbStartDate = empDy.getDate("startdate");
            } else if (!CollectionUtils.isEmpty((Collection)effectDys)) {
                dbStartDate = ((DynamicObject)effectDys.get(0)).getDate("startdate");
            }
            if (dbStartDate == null || HRDateTimeUtils.dayEquals((Date)compareDate, (Date)dbStartDate)) {
                return;
            }
            Date compareMidnight = SuperiorHisCommonService.getMidnight(compareDate);
            if (HRDateTimeUtils.dayBefore((Date)compareMidnight, (Date)dbStartDate)) {
                paramParse.appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5458\u5de5\u5f53\u524d\u201c%2$s\u201d\u5f00\u59cb\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"SuperiorHisCommonService_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), dateTip, this.getDateTip(), HRDateTimeUtils.format((Date)dbStartDate, (String)"yyyy-MM-dd")));
            }
        }
    }

    protected String getDateTip() {
        return ResManager.loadKDString((String)"\u4efb\u804c", (String)"SuperiorHisCommonService_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
    }

    protected void doValidateData(SuperiorValidateEntity superiorValidateEntity, SuperiorEntity superiorEntity) {
        Map depEmpMap;
        DynamicObject dbDy;
        Map nextMap = superiorValidateEntity.getNextMap();
        Long depEmpId = (Long)nextMap.get("depemp");
        Long depObj = (Long)nextMap.get("reporttype");
        if (HRPIValueConstants.OTCLASSIFY_1010.equals(depObj) && (dbDy = (DynamicObject)(depEmpMap = superiorEntity.transferDemEmpToMap()).get(depEmpId)) != null) {
            long personId = dbDy.getLong("person.id");
            Set personIds = superiorEntity.getPersonIds();
            personIds.add(personId);
        }
    }

    protected void commonHasEffectSuper(SuperiorValidateEntity superiorValidateEntity) {
        Map failMap = superiorValidateEntity.getFailMap();
        Map nextMap = superiorValidateEntity.getNextMap();
        Object repTypeObj = nextMap.get("reporttype");
        Map repTypeMap = superiorValidateEntity.getRepTypeMap();
        String failKey = SuperiorCommonParamParse.getInstance().getLatUniqueKey(nextMap);
        List effectDys = superiorValidateEntity.getEffectDys();
        String repName = null;
        Long repTypeId = (Long)repTypeObj;
        DynamicObject repDy = (DynamicObject)repTypeMap.get(repTypeId);
        if (repDy != null) {
            repName = repDy.getString("name");
        }
        if (CollectionUtils.isEmpty((Collection)effectDys)) {
            SuperiorCommonParamParse.getInstance().appendMap(failMap, failKey, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u65e0\u201c%1$s\u201d\u4e0b\u751f\u6548\u4e2d\u7684\u5173\u7cfb\uff0c%2$s\u3002", (String)"SuperiorHisCommonService_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]), repName, superiorValidateEntity.getTip()));
        }
    }

    private void validateParamFieldType(Map<String, Object> nextMap, String type, Map<String, Object> failMap, Map<Long, DynamicObject> repTypeMap, SuperiorEntity superiorEntity, Map<String, List<Map<String, Object>>> repeatMap) {
        Map dbEffectSupMap = superiorEntity.transferEffectSuperToLatMap();
        Set<Long> repTypeSet = repTypeMap.keySet();
        Object depObj = nextMap.get("depemp");
        Object repTypeObj = nextMap.get("reporttype");
        Map dbDepMap = superiorEntity.transferDemEmpToMap();
        Set<Long> dbDepIds = dbDepMap.keySet();
        String failKey = SuperiorCommonParamParse.getInstance().getLatUniqueKey(nextMap);
        SuperiorCommonParamParse paramParse = SuperiorCommonParamParse.getInstance();
        boolean notEmptyDepId = paramParse.fieldLongValidate(failKey, failMap, dbDepIds, depObj, ResManager.loadKDString((String)"\u6e90\u4eba\u5458", (String)"SuperiorHisCommonService_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        boolean notEmptyRepTypeId = paramParse.fieldLongValidate(failKey, failMap, repTypeSet, repTypeObj, ResManager.loadKDString((String)"\u4eba\u5458\u6c47\u62a5\u7c7b\u578b", (String)"SuperiorHisCommonService_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        if (!notEmptyDepId || !notEmptyRepTypeId) {
            return;
        }
        List<DynamicObject> effectDys = this.getEffectDy(type, dbEffectSupMap, (Long)depObj, (Long)repTypeObj);
        SuperiorValidateEntity superiorValidateEntity = new SuperiorValidateEntity(failMap, repTypeMap, nextMap, effectDys, this.getChildTip(), dbDepMap, repeatMap, superiorEntity.getMethodType());
        this.doValidateData(superiorValidateEntity, superiorEntity);
    }

    private void queryEffectSuperDys(SuperiorEntity superiorEntity, List<Map<String, Object>> superiorList, List<Long> orgDepEmpIds) {
        List<Long> repTypeIds = superiorList.stream().filter(tmp -> (Long)tmp.get("reporttype") != 0L && (Long)tmp.get("reporttype") != null).map(tmp -> (Long)tmp.get("reporttype")).collect(Collectors.toList());
        Object[] effectDyArr = HRPIPersonRolerelRepository.getSuperiorByDepEmpIds(orgDepEmpIds, repTypeIds);
        if (HRArrayUtils.isNotEmpty((Object[])effectDyArr)) {
            superiorEntity.setDbSuperiorDys((DynamicObject[])effectDyArr);
        }
    }

    private List<Long> queryDepEmpInfo(SuperiorEntity superiorEntity, List<Map<String, Object>> superiorList, String type) {
        ArrayList<Long> allDepIds = new ArrayList<Long>(16);
        List<Long> orgDepEmpIds = superiorList.stream().filter(tmp -> (Long)tmp.get("depemp") != 0L && (Long)tmp.get("depemp") != null).map(tmp -> (Long)tmp.get("depemp")).collect(Collectors.toList());
        allDepIds.addAll(orgDepEmpIds);
        if (!"delete".equals(type)) {
            for (Map<String, Object> tmp2 : superiorList) {
                Object supObj = tmp2.get("superiordepemp");
                if (!(supObj instanceof List)) continue;
                List supIds = (List)supObj;
                allDepIds.addAll(supIds);
            }
        }
        DynamicObject[] dbDepEmpDys = HRPIDepempRepository.listDepempIds(allDepIds, "id,startdate,enddate,sysenddate,person,employee,adminorg,position.workrole");
        superiorEntity.setDepEmpDys(dbDepEmpDys);
        return orgDepEmpIds;
    }

    private Map<Long, DynamicObject> queryReportTypeBaseData() {
        QFilter filter = new QFilter("id", ">", (Object)0L);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hbpm_reportcoreltype");
        DynamicObject[] reportTypeDys = baseServiceHelper.query("id,name,number", new QFilter[]{filter});
        return Arrays.stream(reportTypeDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
    }

    private List<DynamicObject> getEffectDy(String type, Map<String, List<DynamicObject>> dbEffectSupMap, Long depId, Long repTypeId) {
        List<DynamicObject> effesctDys = new ArrayList<DynamicObject>();
        if (!"add".equals(type)) {
            effesctDys = dbEffectSupMap.get(depId + "-" + repTypeId);
        }
        return effesctDys;
    }

    protected void addHisData(DynamicObjectCollection addDys) {
        HashMap<String, DynamicObjectCollection> supMap = new HashMap<String, DynamicObjectCollection>(4);
        supMap.put("hrpi_empsuprel", addDys);
        HRPIOperationServiceImpl.getInstance().doSaveOrUpdate(supMap, false);
    }

    protected void updateHisData(DynamicObjectCollection updateDys) {
        HashMap<String, DynamicObjectCollection> supMap = new HashMap<String, DynamicObjectCollection>(4);
        supMap.put("hrpi_empsuprel", updateDys);
        HRPIOperationServiceImpl.getInstance().doSaveOrUpdate(supMap, false);
    }

    protected void expireHisData(DynamicObjectCollection expireDys) {
        this.expireOrDel(expireDys);
    }

    private void expireOrDel(DynamicObjectCollection delDys) {
        HisDiscardApiBo hisDiscardApiBo = new HisDiscardApiBo();
        hisDiscardApiBo.setEntityNumber("hrpi_empsuprel");
        Set delIds = delDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        hisDiscardApiBo.setBoIdSet(delIds);
        HisModelController.getInstance().discardBoData(hisDiscardApiBo);
    }

    protected void minAddCommonField(DynamicObject saveDy, Map<String, Object> superiorMap) {
        saveDy.set("initstatus", (Object)"2");
        long currUserId = RequestContext.get().getCurrUserId();
        try {
            this.setOpMan("creator", saveDy, superiorMap, currUserId);
            this.setOpMan("modifier", saveDy, superiorMap, currUserId);
            this.setOpTime("modifytime", saveDy, superiorMap);
            this.setOpTime("createtime", saveDy, superiorMap);
        }
        catch (Exception es) {
            LOGGER.error("setSystemFieldError");
            saveDy.set("creator", (Object)currUserId);
            saveDy.set("modifier", (Object)currUserId);
            saveDy.set("modifytime", (Object)new Date());
            saveDy.set("createtime", (Object)new Date());
        }
    }

    protected void minUpdateCommonField(DynamicObject saveDy, Map<String, Object> superiorMap) {
        saveDy.set("initstatus", (Object)"2");
        long currUserId = RequestContext.get().getCurrUserId();
        try {
            this.setOpMan("modifier", saveDy, superiorMap, currUserId);
            this.setOpTime("modifytime", saveDy, superiorMap);
        }
        catch (Exception es) {
            LOGGER.error("setUpdateSystemFieldError");
            saveDy.set("modifier", (Object)currUserId);
            saveDy.set("modifytime", (Object)new Date());
        }
    }

    protected void setOpTime(String field, DynamicObject saveDy, Map<String, Object> superiorMap) {
        Object cObj = superiorMap.get(field);
        if (cObj instanceof Date) {
            saveDy.set(field, (Object)((Date)cObj));
        } else {
            saveDy.set(field, (Object)new Date());
        }
    }

    protected void setOpMan(String field, DynamicObject saveDy, Map<String, Object> superiorMap, long currUserId) {
        Object cObj = superiorMap.get(field);
        if (cObj instanceof Long) {
            saveDy.set(field, (Object)((Long)cObj));
        } else {
            saveDy.set(field, (Object)currUserId);
        }
    }

    protected Date getDate(Object endDateObj) {
        Date date = null;
        if (endDateObj instanceof String) {
            try {
                String dateStr = (String)endDateObj;
                date = HRDateTimeUtils.parseDate((String)dateStr);
            }
            catch (Exception ex) {
                LOGGER.error("parseDateError");
            }
        } else if (endDateObj instanceof Date) {
            date = (Date)endDateObj;
        }
        return date;
    }

    protected static Date getMidnight(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return HRDateTimeUtils.parseDate((String)(dateStr + " 00:00:00"));
        }
        catch (ParseException parseException) {
            LOGGER.error("parseDateError!", (Throwable)parseException);
            return null;
        }
    }
}

