/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.handler.common;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hrpi.business.domian.service.superior.handler.common.SuperiorCommonParamParse;
import kd.hrmp.hrpi.business.domian.service.superior.handler.common.SuperiorHisCommonService;
import kd.hrmp.hrpi.common.entity.SuperiorEntity;

public class SuperiorUpdateHisService
extends SuperiorHisCommonService {
    private static final Log LOG = LogFactory.getLog(SuperiorUpdateHisService.class);

    @Override
    protected void buildDbAndParamUpdateDys(SuperiorEntity superiorEntity) {
        List superiorList = superiorEntity.getSuperiorList();
        for (Map superiorMap : superiorList) {
            this.buildHisUpdateData(superiorMap, superiorEntity);
        }
        this.saveData(superiorEntity);
    }

    @Override
    protected void saveData(SuperiorEntity superiorEntity) {
        DynamicObjectCollection updateDys = superiorEntity.getUpdateDys();
        DynamicObjectCollection expireDys = superiorEntity.getExpireDys();
        DynamicObjectCollection saveDys = superiorEntity.getSaveDys();
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)updateDys)) {
                this.updateHisData(updateDys);
            }
            if (!CollectionUtils.isEmpty((Collection)expireDys)) {
                this.expireHisData(expireDys);
            }
            if (!CollectionUtils.isEmpty((Collection)saveDys)) {
                this.addHisData(saveDys);
            }
        }
        this.syncDataToUser(superiorEntity);
    }

    private void buildHisUpdateData(Map<String, Object> superiorMap, SuperiorEntity superiorEntity) {
        this.buildHisAddDys(superiorMap, superiorEntity);
        this.buildHisUpdateDys(superiorMap, superiorEntity);
        this.buildHisExpireDys(superiorMap, superiorEntity);
    }

    private void buildHisExpireDys(Map<String, Object> superiorMap, SuperiorEntity superiorEntity) {
        Object endDateObj = superiorMap.get("startdate");
        Date date = SuperiorUpdateHisService.getMidnight(this.getDate(endDateObj));
        String unKey = SuperiorCommonParamParse.getInstance().getLatUniqueKey(superiorMap);
        Map dbGroupMap = superiorEntity.transferSuperToLatMap();
        List dbDy = (List)dbGroupMap.get(unKey);
        if (CollectionUtils.isEmpty((Collection)dbDy)) {
            return;
        }
        List<DynamicObject> paramLessTime = dbDy.stream().filter(dy -> date.compareTo(dy.getDate("startdate")) <= 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paramLessTime)) {
            this.buildExpireDys(superiorMap, paramLessTime, superiorEntity);
        }
    }

    private void buildHisUpdateDys(Map<String, Object> superiorMap, SuperiorEntity superiorEntity) {
        String unKey;
        Object endDateObj = superiorMap.get("startdate");
        Date date = SuperiorUpdateHisService.getMidnight(this.getDate(endDateObj));
        Map dbGroupMap = superiorEntity.transferSuperToLatMap();
        List dbDy = (List)dbGroupMap.get(unKey = SuperiorCommonParamParse.getInstance().getLatUniqueKey(superiorMap));
        if (CollectionUtils.isEmpty((Collection)dbDy)) {
            return;
        }
        Set updateBoIds = superiorEntity.getUpdateDys().stream().filter(dy -> dy.getLong("boid") != 0L).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        List<DynamicObject> paramMiddleTime = dbDy.stream().filter(dy -> !updateBoIds.contains(dy.getLong("boid")) && date.compareTo(dy.getDate("startdate")) > 0 && date.compareTo(dy.getDate("enddate")) <= 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paramMiddleTime)) {
            this.buildUpdateDys(superiorMap, paramMiddleTime, superiorEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)superiorEntity.getSpecialUpdateDys())) {
            this.buildUpdateStartDateDys(superiorMap, superiorEntity, endDateObj);
        }
    }

    private void buildUpdateStartDateDys(Map<String, Object> superiorMap, SuperiorEntity superiorEntity, Object endDateObj) {
        Set updateBoIds = superiorEntity.getUpdateDys().stream().filter(dy -> dy.getLong("boid") != 0L).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        DynamicObjectCollection updateDys = superiorEntity.getUpdateDys();
        DynamicObjectCollection specialUpdateDys = superiorEntity.getSpecialUpdateDys();
        Date midnight = SuperiorUpdateHisService.getMidnight(this.getDate(endDateObj));
        for (DynamicObject oldLoseDy : specialUpdateDys) {
            long depEmpId = oldLoseDy.getLong("boid");
            if (updateBoIds.contains(depEmpId)) continue;
            DynamicObject saveDy = this.getHelper().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)oldLoseDy, (DynamicObject)saveDy);
            saveDy.set("startdate", (Object)midnight);
            saveDy.set("bsed", (Object)midnight);
            saveDy.set("initstatus", (Object)"2");
            this.minUpdateCommonField(saveDy, superiorMap);
            updateDys.add((Object)saveDy);
        }
    }

    private void buildHisAddDys(Map<String, Object> superiorMap, SuperiorEntity superiorEntity) {
        DynamicObjectCollection saveDys = superiorEntity.getSaveDys();
        Map depMap = superiorEntity.transferDemEmpToMap();
        Map dbEffectMap = superiorEntity.transferEffectSuperThreeLatMap();
        List supDepIds = (List)superiorMap.get("superiordepemp");
        Object endDateObj = superiorMap.get("startdate");
        Date midnight = SuperiorUpdateHisService.getMidnight(this.getDate(endDateObj));
        List dbSuperDepIds = dbEffectMap.values().stream().flatMap(Collection::stream).map(dy -> dy.getLong("superiordepemp.id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dbSuperDepIds) && dbSuperDepIds.containsAll(supDepIds) && supDepIds.containsAll(dbSuperDepIds)) {
            List dbEffectDys = dbEffectMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            DynamicObjectCollection specialDys = superiorEntity.getSpecialUpdateDys();
            specialDys.addAll(dbEffectDys);
            return;
        }
        for (Long supDepObj : supDepIds) {
            DynamicObject saveDy = this.getHelper().generateEmptyDynamicObject();
            Long repId = (Long)superiorMap.get("reporttype");
            this.setPersonField(depMap, saveDy, superiorMap);
            this.setSuperField(depMap, saveDy, supDepObj);
            saveDy.set("reporttype", (Object)repId);
            saveDy.set("startdate", (Object)midnight);
            saveDy.set("bsed", (Object)midnight);
            try {
                saveDy.set("enddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
                saveDy.set("sysenddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
            }
            catch (Exception es) {
                LOG.error("parseDateError");
            }
            saveDy.set("businessstatus", (Object)"1");
            this.minAddCommonField(saveDy, superiorMap);
            saveDys.add((Object)saveDy);
        }
    }

    private void buildUpdateDys(Map<String, Object> superiorMap, List<DynamicObject> paramMiddleTime, SuperiorEntity superiorEntity) {
        Object endDateObj = superiorMap.get("startdate");
        Date midnight = SuperiorUpdateHisService.getMidnight(this.getDate(endDateObj));
        DynamicObjectCollection updateDys = superiorEntity.getUpdateDys();
        DynamicObjectCollection specialUpdateDys = superiorEntity.getSpecialUpdateDys();
        Set spicalUpdateBoIds = specialUpdateDys.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        for (DynamicObject oldLoseDy : paramMiddleTime) {
            long boId = oldLoseDy.getLong("boid");
            if (spicalUpdateBoIds.contains(boId)) continue;
            DynamicObject saveDy = this.getHelper().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)oldLoseDy, (DynamicObject)saveDy);
            Date oldStartDate = oldLoseDy.getDate("startdate");
            if (oldStartDate.compareTo(midnight) == 0) {
                saveDy.set("enddate", (Object)midnight);
            } else {
                saveDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)midnight, (long)-1L));
            }
            saveDy.set("sysenddate", (Object)midnight);
            saveDy.set("businessstatus", (Object)"2");
            saveDy.set("bsed", (Object)midnight);
            saveDy.set("initstatus", (Object)"2");
            this.minUpdateCommonField(saveDy, superiorMap);
            updateDys.add((Object)saveDy);
        }
    }

    private void buildExpireDys(Map<String, Object> superiorMap, List<DynamicObject> paramLessTime, SuperiorEntity superiorEntity) {
        DynamicObjectCollection saveDys = superiorEntity.getExpireDys();
        DynamicObjectCollection specialUpdateDys = superiorEntity.getSpecialUpdateDys();
        Set spicalUpdateBoIds = specialUpdateDys.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        for (DynamicObject oldLoseDy : paramLessTime) {
            long boId = oldLoseDy.getLong("boid");
            if (spicalUpdateBoIds.contains(boId)) continue;
            DynamicObject saveDy = this.getHelper().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)oldLoseDy, (DynamicObject)saveDy);
            saveDy.set("initstatus", (Object)"2");
            this.minUpdateCommonField(saveDy, superiorMap);
            saveDys.add((Object)oldLoseDy);
        }
    }

    private void setPersonField(Map<Long, DynamicObject> depMap, DynamicObject saveDy, Map<String, Object> superiorMap) {
        Long depObj = (Long)superiorMap.get("depemp");
        DynamicObject depDy = depMap.get(depObj);
        if (depDy != null) {
            long depEmpId = depDy.getLong("id");
            saveDy.set("depemp", (Object)depEmpId);
            long empId = depDy.getLong("employee.id");
            saveDy.set("employee", (Object)empId);
            long personId = depDy.getLong("person.id");
            saveDy.set("person", (Object)personId);
        }
    }

    private void setSuperField(Map<Long, DynamicObject> depMap, DynamicObject saveDy, Long supDepObj) {
        DynamicObject supDepDy = depMap.get(supDepObj);
        if (supDepDy != null) {
            long workRoleId = supDepDy.getLong("position.workrole.id");
            saveDy.set("superiorrole", (Object)workRoleId);
            long adminOrgId = supDepDy.getLong("adminorg.id");
            saveDy.set("superioradminorg", (Object)adminOrgId);
            long personId = supDepDy.getLong("person.id");
            saveDy.set("superior", (Object)personId);
            long empId = supDepDy.getLong("employee.id");
            saveDy.set("superioremployee", (Object)empId);
            long depEmpId = supDepDy.getLong("id");
            saveDy.set("superiordepemp", (Object)depEmpId);
        }
    }
}

