/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.rule.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.superior.rule.IHRPIPersonSuperiorFetchRuleService;
import kd.hrmp.hrpi.business.domian.service.superior.util.PersonSuperiorFetchUtil;

public class DepChargeSuperiorFetchRuleServiceImpl
extends IHRPIPersonSuperiorFetchRuleService {
    private static final Log LOGGER = LogFactory.getLog(DepChargeSuperiorFetchRuleServiceImpl.class);

    @Override
    public Map<Long, List<Map<String, Object>>> getSuperior(Map<String, Object> paramMap, Date queryDate, Integer searchLevel) {
        List<Map<String, Object>> queryParams;
        Map<String, List<Map<String, Object>>> depChargeWithDateMap;
        ArrayList<Long> orgIds;
        LOGGER.info("DepChargeSuperiorFetchRuleServiceImpl#getSuperior paramMap:{},queryDate:{},searchLevel{}", new Object[]{paramMap, queryDate, searchLevel});
        Map<Long, Set<Object>> personOrgRelationMap = null;
        String queryType = null;
        boolean existPerson = paramMap.get("person") instanceof List;
        if (existPerson || paramMap.get("depemp") instanceof List) {
            List ids;
            DynamicObject[] depemps = null;
            if (existPerson) {
                queryType = "person";
                ids = (List)paramMap.get("person");
                if (!ids.isEmpty()) {
                    depemps = HRPIDepempRepository.listDepEmpDysByPerson(ids, "adminorg.id,person.id");
                }
            } else if (paramMap.get("depemp") instanceof List) {
                queryType = "depemp";
                ids = (List)paramMap.get("depemp");
                if (!ids.isEmpty()) {
                    depemps = HRPIDepempRepository.listDepByDepIds(ids, "adminorg.id");
                }
            }
            if (depemps == null || depemps.length == 0) {
                LOGGER.info("ids or depemp is empty");
                return null;
            }
            personOrgRelationMap = new HashMap<Long, Set>(depemps.length);
            orgIds = new ArrayList<Long>(depemps.length);
            String key = existPerson ? "person.id" : "id";
            for (DynamicObject depemp : depemps) {
                Set sets = personOrgRelationMap.computeIfAbsent(depemp.getLong(key), val -> new HashSet());
                Long orgId = depemp.getLong("adminorg.id");
                sets.add(orgId);
                orgIds.add(orgId);
            }
        } else if (paramMap.get("org") instanceof List) {
            queryType = "org";
            orgIds = (ArrayList<Long>)paramMap.get("org");
            if (orgIds.isEmpty()) {
                LOGGER.info("orgIds is empty");
                return null;
            }
        } else {
            LOGGER.error("param type not suported or param is empty");
            return null;
        }
        if ((depChargeWithDateMap = new ChargeApplicationImpl().queryChargePersonByOrgIdAndDate(queryParams = PersonSuperiorFetchUtil.getDepChargeReqParam((Collection<Long>)orgIds, queryDate))) == null || depChargeWithDateMap.isEmpty()) {
            LOGGER.info("queryChargePersonByOrgIdAndDate result is empty");
            return null;
        }
        Map<Long, List<Map<String, Object>>> depChargeMap = new HashMap<Long, List<Map<String, Object>>>(depChargeWithDateMap.size());
        for (Map.Entry entry : depChargeWithDateMap.entrySet()) {
            String[] strings = ((String)entry.getKey()).split("_");
            ((List)entry.getValue()).removeIf(val -> !"1".equals(val.get("ismain")));
            if (!((List)entry.getValue()).isEmpty()) {
                depChargeMap.put(Long.valueOf(strings[0]), (List<Map<String, Object>>)entry.getValue());
                continue;
            }
            LOGGER.info("all is not is main charge : {}", entry.getKey());
        }
        HashMap result = null;
        depChargeMap = PersonSuperiorFetchUtil.translateDepChargeToSuperior(depChargeMap);
        if ("org".equals(queryType)) {
            Map map;
            if (paramMap.get(queryType + "RelationMap") instanceof Map && !(map = (Map)paramMap.get(queryType + "RelationMap")).isEmpty()) {
                personOrgRelationMap = map;
            }
            if (personOrgRelationMap == null) {
                return depChargeMap;
            }
        }
        if (personOrgRelationMap != null) {
            result = new HashMap(personOrgRelationMap.size());
            for (Map.Entry entry : personOrgRelationMap.entrySet()) {
                ArrayList<Map<String, Object>> depChargList = new ArrayList<Map<String, Object>>();
                for (Long orgId : (Set)entry.getValue()) {
                    List<Map<String, Object>> depChargs = depChargeMap.get(orgId);
                    if (depChargs == null || depChargs.isEmpty()) continue;
                    depChargList.addAll(depChargs);
                }
                if (depChargList.isEmpty()) continue;
                result.put(entry.getKey(), depChargList);
            }
        }
        return result;
    }
}

