/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.rule.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.superior.rule.IHRPIPersonSuperiorFetchRuleService;
import kd.hrmp.hrpi.business.domian.service.superior.util.PersonSuperiorFetchUtil;

public class PositionRoleSuperiorFetchRuleServiceImpl
extends IHRPIPersonSuperiorFetchRuleService {
    private static final Log LOGGER = LogFactory.getLog(PositionRoleSuperiorFetchRuleServiceImpl.class);

    @Override
    public Map<Long, List<Map<String, Object>>> getSuperior(Map<String, Object> paramMap, Date queryDate, Integer searchLevel) {
        Object[] superiorDyCols;
        HashSet<Long> roleIds;
        LOGGER.info("PositionRoleSuperiorFetchRuleServiceImpl#getSuperior paramMap:{},queryDate:{},searchLevel{}", new Object[]{paramMap, queryDate, searchLevel});
        String queryType = null;
        ArrayListMultimap personRoleRelationMap = null;
        boolean existPerson = paramMap.get("person") instanceof List;
        if (existPerson || paramMap.get("depemp") instanceof List) {
            List ids = null;
            if (existPerson) {
                ids = (List)paramMap.get("person");
                queryType = "person";
            } else if (paramMap.get("depemp") instanceof List) {
                ids = (List)paramMap.get("depemp");
                queryType = "depemp";
            }
            List<Long> newDepempIds = this.getIdsOnPosition(ids, queryType);
            if (newDepempIds.isEmpty()) {
                LOGGER.error("ids or filter apositiontype=position,newdepempIds is empty");
                return null;
            }
            DynamicObjectCollection roleColl = HRPIPersonRolerelRepository.getRolesByPersonId("depemp.id", newDepempIds, queryDate, "role.id,depemp.id,person.id");
            if (roleColl == null || roleColl.isEmpty()) {
                LOGGER.error("getRolesByPersonId result is empty");
                return null;
            }
            ArrayListMultimap finalPersonRoleMap = personRoleRelationMap = ArrayListMultimap.create();
            String querykey = PersonSuperiorFetchUtil.getQueryKey(queryType);
            roleColl.forEach(arg_0 -> PositionRoleSuperiorFetchRuleServiceImpl.lambda$getSuperior$0((Multimap)finalPersonRoleMap, querykey, arg_0));
            roleIds = new HashSet(personRoleRelationMap.values());
        } else if (paramMap.get("role") instanceof List) {
            roleIds = new HashSet<Long>((List)paramMap.get("role"));
            queryType = "role";
        } else {
            LOGGER.error("param type not suported or param is empty");
            return null;
        }
        Map<Long, Long> allParentRelationIds = PositionRoleSuperiorFetchRuleServiceImpl.getAllParentRelationIds(roleIds, queryDate);
        LOGGER.info("getDirectSuperior parent : roleIds {}", allParentRelationIds);
        if (!allParentRelationIds.isEmpty() && !HRArrayUtils.isEmpty((Object[])(superiorDyCols = HRPIPersonRolerelRepository.getParentRoleRel(new HashSet<Long>(allParentRelationIds.values()), queryDate)))) {
            LOGGER.info("getDirectSuperior parentPerson : count {}", (Object)superiorDyCols.length);
            Map<Long, List<DynamicObject>> personGroupByOrg = Arrays.stream(superiorDyCols).collect(Collectors.groupingBy(dy -> dy.getLong("role.id")));
            HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(personGroupByOrg.size());
            if ("role".equals(queryType)) {
                Object roleRelationMap;
                if (paramMap.get(queryType + "RelationMap") instanceof Map && !(roleRelationMap = (Map)paramMap.get(queryType + "RelationMap")).isEmpty()) {
                    personRoleRelationMap = ArrayListMultimap.create();
                    for (Map.Entry<Long, Set<Long>> entry : roleRelationMap.entrySet()) {
                        for (Long roleId : entry.getValue()) {
                            personRoleRelationMap.put((Object)entry.getKey(), (Object)roleId);
                        }
                    }
                }
                if (personRoleRelationMap == null) {
                    for (Map.Entry<Long, List<DynamicObject>> personParentRole : personGroupByOrg.entrySet()) {
                        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(personParentRole.getValue().size());
                        this.addSuperiorList(arrayList, personParentRole.getValue());
                        result.put(personParentRole.getKey(), arrayList);
                    }
                    return result;
                }
            }
            if (personRoleRelationMap != null) {
                Map<Long, Set<Long>> personParentRoles = this.getPersonParentRole((Multimap<Long, Long>)personRoleRelationMap, allParentRelationIds);
                LOGGER.info("getDirectSuperior personParentRoles {}", personParentRoles);
                for (Map.Entry<Long, Set<Long>> entry : personParentRoles.entrySet()) {
                    List<DynamicObject> superiorList = PositionRoleSuperiorFetchRuleServiceImpl.findSuperiorList(personGroupByOrg, entry.getValue());
                    if (superiorList.isEmpty()) continue;
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(superiorList.size());
                    this.addSuperiorList(list, superiorList);
                    result.put(entry.getKey(), list);
                }
            }
            return result;
        }
        return null;
    }

    private List<Long> getIdsOnPosition(List<Long> ids, String queryType) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        QFilter personFilter = "person".equals(queryType) ? new QFilter(PersonSuperiorFetchUtil.getQueryKey(queryType), "in", ids) : new QFilter("id", "in", ids);
        personFilter.and("apositiontype", "=", (Object)"1");
        DynamicObject[] depemps = HRPIDepempRepository.listDepEmps(personFilter, "id");
        if (depemps == null || depemps.length == 0) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(depemps).map(val -> val.getLong("id")).collect(Collectors.toList());
    }

    private static Map<Long, Long> getAllParentRelationIds(Set<Long> roleIds, Date queryDate) {
        List<DynamicObject> roleList = HRPIPersonRolerelRepository.getAllParentRelations(roleIds, queryDate);
        LOGGER.info(" parentRelationIds info {}", roleList);
        HashMap<Long, Long> parentRoleIds = new HashMap<Long, Long>(roleList.size());
        roleList.stream().filter(role -> roleIds.contains(role.getLong("role.id"))).forEach(parRole -> parentRoleIds.put(parRole.getLong("role.id"), parRole.getLong("parent.id")));
        return parentRoleIds;
    }

    private Map<Long, Set<Long>> getPersonParentRole(Multimap<Long, Long> personRoleMap, Map<Long, Long> allParentRelationIds) {
        HashMap<Long, Set<Long>> personParentRoles = new HashMap<Long, Set<Long>>(personRoleMap.size());
        for (Map.Entry personRole : personRoleMap.entries()) {
            Long parentId = allParentRelationIds.get(personRole.getValue());
            if (null == parentId || parentId <= 0L) continue;
            HashSet<Long> parentRoleList = (HashSet<Long>)personParentRoles.get(personRole.getKey());
            if (null == parentRoleList) {
                parentRoleList = new HashSet<Long>();
            }
            parentRoleList.add(parentId);
            personParentRoles.put((Long)personRole.getKey(), (Set<Long>)parentRoleList);
        }
        return personParentRoles;
    }

    private static List<DynamicObject> findSuperiorList(Map<Long, List<DynamicObject>> result, Set<Long> parentRoles) {
        LinkedList<DynamicObject> superiorList = new LinkedList<DynamicObject>();
        parentRoles.forEach(roleId -> {
            List infoList = (List)result.get(roleId);
            if (null != infoList) {
                superiorList.addAll(infoList);
            }
        });
        return superiorList;
    }

    private void addSuperiorList(List<Map<String, Object>> result, List<DynamicObject> superiorList) {
        for (DynamicObject superior : superiorList) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
            infoMap.put("superior.number", superior.getString("person.number"));
            infoMap.put("superior.name", superior.getString("person.name"));
            infoMap.put("superior.headsculpture", superior.getString("person.headsculpture"));
            infoMap.put("superioradminorg.id", superior.getLong("adminorg.id"));
            infoMap.put("superioradminorg.name", superior.getString("adminorg.name"));
            infoMap.put("superioradminorg.number", superior.getString("adminorg.number"));
            infoMap.put("person.id", superior.getLong("person.id"));
            infoMap.put("depemp.id", superior.getLong("depemp.id"));
            infoMap.put("employee.id", superior.getLong("employee.id"));
            result.add(infoMap);
        }
    }

    private static /* synthetic */ void lambda$getSuperior$0(Multimap finalPersonRoleMap, String querykey, DynamicObject role) {
        finalPersonRoleMap.put((Object)role.getLong(querykey), (Object)role.getLong("role.id"));
    }
}

