/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.rule.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.superior.rule.IHRPIPersonSuperiorFetchRuleService;
import kd.hrmp.hrpi.business.domian.service.superior.util.PersonSuperiorFetchUtil;

public class SupDepChargeSuperiorFetchRuleServiceImpl
extends IHRPIPersonSuperiorFetchRuleService {
    private static final Log LOGGER = LogFactory.getLog(SupDepChargeSuperiorFetchRuleServiceImpl.class);
    private static final Long COOP_TYPE = 1010L;

    @Override
    public Map<Long, List<Map<String, Object>>> getSuperior(Map<String, Object> paramMap, Date queryDate, Integer searchLevel) {
        Map<Long, Long> supOrgTeamInfoMap;
        ArrayList<Long> orgIds;
        LOGGER.info("SupDepChargeSuperiorFetchRuleServiceImpl#getSuperior paramMap:{},queryDate:{},searchLevel{}", new Object[]{paramMap, queryDate, searchLevel});
        Map<Long, Set<Long>> personOrgRelationMap = null;
        String queryType = null;
        boolean existPerson = paramMap.get("person") instanceof List;
        if (existPerson || paramMap.get("depemp") instanceof List) {
            List ids;
            DynamicObject[] depemps = null;
            if (existPerson) {
                queryType = "person";
                ids = (List)paramMap.get("person");
                if (!ids.isEmpty()) {
                    depemps = HRPIDepempRepository.listDepEmpDysByPerson(ids, "adminorg.id,person.id");
                }
            } else if (paramMap.get("depemp") instanceof List) {
                queryType = "depemp";
                ids = (List)paramMap.get("depemp");
                if (!ids.isEmpty()) {
                    depemps = HRPIDepempRepository.listDepByDepIds(ids, "adminorg.id");
                }
            }
            if (depemps == null || depemps.length == 0) {
                LOGGER.info("ids or depemp is empty");
                return null;
            }
            personOrgRelationMap = new HashMap<Long, Set<Long>>(depemps.length);
            orgIds = new ArrayList<Long>(depemps.length);
            String key = existPerson ? "person.id" : "id";
            for (DynamicObject dynamicObject : depemps) {
                Set sets = personOrgRelationMap.computeIfAbsent(dynamicObject.getLong(key), val -> new HashSet());
                Long orgId = dynamicObject.getLong("adminorg.id");
                sets.add(orgId);
                orgIds.add(orgId);
            }
        } else if (paramMap.get("org") instanceof List) {
            queryType = "org";
            orgIds = (ArrayList<Long>)paramMap.get("org");
            if (orgIds.isEmpty()) {
                LOGGER.info("orgIds is empty");
                return null;
            }
        } else {
            LOGGER.error("param type not suported or param is empty");
            return null;
        }
        if ((supOrgTeamInfoMap = this.getSupOrgTeamInfo((List<Long>)orgIds, queryDate)) == null || supOrgTeamInfoMap.isEmpty()) {
            LOGGER.info("supOrgTeamInfoMap is empty");
            return null;
        }
        List<Map<String, Object>> queryParams = PersonSuperiorFetchUtil.getDepChargeReqParam(supOrgTeamInfoMap.values(), queryDate);
        Map<String, List<Map<String, Object>>> depChargeWithDateMap = new ChargeApplicationImpl().queryChargePersonByOrgIdAndDate(queryParams);
        if (depChargeWithDateMap == null || depChargeWithDateMap.isEmpty()) {
            LOGGER.info("queryChargePersonByOrgIdAndDate result is empty");
            return null;
        }
        Map<Long, List<Map<String, Object>>> depChargeMap = new HashMap<Long, List<Map<String, Object>>>(depChargeWithDateMap.size());
        for (Map.Entry<String, List<Map<String, Object>>> entry : depChargeWithDateMap.entrySet()) {
            String[] stringArray = entry.getKey().split("_");
            entry.getValue().removeIf(val -> !"1".equals(val.get("ismain")));
            if (!entry.getValue().isEmpty()) {
                depChargeMap.put(Long.valueOf(stringArray[0]), entry.getValue());
                continue;
            }
            LOGGER.info("all is not is main charge : {}", (Object)entry.getKey());
        }
        HashMap<Long, List<Map<String, Object>>> result = null;
        depChargeMap = PersonSuperiorFetchUtil.translateDepChargeToSuperior(depChargeMap);
        if ("org".equals(queryType)) {
            Map orgRelationMap;
            if (paramMap.get(queryType + "RelationMap") instanceof Map && !(orgRelationMap = (Map)paramMap.get(queryType + "RelationMap")).isEmpty()) {
                personOrgRelationMap = orgRelationMap;
            }
            if (personOrgRelationMap == null) {
                result = new HashMap(depChargeMap.size());
                for (Map.Entry<Long, Long> entry : supOrgTeamInfoMap.entrySet()) {
                    List<Map<String, Object>> list = depChargeMap.get(entry.getValue());
                    if (list == null || list.isEmpty()) continue;
                    result.put(entry.getKey(), list);
                }
            }
        }
        if (personOrgRelationMap != null) {
            personOrgRelationMap = this.getPersonSupOrgRelationMap(personOrgRelationMap, supOrgTeamInfoMap);
            result = new HashMap<Long, List<Map<String, Object>>>(personOrgRelationMap.size());
            for (Map.Entry<Long, Set<Long>> entry : personOrgRelationMap.entrySet()) {
                ArrayList<Map<String, Object>> depChargList = new ArrayList<Map<String, Object>>();
                for (Long orgId : entry.getValue()) {
                    List<Map<String, Object>> depChargs = depChargeMap.get(orgId);
                    if (depChargs == null || depChargs.isEmpty()) continue;
                    depChargList.addAll(depChargs);
                }
                if (depChargList.isEmpty()) continue;
                result.put(entry.getKey(), depChargList);
            }
        }
        return result;
    }

    private Map<Long, Set<Long>> getPersonSupOrgRelationMap(Map<Long, Set<Long>> personOrgRelationMap, Map<Long, Long> supOrgTeamInfoMap) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(personOrgRelationMap.size());
        for (Map.Entry<Long, Set<Long>> entry : personOrgRelationMap.entrySet()) {
            HashSet<Long> supOrgs = new HashSet<Long>((Collection)entry.getValue());
            for (Long orgId : entry.getValue()) {
                Long supOrgId = supOrgTeamInfoMap.get(orgId);
                if (supOrgId == null) continue;
                supOrgs.add(supOrgId);
            }
            if (supOrgs.isEmpty()) continue;
            result.put(entry.getKey(), supOrgs);
        }
        return result;
    }

    private Map<Long, Long> getSupOrgTeamInfo(List<Long> orgIds, Date queryDate) {
        List supOrgTeamInfo = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSOrgTeamService", (String)"batchGetSupOrgTeamInfo", (Object[])new Object[]{orgIds, queryDate, COOP_TYPE});
        if (supOrgTeamInfo == null || supOrgTeamInfo.isEmpty()) {
            return null;
        }
        return supOrgTeamInfo.stream().filter(val -> orgIds.contains(val.get("orgTeamId"))).collect(Collectors.toMap(val -> (Long)val.get("orgTeamId"), val -> (Long)val.get("coopOrgTeamId")));
    }
}

