/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.superior.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class PersonSuperiorFetchUtil {
    private static final String QUERYKEY_SUFFIX = ".id";

    public static Date handleQueryDate(Date queryDate) {
        if (queryDate != null) {
            return HRDateTimeUtils.truncateDate((Date)queryDate);
        }
        return HRDateTimeUtils.getNowDate();
    }

    public static String getQueryKey(String queryType) {
        return queryType + QUERYKEY_SUFFIX;
    }

    public static Map<Long, List<Map<String, Object>>> translateDepChargeToSuperior(Map<Long, List<Map<String, Object>>> depChargeMap) {
        HashMap<Long, List<Map<String, Object>>> superior = new HashMap<Long, List<Map<String, Object>>>(depChargeMap.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entry : depChargeMap.entrySet()) {
            List<Map<String, Object>> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            ArrayList list = new ArrayList(values.size());
            for (Map<String, Object> value : values) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
                infoMap.put("superior.number", value.get("number"));
                infoMap.put("superior.name", value.get("name"));
                infoMap.put("superior.headsculpture", value.get("headsculpture"));
                infoMap.put("superioradminorg.id", value.get("adminorg"));
                infoMap.put("superioradminorg.name", value.get("adminorg.name"));
                infoMap.put("superioradminorg.number", value.get("adminorg.number"));
                infoMap.put("person.id", value.get("person"));
                infoMap.put("depemp.id", value.get("depemp"));
                infoMap.put("employee.id", value.get("employee.id"));
                list.add(infoMap);
            }
            superior.put(entry.getKey(), list);
        }
        return superior;
    }

    public static List<Map<String, Object>> getDepChargeReqParam(Collection<Long> orgIds, Date queryDate) {
        ArrayList<Map<String, Object>> queryParams = new ArrayList<Map<String, Object>>(orgIds.size());
        for (Long orgId : orgIds) {
            HashMap<String, Comparable<Date>> param = new HashMap<String, Comparable<Date>>(2);
            param.put("date", queryDate);
            param.put("orgid", orgId);
            queryParams.add(param);
        }
        return queryParams;
    }
}

