/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.external.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hrpi.business.external.IHbpmService;

public class HbpmServiceImpl
implements IHbpmService {
    private static final Log LOGGER = LogFactory.getLog(HbpmServiceImpl.class);
    private static final IHbpmService INSTANCE = new HbpmServiceImpl();

    public static IHbpmService getInstance() {
        return INSTANCE;
    }

    @Override
    public List<Map<String, Object>> getAdminOrgHisVersion(List<Long> adminOrgBoidList, Date date) {
        try {
            return (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{adminOrgBoidList, date});
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl#getAdminOrgHisVersion error, exception is {}");
            return Collections.emptyList();
        }
    }

    @Override
    public Map<String, Map<String, Object>> getAdminOrgHis(List<Long> adminOrgIds, Date date) {
        this.filterEmpty(adminOrgIds);
        if (adminOrgIds.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(1);
        }
        try {
            Map adminOrgHisMap = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{adminOrgIds, date});
            LOGGER.info("HbpmServiceImpl.getAdminOrgHis======adminOrgIds|{}adminOrgHisMap|{}", adminOrgIds, (Object)adminOrgHisMap);
            return adminOrgHisMap;
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl.getAdminOrgHis======adminOrgId|{}  error..", adminOrgIds, (Object)ex);
            return new HashMap<String, Map<String, Object>>(1);
        }
    }

    private void filterEmpty(List<Long> ids) {
        LOGGER.info("before filter ids|{}", ids);
        ids.removeIf(id -> id == null || id == 0L);
        LOGGER.info("after filter ids|{}", ids);
    }

    @Override
    public Map<String, Object> getPositionHisVersion(List<Long> positionBoidList, Date startDate, Date endDate) {
        try {
            return (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionHisVersion", (Object[])new Object[]{positionBoidList, startDate, endDate});
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl#getPositionHisVersion error, exception is {}");
            return Collections.EMPTY_MAP;
        }
    }

    @Override
    public Map<String, Object> getStandardPositionHisVersion(List<Long> stdPositionBoidList, Date date) {
        try {
            return (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPosition", (Object[])new Object[]{stdPositionBoidList, date});
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl#getStandardPositionHisVersion error, exception is {}");
            return Collections.EMPTY_MAP;
        }
    }

    @Override
    public Map<String, Object> getJobHisVersion(List<Long> jobBoidList, Date date) {
        try {
            return (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)"selectJobHisinfo", (Object[])new Object[]{jobBoidList, date});
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl#getJobHisVersion error, exception is {}");
            return Collections.EMPTY_MAP;
        }
    }
}

