/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class CodeRuleNumberHelper {
    private static final String DEP_CODE_ID = "2IGOF7P282GE";
    private static final String EMP_CODE_ID = "2CO=7QSXGI4S";
    private static final String SORT_ITEM_VALUE = "sortitemvalue";
    private static final Log LOGGER = LogFactory.getLog(CodeRuleNumberHelper.class);
    private static final DistributeSessionlessCache APP_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hrpi", true);

    public static CodeRuleNumberHelper getInstance() {
        return Holder.INSTANCE;
    }

    public Map<Long, String> getNumberByDepEmp(DynamicObjectCollection dyColl, Map<Long, String> empMap) {
        QFilter qFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObjectCollection depDyColl;
        List empIdList = dyColl.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(empIdList) && !CollectionUtils.isEmpty((Collection)(depDyColl = (serviceHelper = new HRBaseServiceHelper("hrpi_employee")).queryOriginalCollection("id,empnumber,boid", (qFilter = new QFilter("id", "in", empIdList).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf())).toArray())))) {
            for (DynamicObject hisDy : depDyColl) {
                long boId = hisDy.getLong("boid");
                String number = empMap.get(boId);
                if (!HRStringUtils.isEmpty((String)number)) continue;
                empMap.put(boId, hisDy.getString("empnumber"));
            }
        }
        return empMap;
    }

    public DynamicObjectCollection getAllDepOrSerialDepDys(DynamicObjectCollection dyColl, DynamicObjectCollection dirSaveDbDys, Map<Long, String> empNumberMap, boolean reSet) {
        HashMap<Long, String> inParamUpdateBoIdMap = new HashMap<Long, String>(16);
        HashMap<Long, String> assignAndSerialNoMap = new HashMap<Long, String>(16);
        DynamicObjectCollection totalDys = new DynamicObjectCollection();
        this.sortDepEmpByDbAndParam(totalDys, dyColl, inParamUpdateBoIdMap);
        DynamicObjectCollection serialNoDys = this.setAssignNo(empNumberMap, inParamUpdateBoIdMap, dirSaveDbDys, totalDys, assignAndSerialNoMap);
        if (reSet) {
            this.reBuildAssignNoAndSerialNo(dyColl, empNumberMap, inParamUpdateBoIdMap, assignAndSerialNoMap);
            return totalDys;
        }
        return serialNoDys;
    }

    public void putCacheAssignNo(String cacheNumber, String assignNo) {
        APP_CACHE.put(this.getCacheKey(cacheNumber), (Object)assignNo, 30, TimeUnit.SECONDS);
    }

    private String getCacheKey(String cacheNumber) {
        String lock = "cache";
        return "hrpiassignno" + lock + cacheNumber;
    }

    private String getLockKey(String cacheNumber) {
        String lock = "lock";
        return "hrpiassignno" + lock + cacheNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<DynamicObject>> setAssignNoMapAndSerial(DynamicObjectCollection dyColl, Map<Long, String> numberByDepEmp) {
        Map<Long, List<DynamicObject>> employDyMap = dyColl.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")));
        HashMap<Long, List<DynamicObject>> mainDyMap = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<DynamicObject>> eveDys : employDyMap.entrySet()) {
            List<DynamicObject> contextDepDys = eveDys.getValue();
            Long employeeIdKey = eveDys.getKey();
            DLock dl = DLock.create((String)this.getLockKey(numberByDepEmp.get(employeeIdKey)));
            dl.lock();
            try {
                this.handlerSingleAssignNo(numberByDepEmp, contextDepDys, employeeIdKey, mainDyMap);
            }
            catch (Exception esc) {
                LOGGER.error("setAssignNoMapAndSerial error:", (Throwable)esc);
            }
            finally {
                dl.unlock();
            }
        }
        return mainDyMap;
    }

    private void handlerSingleAssignNo(Map<Long, String> numberByDepEmp, List<DynamicObject> contextDepDys, Long employeeIdKey, Map<Long, List<DynamicObject>> mainDyMap) {
        Map<Long, List<DynamicObject>> allDepEmpByNumberMap;
        List<DynamicObject> currentEmployeeDepEmp = new ArrayList<DynamicObject>(10);
        Object[] depEmpByNumber = HRPIDepempRepository.getDepEmpByNumber(numberByDepEmp.values());
        if (HRArrayUtils.isNotEmpty((Object[])depEmpByNumber) && !HRMapUtils.isEmpty(allDepEmpByNumberMap = Arrays.stream(depEmpByNumber).collect(Collectors.groupingBy(dy -> dy.getLong("employee.id"))))) {
            currentEmployeeDepEmp = allDepEmpByNumberMap.get(employeeIdKey);
        }
        String cacheNumber = numberByDepEmp.get(employeeIdKey);
        String mainAssignNo = this.getDbOrCacheMaxAssignNo(cacheNumber, currentEmployeeDepEmp, (DynamicObject[])depEmpByNumber);
        for (DynamicObject dynamicObject : contextDepDys) {
            long conEmployeeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee");
            boolean primary = dynamicObject.getBoolean("isprimary");
            String number = dynamicObject.getString("number");
            if (HRStringUtils.isNotEmpty((String)number) && !"FIXED_NUMBER".equals(number)) continue;
            String empNumber = numberByDepEmp.get(conEmployeeId);
            if (primary) {
                if (!CollectionUtils.isEmpty(currentEmployeeDepEmp)) {
                    if (StringUtils.isEmpty((Object)dynamicObject.getString("assignno"))) {
                        dynamicObject.set("assignno", (Object)mainAssignNo);
                    }
                    mainDyMap.put(conEmployeeId, Collections.singletonList(dynamicObject));
                    continue;
                }
                if (HRArrayUtils.isEmpty((Object[])depEmpByNumber)) {
                    String assignNo = StringUtils.isEmpty((Object)dynamicObject.getString("assignno")) ? "1" : dynamicObject.getString("assignno");
                    dynamicObject.set("assignno", (Object)assignNo);
                    dynamicObject.set("number", (Object)(empNumber + "-" + assignNo));
                    continue;
                }
                this.putDepMaxAssignNo(cacheNumber, dynamicObject, empNumber);
                continue;
            }
            this.putDepMaxAssignNo(cacheNumber, dynamicObject, empNumber);
        }
    }

    private void putDepMaxAssignNo(String cacheNumber, DynamicObject dynamicObject, String empNumber) {
        String assignNo = this.getAssignNoByEmployeeId(cacheNumber);
        int assignNoInt = Integer.parseInt(assignNo) + 1;
        if (!StringUtils.isEmpty((Object)dynamicObject.getString("assignno"))) {
            Integer depempAssignNo = Integer.valueOf(dynamicObject.getString("assignno"));
            if (depempAssignNo > assignNoInt) {
                this.putCacheAssignNo(cacheNumber, depempAssignNo.toString());
            }
            assignNoInt = depempAssignNo;
        } else {
            this.putCacheAssignNo(cacheNumber, String.valueOf(assignNoInt));
            dynamicObject.set("assignno", (Object)assignNoInt);
        }
        dynamicObject.set("number", (Object)(empNumber + "-" + assignNoInt));
    }

    private String getAssignNoByEmployeeId(String cacheNumber) {
        return (String)APP_CACHE.get(this.getCacheKey(cacheNumber));
    }

    private String getDbOrCacheMaxAssignNo(String lockAndCacheKey, List<DynamicObject> dbDepEmpDys, DynamicObject[] dbDepNumberEmpDys) {
        String effectMainAssignNo = "1";
        boolean rePutFlag = false;
        if (!CollectionUtils.isEmpty(dbDepEmpDys)) {
            String dbAssignNo;
            List effectMainDys = dbDepEmpDys.stream().filter(dep -> dep.getBoolean("isprimary") && HRStringUtils.isNotEmpty((String)dep.getString("assignno")) && "1".equals(dep.getString("businessstatus"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(effectMainDys) && HRStringUtils.isNotEmpty((String)(dbAssignNo = ((DynamicObject)effectMainDys.get(0)).getString("assignno")))) {
                effectMainAssignNo = dbAssignNo;
            }
        } else {
            rePutFlag = true;
        }
        if (!HRArrayUtils.isEmpty((Object[])dbDepNumberEmpDys)) {
            String cacheKey = this.getCacheKey(lockAndCacheKey);
            if (APP_CACHE.get(cacheKey) == null) {
                List sortedDys = Arrays.stream(dbDepNumberEmpDys).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("assignno"))).filter(dy -> HRStringUtils.isEmpty((String)dy.getString("serialno"))).sorted(Comparator.comparing(dy -> Integer.parseInt(dy.getString("assignno")), Comparator.reverseOrder())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sortedDys)) {
                    String dbMaxAssignNo = ((DynamicObject)sortedDys.get(0)).getString("assignno");
                    if (HRStringUtils.isNotEmpty((String)dbMaxAssignNo)) {
                        this.putCacheAssignNo(lockAndCacheKey, dbMaxAssignNo);
                    } else {
                        this.putCacheAssignNo(lockAndCacheKey, "1");
                    }
                    rePutFlag = false;
                } else {
                    rePutFlag = false;
                    this.putCacheAssignNo(lockAndCacheKey, "1");
                }
            }
        } else {
            rePutFlag = true;
        }
        if (rePutFlag) {
            this.putCacheAssignNo(lockAndCacheKey, "1");
        }
        return effectMainAssignNo;
    }

    private void sortDepEmpByDbAndParam(DynamicObjectCollection totalDys, DynamicObjectCollection dyColl, Map<Long, String> inParamUpdateBoIdMap) {
        List<Long> employeeIds = dyColl.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")).collect(Collectors.toList());
        DynamicObject[] depEmpByEmployeeIds = null;
        Map<Object, Object> dbEmployDyMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(employeeIds)) {
            depEmpByEmployeeIds = HRPIDepempRepository.getDepEmpByEmployeeIds(employeeIds, null);
            dbEmployDyMap = Arrays.stream(depEmpByEmployeeIds).collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")));
        }
        Map<Long, List<DynamicObject>> employDyMap = dyColl.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")));
        for (Map.Entry<Long, List<DynamicObject>> groupMapDys : employDyMap.entrySet()) {
            List dbDepEmpDys;
            DynamicObjectCollection tmpDys = new DynamicObjectCollection();
            Long employeeId = groupMapDys.getKey();
            List<DynamicObject> groupDys = groupMapDys.getValue();
            for (DynamicObject dynamicObject : groupDys) {
                long boId = dynamicObject.getLong("boid");
                long pkId = dynamicObject.getLong("id");
                if (boId == 0L) {
                    inParamUpdateBoIdMap.put(pkId, String.valueOf(pkId));
                } else {
                    inParamUpdateBoIdMap.put(boId, String.valueOf(boId));
                }
                tmpDys.add((Object)dynamicObject);
            }
            if (dbEmployDyMap != null && dbEmployDyMap.size() > 0 && !CollectionUtils.isEmpty((Collection)(dbDepEmpDys = (List)dbEmployDyMap.get(employeeId)))) {
                for (DynamicObject dy2 : dbDepEmpDys) {
                    long boId = dy2.getLong("boid");
                    long pkId = dy2.getLong("id");
                    if (boId == 0L) {
                        if (!HRStringUtils.isEmpty((String)inParamUpdateBoIdMap.get(pkId))) continue;
                        tmpDys.add((Object)dy2);
                        continue;
                    }
                    if (!HRStringUtils.isEmpty((String)inParamUpdateBoIdMap.get(boId))) continue;
                    tmpDys.add((Object)dy2);
                }
            }
            if (tmpDys.size() <= 0) continue;
            tmpDys.sort(Comparator.comparingLong(dy1 -> dy1.getDate("startdate").getTime()).thenComparingLong(dy1 -> dy1.getDate("createtime").getTime()));
            totalDys.addAll((Collection)tmpDys);
        }
        LOGGER.info("reBuildAssignNo==>reBuildAssignNo==>size==>{},{},{}", new Object[]{totalDys.size(), employDyMap.size(), inParamUpdateBoIdMap});
    }

    private DynamicObjectCollection setAssignNo(Map<Long, String> empMap, Map<Long, String> inParamUpdateBoIdMap, DynamicObjectCollection dirSaveDbDys, DynamicObjectCollection totalDys, Map<Long, String> assignAndSerialNoMap) {
        DynamicObjectCollection serialNoDys = new DynamicObjectCollection();
        Map<Long, Long> postCateGory = this.getPostCateGory(totalDys);
        Map<Long, List<DynamicObject>> employDyMap = totalDys.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")));
        for (Map.Entry<Long, List<DynamicObject>> eveDys : employDyMap.entrySet()) {
            List<DynamicObject> groupEmpDys = eveDys.getValue();
            int count = 2;
            int mainPostype = 1;
            for (DynamicObject dynamicObject : groupEmpDys) {
                Long postypeCateId;
                long boId = dynamicObject.getLong("boid");
                long pk = dynamicObject.getLong("id");
                boolean primary = dynamicObject.getBoolean("isprimary");
                long postypeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"postype");
                String incValue = String.valueOf(count);
                if (postCateGory != null && postCateGory.size() > 0 && HRPIValueConstants.POS_CATEGORY_FULL.equals(postypeCateId = postCateGory.get(postypeId))) {
                    if (primary) {
                        if (mainPostype == 1) {
                            ++mainPostype;
                        } else {
                            this.setSerialNoMap(assignAndSerialNoMap, boId, pk, "1");
                            serialNoDys.add((Object)dynamicObject);
                        }
                        this.setAssignNoMap(inParamUpdateBoIdMap, boId, pk, "1");
                        continue;
                    }
                    this.setAssignNoMap(inParamUpdateBoIdMap, boId, pk, incValue);
                    ++count;
                    continue;
                }
                if (incValue.equals(dynamicObject.getString("assignno"))) {
                    this.setAssignNoMap(inParamUpdateBoIdMap, boId, pk, incValue);
                    ++count;
                    continue;
                }
                long employeeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee");
                dynamicObject.set("assignno", (Object)incValue);
                String number = empMap.get(employeeId);
                if (number != null) {
                    dynamicObject.set("number", (Object)(number + "-" + incValue));
                }
                if (boId == 0L) {
                    if (HRStringUtils.isNotEmpty((String)inParamUpdateBoIdMap.get(pk))) {
                        inParamUpdateBoIdMap.put(pk, incValue);
                    } else {
                        dirSaveDbDys.add((Object)dynamicObject);
                    }
                } else if (HRStringUtils.isNotEmpty((String)inParamUpdateBoIdMap.get(boId))) {
                    inParamUpdateBoIdMap.put(boId, incValue);
                } else {
                    dirSaveDbDys.add((Object)dynamicObject);
                }
                ++count;
            }
        }
        return serialNoDys;
    }

    private void reBuildAssignNoAndSerialNo(DynamicObjectCollection dyColl, Map<Long, String> empNumberMap, Map<Long, String> inParamUpdateBoIdMap, Map<Long, String> assignAndSerialNoMap) {
        for (DynamicObject dynamicObject : dyColl) {
            String number;
            long boId = dynamicObject.getLong("boid");
            long pkId = dynamicObject.getLong("id");
            long employeeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee");
            String assignNo = "";
            assignNo = boId == 0L ? inParamUpdateBoIdMap.get(pkId) : inParamUpdateBoIdMap.get(boId);
            dynamicObject.set("assignno", (Object)assignNo);
            if (!HRStringUtils.isEmpty((String)assignAndSerialNoMap.get(boId)) || !HRStringUtils.isEmpty((String)assignAndSerialNoMap.get(pkId)) || (number = empNumberMap.get(employeeId)) == null) continue;
            dynamicObject.set("number", (Object)(number + "-" + assignNo));
        }
    }

    private void setSerialNoMap(Map<Long, String> assignAndSerialNoMap, long boId, long pk, String incValue) {
        if (boId == 0L) {
            assignAndSerialNoMap.put(pk, incValue);
        } else {
            assignAndSerialNoMap.put(boId, incValue);
        }
    }

    private void setAssignNoMap(Map<Long, String> inParamUpdateBoIdMap, long boId, long pk, String incValue) {
        if (boId == 0L) {
            if (HRStringUtils.isNotEmpty((String)inParamUpdateBoIdMap.get(pk))) {
                inParamUpdateBoIdMap.put(pk, incValue);
            }
        } else if (HRStringUtils.isNotEmpty((String)inParamUpdateBoIdMap.get(boId))) {
            inParamUpdateBoIdMap.put(boId, incValue);
        }
    }

    public Map<Long, Long> getPostCateGory(DynamicObjectCollection dyColl) {
        Set pstypeSet = dyColl.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"postype")).collect(Collectors.toSet());
        Map<Long, Long> retMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty(pstypeSet)) {
            return retMap;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_postype");
        Object[] dynamicObject1 = serviceHelper.query("postcategory", new QFilter[]{new QFilter("id", "in", pstypeSet)});
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObject1)) {
            retMap = Arrays.stream(dynamicObject1).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("postcategory.id")));
        }
        return retMap;
    }

    public void cleanNumber(List<DynamicObject> needGenNumDeps, String type) {
        Map<Long, String> numberByDepEmp;
        if (CollectionUtils.isEmpty(needGenNumDeps)) {
            return;
        }
        HashMap<Long, String> empMap = new HashMap<Long, String>(16);
        String depCodeId = null;
        DynamicObjectCollection dys = new DynamicObjectCollection();
        dys.addAll(needGenNumDeps);
        if ("depemp".equals(type)) {
            depCodeId = DEP_CODE_ID;
            numberByDepEmp = this.getNumberByDepEmp(dys, empMap);
        } else if ("empentrel".equals(type)) {
            depCodeId = EMP_CODE_ID;
            numberByDepEmp = needGenNumDeps.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("empnumber"), (k1, k2) -> k1));
        } else {
            return;
        }
        if (HRMapUtils.isEmpty(numberByDepEmp)) {
            return;
        }
        Collection<String> clenNumbers = numberByDepEmp.values();
        if (!CollectionUtils.isEmpty(clenNumbers)) {
            QFilter qFilter = new QFilter("coderuleid", "=", (Object)depCodeId);
            QFilter firstFist = null;
            for (String indNumber : clenNumbers) {
                if (HRStringUtils.isEmpty((String)indNumber)) continue;
                if (firstFist == null) {
                    firstFist = new QFilter(SORT_ITEM_VALUE, "like", (Object)(indNumber + "%"));
                    continue;
                }
                QFilter nextNumber = new QFilter(SORT_ITEM_VALUE, "like", (Object)(indNumber + "%"));
                firstFist.or(nextNumber);
            }
            if (firstFist == null) {
                return;
            }
            qFilter.and(firstFist);
            Object[] dynamicObjectArr = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"id,coderuleid, sortitemvalue, maxserial", (QFilter[])qFilter.toArray());
            if (HRArrayUtils.isNotEmpty((Object[])dynamicObjectArr)) {
                for (Object dynamicObject : dynamicObjectArr) {
                    CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance((String)depCodeId);
                    codeRuleSigner.clean(depCodeId, dynamicObject.getString(SORT_ITEM_VALUE));
                }
            }
        }
    }

    public Map<Object, DynamicObject> getPrdStatus() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            return entityCfMap;
        }
        return new HashMap<Object, DynamicObject>(16);
    }

    private static class Holder {
        static final CodeRuleNumberHelper INSTANCE = new CodeRuleNumberHelper();

        private Holder() {
        }
    }
}

