/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hrpi.business.external.impl.HbpmServiceImpl;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class EmpposorgrelServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EmpposorgrelServiceHelper.class);
    private static final String RESPONSE_CODE = "code";
    private static final int SUCCESS_CODE = 200;
    private static final String RESPONSE_DATA = "data";
    private static final String RESPONSE_ERRMSG = "ErrMsg";

    public static void setEmpposorgrelHisInfo(List<DynamicObject> empposorgrels) {
        if (Objects.isNull(empposorgrels) || empposorgrels.size() == 0) {
            LOGGER.warn("EmpposorgrelServiceHelper#setEmpposorgrelHisInfo empposorgrels is empty");
            return;
        }
        empposorgrels.forEach(empposorgrel -> {
            String positionType;
            DataEntityPropertyCollection properties = empposorgrel.getDataEntityType().getProperties();
            String businessstatus = empposorgrel.getString("businessstatus");
            empposorgrel.set("adminorgvid", "2".equals(businessstatus) ? Long.valueOf(EmpposorgrelServiceHelper.getAdminorgHisVersionId(empposorgrel)) : empposorgrel.get("adminorg"));
            if (properties.get((Object)"adminorgvid") instanceof BasedataProp) {
                empposorgrel.set("adminorgvid_id", (Object)HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"adminorgvid"));
            }
            switch (positionType = empposorgrel.getString("apositiontype")) {
                case "1": {
                    empposorgrel.set("positionvid", "2".equals(businessstatus) ? EmpposorgrelServiceHelper.getPositionHisVersionId(empposorgrel) : empposorgrel.get("position"));
                    if (!(properties.get((Object)"positionvid") instanceof BasedataProp)) break;
                    empposorgrel.set("positionvid_id", (Object)HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"positionvid"));
                    break;
                }
                case "0": {
                    empposorgrel.set("stdpositionvid", "2".equals(businessstatus) ? EmpposorgrelServiceHelper.getStandardPositionHisVersionId(empposorgrel) : empposorgrel.get("stdposition"));
                    if (!(properties.get((Object)"stdpositionvid") instanceof BasedataProp)) break;
                    empposorgrel.set("stdpositionvid_id", (Object)HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"stdpositionvid"));
                    break;
                }
                case "2": {
                    empposorgrel.set("jobvid", "2".equals(businessstatus) ? EmpposorgrelServiceHelper.getJobHisVersionId(empposorgrel) : empposorgrel.get("job"));
                    if (!(properties.get((Object)"jobvid") instanceof BasedataProp)) break;
                    empposorgrel.set("jobvid_id", (Object)HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"jobvid"));
                    break;
                }
                default: {
                    LOGGER.warn("EmpposorgrelServiceHelper#setEmpposorgrelHisInfo positionType error {}", (Object)positionType);
                }
            }
            if (!"1".equals(positionType)) {
                empposorgrel.set("positionvid", empposorgrel.get("position"));
                if (properties.get((Object)"positionvid") instanceof BasedataProp) {
                    empposorgrel.set("positionvid_id", (Object)HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"positionvid"));
                }
            }
        });
    }

    private static long getAdminorgHisVersionId(DynamicObject empposorgrel) {
        long adminOrgId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"adminorg");
        if (adminOrgId == 0L) {
            return adminOrgId;
        }
        ArrayList<Long> adminOrgIdList = new ArrayList<Long>(4);
        adminOrgIdList.add(adminOrgId);
        Date endDate = empposorgrel.getDate("enddate");
        Map<String, Map<String, Object>> result = HbpmServiceImpl.getInstance().getAdminOrgHis(adminOrgIdList, endDate);
        if (CollectionUtils.isEmpty(result)) {
            LOGGER.error("EmpposorgrelServiceHelper#getAdminorgHisVersionId error, result is empty");
            return adminOrgId;
        }
        Map<String, Object> resMap = result.get(String.valueOf(adminOrgId));
        if (CollectionUtils.isEmpty(result)) {
            LOGGER.error("EmpposorgrelServiceHelper#getAdminorgHisVersionId result error, result is empty");
            return adminOrgId;
        }
        Long vid = HRJSONUtils.getLongValOfCustomParam((Object)resMap.get("vid"));
        LOGGER.info("EmpposorgrelServiceHelper#getAdminorgHisVersionId, boid is {}, vid is {}", (Object)adminOrgId, (Object)vid);
        return vid;
    }

    private static Long getPositionHisVersionId(DynamicObject empposorgrel) {
        Map data;
        Long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"position");
        if (Objects.isNull(positionId) || 0L == positionId) {
            return 0L;
        }
        Date endDate = empposorgrel.getDate("enddate");
        Map<String, Object> result = HbpmServiceImpl.getInstance().getPositionHisVersion(Collections.singletonList(positionId), endDate, endDate);
        if (EmpposorgrelServiceHelper.checkRequestResult(result, "1") && Objects.nonNull(data = (Map)result.get(RESPONSE_DATA)) && Objects.nonNull(data.get(positionId)) && ((List)data.get(positionId)).size() > 0) {
            Long vid = (Long)((Map)((List)data.get(positionId)).get(0)).get("id");
            LOGGER.info("EmpposorgrelServiceHelper#getPositionHisVersionId, boid is {}, vid is {}", (Object)positionId, (Object)vid);
            return vid;
        }
        LOGGER.warn("EmpposorgrelServiceHelper#getPositionHisVersionId get vid fail, boid is {}", (Object)positionId);
        return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"position");
    }

    private static Long getStandardPositionHisVersionId(DynamicObject empposorgrel) {
        List data;
        Long stdPositionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"stdposition");
        if (Objects.isNull(stdPositionId) || 0L == stdPositionId) {
            return 0L;
        }
        Date endDate = empposorgrel.getDate("enddate");
        Map<String, Object> result = HbpmServiceImpl.getInstance().getStandardPositionHisVersion(Collections.singletonList(stdPositionId), endDate);
        if (EmpposorgrelServiceHelper.checkRequestResult(result, "0") && Objects.nonNull(data = (List)result.get(RESPONSE_DATA)) && data.size() > 0) {
            Long vid = (Long)((Map)data.get(0)).get("id");
            LOGGER.info("EmpposorgrelServiceHelper#getStandardPositionHisVersionId, boid is {}, vid is {}", (Object)stdPositionId, (Object)vid);
            return vid;
        }
        LOGGER.warn("EmpposorgrelServiceHelper#getStandardPositionHisVersionId get vid fail, boid is {}", (Object)stdPositionId);
        return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"stdposition");
    }

    private static Long getJobHisVersionId(DynamicObject empposorgrel) {
        List data;
        Long jobId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"job");
        if (Objects.isNull(jobId) || 0L == jobId) {
            return 0L;
        }
        Date endDate = empposorgrel.getDate("enddate");
        Map<String, Object> result = HbpmServiceImpl.getInstance().getStandardPositionHisVersion(Collections.singletonList(jobId), endDate);
        if (EmpposorgrelServiceHelper.checkRequestResult(result, "0") && Objects.nonNull(data = (List)result.get(RESPONSE_DATA)) && data.size() > 0) {
            Long vid = (Long)((Map)data.get(0)).get("id");
            LOGGER.info("EmpposorgrelServiceHelper#getJobHisVersionId, boid is {}, vid is {}", (Object)jobId, (Object)vid);
            return vid;
        }
        LOGGER.warn("EmpposorgrelServiceHelper#getJobHisVersionId get vid fail, boid is {}", (Object)jobId);
        return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empposorgrel, (String)"job");
    }

    private static boolean checkRequestResult(Map<String, Object> result, String positionType) {
        if (Objects.isNull(result) || result.isEmpty()) {
            LOGGER.error("EmpposorgrelServiceHelper#checkRequestResult error, result is empty, positionType is {}", (Object)positionType);
            return false;
        }
        int code = (Integer)result.get(RESPONSE_CODE);
        if (code != 200) {
            LOGGER.error("EmpposorgrelServiceHelper#checkRequestResult error {}, positionType is {}", result.get(RESPONSE_ERRMSG), (Object)positionType);
            return false;
        }
        return true;
    }
}

