/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.util.HRPIMapUtils;

public class SyncPersonToUserServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SyncPersonToUserServiceHelper.class);

    public static Predicate<Map<String, Object>> filterEmpParams() {
        return map -> HRPIMapUtils.getLongValueFromMap((Map)map, (String)"employeeId") > 0L;
    }

    public static Predicate<Map<String, Object>> filterPersonIdParams() {
        return map -> HRPIMapUtils.getLongValueFromMap((Map)map, (String)"employeeId") == 0L && HRPIMapUtils.getLongValueFromMap((Map)map, (String)"personId") > 0L;
    }

    public static Predicate<Map<String, Object>> filterNumberParams() {
        return map -> HRPIMapUtils.getLongValueFromMap((Map)map, (String)"employeeId") == 0L && HRPIMapUtils.getLongValueFromMap((Map)map, (String)"personId") == 0L && Objects.nonNull(map.get("number"));
    }

    public static Function<Set<Object>, DynamicObject[]> queryEmpArrByEmployeeIdStrs() {
        return empIdStrs -> {
            Set<Long> empIds = empIdStrs.stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toSet());
            return HRPIEmployeeRepository.listEmployeeById(empIds);
        };
    }

    public static Function<Set<Object>, DynamicObject[]> queryEmpArrByPersonIdStrs() {
        return empIdStrs -> {
            List<Long> personIds = empIdStrs.stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toList());
            return HRPIEmployeeRepository.listEmpByPersonIds(personIds);
        };
    }

    public static Function<Set<Object>, DynamicObject[]> queryEmpArrByNumbers() {
        return empIdStrs -> {
            List<String> numbers = empIdStrs.stream().map(value -> value.toString()).collect(Collectors.toList());
            return HRPIEmployeeRepository.listEmployeeByNumber(numbers);
        };
    }

    public static void disableUserStatus(Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, List<DynamicObject> toUpdateStatusEmpDyList, Map<String, String> errorMap) {
        LOGGER.info("SyncPersonToUserServiceHelper#disableUserStatus");
        SyncPersonToUserServiceHelper.updateBosUserStatus(userRelateMap, personNumberUserMap, toUpdateStatusEmpDyList, null, "0", errorMap);
    }

    public static void disableUser(Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, List<DynamicObject> toUpdateStatusEmpDyList, Map<String, String> errorMap) {
        SyncPersonToUserServiceHelper.updateBosUserStatus(userRelateMap, personNumberUserMap, toUpdateStatusEmpDyList, "0", "0", errorMap);
    }

    public static void disableUserByBosUserInfo(DynamicObject[] bosUser, Map<String, String> errorMap) {
        String enable = "0";
        String isforbidden = "0";
        Map<Long, String> dbUserMap = Arrays.asList(bosUser).stream().collect(Collectors.toMap(user -> user.getLong("id"), user -> user.getString("number")));
        List<UserParam> updateEnableUser = SyncPersonToUserServiceHelper.getUpdateStatusUserInfo("0", "enable", errorMap, bosUser, dbUserMap);
        List<UserParam> updateIsForbiddenUser = SyncPersonToUserServiceHelper.getUpdateStatusUserInfo("0", "isforbidden", errorMap, bosUser, dbUserMap);
        SyncPersonToUserServiceHelper.updateUserInfoStatus("0", "0", updateEnableUser, updateIsForbiddenUser);
    }

    public static void enableUser(Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, List<DynamicObject> toUpdateStatusEmpDyList, Map<String, String> errorMap) {
        SyncPersonToUserServiceHelper.updateBosUserStatus(userRelateMap, personNumberUserMap, toUpdateStatusEmpDyList, "1", "1", errorMap);
    }

    public static void populateEmployeeMap(List<Map<String, Object>> params, String paramKey, String empProperty, Predicate<Map<String, Object>> predicate, Function<Set<Object>, DynamicObject[]> queryEmployee, Map<Long, Map<String, Object>> employeeMap) {
        Map<Object, Map> tmpParamMap = params.stream().filter(map -> predicate.test((Map<String, Object>)map)).collect(Collectors.toMap(map -> map.get(paramKey), map -> map, (v1, v2) -> v1));
        if (HRPIMapUtils.isNotEmpty(tmpParamMap)) {
            DynamicObject[] empDyArr = queryEmployee.apply(tmpParamMap.keySet());
            Arrays.asList(empDyArr).forEach(empDy -> employeeMap.putIfAbsent(empDy.getLong("id"), SyncPersonToUserServiceHelper.buildTmpParamMap((Map)tmpParamMap.get(empDy.get(empProperty)), empDy)));
        }
    }

    private static Map<String, Object> buildTmpParamMap(Map<String, Object> param, DynamicObject employeeDy) {
        HashMap<String, Object> tmpMap = new HashMap<String, Object>();
        tmpMap.put("empDy", employeeDy);
        tmpMap.put("number", employeeDy.getString("empnumber"));
        tmpMap.put("personid", employeeDy.getLong("person.id"));
        tmpMap.put("name", employeeDy.getString("person.name"));
        tmpMap.put("param", param);
        return tmpMap;
    }

    private static void updateBosUserStatus(Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, List<DynamicObject> toUpdateStatusEmpDyList, String enable, String isforbidden, Map<String, String> errorMap) {
        if (CollectionUtils.isEmpty(toUpdateStatusEmpDyList)) {
            LOGGER.info("SyncPersonToUserServiceImpl#disable toDisableEmployeeDy is empty");
            return;
        }
        List<Long> dbUserIds = toUpdateStatusEmpDyList.stream().filter(emp -> Objects.nonNull(userRelateMap.get(emp.getLong("id"))) || Objects.nonNull(personNumberUserMap.get(emp.getString("empnumber"))) && (Long)personNumberUserMap.get(emp.getString("empnumber")) > 0L).map(emp -> {
            DynamicObject relateDy = (DynamicObject)userRelateMap.get(emp.getLong("id"));
            return Objects.nonNull(relateDy) ? Long.valueOf(relateDy.getLong("user")) : (Long)personNumberUserMap.get(emp.getString("empnumber"));
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dbUserIds)) {
            LOGGER.info("SyncPersonToUserServiceImpl#disable dbUserIds is empty");
            return;
        }
        DynamicObject[] bosUser = null;
        if (!CollectionUtils.isEmpty(dbUserIds)) {
            bosUser = HRPIBosUserRepository.getBosUserAllInfoById(dbUserIds);
        }
        if (HRArrayUtils.isEmpty(bosUser)) {
            LOGGER.error("SyncPersonToUserServiceImpl#disable toDisableEmployeeDy error, queryBosUserResult is empty");
            return;
        }
        HashMap<Long, String> dbUserMap = new HashMap<Long, String>(16);
        ArrayList<UserParam> updateEnableUser = Objects.isNull(enable) ? new ArrayList<UserParam>() : SyncPersonToUserServiceHelper.getUpdateStatusUserInfo(enable, "enable", errorMap, bosUser, dbUserMap);
        ArrayList<UserParam> updateIsForbiddenUser = Objects.isNull(isforbidden) ? new ArrayList<UserParam>() : SyncPersonToUserServiceHelper.getUpdateStatusUserInfo(isforbidden, "isforbidden", errorMap, bosUser, dbUserMap);
        LOGGER.info("SyncPersonToUserServiceHelper#updateBosUserStatus enable {}, updateEnableUser {}, isforbidden : {}, updateIsForbiddenUser {}", new Object[]{enable, updateEnableUser, isforbidden, updateIsForbiddenUser});
        SyncPersonToUserServiceHelper.updateUserInfoStatus(enable, isforbidden, updateEnableUser, updateIsForbiddenUser);
    }

    public static void disableRel(DynamicObject[] personUserRelDys) {
        try {
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            if (personUserRelDys != null) {
                for (DynamicObject dy : personUserRelDys) {
                    dy.set("enable", (Object)"0");
                    dy.set("modifytime", (Object)new Date());
                    dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynamicObjects.add((Object)dy);
                }
                HRPIBosUserRepository.saveUser(dynamicObjects);
            }
        }
        catch (Exception esc) {
            LOGGER.error("handleStatusError", (Throwable)esc);
        }
    }

    public static List<UserParam> getUpdateStatusUserInfo(String status, String statusTag, Map<String, String> errorMap, DynamicObject[] bosUser, Map<Long, String> dbUserMap) {
        ArrayList<UserParam> paramList = new ArrayList<UserParam>();
        for (DynamicObject dy : bosUser) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            dbUserMap.put(dy.getLong("id"), number);
            if (status.equals(dy.getString(statusTag))) continue;
            UserParam user = new UserParam();
            user.setId(dy.getLong("id"));
            HashMap<String, String> temMap = new HashMap<String, String>(16);
            temMap.put("name", name);
            temMap.put("number", number);
            user.setDataMap(temMap);
            paramList.add(user);
        }
        return paramList;
    }

    private static void updateUserInfoStatus(String enable, String isforbidden, List<UserParam> updateEnableUser, List<UserParam> updateIsForbiddenUser) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty(updateEnableUser)) {
                if (HRStringUtils.equals((String)"1", (String)enable)) {
                    userService.enable(updateEnableUser);
                } else {
                    userService.disable(updateEnableUser);
                }
            }
            if (!CollectionUtils.isEmpty(updateIsForbiddenUser)) {
                if (HRStringUtils.equals((String)"1", (String)isforbidden)) {
                    userService.enableUser(updateIsForbiddenUser);
                } else {
                    userService.disableUser(updateIsForbiddenUser);
                }
            }
        }
        catch (Exception esc) {
            LOGGER.error("invokeStatusUpdateError", (Throwable)esc);
        }
    }

    public static DynamicObject[] getHRAndBosUserRelateByBosUserIds(List<Long> bosUserIds) {
        QFilter bosQFilter = new QFilter("user", "in", bosUserIds);
        DynamicObject[] hrAndBosUserRelate = HRPIBosUserRepository.getUserRelateByPersonInfo(bosQFilter);
        return hrAndBosUserRelate;
    }

    public static DynamicObject[] getHRAndBosUserRelateByPersonIdOrMid(List<Long> personIdList, List<Long> midList) {
        QFilter personIdQFilter = new QFilter("person", "in", personIdList);
        QFilter midQFilter = new QFilter("mid", "in", midList);
        DynamicObject[] hrAndBosUserRelate = HRPIBosUserRepository.getUserRelateByPersonInfo(personIdQFilter.or(midQFilter));
        return hrAndBosUserRelate;
    }

    public static Map<Long, Long> getLasterEmployeeIdByMid(Map<Long, Long> midEmpMap) {
        Set<Long> mid = midEmpMap.keySet();
        List empId = midEmpMap.values().stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mid)) {
            return new HashMap<Long, Long>();
        }
        String selectProp = "id, startdate, mid";
        QFilter midQFilter = new QFilter("mid", "in", mid);
        QFilter idQFilter = new QFilter("id", "not in", empId);
        DynamicObject[] dynamicObjects = HRPIEmployeeRepository.listEmployeeByCustomerQFilter(selectProp, new QFilter[]{midQFilter, idQFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
        Map<Long, DynamicObject> midLasterEmpMap = Arrays.asList(dynamicObjects).stream().collect(Collectors.toMap(dy -> dy.getLong("mid"), dy -> dy, (dy1, dy2) -> HRDateTimeUtils.dayAfter((Date)dy1.getDate("startdate"), (Date)dy2.getDate("startdate")) ? dy1 : dy2));
        HashMap<Long, Long> midLasterEmpIdMap = new HashMap<Long, Long>();
        if (HRPIMapUtils.isNotEmpty(midLasterEmpMap)) {
            midLasterEmpMap.forEach((key, value) -> midLasterEmpIdMap.put((Long)key, value.getLong("id")));
        }
        return midLasterEmpIdMap;
    }
}

