/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.qing.util.MapUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;

public class ValidateHelper<T> {
    private final Set<String> errSet;
    public static Function<Object, Boolean> isQFilterType = o -> o instanceof QFilter;
    public static Function<Object, Boolean> isDateType = o -> o instanceof Date;
    public static Function<Object, Boolean> isIntegerType = o -> o instanceof Integer;
    public static Function<Object, Boolean> isDoubleType = o -> o instanceof Double;
    public static Function<Object, Boolean> isMapType = o -> o instanceof Map;
    public static Function<Object, Boolean> isBooleanType = o -> o instanceof Boolean;
    public static Function<Object, Boolean> isLongType = o -> o instanceof Long;
    public static Function<Object, Boolean> isStringType = o -> o instanceof String;
    public static Function<Object, Boolean> isListType = o -> o instanceof List;

    private ValidateHelper(Set<String> errList) {
        this.errSet = errList;
    }

    public static ValidateHelper getInstance(Set<String> errList) {
        return new ValidateHelper(errList);
    }

    public static void addErrorMsg(boolean condition, Set<String> errorSet, String errMsg) {
        if (condition) {
            errorSet.add(errMsg);
        }
    }

    public Predicate<Map> validateReqMapNotNull() {
        return map -> {
            if (null == map || map.size() == 0) {
                this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            return false;
        };
    }

    public Predicate<Map> validateMustInput(String ... keys) {
        return map -> {
            Arrays.asList(keys).forEach(oneKey -> {
                if (null == map.get(oneKey) || map.get(oneKey) instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)map.get(oneKey))) || map.get(oneKey) instanceof Map && MapUtils.isEmpty((Map)((Map)map.get(oneKey))) || map.get(oneKey) instanceof String && StringUtils.isEmpty(map.get(oneKey))) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_0", (String)"hrmp-hrpi-business", (Object[])new Object[]{oneKey}));
                }
            });
            return false;
        };
    }

    public Predicate<Map> validateArgType(Function<Object, Boolean> argType, String ... keys) {
        return map -> {
            Arrays.stream(keys).forEach(key -> {
                Optional optional = Optional.ofNullable(map.get(key));
                optional.ifPresent(value -> {
                    if (!((Boolean)argType.apply(value)).booleanValue()) {
                        this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u7684value\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[]{key}));
                    }
                });
            });
            return false;
        };
    }

    public Predicate<Object> validateArgType(Function<Object, Boolean> argType) {
        return obj -> {
            Optional.ofNullable(obj).ifPresent(o -> {
                if (!((Boolean)argType.apply(o)).booleanValue()) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u7684value\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[]{"request"}));
                }
            });
            return false;
        };
    }

    public Predicate<Map> validateLimit(String key, List<T> limitInPut) {
        return map -> {
            Optional optional = Optional.ofNullable(map.get(key));
            boolean hasKeyValueNull = map.containsKey(key) && null == map.get(key);
            optional.ifPresent(value -> {
                if (!limitInPut.contains(value)) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2 {0} \u53ea\u5141\u8bb8\u8f93\u5165 {1} , \u5f53\u524d\u503c\u4e3a {2} ;", (String)"ValidateHelper_1", (String)"hrmp-hrpi-business", (Object[])new Object[]{key, JSONObject.toJSONString((Object)limitInPut), value}));
                }
            });
            if (hasKeyValueNull) {
                this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2 {0} \u53ea\u5141\u8bb8\u8f93\u5165 {1} , \u5f53\u524d\u503c\u4e3a {2} ;", (String)"ValidateHelper_1", (String)"hrmp-hrpi-business", (Object[])new Object[]{key, JSONObject.toJSONString((Object)limitInPut), null}));
            }
            return false;
        };
    }

    public Predicate<Map> validateListSize(String key, int listSize) {
        return map -> {
            Optional optionalList = Optional.ofNullable(map.get(key));
            optionalList.ifPresent(list -> {
                if (list instanceof List && ((List)list).size() > listSize) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2 {0} \u5141\u8bb8\u4f20\u5165\u6700\u5927\u6570\u91cf\u4e3a: {1} , \u5f53\u524d\u5165\u53c2\u6570\u91cf\u4e3a: {2} ;", (String)"ValidateHelper_3", (String)"hrmp-hrpi-business", (Object[])new Object[]{key, listSize, ((List)list).size()}));
                }
            });
            return false;
        };
    }

    public Predicate<Map> validateOneOfItemsMustInput(String ... keys) {
        return map -> {
            AtomicReference<Boolean> mustInputOnePut = new AtomicReference<Boolean>(Boolean.FALSE);
            Arrays.asList(keys).forEach(oneKey -> {
                if (!(null == map.get(oneKey) || map.get(oneKey) instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)map.get(oneKey))) || map.get(oneKey) instanceof Map && MapUtils.isEmpty((Map)((Map)map.get(oneKey))))) {
                    mustInputOnePut.set(Boolean.TRUE);
                }
            });
            if (!mustInputOnePut.get().booleanValue()) {
                this.errSet.add(ResManager.loadKDString((String)"\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u5165\u53c2\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_9", (String)"hrmp-hrpi-business", (Object[])new Object[]{JSONObject.toJSONString((Object)keys)}));
            }
            return false;
        };
    }

    public Predicate<Map> validateSimilarityLimit(String similarity) {
        return map -> {
            Optional optionalO = Optional.ofNullable(map.get(similarity));
            optionalO.ifPresent(value -> {
                BigDecimal thisV;
                BigDecimal zero = new BigDecimal(0);
                BigDecimal one = new BigDecimal(1);
                if (!(value instanceof Double) || (thisV = BigDecimal.valueOf((Double)value)).compareTo(zero) <= 0 || thisV.compareTo(one) > 0) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u9650\u5b9adouble\u7c7b\u578b\u6570\u636e\uff0c\u8303\u56f4\u4e3a[0\uff0c1]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u3002", (String)"ValidateHelper_4", (String)"hrmp-hrpi-business", (Object[])new Object[]{similarity}));
                }
            });
            return false;
        };
    }

    public Predicate<Map> validateMatchArgs(String matchArgs) {
        return map -> {
            List<String> outKeys = Arrays.asList("hrpi_pereduexp", "hrpi_preworkexp");
            AtomicReference<Boolean> legal = new AtomicReference<Boolean>(Boolean.TRUE);
            Optional optionalO = Optional.ofNullable(map.get(matchArgs));
            optionalO.ifPresent(valueMap -> this.legalKeyMap(matchArgs, outKeys, legal, valueMap));
            return false;
        };
    }

    private void legalKeyMap(String matchArgs, List<String> outKeys, AtomicReference<Boolean> legal, Object valueMap) {
        if (valueMap instanceof Map) {
            ((Map)valueMap).keySet().forEach(outKey -> {
                if (!outKeys.contains(outKey)) {
                    legal.set(Boolean.FALSE);
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c{0}\u201d\u9650\u5b9a\u8f93\u5165key\u7684\u8303\u56f4\u4e3a{1}\uff0c\u5f53\u524d\u503cKey\u503c\u4e3a{2}\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_5", (String)"hrmp-hrpi-business", (Object[])new Object[]{matchArgs, JSONObject.toJSONString((Object)outKeys), outKey}));
                }
            });
            boolean oneOfThemInput = this.validateOneOfItemsMustInput(outKeys.toArray(new String[0])).test((Map)valueMap);
            if (!oneOfThemInput) {
                legal.set(Boolean.FALSE);
            }
            if (legal.get().booleanValue()) {
                Optional optionalEdu = Optional.ofNullable(((Map)valueMap).get("hrpi_pereduexp"));
                optionalEdu.ifPresent(listMap -> {
                    if (!(listMap instanceof List) || CollectionUtils.isEmpty((Collection)((List)listMap)) || !(((List)listMap).get(0) instanceof Map)) {
                        this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u7684value\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[]{"hrpi_pereduexp"}));
                        legal.set(Boolean.FALSE);
                    } else {
                        ((List)listMap).forEach(map -> this.legalKeyMap("hrpi_pereduexp", Arrays.asList("graduateschool_id", "admissiondate"), legal, map));
                    }
                });
                Optional optionalPreWork = Optional.ofNullable(((Map)valueMap).get("hrpi_preworkexp"));
                optionalPreWork.ifPresent(listMap -> {
                    if (!(listMap instanceof List) || CollectionUtils.isEmpty((Collection)((List)listMap)) || !(((List)listMap).get(0) instanceof Map)) {
                        this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u7684value\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[]{"hrpi_preworkexp"}));
                        legal.set(Boolean.FALSE);
                    } else {
                        ((List)listMap).forEach(map -> this.legalKeyMap("hrpi_preworkexp", Collections.singletonList("unitname"), legal, map));
                    }
                });
            }
        } else {
            this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u7684value\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[]{matchArgs}));
            legal.set(Boolean.FALSE);
        }
    }

    public Predicate<Map> validateDateRel(String dateBefore, String dateAfter) {
        return map -> {
            AtomicReference before = new AtomicReference();
            Optional.ofNullable(map.get(dateBefore)).ifPresent(d -> before.set(DateUtil.getDate(d)));
            AtomicReference after = new AtomicReference();
            Optional.ofNullable(map.get(dateAfter)).ifPresent(d -> after.set(DateUtil.getDate(d)));
            if (null != before.get() && null != after.get() && !((Date)before.get()).before((Date)after.get())) {
                this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c{0}\u201d\u5fc5\u987b\u5728\u201c{1}\u201d\u4e4b\u524d\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_8", (String)"hrmp-hrpi-business", (Object[])new Object[]{dateBefore, dateAfter}));
            }
            return false;
        };
    }

    public Predicate<Map> validatePairInput(String keyOne, String keyTwo) {
        return map -> {
            if (null != map.get(keyOne) && null == map.get(keyTwo) || null == map.get(keyOne) && null != map.get(keyTwo)) {
                this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u201c{0}\u201d\u548c\u201c{1}\u201d\u5fc5\u987b\u6210\u5bf9\u8f93\u5165\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_7", (String)"hrmp-hrpi-business", (Object[])new Object[]{keyOne, keyTwo}));
            }
            return false;
        };
    }

    public Predicate<List> validateListSize(int listSizeLimit) {
        return list -> {
            Optional.of(list).ifPresent(l -> {
                if (l.size() > listSizeLimit) {
                    this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2 {0} \u5141\u8bb8\u4f20\u5165\u6700\u5927\u6570\u91cf\u4e3a: {1} , \u5f53\u524d\u5165\u53c2\u6570\u91cf\u4e3a: {2} ;", (String)"ValidateHelper_3", (String)"hrmp-hrpi-business", (Object[])new Object[]{null, listSizeLimit, l.size()}));
                }
            });
            return false;
        };
    }

    public Predicate<List> validateReqListNotNull() {
        return list -> {
            if (null == list || list.size() == 0) {
                this.errSet.add(ResManager.loadKDString((String)"\u5165\u53c2\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\uff1b", (String)"ValidateHelper_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            return false;
        };
    }
}

