/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper.revise;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hrpi.business.helper.revise.BusinessUtils;

public class CalServiceLengthHandler {
    private static final Log LOGGER = LogFactory.getLog(CalServiceLengthHandler.class);
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    public static Map<Long, BigDecimal> calcEmpentrelContinuation(List<DynamicObject> continuationDys, String calFirstAdjTime, String judgeTime) {
        HashMap<Long, BigDecimal> totalServiceLengthMap = new HashMap<Long, BigDecimal>(16);
        if (continuationDys.size() == 0) {
            return totalServiceLengthMap;
        }
        Set<Long> empMid = continuationDys.stream().filter(conDy -> conDy.getLong("employee.mid") != 0L).map(conDy -> conDy.getLong("employee.mid")).collect(Collectors.toSet());
        Object[] empMidDys = CalServiceLengthHandler.queryEmployeeByMid(empMid);
        if (empMid.size() == 0 || HRArrayUtils.isEmpty((Object[])empMidDys)) {
            return totalServiceLengthMap;
        }
        Set<Long> empIds = Arrays.stream(empMidDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Object[] oldEmpentrelDys = CalServiceLengthHandler.queryEmpentrelByEmpId(empIds);
        if (HRArrayUtils.isEmpty((Object[])oldEmpentrelDys)) {
            return totalServiceLengthMap;
        }
        Map<Long, List<DynamicObject>> midEmpentrelMap = Arrays.stream(oldEmpentrelDys).collect(Collectors.groupingBy(conDy -> conDy.getLong("employee.mid")));
        for (DynamicObject conDy2 : continuationDys) {
            long lastId = conDy2.getLong("boid");
            long mid = conDy2.getLong("employee.mid");
            Date sData = conDy2.getDate("startdate");
            List<DynamicObject> oldEmpentrelTmpDys = midEmpentrelMap.get(mid);
            if (oldEmpentrelTmpDys == null || oldEmpentrelTmpDys.size() == 0) continue;
            oldEmpentrelTmpDys.sort(CalServiceLengthHandler::compare);
            BigDecimal lastServiceLength = new BigDecimal(0);
            for (DynamicObject oldEmpentrelDy : oldEmpentrelTmpDys) {
                Date endDate;
                Date startDate = oldEmpentrelDy.getDate("startdate");
                if ("1".equals(judgeTime) && sData.before(startDate)) continue;
                long oldId = oldEmpentrelDy.getLong("boid");
                BigDecimal adjustLength = oldEmpentrelDy.getBigDecimal("adjustlength");
                if (lastId == oldId) {
                    endDate = new Date();
                    long statusPro = oldEmpentrelDy.getLong("labrelstatusprd.id");
                    if (statusPro == 1020L) {
                        endDate = oldEmpentrelDy.getDate("enddate");
                    }
                    if ("1".equals(calFirstAdjTime)) {
                        lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, adjustLength, null));
                        continue;
                    }
                    lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, null));
                    continue;
                }
                endDate = oldEmpentrelDy.getDate("enddate");
                if (startDate == null || endDate == null) continue;
                lastServiceLength = lastServiceLength.add(CalServiceLengthHandler.calcServiceLength(startDate, endDate, adjustLength, null));
                String serviceAgeScheme = oldEmpentrelDy.getString("serviceagescheme");
                if ("2".equals(serviceAgeScheme)) continue;
                break;
            }
            totalServiceLengthMap.put(mid, lastServiceLength);
        }
        return totalServiceLengthMap;
    }

    private static int compare(DynamicObject dynamicObject, DynamicObject dynamicObject1) {
        return dynamicObject.getDate("startdate").after(dynamicObject1.getDate("startdate")) ? -1 : 1;
    }

    public static BigDecimal calcServiceLength(Date startdate, Date endDate, BigDecimal adjustlength, DynamicObject dynamicObject) {
        BigDecimal years = CalServiceLengthHandler.calcYearsDiff(endDate, startdate);
        BigDecimal serviceLength = years.add(adjustlength);
        if (dynamicObject != null) {
            dynamicObject.set("servicelength", (Object)serviceLength);
        }
        return serviceLength;
    }

    public static BigDecimal calcServiceLength(Date startdate, Date endDate, DynamicObject dynamicObject) {
        BigDecimal serviceLength = CalServiceLengthHandler.calcYearsDiff(endDate, startdate);
        if (dynamicObject != null) {
            dynamicObject.set("servicelength", (Object)serviceLength);
        }
        return serviceLength;
    }

    private static DynamicObject[] queryEmpentrelByEmpId(Set<Long> empIds) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter midFilter = new QFilter("employee", "in", empIds);
        return EMPENTREL_HELPER.query("id,boid,person,entservicelen,employee.mid,servicelength,adjustlength,startdate,enddate,iscurrentversion,serviceagescheme,boid,labrelstatusprd", new QFilter[]{qFilter, midFilter});
    }

    private static DynamicObject[] queryEmployeeByMid(Set<Long> empMid) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter midFilter = new QFilter("mid", "in", empMid);
        return EMPLOYEE_HELPER.query("id,mid", new QFilter[]{qFilter, midFilter});
    }

    @Deprecated
    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        return BusinessUtils.calcYearsDiff(dateO, dateT);
    }
}

