/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper.revise;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.UserProp;
import kd.hr.hbp.common.util.HRStringUtils;

public class DynamicConvertUtils {
    private List<String> excludeProps;

    public DynamicConvertUtils(List<String> excludeProps) {
        if (excludeProps == null) {
            excludeProps = new ArrayList<String>();
        }
        this.excludeProps = excludeProps;
    }

    public List<CompareResult> compareAndGetAllDiffCol(DynamicObject dynamicObject, DynamicObject sourceDynamic) {
        if (dynamicObject == null || sourceDynamic == null) {
            return new ArrayList<CompareResult>(8);
        }
        IDataEntityType type = dynamicObject.getDataEntityType();
        HashSet props = Sets.newHashSetWithExpectedSize((int)type.getProperties().size());
        for (IDataEntityProperty prop : type.getProperties()) {
            if (prop instanceof EntryProp || prop.isDbIgnore() && !(prop instanceof BasedataProp) || this.excludeProps.contains(prop.getName()) || prop instanceof LongProp && ((LongProp)prop).isRefId()) continue;
            props.add(prop);
        }
        IDataEntityType sourceType = sourceDynamic.getDataEntityType();
        Set sourceTypeProps = sourceType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        Set propsFinal = props.stream().filter(data -> sourceTypeProps.contains(data.getName())).collect(Collectors.toSet());
        ArrayList<CompareResult> result = new ArrayList<CompareResult>(8);
        for (IDataEntityProperty prop : propsFinal) {
            CompareResult compareResult = DynamicConvertUtils.getCompareResult(prop, dynamicObject, sourceDynamic);
            result.add(compareResult);
        }
        return result;
    }

    public static CompareResult getCompareResult(IDataEntityProperty prop, DynamicObject dynamicObject, DynamicObject sourceDynamic) {
        CompareResult compareResult = new CompareResult();
        compareResult.setPropKey(prop.getName());
        compareResult.setPropType(prop.getClass().getName());
        boolean same = true;
        String col = prop.getName();
        if (prop instanceof MuliLangTextProp) {
            ILocaleString data = dynamicObject.getLocaleString(col);
            ILocaleString sourceData = sourceDynamic.getLocaleString(col);
            same = DynamicConvertUtils.compareMulLangTextCol(data, sourceData);
        } else if (prop instanceof UserProp) {
            Object data = dynamicObject.get(col);
            Object sourceData = sourceDynamic.get(col);
            Long dataId = 0L;
            Long sourceDataId = 0L;
            if (data instanceof DynamicObject) {
                dataId = ((DynamicObject)data).getLong("id");
            } else if (data instanceof Long) {
                dataId = (Long)data;
            }
            if (sourceData instanceof DynamicObject) {
                sourceDataId = ((DynamicObject)sourceData).getLong("id");
            } else if (sourceData instanceof Long) {
                sourceDataId = (Long)sourceData;
            }
            same = DynamicConvertUtils.compareCommonCol(dataId, sourceDataId);
        } else if (prop instanceof BasedataProp) {
            DynamicObject data = dynamicObject.getDynamicObject(col);
            DynamicObject sourceData = sourceDynamic.getDynamicObject(col);
            same = DynamicConvertUtils.compareBaseDataCol(data, sourceData);
        } else if (prop instanceof DynamicObjectCollection) {
            DynamicObjectCollection data = dynamicObject.getDynamicObjectCollection(col);
            DynamicObjectCollection sourceData = sourceDynamic.getDynamicObjectCollection(col);
            same = DynamicConvertUtils.compareDynaCollectCol(data, sourceData);
        } else if (prop instanceof DateProp || prop instanceof DateTimeProp) {
            Date data = dynamicObject.getDate(col);
            Date sourceData = sourceDynamic.getDate(col);
            same = DynamicConvertUtils.compareDateCol(data, sourceData);
        } else {
            Object data = dynamicObject.get(col);
            Object sourceData = sourceDynamic.get(col);
            same = DynamicConvertUtils.compareCommonCol(data, sourceData);
        }
        compareResult.setSame(same);
        if (!same) {
            compareResult.setBeforeValue(String.valueOf(sourceDynamic.getLong("id")));
            compareResult.setAfterValue(String.valueOf(dynamicObject.getLong("id")));
        }
        return compareResult;
    }

    public static boolean compareMulLangTextCol(ILocaleString val, ILocaleString sourceVal) {
        if (ObjectUtils.isEmpty((Object)val) && ObjectUtils.isEmpty((Object)sourceVal)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)val) || ObjectUtils.isEmpty((Object)sourceVal)) {
            return false;
        }
        HashSet mulLangType = new HashSet(4);
        mulLangType.addAll(val.keySet());
        mulLangType.addAll(sourceVal.keySet());
        for (String type : mulLangType) {
            if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type)) continue;
            String sourceSubVal = (String)sourceVal.getOrDefault((Object)type, (Object)"");
            String subVal = (String)val.getOrDefault((Object)type, (Object)"");
            if (subVal.equals(sourceSubVal)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBaseDataCol(DynamicObject dynamicObject, DynamicObject sourceDynamic) {
        if (ObjectUtils.isEmpty((Object)dynamicObject) && ObjectUtils.isEmpty((Object)sourceDynamic)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)sourceDynamic)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(dynamicObject.getPkValue()), (String)String.valueOf(sourceDynamic.getPkValue()));
    }

    public static boolean compareDynaCollectCol(DynamicObjectCollection datas, DynamicObjectCollection sourceDatas) {
        if (ObjectUtils.isEmpty((Object)datas) && ObjectUtils.isEmpty((Object)sourceDatas)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)datas) || ObjectUtils.isEmpty((Object)sourceDatas)) {
            return false;
        }
        Map<Object, DynamicObject> dataMap = datas.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Map<Object, DynamicObject> sourceMap = sourceDatas.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (dataMap.size() != sourceMap.size()) {
            return false;
        }
        for (Map.Entry<Object, DynamicObject> entry : dataMap.entrySet()) {
            DynamicObject srouceDy = sourceMap.get(entry.getKey());
            if (!ObjectUtils.isEmpty((Object)srouceDy)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareDateCol(Date data, Date sourceData) {
        if (ObjectUtils.isEmpty((Object)data) && ObjectUtils.isEmpty((Object)sourceData)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)data) || ObjectUtils.isEmpty((Object)sourceData)) {
            return false;
        }
        return data.compareTo(sourceData) == 0;
    }

    public static boolean compareCommonCol(Object data, Object sourceData) {
        if (ObjectUtils.isEmpty((Object)data) && ObjectUtils.isEmpty((Object)sourceData)) {
            return true;
        }
        if (ObjectUtils.isEmpty((Object)data) || ObjectUtils.isEmpty((Object)sourceData)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(data), (String)String.valueOf(sourceData));
    }

    public static class CompareResult {
        private boolean same = true;
        private String propKey;
        private String propType;
        private String basedataPropCode;
        private String beforeValue;
        private String afterValue;

        public String getPropKey() {
            return this.propKey;
        }

        public void setPropKey(String propKey) {
            this.propKey = propKey;
        }

        public String getPropType() {
            return this.propType;
        }

        public void setPropType(String propType) {
            this.propType = propType;
        }

        public String getBasedataPropCode() {
            return this.basedataPropCode;
        }

        public void setBasedataPropCode(String basedataPropCode) {
            this.basedataPropCode = basedataPropCode;
        }

        public String getBeforeValue() {
            return this.beforeValue;
        }

        public void setBeforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
        }

        public String getAfterValue() {
            return this.afterValue;
        }

        public void setAfterValue(String afterValue) {
            this.afterValue = afterValue;
        }

        public boolean isSame() {
            return this.same;
        }

        public void setSame(boolean same) {
            this.same = same;
        }
    }
}

