/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.helper.revise;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.CommonQueryRepository;
import kd.hrmp.hrpi.business.helper.revise.CalServiceLengthHandler;
import kd.hrmp.hrpi.business.helper.revise.DynamicConvertUtils;
import kd.hrmp.hrpi.business.helper.revise.ReviseEntityNameHelperEnum;
import kd.hrmp.hrpi.common.HRPIPersonReviseConstants;

public class HRPIPersonReviseHelper
implements HRPIPersonReviseConstants {
    public static Map<Long, String> getIdVsAbstractMap(String reviseLogEntityNum, List<Long> reviseLogIdList) {
        return HRPIPersonReviseHelper.getIdVsAbstractMap(reviseLogEntityNum, reviseLogIdList, Lists.newArrayListWithExpectedSize((int)0));
    }

    public static Map<Long, String> getIdVsAbstractMap(String reviseLogEntityNum, List<Long> reviseLogIdList, List<String> ignoreFieldList) {
        HashMap idVsAbstractMap = Maps.newHashMapWithExpectedSize((int)20);
        QFilter idFilter = new QFilter("id", "in", reviseLogIdList);
        HashSet queryFieldSet = Sets.newHashSet((Object[])new String[]{"id", "revisetype", "revisebefore", "reviseafter", "revisenumber"});
        DynamicObject[] reviseLogDynArr = CommonQueryRepository.getInstance().queryColsInfoByFilter(reviseLogEntityNum, queryFieldSet, idFilter);
        if (reviseLogDynArr.length == 0) {
            return idVsAbstractMap;
        }
        Map<Long, DynamicObject> idVsDynMap = HRPIPersonReviseHelper.getIdVsDynMap(reviseLogDynArr);
        for (DynamicObject reviseLogDyn : reviseLogDynArr) {
            String reviseType = reviseLogDyn.getString("revisetype");
            String reviseNumber = reviseLogDyn.getString("revisenumber");
            String groupName = ReviseEntityNameHelperEnum.getPageNameByBaseEntityName(reviseNumber);
            StringBuilder abstractSb = new StringBuilder();
            if (HRStringUtils.equals((String)reviseType, (String)"0")) {
                abstractSb.append(String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HRPIPersonReviseHelper_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]), groupName));
            } else if (HRStringUtils.equals((String)reviseType, (String)"1")) {
                abstractSb.append(String.format(ResManager.loadKDString((String)"\u5220\u9664%s", (String)"HRPIPersonReviseHelper_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), groupName));
            } else if (HRStringUtils.equals((String)reviseType, (String)"5")) {
                DynamicObject reviseBeforeDyn = idVsDynMap.get(reviseLogDyn.getLong("revisebefore"));
                DynamicObject reviseAfterDyn = idVsDynMap.get(reviseLogDyn.getLong("reviseafter"));
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)reviseNumber);
                DataEntityPropertyCollection mainEntityTypeProps = mainEntityType.getProperties();
                Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
                List<String> compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList(reviseNumber);
                if (!CollectionUtils.isEmpty(ignoreFieldList)) {
                    compareExcludeFieldList.addAll(ignoreFieldList);
                }
                DynamicConvertUtils dynamicConvertUtils = new DynamicConvertUtils(compareExcludeFieldList);
                List<DynamicConvertUtils.CompareResult> compareResults = dynamicConvertUtils.compareAndGetAllDiffCol(reviseAfterDyn, reviseBeforeDyn);
                for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                    String afterDisplayValue;
                    boolean same = compareResult.isSame();
                    if (same) continue;
                    String reviseFieldName = compareResult.getPropKey();
                    String fieldDisplayName = propMap.get(reviseFieldName).getDisplayName().getLocaleValue();
                    IDataEntityProperty prop = propMap.get(reviseFieldName);
                    if (prop instanceof MuliLangTextProp) {
                        HRPIPersonReviseHelper.treatAbstractForMultiLang(abstractSb, reviseBeforeDyn, reviseAfterDyn, fieldDisplayName, prop);
                        continue;
                    }
                    String beforeDisplayValue = HRPIPersonReviseHelper.getDisplayValueByProp(reviseBeforeDyn, propMap.get(reviseFieldName));
                    if (HRStringUtils.isEmpty((String)beforeDisplayValue)) {
                        beforeDisplayValue = ResManager.loadKDString((String)"\u7a7a", (String)"HRPIPersonReviseHelper_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                    }
                    if (HRStringUtils.isEmpty((String)(afterDisplayValue = HRPIPersonReviseHelper.getDisplayValueByProp(reviseAfterDyn, propMap.get(reviseFieldName))))) {
                        afterDisplayValue = ResManager.loadKDString((String)"\u7a7a", (String)"HRPIPersonReviseHelper_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                    }
                    if (HRStringUtils.equals((String)reviseFieldName, (String)"servicelength") && HRStringUtils.equals((String)beforeDisplayValue, (String)afterDisplayValue)) continue;
                    abstractSb.append(String.format(ResManager.loadKDString((String)"\u5c06%1$s\u7531%2$s\u4fee\u8ba2\u4e3a%3$s;%4$s", (String)"HRPIPersonReviseHelper_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), fieldDisplayName, beforeDisplayValue, afterDisplayValue, System.lineSeparator()));
                }
            }
            long id = reviseLogDyn.getLong("id");
            idVsAbstractMap.put(id, abstractSb.toString());
        }
        return idVsAbstractMap;
    }

    private static Map<Long, DynamicObject> getIdVsDynMap(DynamicObject[] reviseLogDynArr) {
        Map<String, List<DynamicObject>> reviseNumberVsDynListMap = Arrays.stream(reviseLogDynArr).collect(Collectors.groupingBy(dyn -> dyn.getString("revisenumber")));
        HashMap allIdVsDynMap = Maps.newHashMapWithExpectedSize((int)reviseLogDynArr.length);
        for (Map.Entry<String, List<DynamicObject>> entry : reviseNumberVsDynListMap.entrySet()) {
            String reviseNumber = entry.getKey();
            List<DynamicObject> dynList = entry.getValue();
            HashSet entityDataIdSet = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject dyn2 : dynList) {
                entityDataIdSet.add(dyn2.getLong("revisebefore"));
                entityDataIdSet.add(dyn2.getLong("reviseafter"));
            }
            DynamicObject[] reviseDynArr = CommonQueryRepository.getInstance().loadInfoByIds(reviseNumber, entityDataIdSet);
            Map<Long, DynamicObject> idVsDynMap = Arrays.stream(reviseDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            allIdVsDynMap.putAll(idVsDynMap);
        }
        return allIdVsDynMap;
    }

    private static void treatAbstractForMultiLang(StringBuilder abstractSb, DynamicObject reviseBeforeDyn, DynamicObject reviseAfterDyn, String fieldDisplayName, IDataEntityProperty prop) {
        String propName = prop.getName();
        ILocaleString beforeVal = reviseBeforeDyn.getLocaleString(propName);
        ILocaleString afterVal = reviseAfterDyn.getLocaleString(propName);
        HashSet mulLangType = new HashSet(4);
        mulLangType.addAll(beforeVal.keySet());
        mulLangType.addAll(afterVal.keySet());
        for (String type : mulLangType) {
            String afterSubVal;
            String beforeSubVal;
            if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type) || HRStringUtils.equals((String)(beforeSubVal = (String)beforeVal.getOrDefault((Object)type, (Object)ResManager.loadKDString((String)"\u7a7a", (String)"HRPIPersonReviseHelper_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]))), (String)(afterSubVal = (String)afterVal.getOrDefault((Object)type, (Object)ResManager.loadKDString((String)"\u7a7a", (String)"HRPIPersonReviseHelper_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]))))) continue;
            abstractSb.append(String.format(ResManager.loadKDString((String)"\u5c06%1$s\uff08%2$s\uff09\u7531%3$s\u4fee\u8ba2\u4e3a%4$s;", (String)"HRPIPersonReviseHelper_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]), fieldDisplayName, type, beforeSubVal, afterSubVal));
            abstractSb.append(System.lineSeparator());
        }
    }

    public static DynamicObject generateLogDetailDyn(String logEntityName, Long reviseLogId) {
        return HRPIPersonReviseHelper.generateLogDetailDyn(logEntityName, reviseLogId, Lists.newArrayListWithExpectedSize((int)0));
    }

    public static DynamicObject generateLogDetailDyn(String logEntityName, Long reviseLogId, List<String> ignoreFieldList) {
        DynamicObject reviseLogDyn = CommonQueryRepository.getInstance().loadInfoById(logEntityName, reviseLogId);
        String reviseType = reviseLogDyn.getString("revisetype");
        String baseEntityName = reviseLogDyn.getString("revisenumber");
        Long beforeId = HRPIPersonReviseHelper.getBaseDataId(reviseLogDyn, "revisebefore");
        Long afterId = HRPIPersonReviseHelper.getBaseDataId(reviseLogDyn, "reviseafter");
        DynamicObject[] dynArr = CommonQueryRepository.getInstance().loadInfoByIds(baseEntityName, new HashSet<Long>(Arrays.asList(beforeId, afterId)));
        DynamicObject beforeDyn = new DynamicObject();
        DynamicObject afterDyn = new DynamicObject();
        switch (reviseType) {
            case "0": {
                afterDyn = Arrays.stream(dynArr).filter(dyn -> dyn.getLong("id") == afterId.longValue()).findFirst().get();
                beforeDyn = new HRBaseServiceHelper(afterDyn.getDynamicObjectType().getName()).generateEmptyDynamicObject();
                break;
            }
            case "1": {
                beforeDyn = Arrays.stream(dynArr).filter(dyn -> dyn.getLong("id") == beforeId.longValue()).findFirst().get();
                afterDyn = new HRBaseServiceHelper(beforeDyn.getDynamicObjectType().getName()).generateEmptyDynamicObject();
                break;
            }
            case "5": {
                beforeDyn = Arrays.stream(dynArr).filter(dyn -> dyn.getLong("id") == beforeId.longValue()).findFirst().get();
                afterDyn = Arrays.stream(dynArr).filter(dyn -> dyn.getLong("id") == afterId.longValue()).findFirst().get();
                break;
            }
        }
        List<String> compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList(baseEntityName);
        if (!CollectionUtils.isEmpty(ignoreFieldList)) {
            compareExcludeFieldList.addAll(ignoreFieldList);
        }
        DynamicConvertUtils dynamicCompareUtils = new DynamicConvertUtils(compareExcludeFieldList);
        List<DynamicConvertUtils.CompareResult> compareResults = dynamicCompareUtils.compareAndGetAllDiffCol(beforeDyn, afterDyn);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName);
        DataEntityPropertyCollection mainEntityTypeProps = mainEntityType.getProperties();
        Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
        HRBaseServiceHelper reviseLogDetailHelper = new HRBaseServiceHelper("hspm_reviselogdetail");
        DynamicObject reviseLogDetailDyn = reviseLogDetailHelper.generateEmptyDynamicObject();
        DynamicObjectCollection detailDynCol = reviseLogDetailDyn.getDynamicObjectCollection("reviselogdetail");
        if (!CollectionUtils.isEmpty(compareResults)) {
            for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                DynamicObject reviseLogDetail = new DynamicObject(detailDynCol.getDynamicObjectType());
                String reviseFieldName = compareResult.getPropKey();
                String fieldDisplayName = propMap.get(reviseFieldName).getDisplayName().getLocaleValue();
                String beforeDisplayValue = HRPIPersonReviseHelper.getDisplayValueByProp(beforeDyn, propMap.get(reviseFieldName));
                String afterDisplayValue = HRPIPersonReviseHelper.getDisplayValueByProp(afterDyn, propMap.get(reviseFieldName));
                boolean booleanPropNewOrDeleteFlag = false;
                String propType = compareResult.getPropType();
                if (BooleanProp.class.getName().equals(propType)) {
                    if ("0".equals(reviseType)) {
                        beforeDisplayValue = "";
                        booleanPropNewOrDeleteFlag = true;
                    } else if ("1".equals(reviseType)) {
                        afterDisplayValue = "";
                        booleanPropNewOrDeleteFlag = true;
                    }
                }
                if (compareResult.isSame() && !booleanPropNewOrDeleteFlag || HRStringUtils.equals((String)reviseFieldName, (String)"servicelength") && HRStringUtils.equals((String)beforeDisplayValue, (String)afterDisplayValue)) continue;
                reviseLogDetail.set("revisetype", (Object)reviseType);
                reviseLogDetail.set("revisefield", (Object)reviseFieldName);
                reviseLogDetail.set("revisefieldname", (Object)fieldDisplayName);
                reviseLogDetail.set("revisebefore", (Object)beforeDisplayValue);
                reviseLogDetail.set("reviseafter", (Object)afterDisplayValue);
                detailDynCol.add((Object)reviseLogDetail);
            }
        }
        return reviseLogDetailDyn;
    }

    private static Long getBaseDataId(DynamicObject dyn, String fieldName) {
        Object fieldObject = dyn.get(fieldName);
        if (fieldObject instanceof DynamicObject) {
            DynamicObject baseDataDyn = (DynamicObject)fieldObject;
            if (Objects.nonNull(baseDataDyn)) {
                return baseDataDyn.getLong("id");
            }
        } else {
            return (Long)fieldObject;
        }
        return 0L;
    }

    public static String getDisplayValueByProp(DynamicObject dyn, IDataEntityProperty prop) {
        if (prop == null) {
            return null;
        }
        String propName = prop.getName();
        if (prop instanceof MuliLangTextProp) {
            ILocaleString val = dyn.getLocaleString(propName);
            HashSet<String> allStr = new HashSet<String>(4);
            HashSet mulLangType = new HashSet(4);
            mulLangType.addAll(val.keySet());
            for (String type : mulLangType) {
                if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type)) continue;
                String subVal = (String)val.getOrDefault((Object)type, (Object)"");
                allStr.add(subVal + "(" + type + ")");
            }
            return StringUtils.join((Object[])allStr.toArray(), (String)",");
        }
        if (prop instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)prop;
            if (dyn != null) {
                return comboProp.getItemByName(dyn.getString(propName));
            }
        } else if (prop instanceof BasedataProp) {
            DynamicObject propValue;
            BasedataProp basedataProp = (BasedataProp)prop;
            if (dyn != null && (propValue = dyn.getDynamicObject(propName)) != null) {
                return propValue.getString(basedataProp.getDisplayProp());
            }
        } else {
            if (prop instanceof MulBasedataProp) {
                return dyn.getDynamicObjectCollection(prop).stream().map(dy -> dy.getString("fbasedataid.name")).collect(Collectors.joining(","));
            }
            if (prop instanceof DateProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    return HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)((DateProp)prop), (Date)dyn.getDate(propName), (Long)0L);
                }
            } else if (prop instanceof DateTimeProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    return HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)((DateTimeProp)prop), (Date)dyn.getDate(propName), (Long)0L);
                }
            } else if (prop instanceof IntegerProp) {
                if (dyn != null) {
                    return dyn.getString(propName);
                }
            } else if (prop instanceof BooleanProp) {
                String flag = dyn.getString(propName);
                if (HRStringUtils.equals((String)"true", (String)flag)) {
                    return ResManager.loadKDString((String)"\u662f", (String)"HRPIPersonReviseHelper_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                }
                if (HRStringUtils.equals((String)"false", (String)flag)) {
                    return ResManager.loadKDString((String)"\u5426", (String)"HRPIPersonReviseHelper_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                }
            } else if (prop instanceof DecimalProp && dyn != null) {
                if ("servicelength".equals(prop.getName())) {
                    BigDecimal serviceLength = HRPIPersonReviseHelper.setServiceLength(dyn);
                    if (serviceLength != null) {
                        return String.valueOf(serviceLength).substring(0, dyn.getString(propName).lastIndexOf(".") + 2);
                    }
                } else {
                    return dyn.getString(propName).substring(0, dyn.getString(propName).lastIndexOf(".") + 2);
                }
            }
        }
        if (dyn != null) {
            return dyn.getString(propName);
        }
        return null;
    }

    private static BigDecimal setServiceLength(DynamicObject dyn) {
        BigDecimal adjustLength = dyn.getBigDecimal("adjustlength");
        Date startDate = dyn.getDate("startdate");
        String scheme = dyn.getString("serviceagescheme");
        if ("2".equals(scheme)) {
            Map<Long, BigDecimal> serLenMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(dyn), "0", "1");
            BigDecimal serLen = serLenMap.get(dyn.getLong("employee.mid"));
            if (serLen != null) {
                BigDecimal serAdd = serLen.add(adjustLength);
                return serAdd;
            }
            return new BigDecimal("");
        }
        Date endDate = new Date();
        long statusPro = dyn.getLong("labrelstatusprd.id");
        if (statusPro == 1020L) {
            endDate = dyn.getDate("enddate");
        }
        BigDecimal serLength = HRPIPersonReviseHelper.calcYearsDiff(endDate, new Date(startDate.getTime())).add(adjustLength);
        return serLength;
    }

    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        if (null == dateO || null == dateT || dateO.before(dateT)) {
            return BigDecimal.ZERO;
        }
        return HRPerserlenHelper.calcYearsDiffNew((Date)dateO, (Date)dateT);
    }
}

