/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.infrastructure.utils;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class BusinessDataUtil {
    private static final Log LOGGER = LogFactory.getLog(BusinessDataUtil.class);
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    public static BigDecimal getWorkYear(Date joinWorkTime, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(joinWorkTime, adjustLength);
    }

    public static BigDecimal getWorkYear(Date endDate, Date joinWorkTime, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(endDate, joinWorkTime, adjustLength);
    }

    public static BigDecimal getComServiceLength(Date firstJoinComDate, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(firstJoinComDate, adjustLength);
    }

    public static BigDecimal getComServiceLength(Date endDate, Date firstJoinComDate, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(endDate, firstJoinComDate, adjustLength);
    }

    public static BigDecimal getServiceLength(Date stateDate, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(stateDate, adjustLength);
    }

    public static BigDecimal getServiceLength(Date endDate, Date stateDate, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(endDate, stateDate, adjustLength);
    }

    public static int getAge(Date birthday) {
        return BusinessDataUtil.calculateAgeData(birthday);
    }

    private static BigDecimal getDateDiff(Date startDate, BigDecimal adjustLength) {
        return BusinessDataUtil.getDateDiff(new Date(), startDate, adjustLength);
    }

    private static BigDecimal getDateDiff(Date nowDate, Date startDate, BigDecimal adjustLength) {
        if (adjustLength == null) {
            adjustLength = BigDecimal.ZERO;
        }
        return adjustLength.add(HRPerserlenHelper.calcYearsDiffNew((Date)nowDate, (Date)startDate));
    }

    private static int calculateAgeData(Date birthday) {
        if (birthday == null) {
            return 0;
        }
        return Math.toIntExact(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)birthday, (Date)new Date()));
    }
}

