/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.infrastructure.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;

public class DateUtil {
    private static final Log LOGGER = LogFactory.getLog(DateUtil.class);

    public static boolean dayEquals(Date dateOne, Date dateTwo) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        return fmt.format(dateOne).equals(fmt.format(dateTwo));
    }

    public static int dateCompareString(Date date, String dStr, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        LocalDate strDate = LocalDate.parse(dStr, formatter);
        LocalDate localDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return localDate.compareTo(strDate);
    }

    public static Date getDateByString(String dateStr, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        return fmt.parse(dateStr, pos);
    }

    public static int compareDate(Date d1, Date d2) {
        LocalDate localDate1 = ZonedDateTime.ofInstant(d1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = ZonedDateTime.ofInstant(d2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return localDate1.compareTo(localDate2);
    }

    public static boolean isNextDay(Date bDate, Date sDate) {
        LocalDate localDate1 = ZonedDateTime.ofInstant(bDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = ZonedDateTime.ofInstant(sDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return localDate2.plusDays(1L).compareTo(localDate1) == 0;
    }

    public static Date dateWithoutTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(sdf.format(date));
        }
        catch (ParseException ex) {
            LOGGER.error("parse date error", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDate(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        throw new KDBizException("date format error");
    }

    public static BigDecimal calcDaysDiff(Date dateO, Date dateT) {
        if (null == dateO || null == dateT || dateO.before(dateT)) {
            LOGGER.error("date calculate failed , we will return zero");
            return BigDecimal.ZERO;
        }
        BigDecimal res = BigDecimal.valueOf(dateO.getTime() - dateT.getTime());
        return res.divide(BigDecimal.valueOf(86400000L), 1, RoundingMode.DOWN);
    }

    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        return HRPerserlenHelper.calcYearsDiffNew((Date)dateO, (Date)dateT);
    }

    public static boolean isSameDay(Object dateOne, Object dateTwo) {
        Calendar cOne = DateUtil.transCalender(dateOne);
        Calendar cTwo = DateUtil.transCalender(dateTwo);
        return cOne.get(1) == cTwo.get(1) && cOne.get(2) == cTwo.get(2) && cOne.get(5) == cTwo.get(5);
    }

    public static Calendar transCalender(Object date) {
        Calendar cal = Calendar.getInstance();
        if (date instanceof Date) {
            cal.setTime((Date)date);
        } else if (date instanceof Timestamp) {
            cal.setTimeInMillis(((Timestamp)date).getTime());
        } else if (date instanceof Long) {
            cal.setTimeInMillis((Long)date);
        } else {
            LOGGER.error("transCalender error : input type error :" + date.getClass().getName());
        }
        return cal;
    }
}

