/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.infrastructure.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.function.HRPIConsumer;

public class DynamicTransformUtil {
    private static final Log LOGGER = LogFactory.getLog(DynamicTransformUtil.class);
    private static final Map<String, String> entitySelectPropMap = new ConcurrentHashMap<String, String>(16);
    private static final List<String> ignoreSysList = Arrays.asList("multilanguagetext", "creator", "createtime", "modifier", "modifiertime", "modifytime", "vid", "sourcevid", "firstbsed", "changebsed", "ismodify", "brfd", "changedescription", "hisversion", "initstatus", "initbatch", "initdatasource");
    private static final HRPIConsumer<Map<String, Object>, DynamicObject, IDataEntityProperty> transferName = (resultMap, dy, property) -> {
        Object propObj = dy.get(property);
        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
        resultMap.put(property.getName(), propObj instanceof DynamicObject ? DynamicTransformUtil.getBaseDataValue((DynamicObject)propObj) : mapValue);
    };
    private static final HRPIConsumer<Map<String, Object>, DynamicObject, IDataEntityProperty> transferNameAndNumber = (resultMap, dy, property) -> {
        Object mapValue;
        Object propObj = dy.get(property);
        Object object = mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
        if (Objects.isNull(propObj)) {
            return;
        }
        if (propObj instanceof DynamicObject) {
            resultMap.put(String.join((CharSequence)"_", property.getName(), "name"), DynamicTransformUtil.getBaseDataValue((DynamicObject)propObj));
            resultMap.put(String.join((CharSequence)"_", property.getName(), "number"), DynamicTransformUtil.getBaseDataNumber((DynamicObject)propObj, property));
        } else {
            resultMap.put(property.getName(), mapValue);
        }
    };

    public static String getDynamicPropString(String entityName) {
        return DynamicTransformUtil.getDynamicPropString(entityName, null);
    }

    public static String getDynamicPropString(String entityName, Set<String> ignoreKey) {
        Set<String> ignore = DynamicTransformUtil.getIgnoreSet(ignoreKey);
        String propString = entitySelectPropMap.get(entityName);
        if (!HRStringUtils.isEmpty((String)propString)) {
            return propString;
        }
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                ArrayList<String> propList = new ArrayList<String>(properties.size());
                for (IDataEntityProperty property : dataEntityType.getProperties()) {
                    if (!DynamicTransformUtil.checkFields(property.getName(), ignore) || HRStringUtils.isEmpty((String)property.getAlias())) continue;
                    propList.add(property.getName());
                }
                propString = String.join((CharSequence)",", propList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entitName:{} error:{}", (Object)entityName, (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return propString == null ? "id" : propString;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy) {
        return DynamicTransformUtil.dynamicObjectToMap(dy, null);
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy, Set<String> ignoreKey) {
        return DynamicTransformUtil.getPropMap(dy, ignoreKey);
    }

    public static Map<String, Object> dynamicObjectsToMap(List<DynamicObject> dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            dynamicObjects.forEach(dynamicObject -> {
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                properties.forEach(property -> {
                    if (!resultMap.containsKey(property.getName())) {
                        Object propObj = dynamicObject.get(property);
                        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        resultMap.put(property.getName(), propObj instanceof DynamicObject ? DynamicTransformUtil.getBaseDataValue((DynamicObject)propObj) : mapValue);
                    }
                });
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicObjectsToMap", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\u3002", (String)"DynamicTransformUtil_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList) {
        return DynamicTransformUtil.dynamicListToMap(dyList, null, true, transferName);
    }

    public static List<Map<String, Object>> dynamicBaseDataToMap(List<DynamicObject> dyList, Set<String> ignoreKey) {
        return DynamicTransformUtil.dynamicListToMap(dyList, ignoreKey, true, transferNameAndNumber);
    }

    public static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList, Set<String> ignoreKey) {
        return DynamicTransformUtil.dynamicListToMap(dyList, ignoreKey, true, transferName);
    }

    public static List<Map<String, Object>> dynamicAllPropListToMap(List<DynamicObject> dyList) {
        return DynamicTransformUtil.dynamicListToMap(dyList, null, false, transferName);
    }

    private static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList, Set<String> ignoreKey, boolean isIgnore, HRPIConsumer<Map<String, Object>, DynamicObject, IDataEntityProperty> func) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            dyList.forEach(dynamicObject -> {
                Map<String, Object> dyMap = DynamicTransformUtil.getPropMap(dynamicObject, ignoreKey, isIgnore, func);
                if (!dyMap.isEmpty()) {
                    resultList.add(dyMap);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToMap", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25!", (String)"DynamicTransformUtil_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultList;
    }

    public static List<Map<String, Object>> dynamicListToDyMap(List<DynamicObject> dyList) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            IDataEntityType dataEntityType = dyList.get(0).getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            dyList.forEach(dynamicObject -> {
                HashMap<String, Object> resultMap;
                try {
                    resultMap = new HashMap<String, Object>(properties.size());
                    for (IDataEntityProperty property : properties) {
                        Object propObj = dynamicObject.get(property);
                        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        resultMap.put(property.getName(), mapValue);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("getPropMap property", (Throwable)ex);
                    throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                resultList.add(resultMap);
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToDyMap", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25!", (String)"DynamicTransformUtil_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultList;
    }

    private static Object getBaseDataValue(DynamicObject baseDataDy) {
        return baseDataDy.getDataEntityType().getProperties().get((Object)"name") == null ? baseDataDy.get("id") : (baseDataDy.get("name") instanceof ILocaleString ? baseDataDy.getLocaleString("name").getLocaleValue() : baseDataDy.get("name"));
    }

    private static Object getBaseDataNumber(DynamicObject baseDataDy, IDataEntityProperty property) {
        String numberProp = ((BasedataProp)property).getNumberProp();
        return numberProp != null ? baseDataDy.get(numberProp) : null;
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey) {
        return DynamicTransformUtil.getPropMap(dy, ignoreKey, true, transferName);
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey, boolean isIgnore, HRPIConsumer<Map<String, Object>, DynamicObject, IDataEntityProperty> func) {
        HashMap<String, Object> resultMap;
        if (dy == null) {
            return Collections.emptyMap();
        }
        Set<String> ignore = DynamicTransformUtil.getIgnoreSet(ignoreKey);
        try {
            IDataEntityType dataEntityType = dy.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            resultMap = new HashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                if (isIgnore && ignore.contains(property.getName())) continue;
                func.wrap(resultMap, dy, property);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPropMap property", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultMap;
    }

    private static Set<String> getIgnoreSet(Set<String> ignoreKey) {
        if (null == ignoreKey || ignoreKey.isEmpty()) {
            ignoreKey = new HashSet<String>(ignoreSysList);
        } else {
            ignoreKey.addAll(ignoreSysList);
        }
        return ignoreKey;
    }

    private static boolean checkFields(String propName, Set<String> ignoreSet) {
        return !ignoreSet.contains(propName) && !propName.endsWith("_id") && !propName.equals("multilanguagetext");
    }

    public static void setBaseData(String mapKey, DynamicObject baseData, Map<String, Object> map) {
        if (null != baseData) {
            DataEntityPropertyCollection properties = baseData.getDataEntityType().getProperties();
            if (null != properties.get((Object)"name")) {
                map.put(mapKey, baseData.getString("name"));
            }
            if (null != properties.get((Object)"number")) {
                map.put(mapKey + "_number", baseData.getString("number"));
            }
            map.put(mapKey + "_id", baseData.getLong("id"));
        }
    }

    public static void setLocalProp(MainEntityType dataEntityType, DynamicObject baseInstance, Map.Entry<String, Object> keyValue) {
        IDataEntityProperty property = dataEntityType.findProperty(keyValue.getKey());
        if (property != null) {
            Object value = keyValue.getValue();
            if (value instanceof Map) {
                Map langMap = (Map)value;
                LocaleString localeString = LocaleString.fromMap((Map)langMap);
                baseInstance.set(keyValue.getKey(), (Object)localeString);
            } else {
                baseInstance.set(keyValue.getKey(), keyValue.getValue());
            }
            if (property instanceof BasedataProp) {
                baseInstance.set(String.join((CharSequence)"_", keyValue.getKey(), "id"), keyValue.getValue());
            }
        }
    }

    @SafeVarargs
    public static void mergeMap(List<Map<String, Object>> listMap, Tuple<String, Map> ... tuples) {
        listMap.forEach(map -> {
            for (Tuple tuple : tuples) {
                map.put(tuple.item1, ((Map)tuple.item2).get(map.get("person_id")));
            }
        });
    }

    public static String getAllDbPropString(String entityName) {
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                HashSet propList = Sets.newHashSetWithExpectedSize((int)(properties.size() * 2));
                for (IDataEntityProperty property : dataEntityType.getProperties()) {
                    String name = property.getName();
                    if (!property.isDbIgnore() && !"multilanguagetext".equals(property.getName())) {
                        propList.add(name);
                    }
                    if (!(property instanceof PKFieldProp) || !((PKFieldProp)property).isRefId()) continue;
                    propList.add(name.substring(0, name.indexOf("_id")));
                }
                return String.join((CharSequence)",", propList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entitName:{} error:{}", (Object)entityName, (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return "id";
    }

    public static void wrapSameFieldFromSourceForInit(DynamicObject target, DynamicObject source) {
        DynamicTransformUtil.wrapSameFieldFromSource(target, source, new HashSet<String>(Arrays.asList("id", "multilanguagetext", "description", "initstatus", "creator", "creator_id", "modifier", "modifier_id", "createtime", "modifytime", "initdatasource", "boid", "iscurrentversion", "datastatus", "sourcevid", "ismodify", "hisversion", "changedescription")));
    }

    public static void wrapSameFieldFromSource(DynamicObject target, DynamicObject source, HashSet<String> ignoreFields) {
        DataEntityPropertyCollection targetFields = target.getDynamicObjectType().getProperties();
        BillEntityType sourceType = (BillEntityType)source.getDynamicObjectType();
        targetFields.stream().filter(field -> {
            String fieldName = field.getName();
            return CollectionUtils.isEmpty((Collection)ignoreFields) || !ignoreFields.contains(fieldName);
        }).forEach(field -> {
            String fieldName = field.getName();
            IDataEntityProperty property = sourceType.findProperty(fieldName);
            if (property != null) {
                target.set(fieldName, source.get(fieldName));
            }
        });
    }
}

