/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.infrastructure.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;

public class QFilterUtil {
    private static final Log LOG = LogFactory.getLog(QFilterUtil.class);

    public static QFilter getCurrentQf() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public static QFilter getDataStatusFilter() {
        return new QFilter("datastatus", "=", (Object)"1");
    }

    public static QFilter getStatusFilters() {
        return new QFilter("businessstatus", "=", (Object)"1");
    }

    public static QFilter getInitStatusFinish() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public static QFilter getLaborreltypeByClsList(String selectProperty, List<Long> labreltypeclsList) {
        HashSet laborreltype = new HashSet();
        QFilter qFilter = new QFilter("laborreltypecls", "in", labreltypeclsList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborreltype", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter, statusFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            entityCfMap.values().forEach(labrel -> laborreltype.add(labrel.getLong("id")));
        }
        return new QFilter(selectProperty, "in", laborreltype);
    }

    public static QFilter getLaborrelstatusByClsList(String selectProperty, List<Long> labrelstatusclsList) {
        HashSet labrelstatus = new HashSet();
        QFilter qFilter = new QFilter("labrelstatuscls", "in", labrelstatusclsList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter, statusFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            entityCfMap.values().forEach(labrel -> labrelstatus.add(labrel.getLong("id")));
        }
        return new QFilter(selectProperty, "in", labrelstatus);
    }

    public static QFilter getHisVersionQf() {
        return new QFilter("iscurrentversion", "=", (Object)"0");
    }

    public static QFilter getHisDataStatusQf() {
        return new QFilter("datastatus", "in", Arrays.asList("1", "2", "3"));
    }

    public static QFilter getTimeFilter(Map<String, Object> requestParams) {
        return QFilterUtil.getTimeFilter((String)requestParams.get("qTimeModel"), DateUtil.getDate(requestParams.get("dateOne")), DateUtil.getDate(requestParams.get("dateTwo")));
    }

    public static QFilter getTimeFilter(String queryModel, Date dateStart, Date dateEnd) {
        QFilter filter;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date sysEndDate = null;
        try {
            sysEndDate = format.parse("2999-12-30");
        }
        catch (ParseException e) {
            LOG.error("formatDate occur exception : ", (Throwable)e);
        }
        if ("-1".equals(queryModel)) {
            filter = new QFilter("startdate", "<=", (Object)dateStart).and(new QFilter("enddate", ">=", (Object)sysEndDate)).or(new QFilter("enddate", "<=", (Object)dateStart).and(new QFilter("enddate", "<", (Object)sysEndDate)));
        } else if ("0".equals(queryModel)) {
            filter = null == dateEnd ? new QFilter("startdate", "<=", (Object)dateStart).and(new QFilter("enddate", ">=", (Object)dateStart)) : new QFilter("enddate", ">=", (Object)sysEndDate).and(new QFilter("startdate", ">=", (Object)dateStart)).and(new QFilter("startdate", "<=", (Object)dateEnd)).or(new QFilter("enddate", "<", (Object)sysEndDate).and(new QFilter("startdate", ">=", (Object)dateStart)).and(new QFilter("enddate", "<=", (Object)dateEnd)));
        } else if ("1".equals(queryModel)) {
            filter = null == dateEnd ? new QFilter("startdate", ">=", (Object)dateStart) : new QFilter("startdate", ">=", (Object)dateEnd);
        } else {
            throw new IllegalArgumentException(String.format("error data input , check  queryModel:%1$s, dateStart:%2$s, dateEnd:%3$s ", queryModel, dateStart, dateEnd));
        }
        return filter;
    }

    public static QFilter getCurrentAndHisEffectFilter() {
        return QFilterUtil.getCurrentQf().and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getInitStatusFinish());
    }

    public static QFilter notLatestRecord() {
        return new QFilter("islatestrecord", "=", (Object)Character.valueOf('0'));
    }

    public static QFilter isLatestRecord() {
        return new QFilter("islatestrecord", "=", (Object)Character.valueOf('1'));
    }

    public static QFilter isNotLatestRecord() {
        return new QFilter("islatestrecord", "=", (Object)Character.valueOf('0'));
    }

    public static QFilter empLatestRecord() {
        return new QFilter("employee.islatestrecord", "=", (Object)Character.valueOf('1'));
    }

    public static QFilter getContainFilter(Date date) {
        return new QFilter("startdate", "<=", (Object)date).and(new QFilter("sysenddate", ">", (Object)date));
    }

    public static QFilter alwaysEqualsFilter() {
        QFilter alwaysEqualsFilter = new QFilter("1", "=", (Object)1);
        return alwaysEqualsFilter;
    }

    public static QFilter getEnable() {
        return new QFilter("enable", "=", (Object)"1");
    }
}

