/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.util.HRMultiEntityImptUtil;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.generic.IPersonGenericService;

public abstract class HRPICommonInitService
extends AbstractInitDomainDataService {
    protected final IPersonGenericService personGenericService = HRPIServiceFactory.personGenericService;
    protected static final int BUS_PAGE_SIZE = 10000;
    protected static final int POSITION_PAGE_SIZE = 10000;
    protected static final String TMP_SQL = "update %s set finitstatus = ? where finitbatch = ?";
    private static final Log LOG = LogFactory.getLog(HRPICommonInitService.class);

    public void validate() {
        LOG.info("HRPICommonInitService#validate start");
        Map map = this.getInfoWithMap();
        Map dysMap = this.getInfoWithDynamicObject();
        this.businessValidate(map, dysMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        LOG.info("HRPICommonInitService#save start");
        DLock dLock = DLock.create((String)String.join((CharSequence)"_", this.getInitInParam().getEntityNumber(), String.valueOf(this.getInitInParam().getExecTaskId())));
        if (!dLock.tryLock()) {
            LOG.error("\u521d\u59cb\u5316\u6d88\u606f\u4e22\u5f03,entitynumber:{},exectaskid:{}", (Object)this.getInitInParam().getEntityNumber(), (Object)this.getInitInParam().getExecTaskId());
            this.discard();
            return;
        }
        try {
            boolean success;
            Map map = this.getInfoWithMap();
            Map dysMap = this.getInfoWithDynamicObject();
            this.initData((List)dysMap.get("data"));
            if (!this.getSkipParam().booleanValue()) {
                LOG.info("HRPICommonInitService.businessValidate start");
                this.businessValidate(map, dysMap);
            }
            if (!(success = this.businessSave(map, dysMap))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u5199\u5165\u5f02\u5e38\u3002", (String)"HRPICommonInitService_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        finally {
            dLock.unlock();
        }
    }

    public void initData(List<DynamicObject> data) {
    }

    public abstract void businessValidate(Map<String, Object> var1, Map<String, Object> var2);

    public abstract boolean businessSave(Map<String, Object> var1, Map<String, Object> var2);

    protected Map<String, Object> buildDatasByCollection(DynamicObjectCollection ... collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.length);
        for (DynamicObjectCollection collection : collections) {
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collection);
            datas.add(item);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "initialize");
        paramMap.put("mustAllSuccess", true);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }

    protected void addErrorMsg(StringBuilder sb, String msg) {
        sb.append(msg);
        sb.append("\n");
    }

    protected <T> void addItemAndSort(List<T> array, T item) {
        T cur;
        Comparator<T> comparator = this.getComparator();
        Iterator<T> iterator = array.iterator();
        int targetIndex = 0;
        while (iterator.hasNext() && comparator.compare(item, cur = iterator.next()) >= 0) {
            ++targetIndex;
        }
        array.add(targetIndex, item);
    }

    protected <T> Comparator<T> getComparator() {
        return (o1, o2) -> {
            if (o1 instanceof DynamicObject) {
                Date startDate1 = ((DynamicObject)o1).getDate("startdate");
                Date startDate2 = ((DynamicObject)o2).getDate("startdate");
                return startDate1.compareTo(startDate2);
            }
            if (o1 instanceof Map) {
                Date startDate1 = (Date)((Map)o1).get("startdate");
                Date startDate2 = (Date)((Map)o2).get("startdate");
                return startDate1.compareTo(startDate2);
            }
            return -1;
        };
    }

    protected void changeOtherTableStatus(String ... otherTables) {
        if (otherTables.length > 0) {
            for (String entityCode : otherTables) {
                QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "=", (Object)this.getSourceStatus())};
                int count = this.getORMHelper().count("QueryServiceHelper." + entityCode, entityCode, batchQFiler);
                int pageCount = (int)Math.ceil((double)count / 10000.0);
                LOG.info("changestatus:initbatch={}, entityCode={}, pageCount={}, length={}", new Object[]{this.getInitInParam().getBatchNumber(), entityCode, pageCount, count});
                if (count <= 0) continue;
                for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                    DynamicObject[] dynamicObjectList = BusinessDataServiceHelper.load((String)entityCode, (String)"initstatus", (QFilter[])batchQFiler, (String)"id", (int)0, (int)10000);
                    this.setInitStatus(dynamicObjectList);
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectList);
                }
            }
        }
    }

    protected void changeTableStatusBySql(String ... tables) {
        DBRoute route = new DBRoute("hr");
        for (String table : tables) {
            String sql = String.format(TMP_SQL, table);
            LOG.info("HRPICommonInitService changeStatus start:{}", (Object)table);
            this.runTable(route, sql);
            LOG.info("HRPICommonInitService changeStatus end:{}", (Object)table);
        }
    }

    private void runTable(DBRoute route, String sql) {
        DB.execute((DBRoute)route, (String)sql, (Object[])new Object[]{this.getTargetStatus(), this.getInitInParam().getBatchNumber()});
    }

    private void setInitStatus(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("initstatus", (Object)this.getTargetStatus());
        }
    }

    protected void rollbackOtherTableAll(String ... otherTables) {
        if (otherTables.length > 0) {
            for (String entityNumber : otherTables) {
                LOG.info("HRPICommonInitService rollbackOtherTableAll start:{}", (Object)entityNumber);
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
                QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"0", "1"}))};
                helper.deleteByFilter(batchQFiler);
                LOG.info("HRPICommonInitService rollbackOtherTableAll start:{}", (Object)entityNumber);
            }
        }
    }

    private ORM getORMHelper() {
        return new ORMImpl();
    }

    protected Map<String, Object> getOtherMap() {
        return (Map)this.getInitInParam().getOther().get("hric$subTaskInitBatchMap");
    }

    protected Boolean getSkipParam() {
        return Optional.ofNullable(this.getInitInParam()).map(InitInParam::getOther).map(param -> (Boolean)param.get("common$skip.biz.validate")).orElse(false);
    }

    protected String[] getImportFields(DynamicObjectType type) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)type.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems().stream().filter(item -> item instanceof Field && HRMultiEntityImptUtil.isValid((Field)((Field)item))).map(AbstractElement::getKey).collect(Collectors.toList());
        entityItems.add("id");
        return (String[])type.getProperties().stream().map(IMetadata::getName).filter(entityItems::contains).toArray(String[]::new);
    }
}

