/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.cmp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPICmpempRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.InitValidateUtil;
import org.apache.commons.collections.CollectionUtils;

public abstract class HRPICommonCmpInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOG = LogFactory.getLog(HRPICommonCmpInitServiceImpl.class);
    private Map<Long, List<DynamicObject>> groupByEmpNumber = null;
    private Map<Long, Long> midAndEmpNumberMap = null;
    protected final Set<Long> primarySet = Sets.newHashSetWithExpectedSize((int)1000);

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        HashSet employeeIds = Sets.newHashSetWithExpectedSize((int)data.size());
        this.groupByEmpNumber = Maps.newHashMapWithExpectedSize((int)data.size());
        this.midAndEmpNumberMap = Maps.newHashMapWithExpectedSize((int)data.size());
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            if (item.getLong("employee.id") != 0L) {
                employeeIds.add(item.getLong("employee.id"));
            }
            this.preValidate((DynamicObject)item, midId);
        });
        this.preQueryCmp(employeeIds);
        StringBuilder msg = new StringBuilder();
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            DynamicObject emp = item.getDynamicObject("employee");
            CommonServiceUtil.checkIsEmployee(msg, emp);
            CommonServiceUtil.checkEndDate(msg, item);
            CommonServiceUtil.checkStartDate(msg, item.getDate("startdate"));
            this.cusBusinessValidate((DynamicObject)item, msg);
            if (msg.length() != 0) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)msg.toString());
                msg.delete(0, msg.length());
            }
        });
        this.validateByGroup(idMap);
        this.validateOtherGroupData(idMap);
        CommonServiceUtil.wrapSuccessPkIds(idMap, data, this.getInitOutParam());
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "empnumber", "startdate", this.isQuit() ? HRPIValueConstants.LABRELSTATUSPRD_END : HRPIValueConstants.LABRELSTATUSPRD_ING);
    }

    public abstract boolean isQuit();

    private void preQueryCmp(Set<Long> employeeIds) {
        DynamicObject[] existCmp = HRPICmpempRepository.getCmpEmpByEmployeeId(employeeIds);
        for (int i = 0; i < existCmp.length; ++i) {
            DynamicObject item = existCmp[i];
            Long employeeId = item.getLong("employee.id");
            List<DynamicObject> groupData = this.groupByEmpNumber.get(employeeId);
            this.addItemAndSort(groupData, item);
            if (!this.isEffectAndPrimary(item)) continue;
            this.primarySet.add(employeeId);
        }
    }

    protected boolean isEffectAndPrimary(DynamicObject item) {
        Date enddate = item.getDate("enddate");
        boolean isprimaryscope = item.getBoolean("isprimaryscope");
        return HRBaseUtils.getMaxEndDate().equals(enddate) && isprimaryscope;
    }

    private void preValidate(DynamicObject item, Long midId) {
        Date start = item.getDate("startdate");
        Date enddate = item.getDate("enddate");
        Long employeeId = item.getLong("employee.id");
        if (employeeId != 0L) {
            List itemList = this.groupByEmpNumber.computeIfAbsent(employeeId, k -> new LinkedList());
            this.addItemAndSort(itemList, item);
            this.midAndEmpNumberMap.put(midId, employeeId);
        }
        StringBuilder msg = new StringBuilder();
        if (enddate.before(start)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPICommonCmpInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        this.preCusBusinessValidate(item, msg);
        if (msg.length() != 0) {
            this.getInitOutParam().addErrorMsg(midId, msg.toString());
        }
    }

    private void validateByGroup(Map<Long, HashSet<Long>> idMap) {
        for (Map.Entry<Long, List<DynamicObject>> entry : this.groupByEmpNumber.entrySet()) {
            Date preEndDate = null;
            List<DynamicObject> cmpList = entry.getValue();
            int size = cmpList.size();
            boolean dateContinueFlag = true;
            for (int i = 0; i < size; ++i) {
                Long midId;
                DynamicObject item = cmpList.get(i);
                HashSet<Long> ids = idMap.get(item.get("id"));
                Long l = midId = CollectionUtils.isEmpty(ids) ? Long.valueOf(0L) : ids.iterator().next();
                if (!dateContinueFlag || !((Boolean)item.get("isprimaryscope")).booleanValue()) continue;
                if (preEndDate != null) {
                    Date startDate = item.getDate("startdate");
                    if (startDate == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5458\u5de5%s\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u5bfc\u5165\u6a21\u677f\u3002", (String)"HRPICommonCmpInitServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[]{"person.number"}));
                    }
                    if (startDate.getTime() - preEndDate.getTime() != 86400000L) {
                        InitValidateUtil.addErrorMsgInSameNumber((InitOutParam)this.getInitOutParam(), cmpList, idMap, (String)ResManager.loadKDString((String)"\u6b64\u5458\u5de5\u6570\u636e\u7684\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4\u4e0d\u8fde\u7eed\u3002", (String)"HRPICommonCmpInitServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                        dateContinueFlag = false;
                        continue;
                    }
                    preEndDate = item.getDate("enddate");
                    continue;
                }
                preEndDate = item.getDate("enddate");
            }
        }
    }

    public void validateOtherGroupData(Map<Long, HashSet<Long>> idMap) {
        Map validateMap = this.getInitOutParam().getData();
        for (Map.Entry entry : validateMap.entrySet()) {
            Long midId = (Long)entry.getKey();
            InitOutMessage msg = (InitOutMessage)entry.getValue();
            if (msg.getSuccess().booleanValue() || this.midAndEmpNumberMap.get(midId) == null) continue;
            List<DynamicObject> group = this.groupByEmpNumber.get(this.midAndEmpNumberMap.get(midId));
            group.forEach(item -> {
                Long itemMidId;
                Long id = (Long)item.get("id");
                HashSet ids = (HashSet)idMap.get(id);
                if (CollectionUtils.isNotEmpty((Collection)ids) && InitValidateUtil.checkDateStatus((Map)validateMap, (Long)(itemMidId = (Long)ids.iterator().next()))) {
                    this.getInitOutParam().addErrorMsg(itemMidId, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5b58\u5728\u5176\u4ed6\u9519\u8bef\u6570\u636e\u3002", (String)"HRPICommonCmpInitServiceImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            });
        }
    }

    public abstract void preCusBusinessValidate(DynamicObject var1, StringBuilder var2);

    public abstract void cusBusinessValidate(DynamicObject var1, StringBuilder var2);

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType cmpType = EntityMetadataCache.getDataEntityType((String)"hrpi_cmpemp");
        DynamicObjectCollection cmpCollection = new DynamicObjectCollection((DynamicObjectType)cmpType, null);
        MainEntityType manageScopeType = EntityMetadataCache.getDataEntityType((String)"hrpi_managingscope");
        DynamicObjectCollection manageScopeCollection = new DynamicObjectCollection((DynamicObjectType)manageScopeType, null);
        long[] manageScopeIds = ORM.create().genLongIds((IDataEntityType)manageScopeType, data.size());
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            DynamicObject manageScope = this.buildManageScope((DynamicObjectType)manageScopeType, manageScopeIds[i], item);
            manageScopeCollection.add((Object)manageScope);
            DynamicObject cmp = this.buildCmpDy((DynamicObjectType)cmpType, manageScope);
            cmpCollection.add((Object)cmp);
        }
        if (CollectionUtils.isNotEmpty((Collection)cmpCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(cmpCollection, manageScopeCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private DynamicObject buildCmpDy(DynamicObjectType type, DynamicObject item) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, item);
        dy.set("id", item.get("cmpemp"));
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    private DynamicObject buildManageScope(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, item);
        Date start = item.getDate("startdate");
        Date endDate = item.getDate("enddate");
        dy.set("id", (Object)id);
        dy.set("cmpemp", item.get("id"));
        dy.set("bsed", (Object)start);
        dy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        dy.set("variationtype", (Object)HRPIValueConstants.ACTION_TYPE_INIT);
        CommonServiceUtil.setEmpAndNewPerson(dy, item);
        if (HRBaseUtils.getMaxEndDate().equals(endDate)) {
            dy.set("businessstatus", (Object)"1");
        } else {
            dy.set("businessstatus", (Object)"2");
        }
        this.cusBuildManageScope(dy, item.getDynamicObject("employee"), item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    public abstract void cusBuildManageScope(DynamicObject var1, DynamicObject var2, DynamicObject var3);

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_cmpemp");
    }

    protected void rollbackAll() {
        this.validateRollbackEmpExp(ResManager.loadKDString((String)"\u56de\u6eda\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7684\u4efb\u804c\u7ecf\u5386\u6570\u636e\u5fc5\u987b\u5168\u90e8\u56de\u6eda\u6210\u529f\uff0c\u624d\u53ef\u6267\u884c\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u6570\u636e\u7684\u56de\u6eda\u3002", (String)"HRPICommonCmpInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        super.rollbackAll();
        this.rollbackOtherTableAll("hrpi_cmpemp");
    }

    public abstract void validateRollbackEmpExp(String var1);
}

