/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class CommonServiceUtil {
    private static final Log LOGGER = LogFactory.getLog(CommonServiceUtil.class);
    private static String EMPLOYEE_STRING = "person,enterprise,empnumber,startdate,enddate";

    public static void addErrorMsg(StringBuilder sb, String msg) {
        sb.append(msg);
        sb.append('\n');
    }

    public static <T> void addItemAndSort(List<T> array, T item) {
        T cur;
        Comparator<T> comparator = CommonServiceUtil.getComparator();
        Iterator<T> iterator = array.iterator();
        int targetIndex = 0;
        while (iterator.hasNext() && comparator.compare(item, cur = iterator.next()) >= 0) {
            ++targetIndex;
        }
        array.add(targetIndex, item);
    }

    public static <T> Comparator<T> getComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 instanceof DynamicObject) {
                    Date startDate1 = ((DynamicObject)o1).getDate("startdate");
                    Date startDate2 = ((DynamicObject)o2).getDate("startdate");
                    return startDate1.compareTo(startDate2);
                }
                if (o1 instanceof Map) {
                    Date startDate1 = (Date)((Map)o1).get("startdate");
                    Date startDate2 = (Date)((Map)o2).get("startdate");
                    return startDate1.compareTo(startDate2);
                }
                return -1;
            }
        };
    }

    public static Map<String, List<DynamicObject>> getGroup(String propKey, List<DynamicObject> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return list.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString(propKey))).collect(Collectors.groupingBy(dy -> dy.getString(propKey)));
    }

    public static DynamicObject buildDy(DynamicObjectType type, DynamicObject source, String[] props) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        InitValidateUtil.wrapPropsFromSourceToDy((String[])props, (DynamicObject)source, (DynamicObject)dy);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    public static Map<String, DynamicObject> getEmployeeInfoByPerson(List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        QFilter qFilter = new QFilter("person", "in", personIds);
        return CommonServiceUtil.getInfo(qFilter, EMPLOYEE_STRING, "empnumber", "hrpi_employee");
    }

    private static Map<String, List<DynamicObject>> getEmpMap(List<DynamicObject> data, String propertyName, Long laborRelId) {
        if (CollectionUtils.isEmpty(data)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Set empNumberSet = data.stream().map(dy -> dy.getString(propertyName)).collect(Collectors.toSet());
        QFilter filter = new QFilter("empnumber", "in", empNumberSet);
        filter.and(QFilterUtil.getCurrentQf());
        if (laborRelId != null) {
            filter.and("laborrelstatus.labrelstatusprd", "=", (Object)laborRelId);
        }
        DynamicObject[] empDys = HRPIEmployeeRepository.employeeServiceHelper.query("person,empnumber,startdate,enddate,laborreltype_id,laborrelstatus_id", filter.toArray());
        return Arrays.stream(empDys).collect(Collectors.groupingBy(dy -> dy.getString("empnumber")));
    }

    public static Map<String, List<DynamicObject>> getGroupSortMap(String propKey, List<DynamicObject> data) {
        return data.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString(propKey))).collect(Collectors.groupingBy(dy -> dy.getString(propKey), Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
            return list;
        })));
    }

    public static Set<Long> existsEmpIdByData(List<DynamicObject> data, String entityName) {
        Set<Long> empIds = data.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
        return CommonServiceUtil.existsEmpIdByEmp(empIds, entityName);
    }

    public static Set<Long> existsEmpIdByEmp(Set<Long> empIds, String entityName) {
        if (CollectionUtils.isEmpty(empIds)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        QFilter qFilter = new QFilter("employee", "in", empIds);
        qFilter.and(QFilterUtil.getCurrentQf());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.queryOriginalCollection("employee.id", qFilter.toArray()).stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
    }

    public static void initNewPerson(List<DynamicObject> data, String propertyName, Long laborRelId) {
        Map<String, List<DynamicObject>> empMap = CommonServiceUtil.getEmpMap(data, propertyName, laborRelId);
        for (DynamicObject item : data) {
            List<DynamicObject> empDyList = empMap.get(item.getString(propertyName));
            if (CollectionUtils.isEmpty(empDyList)) {
                item.set("person", null);
                continue;
            }
            DynamicObject empDy = empDyList.stream().max(Comparator.comparing(dy -> dy.getDate("enddate"))).orElse(null);
            if (empDy == null || empDy.getLong("person.id") == item.getLong("person.id")) continue;
            item.set("person", (Object)empDy.getDynamicObject("person"));
        }
    }

    public static void initEmpAndNewPerson(List<DynamicObject> data, String dateProperty, boolean isQuit) {
        Long laborRelId;
        Long l = laborRelId = isQuit ? HRPIValueConstants.LABRELSTATUSPRD_END : HRPIValueConstants.LABRELSTATUSPRD_ING;
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        DynamicObject dynamicObject = data.get(0);
        if (isQuit && dynamicObject.containsProperty("empnumber") && dynamicObject.get("empnumber") != null) {
            CommonServiceUtil.initEmpAndNewPersonOneToMore(data, dateProperty, laborRelId);
        } else {
            CommonServiceUtil.initEmpAndNewPerson(data, dateProperty, laborRelId);
        }
    }

    public static void initEmpAndNewPersonOneToMore(List<DynamicObject> data, String dateProperty, Long laborRelId) {
        CommonServiceUtil.initEmpAndNewPerson(data, "empnumber", dateProperty, laborRelId);
    }

    public static void initEmpAndNewPerson(List<DynamicObject> data, String dateProperty, Long laborRelId) {
        CommonServiceUtil.initEmpAndNewPerson(data, "person.number", dateProperty, laborRelId);
    }

    public static void initEmpAndNewPerson(List<DynamicObject> data, String propertyName, String dateProperty, Long laborRelId) {
        Map<String, List<DynamicObject>> empMap = CommonServiceUtil.getEmpMap(data, propertyName, laborRelId);
        for (DynamicObject item : data) {
            List<DynamicObject> empDyList = empMap.get(item.getString(propertyName));
            if (empDyList == null) continue;
            Date date = item.getDate(dateProperty);
            DynamicObject empDy = empDyList.stream().filter(dy -> date.compareTo(dy.getDate("startdate")) >= 0 && date.compareTo(dy.getDate("enddate")) <= 0).findFirst().orElse(null);
            item.set("employee", (Object)empDy);
            if (empDy == null || empDy.getLong("person.id") == item.getLong("person.id")) continue;
            item.set("person", (Object)empDy.getDynamicObject("person"));
        }
    }

    public static void checkIsEmployee(StringBuilder msg, DynamicObject empDy) {
        if (empDy == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u5458\u5de5\u7684\u4f01\u4e1a\u4eba\u4fe1\u606f\u3002", (String)"CommonServiceUtil_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public static void setEmpAndNewPerson(DynamicObject newDy, DynamicObject dataDy) {
        DynamicObject employeeDy = dataDy.getDynamicObject("employee");
        newDy.set("employee", (Object)employeeDy);
        if (employeeDy.getLong("person.id") != newDy.getLong("person.id")) {
            newDy.set("person", (Object)employeeDy.getDynamicObject("person"));
        }
    }

    public static void checkEndDate(StringBuilder msg, DynamicObject dynamicObject) {
        DynamicObject empDy = dynamicObject.getDynamicObject("employee");
        Date endDate = dynamicObject.getDate("enddate");
        if (empDy == null || endDate == null) {
            return;
        }
        if (endDate.compareTo(empDy.getDate("enddate")) > 0) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7528\u5de5\u7ed3\u675f\u65e5\u671f", (String)"CommonServiceUtil_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public static DynamicObject checkIsEmployee(StringBuilder msg, Map<String, DynamicObject> employeeInfo, String employeeNumber) {
        if (CollectionUtils.isEmpty(employeeInfo) || Objects.isNull(employeeInfo.get(employeeNumber))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u5458\u5de5\u7684\u4f01\u4e1a\u4eba\u4fe1\u606f\u3002", (String)"CommonServiceUtil_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            return null;
        }
        return employeeInfo.get(employeeNumber);
    }

    public static void checkStartDate(StringBuilder msg, Date startDate) {
        LocalDate now;
        LocalDate start = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (start.isAfter(now = LocalDate.now())) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CommonServiceUtil_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public static Map<String, DynamicObject> getInfo(QFilter filter, String selectProperties, String keyProperty, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        Object[] employees = serviceHelper.query(selectProperties, new QFilter[]{filter, QFilterUtil.getCurrentQf()});
        if (HRArrayUtils.isEmpty((Object[])employees)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Arrays.asList(employees).stream().collect(Collectors.toMap(dy -> dy.getString(keyProperty), dy -> dy, (k1, k2) -> k2));
    }

    public static void checkDate(Date bDate, Date SDate, StringBuilder msg, String errorMsg, String compare) {
        if (Objects.isNull(bDate) || Objects.isNull(SDate)) {
            return;
        }
        if (HRStringUtils.equals((String)"0", (String)compare) && DateUtil.compareDate(bDate, SDate) >= 0) {
            CommonServiceUtil.addErrorMsg(msg, errorMsg);
        }
        if (HRStringUtils.equals((String)"1", (String)compare) && DateUtil.compareDate(bDate, SDate) > 0) {
            CommonServiceUtil.addErrorMsg(msg, errorMsg);
        }
    }

    public static boolean validIdentityCardNo(Long countryId, String number, String identityNo) {
        try {
            Map result = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IIdentityService", (String)"validIdentityCardNo", (Object[])new Object[]{countryId, number, identityNo});
            return Boolean.parseBoolean(result.get("isSuccess").toString());
        }
        catch (Exception e) {
            LOGGER.error("invoke IIdentityService.validIdentityCardNo failed!", (Throwable)e);
            return false;
        }
    }

    public static void checkGroup(List<DynamicObject> data, Map<String, List<DynamicObject>> sortGroup, InitOutParam initOutParam, Map<Long, HashSet<Long>> idMap) {
        CommonServiceUtil.checkGroup(data, sortGroup, initOutParam, idMap, "person.number");
    }

    public static void checkGroup(List<DynamicObject> data, Map<String, List<DynamicObject>> sortGroup, InitOutParam initOutParam, Map<Long, HashSet<Long>> idMap, String propKey) {
        Map validateMap = initOutParam.getData();
        data.stream().forEach(dy -> {
            Long midId = (Long)((HashSet)idMap.get(dy.getLong("id"))).iterator().next();
            InitOutMessage initOutMessage = (InitOutMessage)validateMap.get(midId);
            List list = (List)sortGroup.get(dy.getString(propKey));
            if (CollectionUtils.isEmpty((Collection)list) || Objects.nonNull(initOutMessage) && !initOutMessage.getSuccess().booleanValue()) {
                return;
            }
            AtomicBoolean flag = new AtomicBoolean(false);
            list.stream().filter(dynamicObject -> dy.getLong("id") != dynamicObject.getLong("id")).forEach(dynamicObject -> {
                Long empMidId = (Long)((HashSet)idMap.get(dynamicObject.getLong("id"))).iterator().next();
                InitOutMessage message = (InitOutMessage)validateMap.get(empMidId);
                if (Objects.nonNull(message) && !message.getSuccess().booleanValue()) {
                    flag.set(true);
                }
            });
            if (flag.get()) {
                InitValidateUtil.addMsg((InitOutParam)initOutParam, (Long)midId, (String)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5b58\u5728\u5176\u4ed6\u9519\u8bef\u6570\u636e\u3002", (String)"CommonServiceUtil_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        });
    }

    public static Map<String, Boolean> checkTimeContinuity(Map<String, List<DynamicObject>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap<String, Boolean> reMap = new HashMap<String, Boolean>(map.size());
        map.forEach((key, value) -> reMap.put((String)key, CommonServiceUtil.checkTimeContinuity(value)));
        return reMap;
    }

    public static Map<String, Boolean> checkTimeNonOverlap(Map<String, List<DynamicObject>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, dy -> CommonServiceUtil.checkTimeNonOverlap((List)dy.getValue())));
    }

    private static Boolean checkTimeNonOverlap(List<DynamicObject> sortList) {
        if (CollectionUtils.isEmpty(sortList)) {
            return true;
        }
        Date preEndDate = null;
        for (DynamicObject dy : sortList) {
            if (preEndDate == null) {
                preEndDate = dy.getDate("enddate");
                continue;
            }
            if (dy.getDate("startdate").compareTo(preEndDate) <= 0) {
                return Boolean.FALSE;
            }
            preEndDate = dy.getDate("enddate");
        }
        return Boolean.TRUE;
    }

    public static boolean checkTimeContinuity(List<DynamicObject> list) {
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        Date tempEndDate = null;
        for (DynamicObject dy : list) {
            Date starDate = dy.getDate("startdate");
            Date endDate = dy.getDate("enddate");
            if (endDate.before(starDate)) {
                return false;
            }
            if (tempEndDate == null) {
                tempEndDate = endDate;
                continue;
            }
            if (!DateUtil.isNextDay(starDate, tempEndDate)) {
                return false;
            }
            tempEndDate = endDate;
        }
        return true;
    }

    public static Map<String, List<DynamicObject>> getSortGroup(String propKey, List<DynamicObject> list) {
        Map<String, List<DynamicObject>> groupMap = CommonServiceUtil.getGroup(propKey, list);
        HashMap<String, List<DynamicObject>> newGroupMap = new HashMap<String, List<DynamicObject>>(groupMap.size());
        groupMap.forEach((key, value) -> {
            ArrayList newList = new ArrayList(value.size());
            value.stream().forEach(item -> CommonServiceUtil.addItemAndSort(newList, item));
            newGroupMap.put((String)key, newList);
        });
        return newGroupMap;
    }

    public static Map<String, Boolean> checkEndDate(Map<String, List<DynamicObject>> map, boolean isQuit) {
        if (isQuit || CollectionUtils.isEmpty(map)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap<String, Boolean> reMap = new HashMap<String, Boolean>(map.size());
        map.forEach((key, value) -> {
            long count = value.stream().filter(dy -> DateUtil.compareDate(dy.getDate("enddate"), HRBaseUtils.getMaxEndDate()) == 0).count();
            reMap.put((String)key, count == 1L);
        });
        return reMap;
    }

    public static void checkTime(StringBuilder msg, Map<String, Boolean> map, String empNumber) {
        if (!CollectionUtils.isEmpty(map) && Objects.nonNull(map.get(empNumber)) && !map.get(empNumber).booleanValue()) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0\u3002", (String)"CommonServiceUtil_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public static void wrapSuccessPkIds(Map<Long, HashSet<Long>> idMap, List<DynamicObject> dysData, InitOutParam param) {
        Map messageMap = param.getData();
        dysData.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            InitOutMessage message = (InitOutMessage)messageMap.get(midId);
            if (message == null) {
                param.addSuccessMsg(midId, String.valueOf(id), " ");
            }
        });
    }

    public static boolean validatePhone(String phone) {
        TelephoneParseResult res = I18nServiceHelper.parseTelephone((String)phone);
        if (!res.isSuccess()) {
            LOGGER.info("invoke I18nServiceHelper.parseTelephone failed , and errorMsg is " + res.getErrorMsg());
            return false;
        }
        List countryList = res.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)res.getTelephone(), (String[])countryList.toArray(new String[0]));
        return !HRObjectUtils.isEmpty((Object)result) && HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")));
    }

    public static boolean isOverOneInput(String ... values) {
        int i = 0;
        for (int k = 0; k < values.length; ++k) {
            if (!HRStringUtils.isNotEmpty((String)values[k])) continue;
            ++i;
        }
        return i > 1 || i == 0;
    }
}

