/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.controlworkloc;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIControlWorkLocInitServiceImpl
extends HRPICommonInitService {
    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map midIdMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        Set<Long> controlWorkLocations = CommonServiceUtil.existsEmpIdByData(data, "hrpi_contrworkloc");
        HashSet empIdSet = Sets.newHashSetWithExpectedSize((int)data.size());
        for (DynamicObject item : data) {
            StringBuilder msg = new StringBuilder();
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)midIdMap.get(id)).iterator().next();
            Long empId = item.getLong("employee.id");
            if (empId != 0L && !empIdSet.add(empId)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u534f\u8bae\u5de5\u4f5c\u5730\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRPIControlWorkLocCommonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            CommonServiceUtil.checkIsEmployee(msg, item.getDynamicObject("employee"));
            CommonServiceUtil.checkEndDate(msg, item);
            if (controlWorkLocations.contains(empId)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u534f\u8bae\u5de5\u4f5c\u5730\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"HRPIControlWorkLocCommonInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            this.checkDateValidate(item, msg);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        }
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", null);
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        MainEntityType controlWorkType = EntityMetadataCache.getDataEntityType((String)"hrpi_contrworkloc");
        DynamicObjectCollection controlWorkCollection = new DynamicObjectCollection((DynamicObjectType)controlWorkType, null);
        String[] needImpPros = this.getImportFields((DynamicObjectType)controlWorkType);
        Map outMessageMap = this.getInitOutParam().getData();
        for (DynamicObject item : data) {
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            DynamicObject newRewardDy = CommonServiceUtil.buildDy((DynamicObjectType)controlWorkType, item, needImpPros);
            newRewardDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            newRewardDy.set("bsed", (Object)item.getDate("startdate"));
            CommonServiceUtil.setEmpAndNewPerson(newRewardDy, item);
            Date endDate = item.getDate("enddate");
            newRewardDy.set("businessstatus", (Object)"2");
            if (DateUtil.compareDate(endDate, HRBaseUtils.getMaxEndDate()) == 0) {
                newRewardDy.set("businessstatus", (Object)"1");
            }
            controlWorkCollection.add((Object)newRewardDy);
        }
        if (!CollectionUtils.isEmpty((Collection)controlWorkCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(controlWorkCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private void checkDateValidate(DynamicObject item, StringBuilder msg) {
        Date startDate = item.getDate("startdate");
        Date endDate = item.getDate("enddate");
        String sdDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPIControlWorkLocCommonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(startDate, new Date(), msg, sdDateStr, "1");
        String bsDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"HRPIControlWorkLocCommonInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(startDate, endDate, msg, bsDateStr, "1");
        Date bigDate = HRBaseUtils.getMaxEndDate();
        String bigDateStr = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c2999-12-31\u201d\u3002", (String)"HRPIControlWorkLocCommonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(endDate, bigDate, msg, bigDateStr, "1");
    }
}

