/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.dep;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HRPICmpempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.HRPIMsgConstants;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import kd.hrmp.hrpi.common.util.InitValidateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class HRPICommonDepInitService
extends HRPICommonInitService {
    private static final String EMP_LABORRELTYPE_ID = "employee.laborreltype_id";
    private static final Log LOG = LogFactory.getLog(HRPICommonDepInitService.class);
    private Map<Long, Long> empEntRelMap;
    private Map<Long, DynamicObject> perNonTsMap = null;
    private Map<Long, List<DynamicObject>> groupByEmpNumberForCmp = null;
    private Map<Long, List<DynamicObject>> groupByEmpNumberForDmp = null;
    private Map<Long, DynamicObject> depCmpRelMap = null;
    private Map<Long, Long> midAndEmpNumberMap = null;
    private Set<Long> lastDepEmpIds = null;
    protected final Set<String> primarySet = Sets.newHashSetWithExpectedSize((int)1000);
    private Map<Long, Map<String, Object>> posJobRelMap = null;
    private Map<Long, Map<String, Object>> stdPosJobRelMap = null;
    private Map<String, Map<String, Object>> companyResult = null;
    private Map<Long, Long> adminOrgBuRel = null;
    protected Map<String, Map<String, Object>> darkPosMap = null;
    protected Map<String, Map<String, Object>> darkPosByJobMap = null;
    private Set<Long> adminOrgIds = null;
    private Map<String, Long> fileTypeMaps = null;
    protected static final int OCCUPATION_HEADCOUNT_BATCHCOUNT = 5000;
    protected static final int EMPPOS_BATCHCOUNT = 5000;
    private final String[] empExpAllProps = new String[]{"bsed", "businessstatus", "initbatch", "employee", "person", "cmpemp", "depemp", "isprimary", "startdate", "enddate", "lastworkdate", "workplace"};
    private final String[] entityNumbers = new String[]{"hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall", "hspm_ermanfile", "hrpi_personrolerel"};
    private final String[] depTables = new String[]{"t_hrpi_depemp", "t_hrpi_empposorgrel", "t_hrpi_ermanfile", "t_hrpi_emporgrelall", "t_hrpi_personrolerel"};
    private Map<String, Boolean> groupBooleanMap;

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        HashSet employeeIdSet = Sets.newHashSetWithExpectedSize((int)data.size());
        this.groupByEmpNumberForDmp = Maps.newHashMapWithExpectedSize((int)data.size());
        this.depCmpRelMap = Maps.newHashMapWithExpectedSize((int)data.size());
        this.midAndEmpNumberMap = Maps.newHashMapWithExpectedSize((int)data.size());
        this.adminOrgIds = Sets.newHashSetWithExpectedSize((int)data.size());
        this.darkPosMap = Maps.newHashMapWithExpectedSize((int)data.size());
        this.darkPosByJobMap = Maps.newHashMapWithExpectedSize((int)data.size());
        HashMap positionSortGroupMap = Maps.newHashMapWithExpectedSize((int)data.size());
        HashSet labAndPosTypeSet = Sets.newHashSetWithExpectedSize((int)data.size());
        Boolean empExpFlag = HRPIServiceFactory.initCenterParam.queryParamConfigOfEmpExp();
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            if (!empExpFlag.booleanValue()) {
                this.preIsPrimary((DynamicObject)item);
            }
            if (item.getLong("employee.id") != 0L) {
                employeeIdSet.add(item.getLong("employee.id"));
                labAndPosTypeSet.add(this.getFileType((DynamicObject)item));
            }
            this.preValidate((DynamicObject)item, midId);
            this.addItemAndSort(positionSortGroupMap.computeIfAbsent(this.getPositionGroupKey((DynamicObject)item), v -> Lists.newArrayListWithCapacity((int)16)), item);
        });
        this.groupBooleanMap = CommonServiceUtil.checkTimeNonOverlap(positionSortGroupMap);
        this.initFileTypeMap(labAndPosTypeSet);
        this.queryCmp(employeeIdSet);
        this.queryEmpExp(employeeIdSet);
        this.queryBuByAdminOrg();
        StringBuilder msg = new StringBuilder();
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            if (item.get("affiliateadminorg") == null) {
                item.set("affiliateadminorg", item.get("adminorg"));
            }
            this.depValidate(midId, msg, (DynamicObject)item, empExpFlag);
        });
        this.validateByGroup(idMap);
        this.validateOtherGroupData(idMap);
        CommonServiceUtil.wrapSuccessPkIds(idMap, data, this.getInitOutParam());
    }

    private void initFileTypeMap(Set<String> labAndPosTypeSet) {
        if (this.fileTypeMaps == null) {
            this.fileTypeMaps = HRPIManFileRepository.getFileTypeByLabAndPosType(labAndPosTypeSet);
        }
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "empnumber", "startdate", this.isQuit() ? HRPIValueConstants.LABRELSTATUSPRD_END : HRPIValueConstants.LABRELSTATUSPRD_ING);
    }

    public abstract boolean isQuit();

    private void preIsPrimary(DynamicObject midData) {
        if (HRPIValueConstants.POS_CATEGORY_FULL.equals(midData.get("postype.postcategory_id"))) {
            midData.set("isprimary", (Object)"1");
        } else {
            midData.set("isprimary", (Object)"0");
        }
    }

    private void queryEmpExp(Set<Long> employeeIdSet) {
        DynamicObject[] empExps = HRPIDepempRepository.loadEmpPosByEmployeeId(employeeIdSet);
        for (int i = 0; i < empExps.length; ++i) {
            DynamicObject item = empExps[i];
            List<DynamicObject> groupData = this.groupByEmpNumberForDmp.get(item.getLong("employee.id"));
            this.addItemAndSort(groupData, item);
            String apositiontype = item.getString("apositiontype");
            if ("0".equals(apositiontype)) {
                Long stdPositionId = (Long)item.get("stdposition.id");
                this.buildDarkPosMap(this.darkPosMap, stdPositionId, item);
            } else if ("2".equals(apositiontype)) {
                Long jobId = (Long)item.get("job.id");
                this.buildDarkPosMap(this.darkPosByJobMap, jobId, item);
            }
            if (!this.isEffectAndPrimary(item)) continue;
            String empNumber = item.getString("employee.empnumber");
            this.primarySet.add(empNumber);
        }
    }

    protected boolean isEffectAndPrimary(DynamicObject item) {
        Date enddate = (Date)item.get("enddate");
        String isPriMary = item.getString("isprimary");
        return HRBaseUtils.getMaxEndDate().equals(enddate) && "1".equals(isPriMary);
    }

    private void buildDarkPosMap(Map<String, Map<String, Object>> map, Long stdPosId, DynamicObject item) {
        Long positionId = (Long)item.get("position_id");
        Long adminOrgId = (Long)item.get("adminorg_id");
        Long personId = (Long)item.get("person_id");
        Date startDate = item.getDate("startdate");
        Date endDate = item.getDate("endDate");
        String darkPosKey = String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(stdPosId), String.valueOf(personId), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate));
        HashMap<String, Object> darkPosItem = new HashMap<String, Object>();
        darkPosItem.put("position", positionId);
        darkPosItem.put("workrole", item.get("position.workrole_id"));
        darkPosItem.put("org", adminOrgId);
        darkPosItem.put("isSuccess", Boolean.TRUE);
        map.put(darkPosKey, darkPosItem);
    }

    private void queryCmp(Set<Long> employeeIdSet) {
        DynamicObject[] cmps = HRPICmpempRepository.getCmpEmpByEmployeeId("id,person_id,employee.empnumber,startdate,enddate,managingscope_id,isprimaryscope", employeeIdSet);
        this.groupByEmpNumberForCmp = Arrays.stream(cmps).collect(Collectors.groupingBy(item -> item.getLong("employee.id")));
    }

    private void queryOrgAndPosInfo(Set<Long> adminOrgIds, Set<Long> positionIds, Set<Long> stdPositionIds) {
        List jobs;
        Integer success;
        Map jobInfo;
        if (CollectionUtils.isNotEmpty(adminOrgIds)) {
            this.companyResult = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{new ArrayList<Long>(adminOrgIds), new Date()});
            LOG.info("\u8c03\u7528IHAOSBatchAdminOrgInfoQueryService.adminOrgInfoQuery\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(this.companyResult));
        }
        if (CollectionUtils.isNotEmpty(positionIds)) {
            jobInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPosition", (Object[])new Object[]{new ArrayList<Long>(positionIds)});
            success = 200;
            if (success.equals(jobInfo.get("code"))) {
                jobs = (List)jobInfo.get("data");
                this.posJobRelMap = Maps.newHashMapWithExpectedSize((int)jobs.size());
                jobs.forEach(item -> this.posJobRelMap.put((Long)item.get("id"), (Map<String, Object>)item));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIPositionService.queryPosition\u201d\u5f02\u5e38\u3002", (String)"HRPICommonDepInitService_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        if (CollectionUtils.isNotEmpty(stdPositionIds)) {
            jobInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPosition", (Object[])new Object[]{new ArrayList<Long>(stdPositionIds)});
            success = 200;
            if (success.equals(jobInfo.get("code"))) {
                jobs = (List)jobInfo.get("data");
                this.stdPosJobRelMap = Maps.newHashMapWithExpectedSize((int)jobs.size());
                jobs.forEach(item -> this.stdPosJobRelMap.put((Long)item.get("id"), (Map<String, Object>)item));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"IStandardPositionQueryService.queryStandardPosition\u5f02\u5e38\u3002", (String)"HRPICommonDepInitService_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    private void queryBuByAdminOrg() {
        if (CollectionUtils.isNotEmpty(this.adminOrgIds)) {
            HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)this.adminOrgIds.size());
            HashSet businessTypeSet = Sets.newHashSetWithExpectedSize((int)1);
            businessTypeSet.add(HRPIValueConstants.BUSINESS_HR);
            for (Long adminOrgId : this.adminOrgIds) {
                orgId2BusinessType.put(adminOrgId, businessTypeSet);
            }
            List buResult = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, HRPIValueConstants.BUS_OBJ_TYPE_EMP});
            if (CollectionUtils.isNotEmpty((Collection)buResult)) {
                this.adminOrgBuRel = Maps.newHashMapWithExpectedSize((int)buResult.size());
                for (Map bu : buResult) {
                    this.adminOrgBuRel.put((Long)bu.get("adminOrgId"), (Long)bu.get("hrBuId"));
                }
            }
        }
    }

    private void depValidate(Long midId, StringBuilder msg, DynamicObject item, Boolean empExpFlag) {
        Long employeeId = item.getLong("employee.id");
        Date start = (Date)item.get("startdate");
        Date enddate = (Date)item.get("enddate");
        if (enddate.before(start)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPICommonDepInitService_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (empExpFlag.booleanValue()) {
            Long posTypeCategoryId;
            String isPriMary = item.getString("isprimary");
            if (StringUtils.isBlank((CharSequence)isPriMary)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u662f\u5426\u4e3b\u4efb\u804c\u3002", (String)"HRPICommonDepInitService_24", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (!HRPIValueConstants.POS_CATEGORY_FULL.equals(posTypeCategoryId = (Long)item.get("postype.postcategory_id")) && "1".equals(isPriMary)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b\u4e0d\u662f\u201c\u5168\u804c\u4efb\u804c\u201d\u7684\u4efb\u804c\u7ecf\u5386\u4e0d\u80fd\u88ab\u8bbe\u4e3a\u4e3b\u4efb\u804c\u3002", (String)"HRPICommonDepInitService_25", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        CommonServiceUtil.checkStartDate(msg, start);
        this.validateAdminOrg(msg, item);
        this.validateEnableAndStatus(msg, item, item.getDynamicObject("adminorg"), ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"HRPICommonDepInitService_34", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        if (!this.groupByEmpNumberForCmp.containsKey(employeeId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u5458\u5de5\u7684\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u4fe1\u606f\u3002", (String)"HRPICommonDepInitService_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        } else {
            CommonServiceUtil.checkEndDate(msg, item);
            if (!this.buildDepCmpRelMap(item)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u65e0\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u4e0e\u6b64\u4efb\u804c\u5bf9\u5e94\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u3002", (String)"HRPICommonDepInitService_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        DynamicObject position = item.getDynamicObject("position");
        String posMsg = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"HRPICommonDepInitService_15", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        DynamicObject stdPosition = item.getDynamicObject("stdposition");
        String stdPosMsg = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"HRPICommonDepInitService_17", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        DynamicObject job = item.getDynamicObject("job");
        String jobMsg = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"HRPICommonDepInitService_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        String apositiontype = item.getString("apositiontype");
        if (position == null && stdPosition == null && job == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5c97\u4f4d\u3001\u804c\u4f4d\u548c\u6807\u51c6\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPICommonDepInitService_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if ("1".equals(apositiontype)) {
            this.validatePositionTypeMustInput(msg, posMsg, position);
            this.validatePosition(msg, item, position);
            this.validateNotInput(msg, this.buildMsg(posMsg, stdPosMsg, jobMsg), stdPosition, job);
            this.validateGroupOverlap(msg, item, posMsg);
            this.validateEnableAndStatus(msg, item, position, ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"HRPICommonDepInitService_31", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        } else if ("2".equals(apositiontype)) {
            this.validatePositionTypeMustInput(msg, jobMsg, job);
            this.validateNotInput(msg, this.buildMsg(jobMsg, posMsg, stdPosMsg), position, stdPosition);
            this.validateGroupOverlap(msg, item, jobMsg);
            this.validateEnableAndStatus(msg, item, job, ResManager.loadKDString((String)"\u804c\u4f4d", (String)"HRPICommonDepInitService_32", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        } else if ("0".equals(apositiontype)) {
            this.validatePositionTypeMustInput(msg, stdPosMsg, stdPosition);
            this.validateNotInput(msg, this.buildMsg(stdPosMsg, posMsg, jobMsg), position, job);
            this.validateGroupOverlap(msg, item, stdPosMsg);
            this.validateEnableAndStatus(msg, item, stdPosition, ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"HRPICommonDepInitService_33", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        } else if (this.isOverOneInput(position, stdPosition, job)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5c97\u4f4d\u3001\u804c\u4f4d\u548c\u6807\u51c6\u5c97\u4f4d\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u3002", (String)"HRPICommonDepInitService_20", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        Long adminOrgId = (Long)item.get("adminorg.id");
        if (this.adminOrgBuRel == null || !this.adminOrgBuRel.containsKey(adminOrgId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5f53\u524d\u5458\u5de5\u7684\u884c\u653f\u7ec4\u7ec7\u5bf9\u5e94\u7684\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"HRPICommonDepInitService_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        this.validateFileType(msg, item);
        this.cusBusinessValidate(item, msg);
        if (msg.length() != 0) {
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)msg.toString());
            msg.delete(0, msg.length());
        }
    }

    private void validateEnableAndStatus(StringBuilder msg, DynamicObject item, DynamicObject dyn, String fieldCNName) {
        Date endDate = item.getDate("enddate");
        if (Objects.nonNull(dyn) && !this.isQuit() && HRBaseUtils.getMaxEndDate().equals(endDate)) {
            String enable = dyn.getString("enable");
            String status = dyn.getString("status");
            if (!HRStringUtils.equals((String)enable, (String)"1") || !HRStringUtils.equals((String)status, (String)"C")) {
                CommonServiceUtil.addErrorMsg(msg, String.format(ResManager.loadKDString((String)"\u5728\u5c97\u7684\u4efb\u804c\u7ecf\u5386\u7684%s\u7684\u4e1a\u52a1\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5df2\u542f\u7528\u201d\u4e14\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5df2\u5ba1\u6838\u201d", (String)"HRPICommonDepInitService_35", (String)"hrmp-hrpi-business", (Object[])new Object[0]), fieldCNName));
            }
        }
    }

    private void validateGroupOverlap(StringBuilder msg, DynamicObject item, String posMsg) {
        if (item.getLong("person.id") == 0L) {
            return;
        }
        Boolean flag = this.groupBooleanMap.get(this.getPositionGroupKey(item));
        if (flag != null && !flag.booleanValue()) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u4e00\u4e2a\u5458\u5de5\u5728\u540c\u4e00\u4e2a\u90e8\u95e8\u76f8\u540c\u7684\u201c{0}\u201d\u4efb\u804c\u65f6\u95f4\u6bb5\u91cd\u53e0\u3002", (String)"HRPICommonDepInitService_30", (String)"hrmp-hrpi-business", (Object[])new Object[]{posMsg}));
        }
    }

    private void validateFileType(StringBuilder msg, DynamicObject item) {
        if (item.getLong("employee.id") == 0L || item.getLong("postype.id") == 0L) {
            return;
        }
        String key = this.getFileType(item);
        if (this.fileTypeMaps == null || this.fileTypeMaps.get(key) == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u8fd9\u6761\u4efb\u804c\u7ecf\u5386\u6ca1\u6709\u5339\u914d\u7684\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u3002", (String)"HRPICommonDepInitService_29", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private String getFileType(DynamicObject item) {
        return item.getLong(EMP_LABORRELTYPE_ID) + "_" + item.getLong("postype.id");
    }

    private String getPositionGroupKey(DynamicObject item) {
        return item.getLong("adminorg.id") + "_" + item.getLong("position.id") + "_" + item.getLong("stdposition.id") + "_" + item.getLong("job.id") + "_" + item.getLong("person.id");
    }

    private void validateAdminOrg(StringBuilder msg, DynamicObject item) {
        DynamicObject adminOrgDy = item.getDynamicObject("adminorg");
        if (adminOrgDy == null) {
            return;
        }
        if ("true".equals(adminOrgDy.getString("isvirtualorg"))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u662f\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HRPICommonDepInitService_28", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void validatePosition(StringBuilder msg, DynamicObject item, DynamicObject position) {
        if (position == null) {
            return;
        }
        long adminOrgId = item.getLong("adminorg.id");
        if (adminOrgId == 0L) {
            return;
        }
        if (position.getLong("adminorg.id") != adminOrgId) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u8be5\u5c97\u4f4d\u4fe1\u606f\u3002", (String)"HRPICommonDepInitService_27", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void validatePositionTypeMustInput(StringBuilder msg, String fieldName, DynamicObject field) {
        if (Objects.isNull(field)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRPICommonDepInitService_18", (String)"hrmp-hrpi-business", (Object[])new Object[]{fieldName}));
        }
    }

    private void validateNotInput(StringBuilder msg, String validateMsg, DynamicObject ... fields) {
        for (DynamicObject field : fields) {
            if (!Objects.nonNull(field)) continue;
            CommonServiceUtil.addErrorMsg(msg, validateMsg);
            break;
        }
    }

    private String buildMsg(String ... msgs) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f\u9009\u62e9\u201c%1$s\u201d\u65f6\uff0c\u4e0d\u80fd\u586b\u5165\u201c%2$s\u201d\u548c\u201c%3$s\u201d\u3002", (String)"HRPICommonDepInitService_19", (String)"hrmp-hrpi-business", (Object[])new Object[0]), msgs);
    }

    private boolean isOverOneInput(DynamicObject ... values) {
        int i = 0;
        for (int k = 0; k < values.length; ++k) {
            if (!Objects.nonNull(values[k])) continue;
            ++i;
        }
        return i > 1;
    }

    public abstract void cusPreBusinessValidate(DynamicObject var1, StringBuilder var2);

    public abstract void cusBusinessValidate(DynamicObject var1, StringBuilder var2);

    private void preValidate(DynamicObject item, Long midId) {
        Long employeeId = item.getLong("employee.id");
        if (employeeId != 0L) {
            List groupData = this.groupByEmpNumberForDmp.computeIfAbsent(employeeId, k -> new LinkedList());
            this.addItemAndSort(groupData, item);
            this.midAndEmpNumberMap.put(midId, employeeId);
        }
        this.adminOrgIds.add((Long)item.get("adminorg.id"));
        StringBuilder msg = new StringBuilder();
        this.cusPreBusinessValidate(item, msg);
        if (msg.length() != 0) {
            this.getInitOutParam().addErrorMsg(midId, msg.toString());
        }
    }

    private void validateByGroup(Map<Long, HashSet<Long>> idMap) {
        this.lastDepEmpIds = Sets.newHashSetWithExpectedSize((int)this.groupByEmpNumberForDmp.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : this.groupByEmpNumberForDmp.entrySet()) {
            Long midId;
            HashSet<Long> ids;
            Date preEndDate = null;
            List<DynamicObject> depList = entry.getValue();
            int size = depList.size();
            DynamicObject primaryExp = null;
            Long primaryMid = null;
            Long lastDepEmpId = 0L;
            boolean firstValidate = true;
            for (int i = 0; i < size; ++i) {
                DynamicObject item = depList.get(i);
                String isPriMary = item.getString("isprimary");
                if (!"1".equals(isPriMary)) continue;
                ids = idMap.get(item.get("id"));
                Long l = midId = CollectionUtils.isEmpty(ids) ? Long.valueOf(0L) : ids.iterator().next();
                if (preEndDate != null) {
                    Date startDate = (Date)item.get("startdate");
                    if (startDate == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5458\u5de5%s\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u5bfc\u5165\u6a21\u677f\u3002", (String)"HRPICommonDepInitService_13", (String)"hrmp-hrpi-business", (Object[])new Object[]{"empnumber"}));
                    }
                    if (startDate.compareTo(preEndDate) <= 0 && firstValidate) {
                        InitValidateUtil.addErrorMsgInSameNumber((InitOutParam)this.getInitOutParam(), depList, idMap, (String)ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0\u3002", (String)"HRPICommonDepInitService_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                        firstValidate = false;
                    }
                }
                preEndDate = (Date)item.get("enddate");
                if (HRBaseUtils.getMaxEndDate().equals(item.get("enddate"))) {
                    primaryExp = item;
                    primaryMid = midId;
                }
                lastDepEmpId = (Long)item.get("id");
            }
            this.lastDepEmpIds.add(lastDepEmpId);
            if (!Objects.nonNull(primaryMid)) continue;
            boolean repeatFlag = false;
            for (int i = 0; i < size; ++i) {
                DynamicObject item = depList.get(i);
                ids = idMap.get(item.get("id"));
                midId = CollectionUtils.isEmpty(ids) ? Long.valueOf(0L) : ids.iterator().next();
                Long posTypeCategoryId = (Long)item.get("postype.postcategory_id");
                if (!HRPIValueConstants.POS_CATEGORY_PART.equals(posTypeCategoryId) || !HRBaseUtils.getMaxEndDate().equals(item.get("enddate")) || !this.isSamePosition(item, primaryExp)) continue;
                repeatFlag = true;
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)ResManager.loadKDString((String)"\u751f\u6548\u4e3b\u4efb\u804c\u4e0e\u751f\u6548\u517c\u804c\u4efb\u804c\u5b8c\u5168\u76f8\u540c\u3002", (String)"HRPICommonDepInitService_11", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (!repeatFlag) continue;
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), primaryMid, (String)ResManager.loadKDString((String)"\u751f\u6548\u4e3b\u4efb\u804c\u4e0e\u751f\u6548\u517c\u804c\u4efb\u804c\u5b8c\u5168\u76f8\u540c\u3002", (String)"HRPICommonDepInitService_11", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void wrapLastDepEmpIds() {
        this.lastDepEmpIds = Sets.newHashSetWithExpectedSize((int)this.groupByEmpNumberForDmp.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : this.groupByEmpNumberForDmp.entrySet()) {
            List<DynamicObject> depList = entry.getValue();
            int size = depList.size();
            Long lastDepEmpId = 0L;
            for (int i = 0; i < size; ++i) {
                DynamicObject item = depList.get(i);
                String isPriMary = item.getString("isprimary");
                if (!"1".equals(isPriMary)) continue;
                lastDepEmpId = (Long)item.get("id");
            }
            this.lastDepEmpIds.add(lastDepEmpId);
        }
    }

    private boolean isSamePosition(DynamicObject exp1, DynamicObject exp2) {
        String apositiontype2;
        boolean flag = false;
        String apositiontype1 = exp1.getString("apositiontype");
        if (StringUtils.equals((CharSequence)apositiontype1, (CharSequence)(apositiontype2 = exp2.getString("apositiontype")))) {
            if ("1".equals(apositiontype1)) {
                Long positionId1 = (Long)exp1.get("position.id");
                flag = positionId1.equals(exp2.get("position.id"));
            } else {
                Long adminorgId1 = (Long)exp1.get("adminorg.id");
                if (adminorgId1.equals(exp2.get("adminorg.id"))) {
                    if ("0".equals(apositiontype1)) {
                        Long stdPositionId = (Long)exp1.get("stdposition.id");
                        flag = stdPositionId.equals(exp2.get("stdposition.id"));
                    } else if ("2".equals(apositiontype1)) {
                        Long jobId = (Long)exp1.get("job.id");
                        flag = jobId.equals(exp2.get("job.id"));
                    }
                }
            }
        }
        return flag;
    }

    private void validateOtherGroupData(Map<Long, HashSet<Long>> idMap) {
        Map validateMap = this.getInitOutParam().getData();
        for (Map.Entry entry : validateMap.entrySet()) {
            Long midId = (Long)entry.getKey();
            InitOutMessage msg = (InitOutMessage)entry.getValue();
            if (msg.getSuccess().booleanValue() || this.midAndEmpNumberMap.get(midId) == null) continue;
            List<DynamicObject> group = this.groupByEmpNumberForDmp.get(this.midAndEmpNumberMap.get(midId));
            group.forEach(item -> {
                Long itemMidId;
                Long id = (Long)item.get("id");
                HashSet ids = (HashSet)idMap.get(id);
                if (CollectionUtils.isNotEmpty((Collection)ids) && InitValidateUtil.checkDateStatus((Map)validateMap, (Long)(itemMidId = (Long)ids.iterator().next()))) {
                    this.getInitOutParam().addErrorMsg(itemMidId, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5b58\u5728\u5176\u4ed6\u9519\u8bef\u6570\u636e\u3002", (String)"HRPICommonDepInitService_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            });
        }
    }

    private boolean buildDepCmpRelMap(DynamicObject item) {
        Long id = (Long)item.get("id");
        Long employeeId = item.getLong("employee.id");
        Date startDate = item.getDate("startdate");
        Date endDate = item.getDate("enddate");
        Long posTypeCls = (Long)item.get("postype.postcategory_id");
        List<DynamicObject> cmpList = this.groupByEmpNumberForCmp.get(employeeId);
        for (DynamicObject cmp : cmpList) {
            Date cmpStartDate = cmp.getDate("startdate");
            Date cmpEndDate = cmp.getDate("enddate");
            Boolean isPrimary = (Boolean)cmp.get("isprimaryscope");
            if (cmpStartDate.after(startDate) || cmpEndDate.before(endDate) || (!HRPIValueConstants.POS_CATEGORY_FULL.equals(posTypeCls) && !HRPIValueConstants.POS_CATEGORY_PART.equals(posTypeCls) || !isPrimary.booleanValue()) && (!HRPIValueConstants.POS_CATEGORY_EXPAT.equals(posTypeCls) && !HRPIValueConstants.POS_CATEGORY_ROTATION.equals(posTypeCls) || isPrimary.booleanValue())) continue;
            this.depCmpRelMap.put(id, cmp);
            return true;
        }
        return false;
    }

    private void initEmpEntRelMap(Set<Long> empIdSet) {
        QFilter qFilter = new QFilter("employee", "in", empIdSet);
        qFilter.and(QFilterUtil.getCurrentQf());
        this.empEntRelMap = HRPIEmployeeRepository.empentrelServiceHelper.queryOriginalCollection("id,employee", qFilter.toArray()).stream().collect(Collectors.toMap(dy -> dy.getLong("employee"), dy -> dy.getLong("id"), (k1, k2) -> k2));
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        this.wrapDataForSave(data);
        MainEntityType depType = EntityMetadataCache.getDataEntityType((String)"hrpi_depemp");
        DynamicObjectCollection depCollection = new DynamicObjectCollection((DynamicObjectType)depType, null);
        MainEntityType empExpType = EntityMetadataCache.getDataEntityType((String)"hrpi_empposorgrel");
        DynamicObjectCollection empExpCollection = new DynamicObjectCollection((DynamicObjectType)empExpType, null);
        long[] empExpIds = ORM.create().genLongIds((IDataEntityType)empExpType, data.size());
        MainEntityType erManFileType = EntityMetadataCache.getDataEntityType((String)"hspm_ermanfile");
        DynamicObjectCollection ermanfileCollection = new DynamicObjectCollection((DynamicObjectType)erManFileType, null);
        long[] erManIds = ORM.create().genLongIds((IDataEntityType)erManFileType, data.size());
        long[] quitErManIds = ORM.create().genLongIds((IDataEntityType)erManFileType, this.lastDepEmpIds.size());
        MainEntityType empPosAllType = EntityMetadataCache.getDataEntityType((String)"hrpi_emporgrelall");
        DynamicObjectCollection empPosAllCollection = new DynamicObjectCollection((DynamicObjectType)empPosAllType, null);
        long[] empPosAllIds = ORM.create().genLongIds((IDataEntityType)empPosAllType, data.size());
        MainEntityType workRoleType = EntityMetadataCache.getDataEntityType((String)"hrpi_personrolerel");
        DynamicObjectCollection workRoleCollection = new DynamicObjectCollection((DynamicObjectType)workRoleType, null);
        long[] workRoleIds = ORM.create().genLongIds((IDataEntityType)workRoleType, data.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)data.size());
        HashSet stdPositionIds = Sets.newHashSetWithExpectedSize((int)data.size());
        ArrayList addDarkPosParam = Lists.newArrayListWithExpectedSize((int)data.size());
        ArrayList addDarkPosByJobParam = Lists.newArrayListWithExpectedSize((int)data.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)data.size());
        HashSet darkPosSet = Sets.newHashSetWithExpectedSize((int)data.size());
        HashSet labAndPosTypes = Sets.newHashSetWithExpectedSize((int)data.size());
        Long initBatch = this.getInitInParam().getBatchNumber();
        LOG.info("HRPICommonDepInitService.businessSave KDDateUtils.getSysTimeZone().toZoneId():{}", (Object)KDDateUtils.getSysTimeZone().toZoneId());
        LOG.info("HRPICommonDepInitService.businessSave ZoneId.systemDefault():{}", (Object)ZoneId.systemDefault());
        HashSet empIdSet = Sets.newHashSetWithExpectedSize((int)data.size());
        data.forEach(item -> {
            empIdSet.add(item.getLong("employee.id"));
            Long id = (Long)item.get("id");
            Long adminOrgId = (Long)item.get("adminorg.id");
            Long positionId = (Long)item.get("position.id");
            Long stdPositionId = (Long)item.get("stdposition.id");
            Long jobId = (Long)item.get("job.id");
            Date startDate = item.getDate("startdate");
            Date endDate = item.getDate("enddate");
            DynamicObject cmp = this.depCmpRelMap.get(id);
            if (InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) {
                Long personId = (Long)cmp.get("person_id");
                personIds.add(personId);
                if (Objects.nonNull(positionId)) {
                    positionIds.add(positionId);
                }
                if (Objects.nonNull(stdPositionId)) {
                    stdPositionIds.add(stdPositionId);
                }
                String darkPosKey = String.join((CharSequence)"_", String.valueOf(adminOrgId), Objects.nonNull(stdPositionId) ? String.valueOf(stdPositionId) : String.valueOf(jobId), String.valueOf(personId), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate));
                LOG.info("HRPICommonDepInitService.businessSave darkPosKey:{}", (Object)darkPosKey);
                if (Objects.isNull(positionId) && darkPosSet.add(darkPosKey)) {
                    HashMap posParam = Maps.newHashMapWithExpectedSize((int)4);
                    posParam.put("org", adminOrgId);
                    posParam.put("effect", startDate);
                    posParam.put("bsled", endDate);
                    posParam.put("user", personId);
                    posParam.put("initbatch", initBatch);
                    if (Objects.nonNull(stdPositionId)) {
                        posParam.put("standardposition", stdPositionId);
                        addDarkPosParam.add(posParam);
                    } else if (Objects.nonNull(jobId)) {
                        posParam.put("job", jobId);
                        addDarkPosByJobParam.add(posParam);
                    }
                }
                DynamicObject empEnt = item.getDynamicObject("employee");
                Long labTypeId = (Long)empEnt.get("laborreltype_id");
                Long posTypeId = (Long)item.get("postype.id");
                labAndPosTypes.add(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId)));
            }
        });
        this.initEmpEntRelMap(empIdSet);
        this.queryOrgAndPosInfo(this.adminOrgIds, positionIds, stdPositionIds);
        this.darkPosMap.putAll(HRPIServiceFactory.positionService.addDarkPositionForInit(addDarkPosParam));
        this.darkPosByJobMap.putAll(HRPIServiceFactory.positionService.addDarkPosByJobForInit(addDarkPosByJobParam));
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_pernontsprop");
        QFilter filter = new QFilter("person_id", "in", (Object)personIds);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] perNonDys = personHelper.query("id,name,person_id", new QFilter[]{filter, hisFilter});
        this.perNonTsMap = Maps.newHashMapWithExpectedSize((int)perNonDys.length);
        for (int i = 0; i < perNonDys.length; ++i) {
            this.perNonTsMap.put((Long)perNonDys[i].get("person_id"), perNonDys[i]);
        }
        this.initFileTypeMap(labAndPosTypes);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_actiontype");
        QFilter actionTypeFilter = new QFilter("id", "=", (Object)HRPIValueConstants.ACTION_TYPE_INIT);
        DynamicObject[] actionTypes = helper.query("name", new QFilter[]{actionTypeFilter});
        ILocaleString actionType = actionTypes[0].getLocaleString("name");
        int empNumberIndex = 0;
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject quitErManFile;
            DynamicObject item2 = (DynamicObject)data.get(i);
            Long id = (Long)item2.get("id");
            Long midId = (Long)((HashSet)idmapping.get(id)).iterator().next();
            DynamicObject cmp = this.depCmpRelMap.get(id);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item2) || !this.validateBeforeSave(midId, cmp, item2)) continue;
            DynamicObject empExp = this.buildEmpExpDy((DynamicObjectType)empExpType, empExpIds[i], cmp, item2);
            empExpCollection.add((Object)empExp);
            DynamicObject dep = this.buildDepEmpDy((DynamicObjectType)depType, empExp, item2);
            depCollection.add((Object)dep);
            DynamicObject erManFile = this.buildErManFileDy((DynamicObjectType)erManFileType, erManIds[i], empExp, item2);
            ermanfileCollection.add((Object)erManFile);
            if (this.lastDepEmpIds.contains(id) && (quitErManFile = this.buildQuitErManFileDy(quitErManIds[empNumberIndex++], erManFile)) != null) {
                ermanfileCollection.add((Object)quitErManFile);
            }
            DynamicObject empExpAll = this.buildEmpExpAll((DynamicObjectType)empPosAllType, empPosAllIds[i], empExp, actionType);
            empPosAllCollection.add((Object)empExpAll);
            DynamicObject workRole = this.buildWorkRole((DynamicObjectType)workRoleType, workRoleIds[i], empExp);
            workRoleCollection.add((Object)workRole);
        }
        if (CollectionUtils.isNotEmpty((Collection)depCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(depCollection, empExpCollection, ermanfileCollection, empPosAllCollection, workRoleCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    protected void wrapDataForSave(List<DynamicObject> data) {
        if (Objects.nonNull(this.groupByEmpNumberForDmp)) {
            return;
        }
        this.groupByEmpNumberForDmp = Maps.newHashMapWithExpectedSize((int)data.size());
        this.depCmpRelMap = Maps.newHashMapWithExpectedSize((int)data.size());
        this.adminOrgIds = Sets.newHashSetWithExpectedSize((int)data.size());
        this.darkPosMap = Maps.newHashMapWithExpectedSize((int)data.size());
        this.darkPosByJobMap = Maps.newHashMapWithExpectedSize((int)data.size());
        HashSet employeeIdSet = Sets.newHashSetWithExpectedSize((int)data.size());
        Boolean empExpFlag = HRPIServiceFactory.initCenterParam.queryParamConfigOfEmpExp();
        data.forEach(item -> {
            Long employeeId = item.getLong("employee.id");
            this.adminOrgIds.add((Long)item.get("adminorg.id"));
            List groupData = this.groupByEmpNumberForDmp.computeIfAbsent(employeeId, k -> new LinkedList());
            this.addItemAndSort(groupData, item);
            if (!empExpFlag.booleanValue()) {
                this.preIsPrimary((DynamicObject)item);
            }
            if (item.getLong("employee.id") != 0L) {
                employeeIdSet.add(item.getLong("employee.id"));
            }
        });
        this.queryCmp(employeeIdSet);
        data.forEach(item -> this.buildDepCmpRelMap((DynamicObject)item));
        this.queryEmpExp(employeeIdSet);
        this.queryBuByAdminOrg();
        this.wrapLastDepEmpIds();
    }

    private boolean validateBeforeSave(Long midId, DynamicObject cmp, DynamicObject item) {
        Map<String, Object> dartPos;
        boolean flag = true;
        Long adminOrgId = (Long)item.get("adminorg.id");
        Long stdPositionId = (Long)item.get("stdposition.id");
        Long jobId = (Long)item.get("job.id");
        Date endDate = item.getDate("enddate");
        Date startDate = item.getDate("startDate");
        if (Objects.nonNull(stdPositionId)) {
            Map<String, Object> dartPos2 = this.darkPosMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(stdPositionId), String.valueOf(cmp.get("person_id")), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)));
            if (dartPos2 != null && !((Boolean)dartPos2.get("isSuccess")).booleanValue()) {
                String msg = (String)dartPos2.get("errorMsg");
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)ResManager.loadKDString((String)"\u751f\u6210\u6697\u5c97\u5931\u8d25:%s", (String)"HRPICommonDepInitService_21", (String)"hrmp-hrpi-business", (Object[])new Object[]{msg}));
                flag = false;
            }
        } else if (Objects.nonNull(jobId) && (dartPos = this.darkPosByJobMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(jobId), String.valueOf(cmp.get("person_id")), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)))) != null && !((Boolean)dartPos.get("isSuccess")).booleanValue()) {
            String msg = (String)dartPos.get("errorMsg");
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)ResManager.loadKDString((String)"\u751f\u6210\u6697\u5c97\u5931\u8d25:%s", (String)"HRPICommonDepInitService_21", (String)"hrmp-hrpi-business", (Object[])new Object[]{msg}));
            flag = false;
        }
        return flag;
    }

    private DynamicObject buildDepEmpDy(DynamicObjectType type, DynamicObject empExp, DynamicObject item) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        dy.set("id", empExp.get("depemp"));
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, empExp);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    private DynamicObject buildEmpExpDy(DynamicObjectType type, Long id, DynamicObject cmp, DynamicObject item) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, item);
        dy.set("id", (Object)id);
        dy.set("cmpemp", cmp.get("id"));
        dy.set("depemp", item.get("id"));
        Date startDate = item.getDate("startdate");
        dy.set("bsed", (Object)startDate);
        dy.set("variationtype", (Object)HRPIValueConstants.ACTION_TYPE_INIT);
        dy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        dy.set("islatestrecord", (Object)0);
        Date endDate = item.getDate("enddate");
        CommonServiceUtil.setEmpAndNewPerson(dy, item);
        if (HRBaseUtils.getMaxEndDate().equals(endDate)) {
            dy.set("businessstatus", (Object)"1");
        } else {
            dy.set("businessstatus", (Object)"2");
        }
        dy.set("isinsystem", (Object)true);
        Long adminOrgId = (Long)item.get("adminorg.id");
        Long positionId = (Long)item.get("position.id");
        Long stdPositionId = (Long)item.get("stdposition.id");
        Long jobId = (Long)item.get("job.id");
        Long companyId = (Long)this.companyResult.get(String.valueOf(adminOrgId)).get("belongcompany");
        dy.set("company", (Object)companyId);
        if (Objects.nonNull(positionId)) {
            Map<String, Object> jobInfo = this.posJobRelMap.get(positionId);
            dy.set("job", Objects.nonNull(jobInfo) ? jobInfo.get("job") : null);
            dy.set("apositiontype", (Object)"1");
        } else if (Objects.nonNull(stdPositionId)) {
            Map<String, Object> jobInfo;
            Map<String, Object> dartPos = this.darkPosMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(stdPositionId), String.valueOf(cmp.get("person_id")), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)));
            if (Objects.nonNull(dartPos)) {
                dy.set("position", dartPos.get("position"));
            }
            dy.set("job", Objects.nonNull(jobInfo = this.stdPosJobRelMap.get(stdPositionId)) ? jobInfo.get("job") : null);
            dy.set("apositiontype", (Object)"0");
        } else if (Objects.nonNull(jobId)) {
            Map<String, Object> dartPos = this.darkPosByJobMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(jobId), String.valueOf(cmp.get("person_id")), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)));
            if (Objects.nonNull(dartPos)) {
                dy.set("position", dartPos.get("position"));
            }
            dy.set("apositiontype", (Object)"2");
        }
        this.cusBuildEmpExp(dy, item.getDynamicObject("employee"), item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    private DynamicObject buildErManFileDy(DynamicObjectType type, Long id, DynamicObject empExp, DynamicObject item) {
        String empNumber = item.getString("empnumber");
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, empExp);
        dy.set("id", (Object)id);
        Long adminOrgId = (Long)empExp.get("adminorg.id");
        dy.set("org", (Object)this.adminOrgBuRel.get(adminOrgId));
        dy.set("affiliateadminorg", item.get("affiliateadminorg") != null ? item.get("affiliateadminorg") : empExp.get("adminorg"));
        dy.set("ismanaged", (Object)0);
        dy.set("dependency", empExp.get("workplace.country"));
        dy.set("dependencytype", (Object)HRPIValueConstants.DEPCY_TYPE_LOCAL);
        dy.set("empposrel", empExp.get("id"));
        dy.set("number", (Object)empNumber);
        DynamicObject empEnt = item.getDynamicObject("employee");
        dy.set("empentrel", (Object)this.empEntRelMap.get(empEnt.getLong("id")));
        DynamicObject per = this.perNonTsMap.get(empExp.getLong("person.id"));
        dy.set("name", (Object)per.getString("name"));
        DynamicObject cmp = this.depCmpRelMap.get(empExp.get("depemp"));
        dy.set("hbsscmpemp", cmp.get("managingscope_id"));
        dy.set("pernontsprop", per.get("id"));
        dy.set("dependencytype", item.get("dependencytype"));
        dy.set("dependency", item.get("dependency"));
        dy.set("ismanaged", item.get("ismanaged"));
        if (Objects.isNull(item.get("empgroup"))) {
            dy.set("empgroup", (Object)HRPIValueConstants.HR_GROUP);
        } else {
            dy.set("empgroup", item.get("empgroup"));
        }
        Object status = empExp.get("businessstatus");
        if ("1".equals(status)) {
            dy.set("businessstatus", (Object)"1");
        } else {
            dy.set("businessstatus", (Object)"-1");
        }
        dy.set("issystem", (Object)true);
        Long labTypeId = (Long)empEnt.get("laborreltype_id");
        Long posTypeId = (Long)empExp.get("postype.id");
        dy.set("filetype", (Object)this.fileTypeMaps.get(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId))));
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    public abstract DynamicObject buildQuitErManFileDy(Long var1, DynamicObject var2);

    private DynamicObject buildEmpExpAll(DynamicObjectType type, Long id, DynamicObject empExp, ILocaleString actionType) {
        Long stdPostionId;
        DynamicObject dy = (DynamicObject)type.createInstance();
        dy.set("id", (Object)id);
        Long adminOrgId = (Long)empExp.get("adminorg.id");
        dy.set("postype", empExp.get("postype.name"));
        Object company = this.companyResult.get(String.valueOf(adminOrgId)).get("companyname");
        dy.set("company", company);
        dy.set("adminorg", empExp.get("adminorg.name"));
        dy.set("position", empExp.get("position.name"));
        dy.set("stdposition", empExp.get("stdposition.name"));
        Long stdPositionId = (Long)empExp.get("stdposition.id");
        if (stdPositionId != null) {
            dy.set("position", empExp.get("stdposition.name"));
        }
        dy.set("variationtype", (Object)actionType);
        Long positionId = (Long)empExp.get("position.id");
        if (Objects.nonNull(positionId)) {
            Map<String, Object> jobInfo = this.posJobRelMap.get(positionId);
            dy.set("job", Objects.nonNull(jobInfo) ? jobInfo.get("job.name") : null);
        }
        if (Objects.nonNull(stdPostionId = (Long)empExp.get("stdposition.id"))) {
            Map<String, Object> jobInfo = this.stdPosJobRelMap.get(stdPostionId);
            dy.set("job", Objects.nonNull(jobInfo) ? jobInfo.get("job.name") : null);
        }
        dy.set("isinsystem", empExp.get("isinsystem"));
        dy.set("apositiontype", empExp.get("apositiontype"));
        InitValidateUtil.wrapPropsFromSourceToDy((String[])this.empExpAllProps, (DynamicObject)empExp, (DynamicObject)dy);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    private DynamicObject buildWorkRole(DynamicObjectType type, Long id, DynamicObject empExp) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, empExp);
        dy.set("id", (Object)id);
        Long adminOrgId = (Long)empExp.get("adminorg.id");
        Long stdPositionId = (Long)empExp.get("stdposition.id");
        Long jobId = (Long)empExp.get("job.id");
        Long personId = empExp.getLong("person.id");
        String posType = empExp.getString("apositiontype");
        Date startDate = empExp.getDate("startdate");
        Date endDate = empExp.getDate("enddate");
        if (StringUtils.equals((CharSequence)posType, (CharSequence)"1")) {
            dy.set("role", empExp.get("position.workrole"));
            dy.set("mainpeoincharge", empExp.get("position.workrole.mainpeoincharge"));
            dy.set("adminorg", empExp.get("position.workrole.adminorg"));
        } else if (StringUtils.equals((CharSequence)posType, (CharSequence)"0")) {
            Map<String, Object> dartPos = this.darkPosMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(stdPositionId), String.valueOf(personId), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)));
            this.wrapWrokRole(dy, dartPos);
        } else if (StringUtils.equals((CharSequence)posType, (CharSequence)"2")) {
            Map<String, Object> dartPos = this.darkPosByJobMap.get(String.join((CharSequence)"_", String.valueOf(adminOrgId), String.valueOf(jobId), String.valueOf(personId), HRDateTimeUtils.formatDate((Date)startDate), HRDateTimeUtils.formatDate((Date)endDate)));
            this.wrapWrokRole(dy, dartPos);
        }
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }

    private void wrapWrokRole(DynamicObject dy, Map<String, Object> dartPos) {
        dy.set("role", dartPos.get("workrole"));
        dy.set("adminorg", dartPos.get("org"));
        dy.set("mainpeoincharge", (Object)Boolean.FALSE);
    }

    public abstract void cusBuildEmpExp(DynamicObject var1, DynamicObject var2, DynamicObject var3);

    protected void rollbackAll() {
        this.beforeRollBackAll();
        String openNewTX = System.getProperty("openNewTX");
        LOG.info("HRPICommonDepInitService rollbackAll param:{}", (Object)openNewTX);
        boolean isOpenNewTx = Boolean.parseBoolean(openNewTX);
        if (isOpenNewTx) {
            this.rollbackAllDepBySplitTransaction();
        } else {
            this.rollbackOtherTableAll("hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall", "hspm_ermanfile", "hrpi_personrolerel");
        }
    }

    private void rollbackAllDepBySplitTransaction() {
        for (String entityNumber : this.entityNumbers) {
            LOG.info("HRPICommonDepInitService rollbackAllDepBySplitTransaction start:{}", (Object)entityNumber);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
                    QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"0", "1"}))};
                    helper.deleteByFilter(batchQFiler);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    throw ex;
                }
            }
            LOG.info("HRPICommonDepInitService rollbackAllDepBySplitTransaction end:{}", (Object)entityNumber);
        }
    }

    public void changeStatus() {
        LOG.info("HRPICommonDepInitService changeStatus start");
        this.changePositionStatus();
        LOG.info("HRPICommonDepInitService changePositionStatus end");
        this.changeTableStatusBySql(this.depTables);
        LOG.info("HRPICommonDepInitService changeStatus end");
    }

    public void changeSuccessStatus() {
        super.changeSuccessStatus();
        this.OccupationHeadcount();
        this.addChargePersonByPosition();
    }

    private void addChargePersonByPosition() {
        LOG.info("addChargePersonByPosition start");
        QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("apositiontype", "=", (Object)"1"), new QFilter("position.isleader", "=", (Object)"1")};
        int count = ORM.create().count("QueryServiceHelper.hrpi_empposorgrel", "hrpi_empposorgrel", batchQFiler);
        int pageCount = (int)Math.ceil((double)count / 5000.0);
        LOG.info("addChargePersonByPosition : initbatch={}, pageCount={}, length={}", new Object[]{this.getInitInParam().getBatchNumber(), pageCount, count});
        if (count > 0) {
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                Object[] dynamicObjects = BusinessDataServiceHelper.load((String)"hrpi_empposorgrel", (String)"person_id,depemp_id,adminorg_id,position.isleader,startdate", (QFilter[])batchQFiler, (String)"id", (int)pageIndex, (int)5000);
                ArrayList<Map<String, Object>> chargePersonParam = new ArrayList<Map<String, Object>>(dynamicObjects.length);
                if (!HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) continue;
                for (Object dynamicObject : dynamicObjects) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("operatetype", "0");
                    param.put("person", dynamicObject.getLong("person_id"));
                    param.put("depemp", dynamicObject.getLong("depemp_id"));
                    param.put("adminorg", dynamicObject.getLong("adminorg_id"));
                    param.put("effdt", dynamicObject.getDate("startdate"));
                    param.put("changesource", ChangeSourceEnum.POSITION_CHANGE.getId());
                    chargePersonParam.add(param);
                }
                LOG.info("addChargePersonByPosition#chargePersonParam={}", chargePersonParam);
                new ChargeApplicationImpl().setChargePerson(chargePersonParam);
            }
        }
    }

    private void OccupationHeadcount() {
        QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("iscurrentversion", "=", (Object)"1")};
        int count = ORM.create().count("QueryServiceHelper.hrpi_depemp", "hrpi_depemp", batchQFiler);
        int pageCount = (int)Math.ceil((double)count / 5000.0);
        LOG.info("OccupationHeadcount : initbatch={}, pageCount={}, length={}", new Object[]{this.getInitInParam().getBatchNumber(), pageCount, count});
        HRBaseServiceHelper deleteHelper = new HRBaseServiceHelper("hrpi_depemp");
        if (count > 0) {
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                DynamicObject[] dynamicObjectList = BusinessDataServiceHelper.load((String)"hrpi_depemp", (String)"id, person.id", (QFilter[])batchQFiler, (String)"id", (int)pageIndex, (int)5000);
                Set personIds = Arrays.stream(dynamicObjectList).map(it -> it.getLong("person.id")).collect(Collectors.toSet());
                this.senMsg(new ArrayList<Long>(personIds), this.getInitInParam().getBatchNumber(), pageIndex);
            }
        }
    }

    private void senMsg(List<Long> depempIds, Long batchNumber, int pageIndex) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        HashMap<String, Object> messageParams = new HashMap<String, Object>(8);
        String msgNumber = String.format("%s_%s_%s", batchNumber, pageIndex, timestamp);
        String msgTitle = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u521d\u59cb\u5316\u7f16\u5236%1$s", (String)"HRPICommonDepInitService_22", (String)"hrmp-hrpi-business", (Object[])new Object[0]), msgNumber);
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgDesc", ResManager.loadKDString((String)"\u4eba\u5458\u521d\u59cb\u5316\u7f16\u5236", (String)"HRPICommonDepInitService_23", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        messageParams.put("msgPubNo", "MP20221226001023");
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("actionId", HRPIMsgConstants.ACTIONID_OCCUPATION_HEADCOUNT);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(depempIds));
        LOG.info("HRPICommonDepInitService ==> OccupationHeadcount senMsg messageParms: {}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    protected void beforeRollBackAll() {
        try (TXHandle h = TX.notSupported();){
            HRPIServiceFactory.positionService.rollbackPosition(this.getInitInParam().getBatchNumber());
        }
    }

    private void changePositionStatus() {
        try (TXHandle h = TX.notSupported();){
            String targetStatus = this.getTargetStatus();
            HRPIServiceFactory.positionService.changePositionInitStatus(this.getInitInParam().getBatchNumber(), targetStatus);
        }
    }
}

