/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.dep;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.init.dep.HRPICommonDepInitService;

public class HRPIQuitDepInitServiceImpl
extends HRPICommonDepInitService {
    private Map<Long, Long> laborStatusFileTypeMaps = null;

    @Override
    protected void wrapDataForSave(List<DynamicObject> data) {
        DynamicObject[] fileTypeInfos;
        super.wrapDataForSave(data);
        if (Objects.nonNull(this.laborStatusFileTypeMaps)) {
            return;
        }
        this.laborStatusFileTypeMaps = Maps.newHashMapWithExpectedSize((int)6);
        Set<Long> laborRelStatusSet = data.stream().filter(dy -> dy.getDynamicObject("employee") != null).map(dy -> dy.getDynamicObject("employee").getLong("laborrelstatus_id")).collect(Collectors.toSet());
        for (DynamicObject fileTypeInfo : fileTypeInfos = HRPIManFileRepository.getFileTypeByLaborRelStatus(laborRelStatusSet)) {
            DynamicObjectCollection laborRelStatusInfos = fileTypeInfo.getDynamicObjectCollection("laborreltatus");
            for (DynamicObject laborRelStatusInfo : laborRelStatusInfos) {
                this.laborStatusFileTypeMaps.put(laborRelStatusInfo.getLong("fbasedataid_id"), fileTypeInfo.getLong("id"));
            }
        }
    }

    @Override
    public boolean isQuit() {
        return true;
    }

    @Override
    public void cusPreBusinessValidate(DynamicObject item, StringBuilder msg) {
    }

    @Override
    public void cusBusinessValidate(DynamicObject item, StringBuilder msg) {
    }

    @Override
    public DynamicObject buildQuitErManFileDy(Long id, DynamicObject erManFile) {
        DynamicObjectType type = erManFile.getDynamicObjectType();
        DynamicObject quitErFile = (DynamicObject)type.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)erManFile, (DynamicObject)quitErFile);
        quitErFile.set("id", (Object)id);
        Date endDate = erManFile.getDate("enddate");
        LocalDateTime end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        Date startDate = Date.from(end.plusDays(1L).atZone(ZoneId.systemDefault()).toInstant());
        quitErFile.set("bsed", (Object)startDate);
        quitErFile.set("startdate", (Object)startDate);
        quitErFile.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
        DynamicObject empEnt = erManFile.getDynamicObject("employee");
        Long laborRelStatusId = (Long)empEnt.get("laborrelstatus_id");
        Long filetype = this.laborStatusFileTypeMaps.get(laborRelStatusId);
        if (filetype == null) {
            filetype = 1050L;
        }
        quitErFile.set("filetype", (Object)filetype);
        quitErFile.set("businessstatus", (Object)"1");
        return quitErFile;
    }

    @Override
    public void cusBuildEmpExp(DynamicObject dy, DynamicObject emp, DynamicObject source) {
        Date endDate = dy.getDate("enddate");
        Date empEndDate = emp.getDate("enddate");
        if (empEndDate.equals(endDate)) {
            dy.set("islatestrecord", (Object)1);
        } else {
            dy.set("islatestrecord", (Object)0);
        }
    }
}

