/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.emp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;
import org.apache.commons.collections.CollectionUtils;

public abstract class HRPIEmpCommonInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOG = LogFactory.getLog(HRPIEmpCommonInitServiceImpl.class);
    private Set<String> empNumberSet = null;
    private Map<String, Long> empNumberMidIdMap = null;
    private Map<String, Long> numberPersonIdMap = null;
    private Set<String> existEmpNumber = null;
    private final String[] employeeProps = new String[]{"bsed", "businessstatus", "person", "empnumber", "startdate", "enddate", "initbatch"};

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.empNumberSet = Sets.newHashSetWithExpectedSize((int)data.size());
        this.empNumberMidIdMap = Maps.newHashMapWithExpectedSize((int)data.size());
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            String empNumber = (String)item.get("empnumber");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            StringBuilder msg = new StringBuilder();
            this.validateLaborrelTypeAndStatus((DynamicObject)item, msg);
            this.checkStartDate(msg, item.getDate("startdate"));
            this.cusBusinessValidate((DynamicObject)item, msg);
            if (msg.length() != 0) {
                this.getInitOutParam().addErrorMsg(midId, msg.toString());
            }
            this.empNumberSet.add(empNumber);
            this.empNumberMidIdMap.put(empNumber, midId);
        });
        this.queryPersonByEmpNumberSet();
        DynamicObjectCollection employeeCollection = HRPIEmployeeRepository.listEmployeesByNumbers("id,empnumber", this.empNumberSet);
        if (CollectionUtils.isNotEmpty((Collection)employeeCollection)) {
            this.existEmpNumber = Sets.newHashSetWithExpectedSize((int)employeeCollection.size());
            employeeCollection.forEach(item -> this.existEmpNumber.add(item.getString("empnumber")));
        }
        this.empNumberMidIdMap.forEach((number, midId) -> {
            StringBuilder msg = new StringBuilder();
            if (this.numberPersonIdMap == null || !this.numberPersonIdMap.containsKey(number)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u6b64\u5de5\u53f7\u7684\u81ea\u7136\u4eba\u4fe1\u606f\u3002", (String)"HRPIEmpCommonInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(this.existEmpNumber) && this.existEmpNumber.contains(number)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u5de5\u53f7\u7684\u804c\u4e1a\u4fe1\u606f\u3002", (String)"HRPIEmpCommonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (msg.length() != 0) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)msg.toString());
            }
        });
        List dysData = (List)dysMap.get("data");
        CommonServiceUtil.wrapSuccessPkIds(idMap, dysData, this.getInitOutParam());
    }

    public abstract void cusBusinessValidate(DynamicObject var1, StringBuilder var2);

    private void validateLaborrelTypeAndStatus(DynamicObject item, StringBuilder msg) {
        Long typeId = (Long)item.get("laborreltype_id");
        DynamicObject status = item.getDynamicObject("laborrelstatus");
        DynamicObjectCollection typeCollection = status.getDynamicObjectCollection("laborreltype");
        boolean flag = false;
        if (CollectionUtils.isNotEmpty((Collection)typeCollection)) {
            for (int i = 0; i < typeCollection.size(); ++i) {
                if (!typeId.equals(((DynamicObject)typeCollection.get(i)).get("fbasedataid_id"))) continue;
                flag = true;
            }
        }
        if (!flag) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u201d\u548c\u201c\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u4e0d\u5339\u914d\u3002", (String)"HRPIEmpCommonInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType employeeType = EntityMetadataCache.getDataEntityType((String)"hrpi_employee");
        DynamicObjectCollection employeeCollection = new DynamicObjectCollection((DynamicObjectType)employeeType, null);
        MainEntityType empentrelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empentrel");
        DynamicObjectCollection empentrelCollection = new DynamicObjectCollection((DynamicObjectType)empentrelType, null);
        long[] empentrelIds = ORM.create().genLongIds((IDataEntityType)empentrelType, data.size());
        this.wrapNumberPersonIdMap(data);
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            String empNumber = item.getString("empnumber");
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            Long personId = this.numberPersonIdMap.get(empNumber);
            DynamicObject empentrel = this.buildEmpEntRel((DynamicObjectType)empentrelType, empentrelIds[i], personId, item);
            empentrelCollection.add((Object)empentrel);
            DynamicObject employeeDy = this.buildEmployeeDy((DynamicObjectType)employeeType, empentrel);
            employeeCollection.add((Object)employeeDy);
        }
        if (CollectionUtils.isNotEmpty((Collection)employeeCollection)) {
            DynamicObjectCollection empNonEntCollection = this.buildEmpNonEntCollection(empentrelCollection);
            Map<String, Object> paramMap = this.buildDatasByCollection(employeeCollection, empentrelCollection, empNonEntCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private void wrapNumberPersonIdMap(List<DynamicObject> midDys) {
        if (Objects.nonNull(this.empNumberSet)) {
            return;
        }
        this.empNumberSet = Sets.newHashSetWithExpectedSize((int)midDys.size());
        midDys.forEach(item -> {
            String empNumber = (String)item.get("empnumber");
            this.empNumberSet.add(empNumber);
        });
        this.queryPersonByEmpNumberSet();
    }

    private void queryPersonByEmpNumberSet() {
        DynamicObject[] collection = HRPIPersonRepository.getPersonsByNumber("id,number", this.empNumberSet, null);
        if (collection != null && collection.length > 0) {
            this.numberPersonIdMap = Maps.newHashMapWithExpectedSize((int)collection.length);
            for (int k = 0; k < collection.length; ++k) {
                DynamicObject perItem = collection[k];
                Long personId = (Long)perItem.get("id");
                String number = perItem.getString("number");
                this.numberPersonIdMap.put(number, personId);
            }
        }
    }

    private DynamicObject buildEmpEntRel(DynamicObjectType type, Long id, Long personId, DynamicObject item) {
        DynamicObject empentrel = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(empentrel, item);
        empentrel.set("id", (Object)id);
        empentrel.set("bsed", (Object)item.getDate("startdate"));
        empentrel.set("firststartdate", (Object)item.getDate("startdate"));
        empentrel.set("person", (Object)personId);
        empentrel.set("employee", item.get("id"));
        empentrel.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildEmpEntRel(empentrel, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)empentrel);
        return empentrel;
    }

    public abstract void cusBuildEmpEntRel(DynamicObject var1, DynamicObject var2);

    private DynamicObject buildEmployeeDy(DynamicObjectType type, DynamicObject item) {
        DynamicObject employee = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(employee, item);
        employee.set("id", item.get("employee"));
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)employee);
        return employee;
    }

    public abstract DynamicObjectCollection buildEmpNonEntCollection(DynamicObjectCollection var1);

    private void checkStartDate(StringBuilder msg, Date startDate) {
        LocalDate now;
        LocalDate start = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (start.isAfter(now = LocalDate.now())) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u4eca\u5929\u3002", (String)"HRPIEmpCommonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_employee", "hrpi_empnonentrel");
    }

    protected void rollbackAll() {
        this.validateRollbackCmp(ResManager.loadKDString((String)"\u56de\u6eda\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7684\u4efb\u804c\u7ecf\u5386\u6570\u636e\u3001\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u6570\u636e\u5fc5\u987b\u5168\u90e8\u56de\u6eda\u6210\u529f\uff0c\u624d\u53ef\u6267\u884c\u804c\u4e1a\u4fe1\u606f\u6570\u636e\u7684\u56de\u6eda\u3002", (String)"HRPIEmpCommonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        super.rollbackAll();
        this.rollbackOtherTableAll("hrpi_employee", "hrpi_empnonentrel");
    }

    public abstract void validateRollbackCmp(String var1);
}

