/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.emp;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPICmpempRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.business.init.emp.HRPIEmpCommonInitServiceImpl;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIEmpNonEntInitServiceImpl
extends HRPIEmpCommonInitServiceImpl {
    @Override
    public void cusBusinessValidate(DynamicObject item, StringBuilder msg) {
        Date startDate;
        Date endDate;
        Long labrelStatusPrdId = item.getLong("laborrelstatus.labrelstatusprd_id");
        if (!HRPIValueConstants.LABRELSTATUSPRD_END.equals(labrelStatusPrdId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u79bb\u804c\u76f8\u5173\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPIEmpNonEntInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if ((endDate = item.getDate("enddate")).after(InitValidateUtil.getCurrentDay())) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPIEmpNonEntInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (endDate.before(startDate = item.getDate("startdate"))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPIEmpNonEntInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void cusBuildEmpEntRel(DynamicObject target, DynamicObject source) {
        target.set("businessstatus", (Object)"1");
        target.set("labrelstatusprd", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
    }

    @Override
    public DynamicObjectCollection buildEmpNonEntCollection(DynamicObjectCollection empentrelCollection) {
        MainEntityType empnonentType = EntityMetadataCache.getDataEntityType((String)"hrpi_empnonentrel");
        DynamicObjectCollection empnonentCollection = new DynamicObjectCollection((DynamicObjectType)empnonentType, null);
        long[] empnonIds = ORM.create().genLongIds((IDataEntityType)empnonentType, empentrelCollection.size());
        Calendar calendar = Calendar.getInstance();
        Long batchNumber = this.getInitInParam().getBatchNumber();
        for (int i = 0; i < empentrelCollection.size(); ++i) {
            DynamicObject item = (DynamicObject)empnonentType.createInstance();
            DynamicObject source = (DynamicObject)empentrelCollection.get(i);
            DynamicTransformUtil.wrapSameFieldFromSourceForInit(item, source);
            item.set("id", (Object)empnonIds[i]);
            calendar.setTime(source.getDate("enddate"));
            calendar.add(5, 1);
            Date startDate = calendar.getTime();
            item.set("bsed", (Object)startDate);
            item.set("startdate", (Object)startDate);
            item.set("enddate", (Object)HRBaseUtils.getMaxEndDate());
            item.set("initbatch", (Object)batchNumber);
            item.set("businessstatus", (Object)"1");
            InitValidateUtil.wrapCommonFieldInit((DynamicObject)item);
            empnonentCollection.add((Object)item);
        }
        return empnonentCollection;
    }

    @Override
    public void validateRollbackCmp(String msg) {
        Map<String, Object> map = this.getOtherMap();
        Long batchNumber = (Long)map.get("hrpi_quitmanagescope_init");
        boolean isExist = HRPICmpempRepository.existByInitBatch(batchNumber);
        if (isExist) {
            throw new KDBizException(msg);
        }
    }
}

