/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.emp.attach;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIWorkCalendarRelInitServiceImpl
extends HRPICommonInitService {
    private final Set<String> primarySet = Sets.newHashSetWithExpectedSize((int)1000);

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List mapData = (List)map.get("data");
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        HashSet empNumberSet = Sets.newHashSetWithExpectedSize((int)data.size());
        HashMap groupByEmpNumber = Maps.newHashMapWithExpectedSize((int)data.size());
        HashMap midAndEmpNumberMap = Maps.newHashMapWithExpectedSize((int)data.size());
        for (int i = 0; i < mapData.size(); ++i) {
            Map item2 = (Map)mapData.get(i);
            String empNumber = (String)item2.get("person");
            Long midId = (Long)item2.get("id");
            empNumberSet.add(empNumber);
            midAndEmpNumberMap.put(midId, empNumber);
            List empList = (List)groupByEmpNumber.get(empNumber);
            if (null != empList && empList.size() > 0) {
                empList.add(item2);
                continue;
            }
            ArrayList<Map> list = new ArrayList<Map>();
            list.add(item2);
            groupByEmpNumber.put(empNumber, list);
        }
        Set<Long> personIdList = data.stream().map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
        Map<String, Boolean> mainWorkCalMap = this.existMainWorkCalMap(personIdList);
        HashMap empMidIdMap = Maps.newHashMapWithExpectedSize((int)data.size());
        StringBuilder msg = new StringBuilder();
        data.forEach(item -> {
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            String empNumber = item.getString("person.number");
            empMidIdMap.put(empNumber, midId);
            CommonServiceUtil.checkIsEmployee(msg, item.getDynamicObject("employee"));
            CommonServiceUtil.checkEndDate(msg, item);
            Date start = (Date)item.get("startdate");
            Date endDate = (Date)item.get("enddate");
            boolean isMainWork = item.getBoolean("ismainwork");
            if (endDate.before(start)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPIWorkCalendarRelInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (endDate.after(new Date()) && !HRBaseUtils.getMaxEndDate().equals(endDate)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u6216\u8bbe\u4e3a\u201c2999-12-31\u201d\u3002", (String)"HRPIWorkCalendarRelInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (HRBaseUtils.getMaxEndDate().equals(endDate) && isMainWork) {
                if (this.primarySet.contains(empNumber) || mainWorkCalMap.get(empNumber) != null) {
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u751f\u6548\u7684\u4e3b\u5de5\u4f5c\u65e5\u5386\u3002", (String)"HRPIWorkCalendarRelInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                } else {
                    this.primarySet.add(empNumber);
                }
            }
            CommonServiceUtil.checkStartDate(msg, start);
            if (msg.length() != 0) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)msg.toString());
                msg.delete(0, msg.length());
            }
        });
        for (String number : empNumberSet) {
            if (mainWorkCalMap.get(number) != null || this.primarySet.contains(number)) continue;
            StringBuilder errorMsg = new StringBuilder();
            CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u751f\u6548\u4e2d\u7684\u4e3b\u5de5\u4f5c\u65e5\u5386\u3002", (String)"HRPIWorkCalendarRelInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            Long midId = (Long)empMidIdMap.get(number);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)errorMsg.toString());
        }
        InitValidateUtil.validateOtherGroupData((InitOutParam)this.getInitOutParam(), (Map)groupByEmpNumber, (Map)midAndEmpNumberMap);
        CommonServiceUtil.wrapSuccessPkIds(idMap, data, this.getInitOutParam());
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", null);
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType workCalType = EntityMetadataCache.getDataEntityType((String)"hrpi_workcalenrel");
        DynamicObjectCollection workCalCollection = new DynamicObjectCollection((DynamicObjectType)workCalType, null);
        data.stream().forEach(item -> {
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) {
                return;
            }
            String empNumber = item.getString("person.number");
            item.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            Date endDate = item.getDate("enddate");
            if (HRDateTimeUtils.getSysMaxDate().equals(endDate)) {
                item.set("businessstatus", (Object)"1");
            } else {
                item.set("businessstatus", (Object)"2");
            }
            item.set("bsed", item.get("startdate"));
            InitValidateUtil.wrapCommonFieldInit((DynamicObject)item);
            workCalCollection.add(item);
        });
        if (!CollectionUtils.isEmpty((Collection)workCalCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(workCalCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            boolean success = (Boolean)result.get("success");
            return success;
        }
        return true;
    }

    private Map<String, Boolean> existMainWorkCalMap(Set<Long> personIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_workcalenrel");
        QFilter personFilter = new QFilter("person", "in", personIdList);
        QFilter mainWorkFilter = new QFilter("ismainwork", "=", (Object)"1");
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjectCollection = serviceHelper.query("person", new QFilter[]{personFilter, mainWorkFilter, statusFilter, currentVersionFilter});
        if (dynamicObjectCollection == null || dynamicObjectCollection.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<String, Boolean> mainWorkCalMap = Arrays.asList(dynamicObjectCollection).stream().collect(Collectors.toMap(dy -> dy.getString("person.number"), dy -> Boolean.TRUE, (o1, o2) -> o2));
        return mainWorkCalMap;
    }
}

