/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.empsuprel;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpposRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIEmpSupRelInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOGGER = LogFactory.getLog(HRPIEmpSupRelInitServiceImpl.class);
    private static String EMP_NUMBER = "empnumber";
    private static String ADMIN_ORG = "adminorg";
    private static String A_POSITION_TYPE = "apositiontype";
    private static String POSITION = "position";
    private static String JOB = "job";
    private static String STD_POSITION = "stdposition";
    private static String PARENT_PREFIX = "parent_";
    private static String PARENT_EMP_NUMBER = "parent_empnumber";
    private static String PARENT_ADMIN_ORG = "parent_adminorg";
    private static String PARENT_A_POSITION_TYPE = "parent_apositiontype";
    private static String PARENT_POSITION = "parent_position";
    private static String PARENT_JOB = "parent_job";
    private static String PARENT_STD_POSITION = "parent_stdposition";
    private static String REPORT_TYPE = "reporttype";
    private static String START_DATE = "startdate";
    private static String END_DATE = "enddate";

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        LOGGER.info("HRPITrialPeriodInitServiceImpl#businessValidate start");
        List data = (List)dysMap.get("data");
        Map midIdMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        ArrayList empNumberList = Lists.newArrayListWithExpectedSize((int)(data.size() * 2));
        data.stream().forEach(dyn -> {
            empNumberList.add(dyn.getString(EMP_NUMBER));
            empNumberList.add(dyn.getString(PARENT_EMP_NUMBER));
        });
        DynamicObject[] empPosDynArr = HRPIEmpposRepository.batchQueryEmpPosByNumber(empNumberList);
        Map<String, List<DynamicObject>> keyVsEmpPosDynListMap = Arrays.stream(empPosDynArr).collect(Collectors.groupingBy(dyn -> this.getDepEmpCombineKey((DynamicObject)dyn)));
        Map<String, List<DynamicObject>> combineKeyVsInputDynListMap = data.stream().collect(Collectors.groupingBy(dyn -> this.getCombineKeyForAllMatchWithOutDate((DynamicObject)dyn)));
        Map<String, List<DynamicObject>> combineKeyVsInputDynListMapForCache = data.stream().collect(Collectors.groupingBy(dyn -> this.getCombineKeyForAllMatch((DynamicObject)dyn)));
        Map<String, List<DynamicObject>> combineKeyVsSupRelDynListMap = this.getCombineKeyVsSupRelDynListMap(data, keyVsEmpPosDynListMap);
        for (DynamicObject item : data) {
            StringBuilder msg = new StringBuilder();
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)midIdMap.get(id)).iterator().next();
            this.validateDate(msg, item);
            this.validateReportType(item, msg);
            if (!this.checkAPositionTypeMustInput(item, msg, "") || !this.checkAPositionTypeMustInput(item, msg, PARENT_PREFIX)) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
                continue;
            }
            boolean matchErrorFlag = this.matchDepEmpValidate(item, msg, keyVsEmpPosDynListMap);
            if (matchErrorFlag) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
                continue;
            }
            this.validateSameDepEmp(item, msg, keyVsEmpPosDynListMap);
            if (this.validateAllMatchType(msg, item, combineKeyVsInputDynListMapForCache)) {
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
                continue;
            }
            this.validateDateCrossForCache(msg, item, combineKeyVsInputDynListMap);
            this.validateDataCrossForDb(item, msg, keyVsEmpPosDynListMap, combineKeyVsSupRelDynListMap);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        }
    }

    private void validateDataCrossForDb(DynamicObject item, StringBuilder msg, Map<String, List<DynamicObject>> keyVsEmpPosDynListMap, Map<String, List<DynamicObject>> combineKeyVsSupRelDynListMap) {
        long reportTypeId = item.getLong("reporttype.id");
        Date startDate = item.getDate(START_DATE);
        Date endDate = item.getDate(END_DATE);
        DynamicObject curEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, "");
        DynamicObject parentEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, PARENT_PREFIX);
        if (Objects.nonNull(curEmpPosDyn) && Objects.nonNull(parentEmpPosDyn)) {
            long depEmpId = curEmpPosDyn.getLong("depemp.id");
            long superiorDepEmpId = parentEmpPosDyn.getLong("depemp.id");
            String depEmpIdReportTypeCombineKey = this.getDepEmpIdReportTypeCombineKey(depEmpId, reportTypeId, superiorDepEmpId);
            List<DynamicObject> supRelDynList = combineKeyVsSupRelDynListMap.get(depEmpIdReportTypeCombineKey);
            if (!CollectionUtils.isEmpty(supRelDynList)) {
                supRelDynList.stream().sorted(Comparator.comparing(dyn -> dyn.getDate(START_DATE)));
                for (DynamicObject supRelDyn : supRelDynList) {
                    boolean isOverlap;
                    Date startDateFromDB = supRelDyn.getDate(START_DATE);
                    Date endDateFromDB = supRelDyn.getDate(END_DATE);
                    if (Objects.isNull(endDateFromDB)) {
                        endDateFromDB = HisEffDateCommonService.getInstance().getDate2999(null);
                    }
                    if (!(isOverlap = this.isOverlap(startDateFromDB, endDateFromDB, startDate, endDate))) continue;
                    LOGGER.info("HRPIEmpSupRelInitServiceImpl.businessValidate.db date cross.");
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u7cfb\u7edf\u4e2d\u4e0e\u4e0a\u7ea7\u7684\u8be5\u79cd\u6c47\u62a5\u5173\u7cfb\u65f6\u95f4\u6709\u91cd\u53e0\u3002", (String)"HRPIEmpSupRelInitServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    private void validateDateCrossForCache(StringBuilder msg, DynamicObject item, Map<String, List<DynamicObject>> combineKeyVsInputDynListMap) {
        Date startDate = item.getDate(START_DATE);
        Date endDate = item.getDate(END_DATE);
        String allMatchCombineKeyForCacheCross = this.getCombineKeyForAllMatch(item);
        String curCombineKeyWithOutDate = this.getCombineKeyForAllMatchWithOutDate(item);
        List<DynamicObject> inputDynListFromCache = combineKeyVsInputDynListMap.get(curCombineKeyWithOutDate);
        inputDynListFromCache.stream().sorted(Comparator.comparing(dyn -> dyn.getDate(START_DATE)));
        for (DynamicObject inputDyn : inputDynListFromCache) {
            boolean isOverlap;
            String allMatchCombineKeyForInput = this.getCombineKeyForAllMatch(inputDyn);
            if (HRStringUtils.equals((String)allMatchCombineKeyForInput, (String)allMatchCombineKeyForCacheCross)) continue;
            Date startDateFromOther = inputDyn.getDate(START_DATE);
            Date endDateFromOther = inputDyn.getDate(END_DATE);
            if (Objects.isNull(endDateFromOther)) {
                endDateFromOther = HisEffDateCommonService.getInstance().getDate2999(null);
            }
            if (!(isOverlap = this.isOverlap(startDateFromOther, endDateFromOther, startDate, endDate))) continue;
            LOGGER.info("HRPIEmpSupRelInitServiceImpl.businessValidate.cache date cross.");
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0e\u4e0a\u7ea7\u7684\u8be5\u79cd\u6c47\u62a5\u5173\u7cfb\u65f6\u95f4\u6709\u91cd\u53e0\u3002", (String)"HRPIEmpSupRelInitServiceImpl_17", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            break;
        }
    }

    private boolean validateAllMatchType(StringBuilder msg, DynamicObject item, Map<String, List<DynamicObject>> combineKeyVsInputDynListMapForCache) {
        String allMatchCombineKeyForCacheCross = this.getCombineKeyForAllMatch(item);
        List<DynamicObject> sameKeyList = combineKeyVsInputDynListMapForCache.get(allMatchCombineKeyForCacheCross);
        if (!CollectionUtils.isEmpty(sameKeyList) && sameKeyList.size() > 1) {
            LOGGER.info("HRPIEmpSupRelInitServiceImpl.businessValidate.same data.");
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4eba\uff0c\u76f8\u540c\u6c47\u62a5\u7c7b\u578b\uff0c\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0\u3002", (String)"HRPIEmpSupRelInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void validateSameDepEmp(DynamicObject item, StringBuilder msg, Map<String, List<DynamicObject>> keyVsEmpPosDynListMap) {
        long parentEmployeeId;
        long depEmployeeId;
        DynamicObject curEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, "");
        DynamicObject parentEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, PARENT_PREFIX);
        if (Objects.nonNull(curEmpPosDyn) && Objects.nonNull(parentEmpPosDyn) && (depEmployeeId = curEmpPosDyn.getLong("employee.id")) == (parentEmployeeId = parentEmpPosDyn.getLong("employee.id"))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u80fd\u548c\u81ea\u5df1\u5f62\u6210\u6c47\u62a5\u5173\u7cfb\u3002", (String)"HRPIEmpSupRelInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private Map<String, List<DynamicObject>> getCombineKeyVsSupRelDynListMap(List<DynamicObject> data, Map<String, List<DynamicObject>> keyVsEmpPosDynListMap) {
        ArrayList depEmpIdList = Lists.newArrayListWithExpectedSize((int)data.size());
        data.stream().forEach(dyn -> {
            DynamicObject curEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, (DynamicObject)dyn, "");
            if (Objects.nonNull(curEmpPosDyn)) {
                depEmpIdList.add(curEmpPosDyn.getLong("depemp.id"));
            }
        });
        return this.getCombineKeyVsSupRelDynListMap(depEmpIdList);
    }

    private void validateReportType(DynamicObject item, StringBuilder msg) {
        String enable = item.getString("reporttype.enable");
        String status = item.getString("reporttype.status");
        if (!HRStringUtils.equals((String)enable, (String)"1") || !HRStringUtils.equals((String)status, (String)"C")) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u53ea\u80fd\u586b\u5199\u540c\u65f6\u6ee1\u8db3\u542f\u7528\u3001\u5df2\u5ba1\u6838\u3001\u6240\u5c5e\u7ec4\u7ec7\u56e2\u961f\u4e3a\u884c\u653f\u7ec4\u7ec7\u7684\u4eba\u5458\u6c47\u62a5\u7c7b\u578b\u3002", (String)"HRPIEmpSupRelInitServiceImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection orgTeamTypeDynCol = item.getDynamicObjectCollection("reporttype.orgteamtype");
        if (!CollectionUtils.isEmpty((Collection)orgTeamTypeDynCol)) {
            Boolean adminOrgTypeFlag = false;
            for (DynamicObject orgTeamTypeDyn : orgTeamTypeDynCol) {
                Long orgTeamType = orgTeamTypeDyn.getLong("fbasedataid.id");
                if (1010L != orgTeamType) continue;
                adminOrgTypeFlag = true;
                break;
            }
            if (!adminOrgTypeFlag.booleanValue()) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u53ea\u80fd\u586b\u5199\u540c\u65f6\u6ee1\u8db3\u542f\u7528\u3001\u5df2\u5ba1\u6838\u3001\u6240\u5c5e\u7ec4\u7ec7\u56e2\u961f\u4e3a\u884c\u653f\u7ec4\u7ec7\u7684\u4eba\u5458\u6c47\u62a5\u7c7b\u578b\u3002", (String)"HRPIEmpSupRelInitServiceImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateDate(StringBuilder msg, DynamicObject item) {
        Date endDate;
        Date startDate = item.getDate(START_DATE);
        if (HRDateTimeUtils.dayAfter((Date)startDate, (Date)(endDate = item.getDate(END_DATE)))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"HRPIEmpSupRelInitServiceImpl_15", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (!HRDateTimeUtils.isBeforeOrEqualNow((Date)startDate)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPIEmpSupRelInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (HRDateTimeUtils.isAfterNow((Date)endDate) && 0 != HisEffDateCommonService.getInstance().getDate2999(null).compareTo(endDate)) {
            Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
            String dataAfterFormat = this.formatData(date2999);
            CommonServiceUtil.addErrorMsg(msg, String.format(ResManager.loadKDString((String)"\u672a\u6765\u65e5\u671f\u8bf7\u586b\u5199\u4e3a\u201c%s\u201d\u3002", (String)"HRPIEmpSupRelInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]), dataAfterFormat));
        }
    }

    private String formatData(Date data) {
        String dateFormat = InteServiceHelper.getDateFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String dataAfterFormat = sdf.format(data);
        return dataAfterFormat;
    }

    private boolean matchDepEmpValidate(DynamicObject item, StringBuilder msg, Map<String, List<DynamicObject>> keyVsEmpPosDynListMap) {
        boolean matchErrorFlag = false;
        List<DynamicObject> curEmpPosDynList = this.getMatchEmpPosDyn(keyVsEmpPosDynListMap, item, "");
        LOGGER.info("HRPIEmpSupRelInitServiceImpl.businessValidate.curEmpPosDynList.size={}", (Object)curEmpPosDynList.size());
        if (curEmpPosDynList.size() == 0) {
            CommonServiceUtil.addErrorMsg(msg, this.getDontFindDepEmpErrorMsg(item, "", true));
            matchErrorFlag = true;
        } else if (curEmpPosDynList.size() > 1) {
            CommonServiceUtil.addErrorMsg(msg, this.getDontFindDepEmpErrorMsg(item, "", false));
            matchErrorFlag = true;
        }
        List<DynamicObject> parentEmpPosDynList = this.getMatchEmpPosDyn(keyVsEmpPosDynListMap, item, PARENT_PREFIX);
        LOGGER.info("HRPIEmpSupRelInitServiceImpl.businessValidate.parentEmpPosDynList.size={}", (Object)parentEmpPosDynList.size());
        if (parentEmpPosDynList.size() == 0) {
            CommonServiceUtil.addErrorMsg(msg, this.getDontFindDepEmpErrorMsg(item, PARENT_PREFIX, true));
            matchErrorFlag = true;
        } else if (parentEmpPosDynList.size() > 1) {
            CommonServiceUtil.addErrorMsg(msg, this.getDontFindDepEmpErrorMsg(item, PARENT_PREFIX, false));
            matchErrorFlag = true;
        }
        return matchErrorFlag;
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", null);
    }

    private boolean checkAPositionTypeMustInput(DynamicObject item, StringBuilder msg, String prefix) {
        DataEntityPropertyCollection properties = item.getDynamicObjectType().getProperties();
        String aPositionTypeFieldName = prefix + A_POSITION_TYPE;
        String aPositionTypeName = ((IDataEntityProperty)properties.get((Object)aPositionTypeFieldName)).getDisplayName().getLocaleValue();
        String aPositionType = item.getString(aPositionTypeFieldName);
        if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
            String stdPositionFieldName = prefix + STD_POSITION;
            DynamicObject stdPosition = item.getDynamicObject(stdPositionFieldName);
            String stdPositionName = ((IDataEntityProperty)properties.get((Object)stdPositionFieldName)).getDisplayName().getLocaleValue();
            if (Objects.isNull(stdPosition)) {
                CommonServiceUtil.addErrorMsg(msg, String.format(ResManager.loadKDString((String)"%1$s\u4e3a\u6807\u51c6\u5c97\u4f4d\u65f6\uff0c%2$s\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HRPIEmpSupRelInitServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]), aPositionTypeName, stdPositionName));
                return false;
            }
        } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
            String positionFieldName = prefix + POSITION;
            String positionName = ((IDataEntityProperty)properties.get((Object)positionFieldName)).getDisplayName().getLocaleValue();
            DynamicObject position = item.getDynamicObject(positionFieldName);
            if (Objects.isNull(position)) {
                CommonServiceUtil.addErrorMsg(msg, String.format(ResManager.loadKDString((String)"%1$s\u4e3a\u5c97\u4f4d\u65f6\uff0c%2$s\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HRPIEmpSupRelInitServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]), aPositionTypeName, positionName));
                return false;
            }
        } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
            String jobFieldName = prefix + JOB;
            String jobName = ((IDataEntityProperty)properties.get((Object)jobFieldName)).getDisplayName().getLocaleValue();
            DynamicObject job = item.getDynamicObject(jobFieldName);
            if (Objects.isNull(job)) {
                CommonServiceUtil.addErrorMsg(msg, String.format(ResManager.loadKDString((String)"%1$s\u4e3a\u804c\u4f4d\u65f6\uff0c%2$s\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HRPIEmpSupRelInitServiceImpl_13", (String)"hrmp-hrpi-business", (Object[])new Object[0]), aPositionTypeName, jobName));
                return false;
            }
        }
        return true;
    }

    private String getDepEmpIdReportTypeCombineKey(Long depEmpId, Long reportTypeId, Long superiorDepEmpId) {
        StringBuilder sb = new StringBuilder();
        sb.append(depEmpId);
        sb.append("_");
        sb.append(reportTypeId);
        sb.append("_");
        sb.append(superiorDepEmpId);
        return sb.toString();
    }

    private Map<String, List<DynamicObject>> getCombineKeyVsSupRelDynListMap(List<Long> depEmpIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empsuprel");
        QFilter depEmpIdFilter = new QFilter("depemp", "in", depEmpIdList);
        depEmpIdFilter.and(QFilterUtil.getCurrentQf());
        depEmpIdFilter.and(QFilterUtil.getDataStatusFilter());
        depEmpIdFilter.and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] empSupRelDynArr = helper.query("id, depemp, reporttype, startdate, enddate, superiordepemp", new QFilter[]{depEmpIdFilter});
        return Arrays.stream(empSupRelDynArr).collect(Collectors.groupingBy(dyn -> this.getDepEmpIdReportTypeCombineKey(dyn.getLong("depemp.id"), dyn.getLong("reporttype.id"), dyn.getLong("superiordepemp.id"))));
    }

    private DynamicObject getEmpPosDyn(Map<String, List<DynamicObject>> keyVsEmpPosDynListMap, DynamicObject item, String prefix) {
        String curCombineKey = this.getCombineKey(item, prefix);
        List<DynamicObject> curEmpPosDynList = keyVsEmpPosDynListMap.get(curCombineKey);
        if (CollectionUtils.isEmpty(curEmpPosDynList)) {
            return null;
        }
        for (DynamicObject curEmpPosDyn : curEmpPosDynList) {
            Date startDateFromImport = item.getDate(START_DATE);
            Date startDate = curEmpPosDyn.getDate(START_DATE);
            Date endDate = curEmpPosDyn.getDate(END_DATE);
            if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate) || HRDateTimeUtils.dayAfter((Date)startDateFromImport, (Date)endDate) || HRDateTimeUtils.dayBefore((Date)startDateFromImport, (Date)startDate)) continue;
            return curEmpPosDyn;
        }
        return null;
    }

    private List<DynamicObject> getMatchEmpPosDyn(Map<String, List<DynamicObject>> keyVsEmpPosDynListMap, DynamicObject item, String prefix) {
        Date startDateFromImport = item.getDate(START_DATE);
        String curCombineKey = this.getCombineKey(item, prefix);
        List<DynamicObject> empPosDynList = keyVsEmpPosDynListMap.get(curCombineKey);
        if (CollectionUtils.isEmpty(empPosDynList)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList resultDynList = Lists.newArrayListWithExpectedSize((int)empPosDynList.size());
        for (DynamicObject empPosDyn : empPosDynList) {
            Date startDate = empPosDyn.getDate(START_DATE);
            Date endDate = empPosDyn.getDate(END_DATE);
            if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate) || HRDateTimeUtils.dayAfter((Date)startDateFromImport, (Date)endDate) || HRDateTimeUtils.dayBefore((Date)startDateFromImport, (Date)startDate)) continue;
            resultDynList.add(empPosDyn);
        }
        return resultDynList;
    }

    private boolean sameReportTypeIsDataCross(Long depEmpId, Long reportTypeId, Date startDate, Date endDate, List<DynamicObject> allEmpSupRelDynList) {
        String curCombineKey;
        Map<String, List<DynamicObject>> combineKeyVsEmpRelDynListMap = allEmpSupRelDynList.stream().collect(Collectors.groupingBy(dyn -> "" + dyn.getLong("depemp.id") + dyn.getLong("reporttype.id")));
        List<DynamicObject> empRelDynList = combineKeyVsEmpRelDynListMap.get(curCombineKey = "" + depEmpId + reportTypeId);
        if (CollectionUtils.isEmpty(empRelDynList)) {
            LOGGER.info("sameReportTypeIsDataCross.empRelDynList is null. depEmpId={}", (Object)depEmpId);
            return false;
        }
        empRelDynList.stream().sorted(Comparator.comparing(dyn -> dyn.getDate(START_DATE)));
        for (DynamicObject empRelDyn : empRelDynList) {
            Date startDateFromDB = empRelDyn.getDate(START_DATE);
            Date endDateFromDB = empRelDyn.getDate(END_DATE);
            boolean isOverLap = this.isOverlap(endDateFromDB, startDateFromDB, startDate, endDate);
            if (!isOverLap) continue;
            return true;
        }
        return false;
    }

    private boolean isOverlap(Date startDateFromDB, Date endDateFromDB, Date startDate, Date endDate) {
        return !HRDateTimeUtils.dayBefore((Date)endDateFromDB, (Date)startDate) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDateFromDB);
    }

    private String getDepEmpCombineKey(DynamicObject dyn) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString("person.number");
            Long adminOrg = dyn.getLong(ADMIN_ORG + ".id");
            String aPositionType = dyn.getString(A_POSITION_TYPE);
            sb.append(number).append("_").append(adminOrg).append("_").append(aPositionType).append("_");
            if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
                Long stdPositionId = dyn.getLong(STD_POSITION + ".id");
                sb.append(stdPositionId);
            } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
                Long positionId = dyn.getLong(POSITION + ".id");
                sb.append(positionId);
            } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
                Long jobId = dyn.getLong(JOB + ".id");
                sb.append(jobId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private String getCombineKey(DynamicObject dyn, String prefix) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString(prefix + EMP_NUMBER);
            Long adminOrg = dyn.getLong(prefix + ADMIN_ORG + ".id");
            String aPositionType = dyn.getString(prefix + A_POSITION_TYPE);
            sb.append(number).append("_").append(adminOrg).append("_").append(aPositionType).append("_");
            if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
                Long stdPositionId = dyn.getLong(prefix + STD_POSITION + ".id");
                sb.append(stdPositionId);
            } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
                Long positionId = dyn.getLong(prefix + POSITION + ".id");
                sb.append(positionId);
            } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
                Long jobId = dyn.getLong(prefix + JOB + ".id");
                sb.append(jobId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private String getCombineKeyForAllMatchWithOutDate(DynamicObject dyn) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString(EMP_NUMBER);
            Long adminOrg = dyn.getLong(ADMIN_ORG + ".id");
            String aPositionType = dyn.getString(A_POSITION_TYPE);
            sb.append(number).append("_").append(adminOrg).append("_").append(aPositionType).append("_");
            if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
                Long stdPositionId = dyn.getLong(STD_POSITION + ".id");
                sb.append(stdPositionId);
            } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
                Long positionId = dyn.getLong(POSITION + ".id");
                sb.append(positionId);
            } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
                Long jobId = dyn.getLong(JOB + ".id");
                sb.append(jobId);
            }
            sb.append("_");
            Long reportTypeId = dyn.getLong("reporttype.id");
            sb.append(reportTypeId);
            sb.append("_");
            sb.append(this.getParentCombineKey(dyn));
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private String getCombineKeyForAllMatch(DynamicObject dyn) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString(EMP_NUMBER);
            Long adminOrg = dyn.getLong(ADMIN_ORG + ".id");
            String aPositionType = dyn.getString(A_POSITION_TYPE);
            sb.append(number).append("_").append(adminOrg).append("_").append(aPositionType).append("_");
            if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
                Long stdPositionId = dyn.getLong(STD_POSITION + ".id");
                sb.append(stdPositionId);
            } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
                Long positionId = dyn.getLong(POSITION + ".id");
                sb.append(positionId);
            } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
                Long jobId = dyn.getLong(JOB + ".id");
                sb.append(jobId);
            }
            sb.append("_");
            Long reportTypeId = dyn.getLong("reporttype.id");
            sb.append(reportTypeId);
            sb.append("_");
            Date startDate = dyn.getDate(START_DATE);
            String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            sb.append(startDateStr);
            Date endDate = dyn.getDate(END_DATE);
            if (Objects.nonNull(endDate)) {
                sb.append("_");
                String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                sb.append(endDateStr);
            }
            sb.append("_");
            sb.append(this.getParentCombineKey(dyn));
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private String getParentCombineKey(DynamicObject dyn) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString(PARENT_EMP_NUMBER);
            Long adminOrg = dyn.getLong(PARENT_ADMIN_ORG + ".id");
            String aPositionType = dyn.getString(PARENT_A_POSITION_TYPE);
            sb.append(number).append("_").append(adminOrg).append("_").append(aPositionType).append("_");
            if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
                Long stdPositionId = dyn.getLong(PARENT_STD_POSITION + ".id");
                sb.append(stdPositionId);
            } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
                Long positionId = dyn.getLong(PARENT_POSITION + ".id");
                sb.append(positionId);
            } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
                Long jobId = dyn.getLong(PARENT_JOB + ".id");
                sb.append(jobId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private String getDontFindDepEmpErrorMsg(DynamicObject item, String prefix, boolean notFindFlag) {
        String number = item.getString(prefix + EMP_NUMBER);
        String adminOrgName = item.getString(prefix + ADMIN_ORG + ".name");
        String aPositionType = item.getString(prefix + A_POSITION_TYPE);
        String aPositionTypeName = "";
        String positionName = "";
        if (HRStringUtils.equals((String)"0", (String)aPositionType)) {
            aPositionTypeName = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"HRPIEmpSupRelInitServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            positionName = item.getString(prefix + STD_POSITION + ".name");
        } else if (HRStringUtils.equals((String)"1", (String)aPositionType)) {
            aPositionTypeName = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"HRPIEmpSupRelInitServiceImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            positionName = item.getString(prefix + POSITION + ".name");
        } else if (HRStringUtils.equals((String)"2", (String)aPositionType)) {
            aPositionTypeName = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"HRPIEmpSupRelInitServiceImpl_11", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            positionName = item.getString(prefix + JOB + ".name");
        }
        String errorMsg = "";
        Date startTime = item.getDate(START_DATE);
        String startTimeStr = HRDateTimeUtils.format((Date)startTime, (String)"yyyy-MM-dd");
        errorMsg = notFindFlag ? String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u4e0b\uff0c\u4efb\u5c97\u6a21\u5f0f\u4e3a%3$s-%4$s\u627e\u4e0d\u5230%5$s\u7684\u4efb\u804c\u7ecf\u5386\u4fe1\u606f\u3002", (String)"HRPIEmpSupRelInitServiceImpl_12", (String)"hrmp-hrpi-business", (Object[])new Object[0]), number, adminOrgName, aPositionTypeName, positionName, startTimeStr) : String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u4e0b\uff0c\u4efb\u5c97\u6a21\u5f0f\u4e3a%3$s-%4$s\u627e\u5230\u591a\u6761%5$s\u7684\u4efb\u804c\u7ecf\u5386\u4fe1\u606f\u3002", (String)"HRPIEmpSupRelInitServiceImpl_14", (String)"hrmp-hrpi-business", (Object[])new Object[0]), number, adminOrgName, aPositionTypeName, positionName, startTimeStr);
        return errorMsg;
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        LOGGER.info("HRPITrialPeriodInitServiceImpl#businessSave start");
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        MainEntityType empSupRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empsuprel");
        DynamicObjectCollection empSupRelCollection = new DynamicObjectCollection((DynamicObjectType)empSupRelType, null);
        Map outMessageMap = this.getInitOutParam().getData();
        String[] needImpPros = this.getImportFields((DynamicObjectType)empSupRelType);
        ArrayList empNumberList = Lists.newArrayListWithExpectedSize((int)(data.size() * 2));
        data.stream().forEach(dyn -> {
            empNumberList.add(dyn.getString(EMP_NUMBER));
            empNumberList.add(dyn.getString(PARENT_EMP_NUMBER));
        });
        DynamicObject[] empPosDynArr = HRPIEmpposRepository.batchQueryEmpPosByNumber(empNumberList);
        Map<String, List<DynamicObject>> keyVsEmpPosDynListMap = Arrays.stream(empPosDynArr).collect(Collectors.groupingBy(dyn -> this.getDepEmpCombineKey((DynamicObject)dyn)));
        ArrayList depEmpIdList = Lists.newArrayListWithExpectedSize((int)data.size());
        data.stream().forEach(dyn -> {
            DynamicObject curEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, (DynamicObject)dyn, "");
            if (Objects.nonNull(curEmpPosDyn)) {
                depEmpIdList.add(curEmpPosDyn.getLong("depemp.id"));
            }
        });
        DynamicObject[] personRoleDynArr = HRPIPersonRolerelRepository.getPersonRoleRelByDepEmp("id, depemp, role", depEmpIdList);
        Map<Long, Long> depEmpIdVsWorkRoleIdMap = Arrays.stream(personRoleDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("depemp.id"), dyn -> dyn.getLong("role.id"), (o1, o2) -> o1));
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            DynamicObject curEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, "");
            if (Objects.isNull(curEmpPosDyn)) {
                LOGGER.error("businessSave.curEmpPosDyn is null!");
                continue;
            }
            DynamicObject parentEmpPosDyn = this.getEmpPosDyn(keyVsEmpPosDynListMap, item, PARENT_PREFIX);
            if (Objects.isNull(parentEmpPosDyn)) {
                LOGGER.error("businessSave.parentEmpPosDyn is null!");
                continue;
            }
            DynamicObject newRewardDy = CommonServiceUtil.buildDy((DynamicObjectType)empSupRelType, item, needImpPros);
            newRewardDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            newRewardDy.set("bsed", (Object)item.getDate("startdate"));
            newRewardDy.set("startdate", (Object)item.getDate("startdate"));
            Date endDate = item.getDate("enddate");
            newRewardDy.set("enddate", (Object)endDate);
            newRewardDy.set("person", (Object)curEmpPosDyn.getDynamicObject("person"));
            newRewardDy.set("depemp", (Object)curEmpPosDyn.getDynamicObject("depemp"));
            newRewardDy.set("employee", (Object)curEmpPosDyn.getDynamicObject("employee"));
            newRewardDy.set("superior", (Object)parentEmpPosDyn.getDynamicObject("person"));
            newRewardDy.set("superiordepemp", (Object)parentEmpPosDyn.getDynamicObject("depemp"));
            newRewardDy.set("superioremployee", (Object)parentEmpPosDyn.getDynamicObject("employee"));
            newRewardDy.set("superioradminorg", (Object)parentEmpPosDyn.getLong("adminorg.id"));
            newRewardDy.set("superiorrole", (Object)depEmpIdVsWorkRoleIdMap.get(curEmpPosDyn.getLong("depemp.id")));
            newRewardDy.set("reporttype", (Object)item.getDynamicObject("reporttype"));
            if (0 == HisEffDateCommonService.getInstance().getDate2999(null).compareTo(endDate)) {
                newRewardDy.set("businessstatus", (Object)"1");
                newRewardDy.set("sysenddate", (Object)endDate);
            } else {
                newRewardDy.set("businessstatus", (Object)"2");
                newRewardDy.set("sysenddate", (Object)HRDateTimeUtils.addDay((Date)endDate, (long)0L));
            }
            empSupRelCollection.add((Object)newRewardDy);
        }
        if (!CollectionUtils.isEmpty((Collection)empSupRelCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(empSupRelCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }
}

