/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.jobrel;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIJobRepository;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public abstract class HRPICommonJobrelInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOGGER = LogFactory.getLog(HRPICommonJobrelInitServiceImpl.class);
    private static final String JOB_LEVEL = "joblevel";
    private static final String JOB_GRADE = "jobgrade";
    private static final String JOB_LEVEL_SCM_ID = "joblevelscm_id";
    private static final String JOB_GRADE_SCM_ID = "jobgradescm_id";
    private static final String JOB_LEVEL_SCM = "joblevelscm";
    private static final String JOB_GRADE_SCM = "jobgradescm";

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        Set<Long> jobrelSet = CommonServiceUtil.existsEmpIdByData(data, "hrpi_empjobrel");
        Map<String, List<DynamicObject>> sortGroup = CommonServiceUtil.getGroupSortMap("employee.id", data);
        Map<String, Boolean> continuity = CommonServiceUtil.checkTimeNonOverlap(sortGroup);
        Map<String, Boolean> endDateMap = CommonServiceUtil.checkEndDate(sortGroup, this.isQuit());
        data.stream().forEach(dy -> {
            StringBuilder msg = new StringBuilder();
            Long id = (Long)dy.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            this.checkIsEmployee(msg, (DynamicObject)dy);
            this.checkJobInfo(msg, jobrelSet, (DynamicObject)dy);
            CommonServiceUtil.checkTime(msg, continuity, dy.getString("employee.id"));
            CommonServiceUtil.checkStartDate(msg, dy.getDate("startdate"));
            this.checkOtherThing((DynamicObject)dy, msg);
            this.cusBusinessValidate((DynamicObject)dy, endDateMap, msg);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        });
        CommonServiceUtil.checkGroup(data, sortGroup, this.getInitOutParam(), idMap, "employee.id");
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", this.isQuit());
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType jobType = EntityMetadataCache.getDataEntityType((String)"hrpi_empjobrel");
        String[] needImpPros = this.getImportFields((DynamicObjectType)jobType);
        DynamicObjectCollection jobCollection = new DynamicObjectCollection((DynamicObjectType)jobType, null);
        Map<String, List<DynamicObject>> sortGroup = CommonServiceUtil.getSortGroup("employee.id", data);
        Map aliasMapping = (Map)map.get("aliasMapping");
        String jobLevelProp = "name";
        String jobGradeProp = "name";
        for (Map.Entry alias : aliasMapping.entrySet()) {
            String[] splitLevel;
            String aliasKey = (String)alias.getKey();
            String aliasValue = (String)alias.getValue();
            if (JOB_LEVEL.equals(aliasValue)) {
                splitLevel = aliasKey.split("\\.");
                jobLevelProp = splitLevel[splitLevel.length - 1];
            }
            if (!JOB_GRADE.equals(aliasValue)) continue;
            splitLevel = aliasKey.split("\\.");
            jobGradeProp = splitLevel[splitLevel.length - 1];
        }
        String finalJobLevelProp = jobLevelProp;
        String finalJobGradeProp = jobGradeProp;
        HashSet jobLevelScmSet = Sets.newHashSetWithExpectedSize((int)data.size());
        HashSet jobGradeScmSet = Sets.newHashSetWithExpectedSize((int)data.size());
        this.buildAllJobLevelAndGradeId(data, jobLevelScmSet, jobGradeScmSet);
        Map<String, DynamicObject> jobLevelMap = this.queryJobLevelAndGroup(jobLevelScmSet, finalJobLevelProp);
        Map<String, DynamicObject> jobGradeMap = this.queryJobGradeAndGroup(jobGradeScmSet, finalJobGradeProp);
        data.forEach(arg_0 -> this.lambda$businessSave$1(outMessageMap, idmapping, (DynamicObjectType)jobType, needImpPros, sortGroup, jobLevelMap, finalJobLevelProp, jobGradeMap, finalJobGradeProp, jobCollection, arg_0));
        if (!CollectionUtils.isEmpty((Collection)jobCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(jobCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private void buildAllJobLevelAndGradeId(List<DynamicObject> data, Set<Long> jobLevelScmSet, Set<Long> jobGradeScmSet) {
        data.forEach(item -> {
            DynamicObject jobLevelScm = item.getDynamicObject(JOB_LEVEL_SCM);
            DynamicObject jobGradeScm = item.getDynamicObject(JOB_GRADE_SCM);
            if (Objects.nonNull(jobLevelScm)) {
                jobLevelScmSet.add((Long)jobLevelScm.get("id"));
            }
            if (Objects.nonNull(jobGradeScm)) {
                jobGradeScmSet.add((Long)jobGradeScm.get("id"));
            }
        });
    }

    private Map<String, DynamicObject> queryJobLevelAndGroup(Set<Long> jobLevelScmSet, String groupByField) {
        if (CollectionUtils.isEmpty(jobLevelScmSet)) {
            return new HashMap<String, DynamicObject>();
        }
        DynamicObject[] jobLevels = HRPIJobRepository.queryEnableJobLevelByScm(jobLevelScmSet);
        Map<String, DynamicObject> jobLevelMap = Arrays.stream(jobLevels).collect(Collectors.toMap(dy -> {
            String jobLevel = dy.getString(groupByField);
            Long jobLevelScm = (Long)dy.get(JOB_LEVEL_SCM_ID);
            return String.join((CharSequence)"_", String.valueOf(jobLevelScm), jobLevel);
        }, dy -> dy, (dy1, dy2) -> dy1));
        return jobLevelMap;
    }

    private Map<String, DynamicObject> queryJobGradeAndGroup(Set<Long> jobGradeScmSet, String groupByField) {
        if (CollectionUtils.isEmpty(jobGradeScmSet)) {
            return new HashMap<String, DynamicObject>();
        }
        DynamicObject[] jobGrades = HRPIJobRepository.queryEnableJobGradeByScm(jobGradeScmSet);
        Map<String, DynamicObject> jobGradeMap = Arrays.stream(jobGrades).collect(Collectors.toMap(dy -> {
            String jobGrade = dy.getString(groupByField);
            Long jobGradeScm = (Long)dy.get(JOB_GRADE_SCM_ID);
            return String.join((CharSequence)"_", String.valueOf(jobGradeScm), jobGrade);
        }, dy -> dy, (dy1, dy2) -> dy1));
        return jobGradeMap;
    }

    private void setJobLevel(DynamicObject newJobDy, Map<String, DynamicObject> jobLevelMap, String jobLevelProp) {
        DynamicObject jobLevel = newJobDy.getDynamicObject(JOB_LEVEL);
        Long scmId = (Long)newJobDy.get(JOB_LEVEL_SCM_ID);
        if (Objects.nonNull(jobLevel) && Objects.nonNull(scmId)) {
            String jobLevelValue = jobLevel.getString(jobLevelProp);
            newJobDy.set(JOB_LEVEL, (Object)jobLevelMap.get(String.join((CharSequence)"_", String.valueOf(scmId), jobLevelValue)));
        }
    }

    private void setJobGrade(DynamicObject newJobDy, Map<String, DynamicObject> jobGradeMap, String jobGradeProp) {
        DynamicObject jobGrade = newJobDy.getDynamicObject(JOB_GRADE);
        Long scmId = (Long)newJobDy.get(JOB_GRADE_SCM_ID);
        if (Objects.nonNull(jobGrade) && Objects.nonNull(scmId)) {
            String jobLevelValue = jobGrade.getString(jobGradeProp);
            newJobDy.set(JOB_GRADE, (Object)jobGradeMap.get(String.join((CharSequence)"_", String.valueOf(scmId), jobLevelValue)));
        }
    }

    public void setCommonFilet(DynamicObject newJobDy) {
        newJobDy.set("bsed", newJobDy.get("startdate"));
    }

    private void checkIsEmployee(StringBuilder msg, DynamicObject dynamicObject) {
        DynamicObject empDy = dynamicObject.getDynamicObject("employee");
        CommonServiceUtil.checkIsEmployee(msg, empDy);
        CommonServiceUtil.checkEndDate(msg, dynamicObject);
        if (Objects.isNull(empDy)) {
            return;
        }
        Date empDate = empDy.getDate("startdate");
        Date jobStartDate = dynamicObject.getDate("startdate");
        if (jobStartDate.compareTo(empDate) < 0) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPICommonJobrelInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void checkJobInfo(StringBuilder msg, Set<Long> jobrelSet, DynamicObject dynamicObject) {
        if (jobrelSet.contains(dynamicObject.getLong("employee.id"))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u8be5\u4eba\u5458\u7684\u804c\u7ea7\u804c\u7b49\u4fe1\u606f\u3002", (String)"HRPICommonJobrelInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        DynamicObject jobLevel = dynamicObject.getDynamicObject(JOB_LEVEL);
        DynamicObject jobGrade = dynamicObject.getDynamicObject(JOB_GRADE);
        DynamicObject joblevelscm = dynamicObject.getDynamicObject(JOB_LEVEL_SCM);
        DynamicObject jobgradescm = dynamicObject.getDynamicObject(JOB_GRADE_SCM);
        if (jobLevel == null && jobGrade == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u804c\u7ea7\u548c\u804c\u7b49\u81f3\u5c11\u586b\u4e00\u4e2a\u3002", (String)"HRPICommonJobrelInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (jobLevel != null && joblevelscm == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u804c\u7ea7\u5bf9\u5e94\u7684\u804c\u7ea7\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPICommonJobrelInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (jobGrade != null && jobgradescm == null) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u804c\u7b49\u5bf9\u5e94\u7684\u804c\u7b49\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPICommonJobrelInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void checkOtherThing(DynamicObject item, StringBuilder msg) {
        Date startdate = item.getDate("startdate");
        Date enddate = item.getDate("enddate");
        if (enddate.compareTo(startdate) < 0) {
            this.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPIQuitJobrelInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public abstract boolean isQuit();

    public abstract void cusDynamicObject(DynamicObject var1, Map<String, List<DynamicObject>> var2);

    public abstract void cusBusinessValidate(DynamicObject var1, Map<String, Boolean> var2, StringBuilder var3);

    private /* synthetic */ void lambda$businessSave$1(Map outMessageMap, Map idmapping, DynamicObjectType jobType, String[] needImpPros, Map sortGroup, Map jobLevelMap, String finalJobLevelProp, Map jobGradeMap, String finalJobGradeProp, DynamicObjectCollection jobCollection, DynamicObject tempDy) {
        if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)tempDy)) {
            return;
        }
        DynamicObject newJobDy = CommonServiceUtil.buildDy(jobType, tempDy, needImpPros);
        newJobDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.setCommonFilet(newJobDy);
        CommonServiceUtil.setEmpAndNewPerson(newJobDy, tempDy);
        this.cusDynamicObject(newJobDy, sortGroup);
        newJobDy.set("variationtype", (Object)HRPIValueConstants.ACTION_TYPE_INIT);
        try {
            this.setJobLevel(newJobDy, jobLevelMap, finalJobLevelProp);
            this.setJobGrade(newJobDy, jobGradeMap, finalJobGradeProp);
        }
        catch (Exception exception) {
            LOGGER.error("setjobLevelOrjobGrade is exception:", (Throwable)exception);
        }
        jobCollection.add((Object)newJobDy);
    }
}

