/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.percre;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public abstract class HRPICommonPercreServiceImpl
extends HRPICommonInitService {
    private static final String IS_MAJOR = "ismajor";
    private static final Long LABORREL_ING_ID = 1010L;
    private static final Long LABORREL_END_ID = 1020L;
    private static final Long RESIDENT_ID_CARD_ID = 1010L;

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        ArrayList<Long> personIds = new ArrayList<Long>(data.size());
        ArrayList<String> numberList = new ArrayList<String>(data.size());
        data.forEach(dy -> {
            personIds.add(dy.getLong("person.id"));
            numberList.add(dy.getString("number"));
        });
        boolean isQuit = this.isQuit();
        List<Long> personIdList = this.getPersonIds(isQuit, personIds);
        Tuple<Map<String, List<Long>>, List<Long>> tuple = this.getPercreMap(numberList);
        Map percreMap = (Map)tuple.item1;
        List percrePerson = (List)tuple.item2;
        Map<String, DynamicObject> majorPercre = this.getMajorPercre(personIds);
        Map<String, List<DynamicObject>> groupMap = CommonServiceUtil.getGroup("person.number", data);
        data.forEach(dy -> {
            Long id = (Long)dy.get("id");
            Long midId = (Long)((HashSet)idMap.get(id)).iterator().next();
            StringBuilder msg = new StringBuilder();
            if (dy.getLong("person.id") == 0L) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u5b58\u5728", (String)"HRPICommonPercreServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
                return;
            }
            this.checkIsHavePercre(percreMap, (DynamicObject)dy, msg, percrePerson);
            this.cusBusinessValidate((DynamicObject)dy, personIdList, msg);
            this.checkGroup((DynamicObject)dy, groupMap, majorPercre, msg);
            this.checkOtherThing((DynamicObject)dy, msg);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        });
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initNewPerson(data, "person.number", this.isQuit() ? LABORREL_END_ID : LABORREL_ING_ID);
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType percreType = EntityMetadataCache.getDataEntityType((String)"hrpi_percre");
        String[] needImpPros = this.getImportFields((DynamicObjectType)percreType);
        DynamicObjectCollection percreCollection = new DynamicObjectCollection((DynamicObjectType)percreType, null);
        Map<String, String> percreTepyMap = this.getPercreTepyMap();
        data.forEach(arg_0 -> this.lambda$businessSave$2(outMessageMap, idmapping, (DynamicObjectType)percreType, needImpPros, percreTepyMap, percreCollection, arg_0));
        if (!CollectionUtils.isEmpty((Collection)percreCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(percreCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    public abstract boolean isQuit();

    public abstract void cusDynamicObject(DynamicObject var1, StringBuilder var2);

    public abstract void cusBusinessValidate(DynamicObject var1, List<Long> var2, StringBuilder var3);

    public List<Long> getLaborrelStatus(Long laborRelId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborrelstatus");
        QFilter qFilter = new QFilter("labrelstatusprd.id", "=", (Object)laborRelId);
        Object[] dynamicObjects = serviceHelper.query("number,name", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getPersonIds(boolean isQuit, List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_employee");
        Long laborRelId = isQuit ? LABORREL_END_ID : LABORREL_ING_ID;
        List<Long> statusLongs = this.getLaborrelStatus(laborRelId);
        if (CollectionUtils.isEmpty(statusLongs)) {
            return new ArrayList<Long>(0);
        }
        QFilter qFilter = new QFilter("laborrelstatus", "in", statusLongs);
        QFilter personFilter = new QFilter("person.id", "in", personIds);
        Object[] dynamicObjects = serviceHelper.query("person.id,person.number", new QFilter[]{qFilter, personFilter, QFilterUtil.getCurrentQf()});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("person.id")).collect(Collectors.toList());
    }

    public Tuple<Map<String, List<Long>>, List<Long>> getPercreMap(List<String> percreNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_percre");
        QFilter qFilter = new QFilter("number", "in", percreNumbers);
        Object[] dynamicObjects = serviceHelper.query("credentialstype.number,person.id,person.number,number", new QFilter[]{qFilter, QFilterUtil.getCurrentQf()});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new Tuple((Object)Maps.newHashMapWithExpectedSize((int)0), new ArrayList(0));
        }
        ArrayList<Long> personIds = new ArrayList<Long>(dynamicObjects.length);
        HashMap map = new HashMap(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            this.setPercreMap(map, (DynamicObject)dy);
            personIds.add(dy.getLong("person.id"));
        });
        boolean isQuit = this.isQuit();
        List<Long> personIdList = this.getPersonIds(isQuit, personIds);
        return new Tuple(map, personIdList);
    }

    public Map<String, DynamicObject> getMajorPercre(List<Long> personIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        qFilter.and(new QFilter(IS_MAJOR, "=", (Object)"1"));
        return CommonServiceUtil.getInfo(qFilter, "person", "person.number", "hrpi_percre");
    }

    public String getKey(DynamicObject dy) {
        boolean isQuit = this.isQuit();
        StringBuilder keyString = new StringBuilder();
        keyString.append(dy.getString("number"));
        keyString.append('_');
        keyString.append(dy.getString("credentialstype.number"));
        if (isQuit) {
            keyString.append('_');
            keyString.append(dy.getString("person.number"));
        }
        return keyString.toString();
    }

    private void setPercreMap(Map<String, List<Long>> map, DynamicObject dy) {
        String keyStr = this.getKey(dy);
        List<Long> longs = map.get(keyStr);
        if (CollectionUtils.isEmpty(longs)) {
            longs = new ArrayList<Long>(1);
            map.put(this.getKey(dy), longs);
        }
        longs.add(dy.getLong("person.id"));
    }

    public void checkIsHavePercre(Map<String, List<Long>> percreMap, DynamicObject item, StringBuilder msg, List<Long> personIds) {
        String strKey = this.getKey(item);
        List<Long> longs = percreMap.get(strKey);
        if (CollectionUtils.isEmpty(longs) || CollectionUtils.isEmpty(personIds)) {
            return;
        }
        boolean flag = longs.stream().anyMatch(personIds::contains);
        if (flag) {
            this.addErrorMsg(msg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8bc1\u4ef6\u4fe1\u606f\u3002", (String)"HRPICommonPercreServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void checkGroup(DynamicObject item, Map<String, List<DynamicObject>> groupMap, Map<String, DynamicObject> majorPercre, StringBuilder msg) {
        DynamicObject major = majorPercre.get(item.getString("person.number"));
        if (Objects.nonNull(major) && item.getBoolean(IS_MAJOR)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u4e3b\u8bc1\u4ef6\u3002", (String)"HRPICommonPercreServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> list = groupMap.get(item.getString("person.number"));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        long count = list.stream().filter(dy -> dy.getBoolean(IS_MAJOR)).count();
        if (count > 1L) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u5e94\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u4e3b\u8bc1\u4ef6\u3002", (String)"HRPICommonPercreServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            groupMap.remove(item.getString("person.number"));
        }
    }

    private void checkOtherThing(DynamicObject item, StringBuilder msg) {
        boolean flag;
        Date issuedate;
        Date birthday = item.getDate("birthday");
        if (birthday != null && DateUtil.compareDate(birthday, new Date()) > 0) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPICommonPercreServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if ((issuedate = item.getDate("issuedate")) != null && DateUtil.compareDate(issuedate, new Date()) > 0) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPICommonPercreServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        Date expirationdate = item.getDate("expirationdate");
        String extDateStr = ResManager.loadKDString((String)"\u8bc1\u4ef6\u6709\u6548\u671f\u81f3\u5e94\u665a\u4e8e\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u3002", (String)"HRPICommonPercreServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(issuedate, expirationdate, msg, extDateStr, "0");
        if (RESIDENT_ID_CARD_ID.equals(item.getLong("credentialstype.id")) && !(flag = CommonServiceUtil.validIdentityCardNo(null, "CN01", item.getString("number")))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"HRPICommonPercreServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private Map<String, String> getPercreTepyMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_credentialstype");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        Object[] dynamicObjects = serviceHelper.query("number,isidentity", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("isidentity"), (v1, v2) -> v2));
    }

    private /* synthetic */ void lambda$businessSave$2(Map outMessageMap, Map idmapping, DynamicObjectType percreType, String[] needImpPros, Map percreTepyMap, DynamicObjectCollection percreCollection, DynamicObject tempDy) {
        if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)tempDy)) {
            return;
        }
        DynamicObject newPercreDy = CommonServiceUtil.buildDy(percreType, tempDy, needImpPros);
        newPercreDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        String isidentity = HRStringUtils.equals((String)"true", (String)((String)percreTepyMap.get(tempDy.getString("credentialstype.number")))) ? "1" : "0";
        newPercreDy.set("isidentity", (Object)isidentity);
        String ismajor = tempDy.getBoolean(IS_MAJOR) ? "1" : "0";
        newPercreDy.set(IS_MAJOR, (Object)ismajor);
        percreCollection.add((Object)newPercreDy);
    }
}

