/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.pereduexpcert;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIPereduexpCertInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOGGER = LogFactory.getLog(HRPIPereduexpCertInitServiceImpl.class);
    private static String EMP_NUMBER = "empnumber";
    private static String ADMISSION_DATE = "admissiondate";
    private static String GRADUTION_DATE = "gradutiondate";
    private static String GRADUATE_SCHOOL = "graduateschool";
    private static String GRADUATE_SCHOOL_ID = "graduateschool.id";
    private static String CERT_TYPE = "certtype";
    private static String CERT_TYPE_ID = "certtype.id";
    private static String NUMBER = "number";

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        LOGGER.info("HRPIPereduexpCertInitServiceImpl#businessValidate start");
        List data = (List)dysMap.get("data");
        Map midIdMap = (Map)dysMap.get("idmapping");
        List<String> empNumberList = data.stream().map(dyn -> dyn.getString("empnumber")).collect(Collectors.toList());
        Map<String, DynamicObject> combineKeyVsCertDynMap = this.getCombineKeyVsCertDynMap(empNumberList);
        DynamicObject[] employeeDynArr = HRPIEmployeeRepository.listEmpEntByNumbers("id, person, empnumber", empNumberList);
        Map<String, Long> empNumberVsPeronIdMap = Arrays.stream(employeeDynArr).collect(Collectors.toMap(dyn -> dyn.getString(EMP_NUMBER), dyn -> dyn.getLong("person.id"), (o1, o2) -> o1));
        Collection<Long> personIdCollection = empNumberVsPeronIdMap.values();
        Map<Long, Boolean> pereduExpIdVsIsHighestDegreeMap = this.getExpIdVsHighestDegreedMap(personIdCollection);
        Map<String, List<DynamicObject>> empNumberVsIsHighestDegreeMap = data.stream().filter(dyn -> dyn.getBoolean("ishighestdegree")).collect(Collectors.groupingBy(dyn -> dyn.getString(EMP_NUMBER)));
        for (DynamicObject item : data) {
            String empNumber;
            Long personId;
            Date graduateDate;
            StringBuilder msg = new StringBuilder();
            Long id = (Long)item.get("id");
            Date admissionDate = HRDateTimeUtils.dateFormatDate((Date)item.getDate(ADMISSION_DATE));
            if (!HRDateTimeUtils.isBeforeOrEqualNow((Date)admissionDate)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5165\u5b66\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPIPereduexpCertInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (HRDateTimeUtils.dayBefore((Date)(graduateDate = HRDateTimeUtils.dateFormatDate((Date)item.getDate(GRADUTION_DATE))), (Date)admissionDate)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6bd5\u4e1a\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u7b49\u4e8e\u5165\u5b66\u65e5\u671f\u3002", (String)"HRPIPereduexpCertInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (Objects.isNull(personId = empNumberVsPeronIdMap.get(empNumber = item.getString(EMP_NUMBER))) || personId.equals(0L)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6839\u636e\u5de5\u53f7\u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u81ea\u7136\u4eba\u4fe1\u606f\u3002", (String)"HRPIPereduexpCertInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            } else {
                List<DynamicObject> inputDynListForIsHighestDegree;
                Boolean flag;
                boolean isHighestDegree = item.getBoolean("ishighestdegree");
                if (isHighestDegree && Objects.nonNull(flag = pereduExpIdVsIsHighestDegreeMap.get(personId)) && flag.booleanValue()) {
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u4e0b\u5df2\u6709\u6700\u9ad8\u5b66\u5386\u6559\u80b2\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRPIPereduexpCertInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                if (!CollectionUtils.isEmpty(inputDynListForIsHighestDegree = empNumberVsIsHighestDegreeMap.get(empNumber)) && inputDynListForIsHighestDegree.size() > 1) {
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8bf7\u52ff\u521d\u59cb\u5316\u591a\u6761\u6709\u6700\u9ad8\u5b66\u5386\u6559\u80b2\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRPIPereduexpCertInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection certEntryDynCol = item.getDynamicObjectCollection("entryentity");
            for (DynamicObject certDynEntry : certEntryDynCol) {
                Object certType = certDynEntry.get(CERT_TYPE);
                if (Objects.isNull(certType)) {
                    this.validateCertTypeMustInput(msg, certDynEntry);
                    continue;
                }
                this.validateSameTypeForDB(combineKeyVsCertDynMap, msg, item, certDynEntry);
            }
            this.addMsgForAllId(midIdMap, msg, id);
        }
    }

    private void addMsgForAllId(Map<Long, HashSet<Long>> midIdMap, StringBuilder msg, Long id) {
        Set setIdSet = midIdMap.get(id);
        for (Long midId : setIdSet) {
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        }
    }

    private void validateSameTypeForDB(Map<String, DynamicObject> combineKeyVsCertDynMap, StringBuilder msg, DynamicObject item, DynamicObject certDynEntry) {
        String empNumber = item.getString(EMP_NUMBER);
        Date admissionDate = HRDateTimeUtils.dateFormatDate((Date)item.getDate(ADMISSION_DATE));
        Date graduateDate = HRDateTimeUtils.dateFormatDate((Date)item.getDate(GRADUTION_DATE));
        long graduateSchoolId = item.getLong(GRADUATE_SCHOOL_ID);
        long certTypeId = certDynEntry.getLong(CERT_TYPE_ID);
        StringBuilder sb = new StringBuilder();
        sb.append(empNumber).append("_").append(admissionDate).append("_").append(graduateDate).append("_").append(graduateSchoolId).append("_").append(certTypeId);
        String combineKey = sb.toString();
        DynamicObject certDynFromDB = combineKeyVsCertDynMap.get(combineKey);
        if (Objects.nonNull(certDynFromDB)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8be5\u5de5\u53f7\u5b58\u5728\u76f8\u540c\u5165\u5b66\u65e5\u671f\u4e0e\u6bd5\u4e1a\u65e5\u671f\u53ca\u6bd5\u4e1a\u9662\u6821\u7684\u6570\u636e\u4fe1\u606f\u3002", (String)"HRPIPereduexpCertInitServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void validateCertTypeMustInput(StringBuilder msg, DynamicObject certDynEntry) {
        List<String> certFieldList = this.getCertFieldList();
        Boolean hasValueFlag = Boolean.FALSE;
        for (String certField : certFieldList) {
            Object certFieldValue = certDynEntry.getDataStorage().getLocalValue((IDataEntityProperty)certDynEntry.getDynamicObjectType().getProperty(certField));
            if (certDynEntry.getDynamicObjectType().getProperty(certField) instanceof MuliLangTextProp) {
                if (!Objects.nonNull(certDynEntry.get(certField)) || ((Map)certDynEntry.get(certField)).size() <= 0) continue;
                hasValueFlag = Boolean.TRUE;
                continue;
            }
            if (!Objects.nonNull(certFieldValue)) continue;
            hasValueFlag = Boolean.TRUE;
        }
        if (hasValueFlag.booleanValue()) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u6559\u80b2\u8bc1\u4ef6\u5b57\u6bb5\u6709\u503c\u65f6\uff0c\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u586b\u3002", (String)"HRPIPereduexpCertInitServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", null);
    }

    protected List<String> getCertFieldList() {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)16);
        fieldList.add("number");
        fieldList.add("isauthenticated");
        fieldList.add("authcertnumber");
        fieldList.add("certdescription");
        return fieldList;
    }

    private Map<String, DynamicObject> getCombineKeyVsCertDynMap(List<String> empNumberList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_pereduexpcert");
        QFilter numberFilter = new QFilter("person.number", "in", empNumberList);
        numberFilter.and(QFilterUtil.getCurrentQf());
        DynamicObject[] certDynArr = helper.query("id, number, person, pereduexp, certtype", new QFilter[]{numberFilter});
        Map<String, DynamicObject> combineKeyVsCertDynMap = Arrays.stream(certDynArr).collect(Collectors.toMap(dyn -> this.getCombineKey((DynamicObject)dyn), dyn -> dyn));
        return combineKeyVsCertDynMap;
    }

    private String getCombineKey(DynamicObject dyn) {
        StringBuilder sb = new StringBuilder();
        try {
            String number = dyn.getString("person.number");
            Date admissionDate = HRDateTimeUtils.dateFormatDate((Date)dyn.getDate("pereduexp." + ADMISSION_DATE));
            Date graduationDate = HRDateTimeUtils.dateFormatDate((Date)dyn.getDate("pereduexp." + GRADUTION_DATE));
            Long graduateSchoolId = dyn.getLong("pereduexp." + GRADUATE_SCHOOL_ID);
            Long certTypeId = dyn.getLong(CERT_TYPE_ID);
            sb.append(number).append("_").append(admissionDate).append("_").append(graduationDate).append("_").append(graduateSchoolId).append("_").append(certTypeId);
        }
        catch (Exception ex) {
            LOGGER.error("getCombineKey error!", (Throwable)ex);
        }
        return sb.toString();
    }

    private Map<Long, Boolean> getExpIdVsHighestDegreedMap(Collection<Long> personIdCollection) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_pereduexp");
        QFilter personIdFilter = new QFilter("person", "in", personIdCollection);
        DynamicObject[] pereduExpDynArr = helper.query("id, person, ishighestdegree", new QFilter[]{personIdFilter});
        HashMap pereduExpIdVsIsHighestDegreeMap = Maps.newHashMapWithExpectedSize((int)pereduExpDynArr.length);
        for (DynamicObject pereduExpDyn : pereduExpDynArr) {
            long personIdFromPereduExpDyn = pereduExpDyn.getLong("person.id");
            boolean isHighestDegree = pereduExpDyn.getBoolean("ishighestdegree");
            if (!isHighestDegree) continue;
            pereduExpIdVsIsHighestDegreeMap.put(personIdFromPereduExpDyn, true);
        }
        return pereduExpIdVsIsHighestDegreeMap;
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        MainEntityType pereduexpType = EntityMetadataCache.getDataEntityType((String)"hrpi_pereduexp");
        DynamicObjectCollection pereduexpCollection = new DynamicObjectCollection((DynamicObjectType)pereduexpType, null);
        Map outMessageMap = this.getInitOutParam().getData();
        List<String> empNumberList = data.stream().map(dyn -> dyn.getString("empnumber")).collect(Collectors.toList());
        DynamicObject[] employeeDynArr = HRPIEmployeeRepository.listEmployeeByNumbers("id, person, empnumber, laborrelstatus", empNumberList);
        Map<String, List<DynamicObject>> empNumberVsEmployeeDynListMap = Arrays.stream(employeeDynArr).collect(Collectors.groupingBy(dyn -> dyn.getString(EMP_NUMBER)));
        MainEntityType pereduexpCertType = EntityMetadataCache.getDataEntityType((String)"hrpi_pereduexpcert");
        String[] needImpPros = this.getImportFields((DynamicObjectType)pereduexpType);
        DynamicObjectCollection pereduexpCertCollection = new DynamicObjectCollection((DynamicObjectType)pereduexpCertType, null);
        Integer entryEntityCount = this.getEntryEntityCount(data);
        long[] longIds = ORM.create().genLongIds("hrpi_pereduexpcert", entryEntityCount.intValue());
        int idCount = 0;
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            DynamicObject pereduExpNewDy = CommonServiceUtil.buildDy((DynamicObjectType)pereduexpType, (DynamicObject)data.get(i), needImpPros);
            pereduExpNewDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            DynamicObjectCollection certDynCol = item.getDynamicObjectCollection("entryentity");
            Long personId = this.getPersonId(empNumberVsEmployeeDynListMap, item);
            pereduExpNewDy.set("isoverseas", item.get("isoverseas"));
            pereduExpNewDy.set("person", (Object)personId);
            for (DynamicObject certDyn : certDynCol) {
                Boolean hasValue = this.isEntryHasValue(certDyn);
                if (!hasValue.booleanValue()) continue;
                DynamicObject newCertDy = (DynamicObject)pereduexpCertType.createInstance();
                InitValidateUtil.wrapCommonFieldInit((DynamicObject)newCertDy);
                newCertDy.set("id", (Object)longIds[idCount++]);
                newCertDy.set("pereduexp", (Object)pereduExpNewDy.getLong("id"));
                newCertDy.set("number", certDyn.get("number"));
                newCertDy.set("person", (Object)personId);
                newCertDy.set("certtype", certDyn.get("certtype"));
                newCertDy.set("authcertnumber", certDyn.get("authcertnumber"));
                newCertDy.set("isauthenticated", certDyn.get("isauthenticated"));
                newCertDy.set("description", certDyn.get("certdescription"));
                newCertDy.set("businessstatus", (Object)"1");
                newCertDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
                pereduexpCertCollection.add((Object)newCertDy);
            }
            pereduexpCollection.add((Object)pereduExpNewDy);
        }
        if (!CollectionUtils.isEmpty((Collection)pereduexpCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(pereduexpCollection, pereduexpCertCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private Long getPersonId(Map<String, List<DynamicObject>> empNumberVsEmployeeDynListMap, DynamicObject item) {
        String empNumber = item.getString(EMP_NUMBER);
        Long personId = 0L;
        List<DynamicObject> employeeDynList = empNumberVsEmployeeDynListMap.get(empNumber);
        if (!CollectionUtils.isEmpty(employeeDynList)) {
            DynamicObject employeeDyn = employeeDynList.stream().filter(dyn -> dyn.getLong("laborrelstatus.id") == 1020L).findFirst().orElse(null);
            personId = Objects.nonNull(employeeDyn) ? Long.valueOf(employeeDyn.getLong("person.id")) : Long.valueOf(employeeDynList.get(0).getLong("person.id"));
        }
        return personId;
    }

    private Boolean isEntryHasValue(DynamicObject certDyn) {
        List<String> certFieldList = this.getCertFieldList();
        certFieldList.add("certtype");
        Boolean hasValueFlag = Boolean.FALSE;
        for (String certField : certFieldList) {
            Object certFieldValue = certDyn.getDataStorage().getLocalValue((IDataEntityProperty)certDyn.getDynamicObjectType().getProperty(certField));
            if (certDyn.getDynamicObjectType().getProperty(certField) instanceof MuliLangTextProp) {
                if (!Objects.nonNull(certDyn.get(certField)) || ((Map)certDyn.get(certField)).size() <= 0) continue;
                hasValueFlag = Boolean.TRUE;
                continue;
            }
            if (!Objects.nonNull(certFieldValue)) continue;
            hasValueFlag = Boolean.TRUE;
        }
        return hasValueFlag;
    }

    private Integer getEntryEntityCount(List<DynamicObject> data) {
        ArrayList countDynList = Lists.newArrayListWithExpectedSize((int)data.size());
        for (DynamicObject item : data) {
            countDynList.addAll(item.getDynamicObjectCollection("entryentity"));
        }
        return countDynList.size();
    }

    protected void rollbackAll() {
        super.rollbackAll();
        this.rollbackOtherTableAll("hrpi_pereduexpcert");
    }

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_pereduexpcert");
    }
}

