/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.person;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class HRPICommonPersonInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOG = LogFactory.getLog(HRPICommonPersonInitServiceImpl.class);
    private final String[] regionProps = new String[]{"politicalstatus", "party", "religion", "regresidencenature", "joinpartydate", "nativeplace", "birthplace"};
    protected Map<String, Long> numberToMidKey = null;

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)map.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)data.size());
        this.numberToMidKey = Maps.newHashMapWithExpectedSize((int)data.size());
        data.forEach(item -> {
            String otherPhoneNumber;
            String phoneNumber;
            Date marryDate;
            Date deathDate;
            Long midId = (Long)item.get("id");
            StringBuilder errorMsg = new StringBuilder();
            Date birthday = (Date)item.get("birthday");
            Boolean birthDayFlag = Boolean.TRUE;
            if (Objects.nonNull(birthday) && !birthday.before(InitValidateUtil.getCurrentDay())) {
                CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                birthDayFlag = Boolean.FALSE;
            }
            if (!((deathDate = (Date)item.get("deathdate")) == null || !birthDayFlag.booleanValue() || deathDate.before(InitValidateUtil.getCurrentDay()) && deathDate.after(birthday))) {
                CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u8eab\u6545\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\uff0c\u4e14\u5fc5\u987b\u665a\u4e8e\u51fa\u751f\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if ((marryDate = (Date)item.get("marriageregistdate")) != null && birthDayFlag.booleanValue() && !marryDate.after(birthday)) {
                CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u7ed3\u5a5a\u767b\u8bb0\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u51fa\u751f\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)(phoneNumber = (String)item.get("phone")))) {
                this.validatePhone(phoneNumber, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\uff1a", (String)"HRPIOnboardPersonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), errorMsg);
            }
            if (StringUtils.isNotBlank((CharSequence)(otherPhoneNumber = (String)item.get("otherphone")))) {
                this.validatePhone(otherPhoneNumber, ResManager.loadKDString((String)"\u5176\u4ed6\u624b\u673a\u53f7\u7801\uff1a", (String)"HRPIOnboardPersonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]), errorMsg);
            }
            this.customValidate((Map<String, Object>)item, errorMsg);
            if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
                this.getInitOutParam().addErrorMsg(midId, errorMsg.toString());
            }
            String number = (String)item.get("number");
            numbers.add(number);
            this.numberToMidKey.put(number, midId);
        });
        DynamicObject[] collection = HRPIPersonRepository.getPersonsByNumber("number", numbers, null);
        if (collection != null && collection.length > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5de5\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u5224\u65ad\u662f\u5426\u4e3a\u5de5\u53f7\u590d\u7528\u7684\u518d\u5165\u804c\u5458\u5de5\u3002", (String)"HRPICommonPersonInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]) + "\n";
            for (int k = 0; k < collection.length; ++k) {
                DynamicObject item2 = collection[k];
                String number = item2.getString("number");
                Long midKey = this.numberToMidKey.get(number);
                InitOutParam param = this.getInitOutParam();
                InitValidateUtil.addMsg((InitOutParam)param, (Long)midKey, (String)errorMsg);
            }
        }
        this.customValidateAfter(map);
        List dysData = (List)dysMap.get("data");
        CommonServiceUtil.wrapSuccessPkIds(idMap, dysData, this.getInitOutParam());
    }

    private void validatePhone(String phoneDy, String tipInfo, StringBuilder errorMsg) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phoneDy);
        if (!telephoneParseResult.isSuccess()) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat(telephoneParseResult.getErrorMsg()));
            return;
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat(ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef", (String)"HRPIOnboardPersonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            return;
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat((String)result.get("message")));
        }
    }

    public abstract void customValidate(Map<String, Object> var1, StringBuilder var2);

    public abstract void customValidateAfter(Map<String, Object> var1);

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List maps = (List)map.get("data");
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType personType = EntityMetadataCache.getDataEntityType((String)"hrpi_person");
        DynamicObjectCollection personCollection = new DynamicObjectCollection((DynamicObjectType)personType, null);
        MainEntityType perNonTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pernontsprop");
        DynamicObjectCollection perNonTsCollection = new DynamicObjectCollection((DynamicObjectType)perNonTsType, null);
        long[] perNonTsIds = ORM.create().genLongIds((IDataEntityType)perNonTsType, data.size());
        MainEntityType perTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pertsprop");
        DynamicObjectCollection perTsCollection = new DynamicObjectCollection((DynamicObjectType)perTsType, null);
        long[] perTsIds = ORM.create().genLongIds((IDataEntityType)perTsType, data.size());
        MainEntityType contactType = EntityMetadataCache.getDataEntityType((String)"hrpi_percontact");
        DynamicObjectCollection contactCollection = new DynamicObjectCollection((DynamicObjectType)contactType, null);
        long[] contactIds = ORM.create().genLongIds((IDataEntityType)contactType, data.size());
        MainEntityType regionType = EntityMetadataCache.getDataEntityType((String)"hrpi_perregion");
        DynamicObjectCollection regionCollection = new DynamicObjectCollection((DynamicObjectType)regionType, null);
        long[] regionIds = ORM.create().genLongIds((IDataEntityType)regionType, data.size());
        for (int i = 0; i < data.size(); ++i) {
            Map mapItem = (Map)maps.get(i);
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            String number = (String)mapItem.get("number");
            DynamicObject personDy = this.buildPersonDy((DynamicObjectType)personType, number, item);
            personCollection.add((Object)personDy);
            DynamicObject perNonTs = this.buildPerNonTsDy((DynamicObjectType)perNonTsType, perNonTsIds[i], item);
            perNonTsCollection.add((Object)perNonTs);
            DynamicObject perTs = this.buildPerTsDy((DynamicObjectType)perTsType, perTsIds[i], item);
            perTsCollection.add((Object)perTs);
            DynamicObject contact = this.buildContact((DynamicObjectType)contactType, contactIds[i], item);
            contactCollection.add((Object)contact);
            DynamicObject region = this.buildRegion((DynamicObjectType)regionType, regionIds[i], item);
            if (!Objects.nonNull(region)) continue;
            regionCollection.add((Object)region);
        }
        if (CollectionUtils.isNotEmpty((Collection)personCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(personCollection, perNonTsCollection, perTsCollection, contactCollection, regionCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            boolean success = (Boolean)result.get("success");
            return success;
        }
        return true;
    }

    private DynamicObject buildPersonDy(DynamicObjectType type, String number, DynamicObject item) {
        DynamicObject person = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(person, item);
        person.set("id", item.get("id"));
        person.set("number", (Object)number);
        person.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildPersonDy(person, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)person);
        return person;
    }

    public abstract void cusBuildPersonDy(DynamicObject var1, DynamicObject var2);

    private DynamicObject buildPerNonTsDy(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject perNonTs = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(perNonTs, item);
        perNonTs.set("id", (Object)id);
        perNonTs.set("person", item.get("id"));
        perNonTs.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildPerNonTsDy(perNonTs, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)perNonTs);
        return perNonTs;
    }

    public abstract void cusBuildPerNonTsDy(DynamicObject var1, DynamicObject var2);

    private DynamicObject buildPerTsDy(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject perTs = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(perTs, item);
        perTs.set("id", (Object)id);
        perTs.set("person", item.get("id"));
        perTs.set("bsed", (Object)new Date());
        perTs.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildPerTsDy(perTs, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)perTs);
        return perTs;
    }

    public abstract void cusBuildPerTsDy(DynamicObject var1, DynamicObject var2);

    private DynamicObject buildContact(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject contact = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(contact, item);
        contact.set("id", (Object)id);
        contact.set("person", item.get("id"));
        contact.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildContact(contact, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)contact);
        return contact;
    }

    public abstract void cusBuildContact(DynamicObject var1, DynamicObject var2);

    private DynamicObject buildRegion(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject region = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(region, item);
        region.set("id", (Object)id);
        region.set("person", item.get("id"));
        region.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        this.cusBuildRegion(region, item);
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)region);
        return region;
    }

    public abstract void cusBuildRegion(DynamicObject var1, DynamicObject var2);

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_person", "hrpi_pertsprop", "hrpi_percontact", "hrpi_perregion");
    }

    protected void rollbackAll() {
        this.validateRollbackEmp(ResManager.loadKDString((String)"\u56de\u6eda\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7684\u4efb\u804c\u7ecf\u5386\u6570\u636e\u3001\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u6570\u636e\u3001\u804c\u4e1a\u4fe1\u606f\u6570\u636e\u5fc5\u987b\u5168\u90e8\u56de\u6eda\u6210\u529f\uff0c\u624d\u53ef\u6267\u884c\u57fa\u672c\u4fe1\u606f\u6570\u636e\u7684\u56de\u6eda\u3002", (String)"HRPICommonPersonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        super.rollbackAll();
        this.rollbackOtherTableAll("hrpi_person", "hrpi_pertsprop", "hrpi_percontact", "hrpi_perregion");
    }

    public abstract void validateRollbackEmp(String var1);
}

