/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.personemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBaseRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpEntrelRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.business.init.personemp.HRPIPersonEmpInitServiceImpl;
import kd.hrmp.hrpi.business.tools.PersonModelConfigUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIOnPersonEmpInitServiceImpl
extends HRPIPersonEmpInitServiceImpl {
    private Map<String, Map<String, Object>> checkMap;
    protected static final String selProp = "person, startdate, islatestrecord";

    @Override
    public void validate(List<DynamicObject> data, Map<Long, HashSet<Long>> idMap) {
        Set<String> empNumberSet = data.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
        DynamicObject[] personsByNumberDys = HRPIPersonRepository.getPersonsByNumber("id, number", empNumberSet, new HashSet<String>(), "modifytime desc");
        Map<Object, Object> numPersonIdMap = new HashMap(data.size());
        Map<Object, Object> personIdEmpMap = new HashMap(data.size());
        Map<String, List<DynamicObject>> empNumEmpMap = HRPIEmployeeRepository.listEmployeesByNumbers("id,startdate,enddate,empnumber", empNumberSet).stream().collect(Collectors.groupingBy(dy -> dy.getString("empnumber")));
        if (personsByNumberDys != null) {
            numPersonIdMap = Arrays.stream(personsByNumberDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (oldVal, newVal) -> newVal));
            List<Long> personIds = Arrays.stream(personsByNumberDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            personIdEmpMap = Arrays.stream(HRPIEmployeeRepository.listEmpByPersonIds("id,person,startdate,enddate,empnumber", personIds)).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        }
        this.beforeValidate(data, idMap);
        for (DynamicObject item : data) {
            List empsList;
            String number = item.getString("number");
            Long id = item.getLong("id");
            Long midId = idMap.get(id).iterator().next();
            StringBuilder errorMsg = new StringBuilder();
            this.service.validatePerson(item, errorMsg);
            this.service.validateEmp(item, errorMsg);
            boolean flag = false;
            if (numPersonIdMap.get(number) != null && (Long)numPersonIdMap.get(number) != 0L) {
                empsList = (List)personIdEmpMap.get(numPersonIdMap.get(number));
                flag = this.validateEmpRepeat(item, empsList, errorMsg);
            }
            if (empNumEmpMap.get(number) != null && !flag) {
                empsList = empNumEmpMap.get(number);
                this.validateEmpRepeat(item, empsList, errorMsg);
            }
            this.customValidate(item, errorMsg);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)errorMsg.toString());
        }
    }

    @Override
    public void beforeValidate(List<DynamicObject> data) {
        this.checkMap = this.service.getPlatformPerson(data, this.getInitOutParam().getExecTaskId());
    }

    @Override
    public void beforeValidate(List<DynamicObject> data, Map<Long, HashSet<Long>> idMap) {
        this.checkMap = this.service.getPlatformPerson(data, this.getInitOutParam().getExecTaskId());
    }

    @Override
    public void customValidate(DynamicObject item, StringBuilder msg) {
        this.service.validateOnboardEmp(item, msg);
        this.service.validatePlatformPerson(this.checkMap.get(item.getString("id")), msg);
    }

    protected boolean validateEmpRepeat(DynamicObject item, List<DynamicObject> dyList, StringBuilder errorMsg) {
        if (CollectionUtils.isEmpty(dyList)) {
            return false;
        }
        Date endDate = this.maxDate;
        boolean flag = dyList.stream().anyMatch(dy -> dy.getDate("startdate").compareTo(endDate) <= 0 && dy.getDate("enddate").compareTo(item.getDate("startdate")) >= 0);
        if (flag) {
            CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u5de5\u53f7\u7684\u804c\u4e1a\u4fe1\u606f\u3002", (String)"HRPIEmpCommonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return flag;
    }

    @Override
    public void cusBuildEmpEntRel(DynamicObject target, DynamicObject source) {
        target.set("businessstatus", (Object)"1");
        target.set("enddate", (Object)this.maxDate);
        target.set("labrelstatusprd", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
    }

    private void cusBuildOnePersonMoreEmpEntRel(DynamicObject empEntRel, DynamicObject entDy, DynamicObject empDy) {
        empEntRel.set("preemployee", empDy.get("id"));
        empEntRel.set("oldempnumber", empDy.get("empnumber"));
        empEntRel.set("firststartdate", entDy.get("startdate"));
        empEntRel.set("inheritnumber", (Object)"2");
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return true;
        }
        MainEntityType personType = EntityMetadataCache.getDataEntityType((String)"hrpi_person");
        DynamicObjectCollection personCol = new DynamicObjectCollection((DynamicObjectType)personType, null);
        MainEntityType perNonTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pernontsprop");
        DynamicObjectCollection perNonTsCol = new DynamicObjectCollection((DynamicObjectType)perNonTsType, null);
        MainEntityType perTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pertsprop");
        DynamicObjectCollection perTsCol = new DynamicObjectCollection((DynamicObjectType)perTsType, null);
        MainEntityType contactType = EntityMetadataCache.getDataEntityType((String)"hrpi_percontact");
        DynamicObjectCollection contactCol = new DynamicObjectCollection((DynamicObjectType)contactType, null);
        MainEntityType regionType = EntityMetadataCache.getDataEntityType((String)"hrpi_perregion");
        DynamicObjectCollection regionCol = new DynamicObjectCollection((DynamicObjectType)regionType, null);
        MainEntityType empType = EntityMetadataCache.getDataEntityType((String)"hrpi_employee");
        DynamicObjectCollection empCol = new DynamicObjectCollection((DynamicObjectType)empType, null);
        MainEntityType empEntRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empentrel");
        DynamicObjectCollection empEntRelCol = new DynamicObjectCollection((DynamicObjectType)empEntRelType, null);
        ArrayList typeList = Lists.newArrayList((Object[])new DynamicObjectType[]{perNonTsType, perTsType, contactType, regionType, empType, empEntRelType});
        Map<DynamicObjectType, long[]> idMap = this.getIdMap(typeList, data.size());
        Date nowDate = HRDateTimeUtils.getNowDate();
        boolean isConfigOn = PersonModelConfigUtil.configOn();
        boolean isNumMul = false;
        Set<String> numSet = data.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
        DynamicObject[] personsByNumberDys = HRPIPersonRepository.getPersonsByNumber("id,number", numSet, new HashSet<String>(), "createtime desc");
        Map<Object, Object> numPersonMap = new HashMap(data.size());
        if (personsByNumberDys != null && personsByNumberDys.length > 0) {
            isNumMul = true;
            numPersonMap = Arrays.stream(personsByNumberDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (oldVal, newVal) -> newVal));
        }
        ArrayList<Long> personIds = new ArrayList<Long>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            String number = item.getString("number");
            DynamicObject personDy = (DynamicObject)numPersonMap.get(number);
            if (isConfigOn && isNumMul && personDy != null) {
                long personId = personDy.getLong("id");
                personIds.add(personId);
                continue;
            }
            item.set("employeeid", (Object)idMap.get(empType)[i]);
            personCol.add((Object)this.buildPersonDy((DynamicObjectType)personType, item));
            perNonTsCol.add((Object)this.buildPerNonTsDy((DynamicObjectType)perNonTsType, idMap.get(perNonTsType)[i], item));
            perTsCol.add((Object)this.buildPerTsDy((DynamicObjectType)perTsType, idMap.get(perTsType)[i], item, nowDate));
            contactCol.add((Object)this.buildContact((DynamicObjectType)contactType, idMap.get(contactType)[i], item));
            regionCol.add((Object)this.buildRegion((DynamicObjectType)regionType, idMap.get(regionType)[i], item));
            DynamicObject empEntRel = this.buildEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item);
            empEntRelCol.add((Object)empEntRel);
            empCol.add((Object)this.buildEmployeeDy((DynamicObjectType)empType, empEntRel));
        }
        if (!CollectionUtils.isEmpty(personIds)) {
            DynamicObject[] empDys = HRPIEmployeeRepository.listEmpByPersonIds("id, person, startdate, empnumber", personIds);
            DynamicObject[] entDys = HRPIEmpEntrelRepository.getInstance().listDynByPersonId("id, preemployee, person, firststartdate, oldempnumber, startdate, enddate", personIds);
            Map<Object, Object> personIdEmps = new HashMap(personIds.size());
            Map<Object, Object> personIdEnts = new HashMap(personIds.size());
            if (empDys != null) {
                personIdEmps = Arrays.stream(empDys).filter(emp -> emp.get("person") != null).collect(Collectors.groupingBy(emp -> emp.getLong("person.id")));
            }
            if (entDys != null) {
                personIdEnts = Arrays.stream(entDys).filter(ent -> ent.get("person") != null).collect(Collectors.groupingBy(ent -> ent.getLong("person.id")));
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject item = (DynamicObject)data.get(i);
                if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
                String number = item.getString("number");
                DynamicObject personDy = (DynamicObject)numPersonMap.get(number);
                if (!isConfigOn || !isNumMul || personDy == null) continue;
                item.set("employeeid", (Object)idMap.get(empType)[i]);
                long personId = personDy.getLong("id");
                DynamicObject empEntRel = this.buildOnePersonMoreEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item, personId);
                List empsList = (List)personIdEmps.get(personId);
                List entsList = (List)personIdEnts.get(personId);
                if (!CollectionUtils.isEmpty((Collection)empsList) && !CollectionUtils.isEmpty((Collection)entsList)) {
                    this.sortDys(entsList, "startdate", "1");
                    this.sortDys(empsList, "startdate", "0");
                    this.cusBuildOnePersonMoreEmpEntRel(empEntRel, (DynamicObject)entsList.get(0), (DynamicObject)empsList.get(0));
                }
                empEntRelCol.add((Object)empEntRel);
                DynamicObject emp2 = this.buildEmployeeDy((DynamicObjectType)empType, empEntRel);
                if (!CollectionUtils.isEmpty((Collection)empsList)) {
                    emp2.set("mid", (Object)((DynamicObject)empsList.get(empsList.size() - 1)).getLong("id"));
                }
                empCol.add((Object)emp2);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)empCol)) {
            DynamicObjectCollection empNonEntCol = this.buildEmpNonEntCol(empEntRelCol);
            Map<String, Object> paramMap = this.buildDatasByCollection(personCol, perNonTsCol, perTsCol, contactCol, regionCol, empCol, empEntRelCol, empNonEntCol);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    @Override
    public void cusRollback() {
        DynamicObject[] emps;
        DynamicObject[] ents;
        HRPIBaseRepository empHelper = new HRPIBaseRepository("hrpi_employee");
        HRPIBaseRepository entHelper = new HRPIBaseRepository("hrpi_empentrel");
        QFilter batchQFiler = new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()).and(new QFilter("initstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"0", "1"}))).and(QFilterUtil.getCurrentQf()).and(QFilterUtil.getDataStatusFilter());
        int batchCount = 1000;
        long entid = 0L;
        while ((ents = entHelper.batchQuery("person", entid, batchCount, batchQFiler)) != null && ents.length > 0) {
            this.updLatestrecord(entHelper, ents);
            if (ents.length < batchCount) break;
            entid = ents[ents.length - 1].getLong("id");
        }
        long empid = 0L;
        while ((emps = empHelper.batchQuery("person", empid, batchCount, batchQFiler)) != null && emps.length > 0) {
            this.updLatestrecord(empHelper, emps);
            if (emps.length < batchCount) break;
            empid = emps[emps.length - 1].getLong("id");
        }
    }

    private void updLatestrecord(HRPIBaseRepository helper, DynamicObject[] emps) {
        ArrayList<Long> personIds = new ArrayList<Long>(emps.length);
        for (DynamicObject emp2 : emps) {
            if (emp2.get("person") == null) continue;
            personIds.add(emp2.getLong("person.id"));
        }
        QFilter[] filter = new QFilter[]{new QFilter("person.id", "in", personIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        boolean isConfigOn = PersonModelConfigUtil.configOn();
        DynamicObject[] empsByPersonIdDys = helper.query(selProp, filter);
        if (empsByPersonIdDys != null) {
            Map<Long, List<DynamicObject>> personIdEmpsMap = Arrays.stream(empsByPersonIdDys).collect(Collectors.groupingBy(emp -> emp.getLong("person.id")));
            if (isConfigOn && !CollectionUtils.isEmpty(personIdEmpsMap)) {
                ArrayList<DynamicObject> empsAllList = new ArrayList<DynamicObject>(emps.length);
                for (Map.Entry<Long, List<DynamicObject>> entry : personIdEmpsMap.entrySet()) {
                    List<DynamicObject> empsList = entry.getValue();
                    if (CollectionUtils.isEmpty(empsList)) continue;
                    this.sortDys(empsList, "startdate", "0");
                    int total = Math.min(empsList.size(), 2);
                    for (int j = 0; j < total; ++j) {
                        DynamicObject dy = empsList.get(j);
                        dy.set("islatestrecord", (Object)Character.valueOf('1'));
                        empsAllList.add(dy);
                    }
                }
                if (!CollectionUtils.isEmpty(empsAllList)) {
                    helper.save(empsAllList.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    @Override
    public void afterValidateEmpRepeat(Map<String, List<DynamicObject>> empMap, DynamicObject item) {
    }

    @Override
    public DynamicObjectCollection buildEmpNonEntCol(DynamicObjectCollection empEntRelCol) {
        return null;
    }

    @Override
    public boolean isQuit() {
        return false;
    }
}

