/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.personemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.impl.PersonServiceImpl;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class HRPIPersonEmpCommonInitService {
    private static final String DEATH_DATE = "deathdate";
    private static final String MARRIAGEREGIST_DATE = "marriageregistdate";
    private static final String OTHER_PHONE = "otherphone";
    private static final String BASE_DATA_ID = "fbasedataid.id";
    private static final String LABORRELSTATUS_LABRELSTATUSCLS_ID = "laborrelstatus.labrelstatuscls.id";
    private static final String LABORRELSTATUS_LABRELSTATUSPRD_ID = "laborrelstatus.labrelstatusprd.id";
    private static final String IS_PROBATION = "isprobation";
    private static final String REPEAT_KEY_NAME = "name";
    private static final String REPEAT_KEY_NUMBER = "number";
    private static final String REPEAT_KEY_PHONE = "phone";
    private static final String REPEAT_KEY_EMAIL = "email";
    private final Date nowDate = HRDateTimeUtils.getNowDate();

    public void validatePerson(DynamicObject item, StringBuilder errorMsg) {
        String otherPhoneNumber;
        Date birthday = item.getDate("birthday");
        if (Objects.nonNull(birthday) && birthday.compareTo(this.nowDate) > 0) {
            CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        } else {
            Date marryDate;
            Date deathDate = (Date)item.get(DEATH_DATE);
            if (deathDate != null && (deathDate.compareTo(this.nowDate) > 0 || deathDate.compareTo(birthday) < 0)) {
                CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u8eab\u6545\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\uff0c\u4e14\u5fc5\u987b\u665a\u4e8e\u51fa\u751f\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if ((marryDate = (Date)item.get(MARRIAGEREGIST_DATE)) != null && marryDate.compareTo(birthday) < 0) {
                CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u7ed3\u5a5a\u767b\u8bb0\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u51fa\u751f\u65e5\u671f\u3002", (String)"HRPICommonPersonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        String phoneNumber = (String)item.get(REPEAT_KEY_PHONE);
        if (HRStringUtils.isNotEmpty((String)phoneNumber)) {
            this.validatePhone(phoneNumber, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\uff1a", (String)"HRPIOnboardPersonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), errorMsg);
        }
        if (HRStringUtils.isNotEmpty((String)(otherPhoneNumber = (String)item.get(OTHER_PHONE)))) {
            this.validatePhone(otherPhoneNumber, ResManager.loadKDString((String)"\u5176\u4ed6\u624b\u673a\u53f7\u7801\uff1a", (String)"HRPIOnboardPersonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]), errorMsg);
        }
    }

    public void validateEmp(DynamicObject item, StringBuilder msg) {
        this.validateLaborRelTypeAndStatus(item, msg);
        if (item.getDate("startdate").compareTo(this.nowDate) > 0) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u4eca\u5929\u3002", (String)"HRPIEmpCommonInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public void validateQuitEmp(DynamicObject item, StringBuilder msg) {
        Date startDate;
        Date endDate;
        Long labRelStatusPrdId = item.getLong(LABORRELSTATUS_LABRELSTATUSPRD_ID);
        if (!HRPIValueConstants.LABRELSTATUSPRD_END.equals(labRelStatusPrdId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u79bb\u804c\u76f8\u5173\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPIEmpNonEntInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if ((endDate = item.getDate("enddate")).after(this.nowDate)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPIEmpNonEntInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (endDate.before(startDate = item.getDate("startdate"))) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"HRPIEmpNonEntInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public void validateOnboardEmp(DynamicObject item, StringBuilder msg) {
        Long labRelStatusPrdId = item.getLong(LABORRELSTATUS_LABRELSTATUSPRD_ID);
        if (!HRPIValueConstants.LABRELSTATUSPRD_ING.equals(labRelStatusPrdId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5728\u804c\u76f8\u5173\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPIEmpEntInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        Long labrelStatusCategoryId = item.getLong(LABORRELSTATUS_LABRELSTATUSCLS_ID);
        boolean isProbation = item.getBoolean(IS_PROBATION);
    }

    public void validatePlatformPerson(Map<String, Object> checkMap, StringBuilder msg) {
        boolean result = (Boolean)checkMap.get("result");
        if (!result) {
            List repeatItems = (List)checkMap.get("checkbos");
            for (Map repeatItem : repeatItems) {
                String repeatkey = (String)repeatItem.get("repeatkey");
                if (REPEAT_KEY_EMAIL.equals(repeatkey)) {
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u6b64\u4e2a\u4eba\u7535\u5b50\u90ae\u7bb1\u3002", (String)"HRPIOnboardPersonInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                if (REPEAT_KEY_PHONE.equals(repeatkey)) {
                    CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u6b64\u624b\u673a\u53f7\u3002", (String)"HRPIOnboardPersonInitServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                if (!REPEAT_KEY_NUMBER.equals(repeatkey)) continue;
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u6b64\u5de5\u53f7\u3002", (String)"HRPIOnboardPersonInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    public Map<String, Map<String, Object>> getPlatformPerson(List<DynamicObject> data, Long execTaskId) {
        ArrayList checkList = Lists.newArrayListWithExpectedSize((int)data.size());
        Long count = HRPIServiceFactory.initService.countByExecTaskId(execTaskId);
        boolean isAllowInit = HRPIServiceFactory.initService.hasEnoughLicense(count);
        if (!isAllowInit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u521d\u59cb\u5316\u4eba\u5458\u6570\u91cf\u5df2\u8d85\u51fa\u8bb8\u53ef\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRPIOnboardPersonInitServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        data.forEach(item -> {
            HashMap check = Maps.newHashMapWithExpectedSize((int)5);
            check.put("personid", item.getString("id"));
            check.put(REPEAT_KEY_NAME, item.getString(REPEAT_KEY_NAME));
            check.put(REPEAT_KEY_NUMBER, item.getString(REPEAT_KEY_NUMBER));
            check.put(REPEAT_KEY_PHONE, item.getString(REPEAT_KEY_PHONE));
            check.put(REPEAT_KEY_EMAIL, item.getString("peremail"));
            checkList.add(check);
        });
        PersonServiceImpl.getInstance().doCheckPerson(checkList, true, false, "1");
        return checkList.stream().collect(Collectors.toMap(dy -> (String)dy.get("personid"), dy -> dy));
    }

    private void validateLaborRelTypeAndStatus(DynamicObject item, StringBuilder msg) {
        long typeId = item.getLong("laborreltype.id");
        DynamicObjectCollection typeCol = item.getDynamicObject("laborrelstatus").getDynamicObjectCollection("laborreltype");
        if (typeCol.stream().noneMatch(dy -> dy.getLong(BASE_DATA_ID) == typeId)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u201d\u548c\u201c\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u4e0d\u5339\u914d\u3002", (String)"HRPIEmpCommonInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void validatePhone(String phoneNumber, String tipInfo, StringBuilder errorMsg) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phoneNumber);
        if (!telephoneParseResult.isSuccess()) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat(telephoneParseResult.getErrorMsg()));
            return;
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat(ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef", (String)"HRPIOnboardPersonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            return;
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            CommonServiceUtil.addErrorMsg(errorMsg, tipInfo.concat((String)result.get("message")));
        }
    }
}

