/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.personemp;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPICmpempRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.personemp.HRPIPersonEmpCommonInitService;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public abstract class HRPIPersonEmpInitServiceImpl
extends HRPICommonInitService {
    protected final HRPIPersonEmpCommonInitService service = new HRPIPersonEmpCommonInitService();
    protected static final String EMPLOYEE_ID = "employeeid";
    protected static final String empSelProp = "id, person, startdate, empnumber";
    protected static final String entSelProp = "id, preemployee, person, firststartdate, oldempnumber, startdate, enddate";
    protected final Date maxDate = HRBaseUtils.getMaxEndDate();
    protected static final String NEWNUMBER = "newnumber";

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idMap = (Map)dysMap.get("idmapping");
        this.validate(data, idMap);
    }

    public abstract void validate(List<DynamicObject> var1, Map<Long, HashSet<Long>> var2);

    public abstract void beforeValidate(List<DynamicObject> var1);

    public abstract void beforeValidate(List<DynamicObject> var1, Map<Long, HashSet<Long>> var2);

    public abstract void customValidate(DynamicObject var1, StringBuilder var2);

    public abstract boolean isQuit();

    public abstract void cusBuildEmpEntRel(DynamicObject var1, DynamicObject var2);

    public abstract void cusRollback();

    public abstract void afterValidateEmpRepeat(Map<String, List<DynamicObject>> var1, DynamicObject var2);

    public abstract DynamicObjectCollection buildEmpNonEntCol(DynamicObjectCollection var1);

    @Override
    public abstract boolean businessSave(Map<String, Object> var1, Map<String, Object> var2);

    protected void sortDys(List<DynamicObject> dys, String key, String orderBy) {
        if (CollectionUtils.isEmpty(dys)) {
            dys.sort((o1, o2) -> {
                Date startDate1 = o1.getDate(key);
                Date startDate2 = o2.getDate(key);
                if (startDate1 == null && startDate2 == null) {
                    return 0;
                }
                if (startDate1 == null) {
                    return 1;
                }
                if (startDate2 == null) {
                    return -1;
                }
                if (orderBy.equals("1")) {
                    return startDate1.compareTo(startDate2);
                }
                return startDate2.compareTo(startDate1);
            });
        }
    }

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_person", "hrpi_pertsprop", "hrpi_percontact", "hrpi_perregion", "hrpi_employee", "hrpi_empentrel", "hrpi_empnonentrel");
    }

    protected void rollbackAll() {
        this.validateRollbackEmp();
        super.rollbackAll();
        this.cusRollback();
        this.rollbackOtherTableAll("hrpi_person", "hrpi_pertsprop", "hrpi_percontact", "hrpi_perregion", "hrpi_employee", "hrpi_empentrel", "hrpi_empnonentrel");
    }

    private void validateRollbackEmp() {
        String entityName = this.isQuit() ? "hrpi_quitmanagescope_init" : "hrpi_managingscope_init";
        Long batchNumber = (Long)this.getOtherMap().get(entityName);
        boolean isExist = HRPICmpempRepository.existByInitBatch(batchNumber);
        if (isExist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u6eda\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7684\u4efb\u804c\u7ecf\u5386\u6570\u636e\u3001\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u6570\u636e\u5fc5\u987b\u5168\u90e8\u56de\u6eda\u6210\u529f\uff0c\u624d\u53ef\u6267\u884c\u804c\u4e1a\u4fe1\u606f\u6570\u636e\u7684\u56de\u6eda\u3002", (String)"HRPIEmpCommonInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    protected Map<DynamicObjectType, long[]> getIdMap(List<DynamicObjectType> typeList, int size) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)typeList.size());
        typeList.forEach(type -> map.put(type, ORM.create().genLongIds((IDataEntityType)type, size)));
        return map;
    }

    protected DynamicObject buildPersonDy(DynamicObjectType type, DynamicObject item) {
        DynamicObject person = this.buildCommonDy(type, item, item.getLong("id"));
        person.set("number", item.get("number"));
        return person;
    }

    protected DynamicObject buildOnePerMoreEmpDy(DynamicObjectType type, DynamicObject item) {
        DynamicObject person = this.buildCommonDy(type, item, item.getLong("id"));
        person.set("number", item.get(NEWNUMBER));
        return person;
    }

    protected DynamicObject buildPerNonTsDy(DynamicObjectType type, Long id, DynamicObject item) {
        return this.buildDy(type, item, id);
    }

    protected DynamicObject buildPerTsDy(DynamicObjectType type, Long id, DynamicObject item, Date nowDate) {
        DynamicObject perTs = this.buildDy(type, item, id);
        perTs.set("bsed", (Object)nowDate);
        return perTs;
    }

    protected DynamicObject buildContact(DynamicObjectType type, Long id, DynamicObject item) {
        return this.buildDy(type, item, id);
    }

    protected DynamicObject buildRegion(DynamicObjectType type, Long id, DynamicObject item) {
        return this.buildDy(type, item, id);
    }

    protected DynamicObject buildEmployeeDy(DynamicObjectType type, DynamicObject empRel) {
        return this.buildCommonDy(type, empRel, empRel.getLong("employee"));
    }

    protected DynamicObject buildEmpEntRel(DynamicObjectType type, Long id, DynamicObject item) {
        DynamicObject dy = this.buildDy(type, item, id);
        Date startDate = item.getDate("startdate");
        dy.set("bsed", (Object)startDate);
        dy.set("firststartdate", (Object)startDate);
        dy.set("employee", item.get(EMPLOYEE_ID));
        dy.set("empnumber", (Object)item.getString("number"));
        this.cusBuildEmpEntRel(dy, item);
        return dy;
    }

    protected DynamicObject buildOnePersonMoreEmpEntRel(DynamicObjectType type, Long id, DynamicObject item, Long personId) {
        DynamicObject dy = this.buildOnePerMoreEmpDy(type, item, id, personId);
        Date startDate = item.getDate("startdate");
        dy.set("bsed", (Object)startDate);
        dy.set("firststartdate", (Object)startDate);
        dy.set("employee", item.get(EMPLOYEE_ID));
        dy.set("empnumber", (Object)item.getString("number"));
        dy.set("islatestrecord", (Object)"1");
        this.cusBuildEmpEntRel(dy, item);
        return dy;
    }

    protected DynamicObject buildDy(DynamicObjectType type, DynamicObject itemDy, Long id) {
        DynamicObject dy = this.buildCommonDy(type, itemDy, id);
        dy.set("person", itemDy.get("id"));
        return dy;
    }

    protected DynamicObject buildOnePerMoreEmpDy(DynamicObjectType type, DynamicObject itemDy, Long id, Long personId) {
        DynamicObject dy = this.buildCommonDy(type, itemDy, id);
        dy.set("person", (Object)personId);
        return dy;
    }

    protected DynamicObject buildCommonDy(DynamicObjectType type, DynamicObject itemDy, Long id) {
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSourceForInit(dy, itemDy);
        dy.set("id", (Object)id);
        dy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
        InitValidateUtil.wrapCommonFieldInit((DynamicObject)dy);
        return dy;
    }
}

