/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.personemp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.business.init.personemp.HRPIPersonEmpInitServiceImpl;
import kd.hrmp.hrpi.business.tools.PersonModelConfigUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.entity.OnePerMoreEmpInitEntity;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIQuitPersonEmpInitServiceImpl
extends HRPIPersonEmpInitServiceImpl {
    @Override
    public void validate(List<DynamicObject> data, Map<Long, HashSet<Long>> idMap) {
        this.setNumToNewNum(data);
        this.beforeValidate(data, idMap);
        Set<String> empNumberSet = data.stream().map(dy -> dy.getString("newnumber")).collect(Collectors.toSet());
        Set<String> oldNumSet = data.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
        DynamicObject[] personsByNumberDys = HRPIPersonRepository.getPersonsByNumber("id, number", empNumberSet, new HashSet<String>(), "modifytime desc");
        Map<Object, Object> numPersonIdMap = new HashMap(data.size());
        Map<Object, Object> personIdEmpMap = new HashMap(data.size());
        Map<String, List<DynamicObject>> empNumEmpMap = HRPIEmployeeRepository.listEmployeesByNumbers("id,startdate,enddate,empnumber", oldNumSet).stream().collect(Collectors.groupingBy(dy -> dy.getString("empnumber")));
        if (personsByNumberDys != null) {
            numPersonIdMap = Arrays.stream(personsByNumberDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (oldVal, newVal) -> newVal));
            List<Long> personIds = Arrays.stream(personsByNumberDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            personIdEmpMap = Arrays.stream(HRPIEmployeeRepository.listEmpByPersonIds("id,person,startdate,enddate,empnumber", personIds)).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        }
        for (DynamicObject item : data) {
            List empsList;
            Long id = item.getLong("id");
            Long midId = idMap.get(id).iterator().next();
            String newNum = item.getString("newnumber");
            String oldNum = item.getString("number");
            Map outMessageMap = this.getInitOutParam().getData();
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, idMap, (DynamicObject)item)) continue;
            StringBuilder errorMsg = new StringBuilder();
            this.service.validatePerson(item, errorMsg);
            this.service.validateEmp(item, errorMsg);
            if (numPersonIdMap.get(newNum) != null && (Long)numPersonIdMap.get(newNum) != 0L) {
                empsList = (List)personIdEmpMap.get(numPersonIdMap.get(newNum));
                this.validateEmpRepeat(item, empsList, errorMsg);
            }
            if (empNumEmpMap.get(oldNum) != null) {
                empsList = empNumEmpMap.get(oldNum);
                this.validateEmpRepeat(item, empsList, errorMsg);
            }
            this.customValidate(item, errorMsg);
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)errorMsg.toString());
        }
    }

    @Override
    public void beforeValidate(List<DynamicObject> data) {
    }

    @Override
    public void beforeValidate(List<DynamicObject> data, Map<Long, HashSet<Long>> idMap) {
        Map<String, List<DynamicObject>> newnumItems = data.stream().collect(Collectors.groupingBy(item -> item.getString("newnumber")));
        for (Map.Entry<String, List<DynamicObject>> entry : newnumItems.entrySet()) {
            List<DynamicObject> items = entry.getValue();
            this.checkDateIsCross(items, idMap);
        }
    }

    private void checkDateIsCross(List<DynamicObject> items, Map<Long, HashSet<Long>> idMap) {
        for (DynamicObject dy : items) {
            StringBuilder errorMsg = new StringBuilder();
            long id = dy.getLong("id");
            Long midId = idMap.get(id).iterator().next();
            Date startDate = dy.getDate("startdate");
            Date endDate = dy.getDate("enddate");
            boolean flag = items.stream().filter(item -> item.getLong("id") != id).anyMatch(item -> item.getDate("startdate").compareTo(endDate) <= 0 && item.getDate("enddate").compareTo(startDate) >= 0);
            if (!flag) continue;
            CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"Excel\u4e2d\u5df2\u5b58\u5728\u8be5\u5de5\u53f7\u5458\u5de5\u7684\u804c\u4e1a\u4fe1\u606f\u3002", (String)"HRPIQuitPersonEmpInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)errorMsg.toString());
        }
    }

    protected void validateEmpRepeat(DynamicObject item, List<DynamicObject> dyList, StringBuilder errorMsg) {
        if (CollectionUtils.isEmpty(dyList)) {
            return;
        }
        Date endDate = item.getDate("enddate");
        Date startDate = item.getDate("startdate");
        boolean flag = dyList.stream().anyMatch(dy -> dy.getDate("startdate").compareTo(endDate) <= 0 && dy.getDate("enddate").compareTo(startDate) >= 0);
        if (flag) {
            CommonServiceUtil.addErrorMsg(errorMsg, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u5de5\u53f7\u7684\u804c\u4e1a\u4fe1\u606f\u3002", (String)"HRPIEmpCommonInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void customValidate(DynamicObject item, StringBuilder msg) {
        this.service.validateQuitEmp(item, msg);
    }

    @Override
    public void cusBuildEmpEntRel(DynamicObject target, DynamicObject source) {
        target.set("businessstatus", (Object)"1");
        target.set("labrelstatusprd", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
    }

    @Override
    public void afterValidateEmpRepeat(Map<String, List<DynamicObject>> empMap, DynamicObject item) {
    }

    @Override
    public void cusRollback() {
    }

    @Override
    public DynamicObjectCollection buildEmpNonEntCol(DynamicObjectCollection empEntRelCol) {
        MainEntityType empNonEntType = EntityMetadataCache.getDataEntityType((String)"hrpi_empnonentrel");
        DynamicObjectCollection empNonEntCol = new DynamicObjectCollection((DynamicObjectType)empNonEntType, null);
        long[] ids = ORM.create().genLongIds((IDataEntityType)empNonEntType, empEntRelCol.size());
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < empEntRelCol.size(); ++i) {
            DynamicObject source = (DynamicObject)empEntRelCol.get(i);
            calendar.setTime(source.getDate("enddate"));
            calendar.add(5, 1);
            Date startDate = calendar.getTime();
            DynamicObject dy = this.buildCommonDy((DynamicObjectType)empNonEntType, source, ids[i]);
            dy.set("bsed", (Object)startDate);
            dy.set("startdate", (Object)startDate);
            dy.set("enddate", (Object)this.maxDate);
            dy.set("businessstatus", (Object)"1");
            empNonEntCol.add((Object)dy);
        }
        return empNonEntCol;
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType personType = EntityMetadataCache.getDataEntityType((String)"hrpi_person");
        DynamicObjectCollection personCol = new DynamicObjectCollection((DynamicObjectType)personType, null);
        MainEntityType perNonTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pernontsprop");
        DynamicObjectCollection perNonTsCol = new DynamicObjectCollection((DynamicObjectType)perNonTsType, null);
        MainEntityType perTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pertsprop");
        DynamicObjectCollection perTsCol = new DynamicObjectCollection((DynamicObjectType)perTsType, null);
        MainEntityType contactType = EntityMetadataCache.getDataEntityType((String)"hrpi_percontact");
        DynamicObjectCollection contactCol = new DynamicObjectCollection((DynamicObjectType)contactType, null);
        MainEntityType regionType = EntityMetadataCache.getDataEntityType((String)"hrpi_perregion");
        DynamicObjectCollection regionCol = new DynamicObjectCollection((DynamicObjectType)regionType, null);
        MainEntityType empType = EntityMetadataCache.getDataEntityType((String)"hrpi_employee");
        DynamicObjectCollection empCol = new DynamicObjectCollection((DynamicObjectType)empType, null);
        MainEntityType empEntRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empentrel");
        DynamicObjectCollection empEntRelCol = new DynamicObjectCollection((DynamicObjectType)empEntRelType, null);
        ArrayList typeList = Lists.newArrayList((Object[])new DynamicObjectType[]{perNonTsType, perTsType, contactType, regionType, empType, empEntRelType});
        Map<DynamicObjectType, long[]> idMap = this.getIdMap(typeList, data.size());
        Date nowDate = HRDateTimeUtils.getNowDate();
        this.setNumToNewNum(data);
        boolean isConfigOn = PersonModelConfigUtil.configOn();
        boolean isNumMul = false;
        Set<String> numSet = data.stream().map(dy -> dy.getString("newnumber")).collect(Collectors.toSet());
        DynamicObject[] personsByNumberDys = HRPIPersonRepository.getPersonsByNumber("id,number", numSet, new HashSet<String>(), "createtime desc");
        Map<Object, Object> numPersonMap = new HashMap(data.size());
        if (personsByNumberDys != null && personsByNumberDys.length > 0) {
            isNumMul = true;
            numPersonMap = Arrays.stream(personsByNumberDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (oldVal, newVal) -> newVal));
        }
        Map<String, List<DynamicObject>> newnumDatas = data.stream().collect(Collectors.groupingBy(dy -> dy.getString("newnumber")));
        HashMap<String, OnePerMoreEmpInitEntity> numInitEntityMap = new HashMap<String, OnePerMoreEmpInitEntity>(data.size());
        int i = -1;
        for (Map.Entry<String, List<DynamicObject>> entry : newnumDatas.entrySet()) {
            String newnum = entry.getKey();
            List<DynamicObject> dyList = entry.getValue();
            for (DynamicObject item : dyList) {
                ++i;
                if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
                if (isConfigOn) {
                    DynamicObject personDy = (DynamicObject)numPersonMap.get(newnum);
                    if (isNumMul && personDy != null) {
                        item.set("employeeid", (Object)idMap.get(empType)[i]);
                        long personId = personDy.getLong("id");
                        DynamicObject empEntRel = this.buildOnePersonMoreEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item, personId);
                        empEntRelCol.add((Object)empEntRel);
                        empCol.add((Object)this.buildEmployeeDy((DynamicObjectType)empType, empEntRel));
                        continue;
                    }
                    OnePerMoreEmpInitEntity initEntity = (OnePerMoreEmpInitEntity)numInitEntityMap.get(newnum);
                    if (initEntity == null || !initEntity.isPersonCreateFlag()) {
                        item.set("employeeid", (Object)idMap.get(empType)[i]);
                        personCol.add((Object)this.buildOnePerMoreEmpDy((DynamicObjectType)personType, item));
                        perNonTsCol.add((Object)this.buildPerNonTsDy((DynamicObjectType)perNonTsType, idMap.get(perNonTsType)[i], item));
                        perTsCol.add((Object)this.buildPerTsDy((DynamicObjectType)perTsType, idMap.get(perTsType)[i], item, nowDate));
                        contactCol.add((Object)this.buildContact((DynamicObjectType)contactType, idMap.get(contactType)[i], item));
                        regionCol.add((Object)this.buildRegion((DynamicObjectType)regionType, idMap.get(regionType)[i], item));
                        DynamicObject empEntRel = this.buildEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item);
                        empEntRelCol.add((Object)empEntRel);
                        empCol.add((Object)this.buildEmployeeDy((DynamicObjectType)empType, empEntRel));
                        initEntity = new OnePerMoreEmpInitEntity(newnum, true, item.getLong("id"));
                        numInitEntityMap.put(newnum, initEntity);
                        continue;
                    }
                    item.set("employeeid", (Object)idMap.get(empType)[i]);
                    long personId = initEntity.getPersonId();
                    DynamicObject empEntRel = this.buildOnePersonMoreEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item, personId);
                    empEntRelCol.add((Object)empEntRel);
                    empCol.add((Object)this.buildEmployeeDy((DynamicObjectType)empType, empEntRel));
                    continue;
                }
                item.set("employeeid", (Object)idMap.get(empType)[i]);
                personCol.add((Object)this.buildOnePerMoreEmpDy((DynamicObjectType)personType, item));
                perNonTsCol.add((Object)this.buildPerNonTsDy((DynamicObjectType)perNonTsType, idMap.get(perNonTsType)[i], item));
                perTsCol.add((Object)this.buildPerTsDy((DynamicObjectType)perTsType, idMap.get(perTsType)[i], item, nowDate));
                contactCol.add((Object)this.buildContact((DynamicObjectType)contactType, idMap.get(contactType)[i], item));
                regionCol.add((Object)this.buildRegion((DynamicObjectType)regionType, idMap.get(regionType)[i], item));
                DynamicObject empEntRel = this.buildEmpEntRel((DynamicObjectType)empEntRelType, idMap.get(empEntRelType)[i], item);
                empEntRelCol.add((Object)empEntRel);
                empCol.add((Object)this.buildEmployeeDy((DynamicObjectType)empType, empEntRel));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)empCol)) {
            DynamicObjectCollection empNonEntCol = this.buildEmpNonEntCol(empEntRelCol);
            Map<String, Object> paramMap = this.buildDatasByCollection(personCol, perNonTsCol, perTsCol, contactCol, regionCol, empCol, empEntRelCol, empNonEntCol);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private void setNumToNewNum(List<DynamicObject> data) {
        for (DynamicObject item : data) {
            if (!HRStringUtils.isEmpty((String)item.getString("newnumber"))) continue;
            item.set("newnumber", (Object)item.getString("number"));
        }
    }

    @Override
    public boolean isQuit() {
        return true;
    }
}

