/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.reentry;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.generic.entity.reentry.EmpnumberAndStartDateEntity;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPIReEntryInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOGGER = LogFactory.getLog(HRPIReEntryInitServiceImpl.class);
    private static String[] REENTRY_PROPS = new String[]{"empnumber", "oldempnumber", "serviceagescheme", "inheritnumber", "startdate", "oldstartdate"};

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map midIdMap = (Map)dysMap.get("idmapping");
        MainEntityType reentryrelateType = EntityMetadataCache.getDataEntityType((String)"hrpi_reentryrelate_init");
        DynamicObjectCollection reentryrelateCollection = new DynamicObjectCollection((DynamicObjectType)reentryrelateType, null);
        for (DynamicObject item : data) {
            DynamicObject newRewardDy = CommonServiceUtil.buildDy((DynamicObjectType)reentryrelateType, item, REENTRY_PROPS);
            reentryrelateCollection.add((Object)newRewardDy);
        }
        if (CollectionUtils.isEmpty((Collection)reentryrelateCollection)) {
            LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate reentryrelateCollection is empty.");
            return;
        }
        Map<String, Object> paramMap = this.buildDatasByCollection(reentryrelateCollection);
        Map<String, Object> result = this.personGenericService.validate(paramMap);
        boolean success = (Boolean)result.get("success");
        if (success) {
            LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate validate success.");
            for (DynamicObject item : data) {
                long id = item.getLong("id");
                Long midId = (Long)((HashSet)midIdMap.get(id)).iterator().next();
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)"");
            }
        } else {
            List errInfoMapList = (List)result.get("errInfos");
            LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate errInfoMapList:{}", (Object)errInfoMapList);
            Map errInfoMap = (Map)errInfoMapList.get(0);
            String exceptionMessage = (String)errInfoMap.get("exceptionMessage");
            List errorDataList = (List)errInfoMap.get("errorDatas");
            Map<EmpnumberAndStartDateEntity, String> errorDataMap = errorDataList.stream().collect(Collectors.toMap(errorData -> {
                String errorEmpnumberEntityStr = (String)errorData.get("id");
                return (EmpnumberAndStartDateEntity)SerializationUtils.fromJsonString((String)errorEmpnumberEntityStr, EmpnumberAndStartDateEntity.class);
            }, errorData -> (String)errorData.get("errMsg")));
            LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate errorDataMap:{}", errorDataMap);
            for (DynamicObject item : data) {
                StringBuilder msg = new StringBuilder();
                if (HRStringUtils.isNotEmpty((String)exceptionMessage)) {
                    CommonServiceUtil.addErrorMsg(msg, exceptionMessage);
                }
                EmpnumberAndStartDateEntity empnumberAndStartDateEntity = EmpnumberAndStartDateEntity.buildEmp((DynamicObject)item);
                LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate empnumberAndStartDateEntity:{}", (Object)empnumberAndStartDateEntity);
                String errMsg = errorDataMap.get(empnumberAndStartDateEntity);
                LOGGER.info("HRPIReEntryInitServiceImpl#businessValidate errMsg:{}", (Object)errMsg);
                if (HRStringUtils.isNotEmpty((String)errMsg)) {
                    CommonServiceUtil.addErrorMsg(msg, errMsg);
                }
                long id = item.getLong("id");
                Long midId = (Long)((HashSet)midIdMap.get(id)).iterator().next();
                InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
            }
        }
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        MainEntityType reentryrelateType = EntityMetadataCache.getDataEntityType((String)"hrpi_reentryrelate_init");
        DynamicObjectCollection reentryrelateCollection = new DynamicObjectCollection((DynamicObjectType)reentryrelateType, null);
        Map outMessageMap = this.getInitOutParam().getData();
        for (DynamicObject item : data) {
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            DynamicObject newRewardDy = CommonServiceUtil.buildDy((DynamicObjectType)reentryrelateType, item, REENTRY_PROPS);
            reentryrelateCollection.add((Object)newRewardDy);
        }
        if (!CollectionUtils.isEmpty((Collection)reentryrelateCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(reentryrelateCollection);
            Map<String, Object> result = this.personGenericService.saveBatchStandard(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    public void rollback() {
        LOGGER.info("HRPIReEntryInitServiceImpl#rollback");
    }

    public void changeStatus() {
        LOGGER.info("HRPIReEntryInitServiceImpl#changeStatus");
    }
}

