/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.init.trialperiod;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.init.HRPICommonInitService;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class HRPITrialPeriodInitServiceImpl
extends HRPICommonInitService {
    private static final Log LOGGER = LogFactory.getLog(HRPITrialPeriodInitServiceImpl.class);

    @Override
    public void businessValidate(Map<String, Object> map, Map<String, Object> dysMap) {
        LOGGER.info("HRPITrialPeriodInitServiceImpl#businessValidate start");
        List data = (List)dysMap.get("data");
        Map midIdMap = (Map)dysMap.get("idmapping");
        this.initData(data);
        Set<Long> empIds = data.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
        Set<Long> trialSet = CommonServiceUtil.existsEmpIdByEmp(empIds, "hrpi_trialperiod");
        Set<Long> trialPeriodRstSet = CommonServiceUtil.existsEmpIdByEmp(empIds, "hrpi_trialperiodrst");
        HashSet empIdSet = Sets.newHashSetWithExpectedSize((int)data.size());
        for (DynamicObject item : data) {
            String regStatus;
            StringBuilder msg = new StringBuilder();
            Long id = (Long)item.get("id");
            Long midId = (Long)((HashSet)midIdMap.get(id)).iterator().next();
            Long empId = item.getLong("employee.id");
            if (empId != 0L && !empIdSet.add(empId)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u8bd5\u7528\u671f\u4fe1\u606f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRPITrialPeriodInitServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            CommonServiceUtil.checkIsEmployee(msg, item.getDynamicObject("employee"));
            if (trialSet.contains(empId)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u8bd5\u7528\u671f\u4fe1\u606f\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"HRPITrialPeriodInitServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (trialPeriodRstSet.contains(empId)) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u5458\u5de5\u8bd5\u7528\u671f\u7ed3\u679c\u4fe1\u606f\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"HRPITrialPeriodInitServiceImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            this.checkDateValidate(item, msg);
            DynamicObject employeeInfo = item.getDynamicObject("employee");
            if (employeeInfo != null) {
                Date startDate = employeeInfo.getDate("startDate");
                this.checkRegularDateValidate(item, startDate, msg);
                CommonServiceUtil.checkEndDate(msg, item);
            }
            if (HRStringUtils.isEmpty((String)(regStatus = item.getString("regstatus")))) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u8f6c\u6b63\u8f6c\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPITrialPeriodInitServiceImpl_13", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            InitValidateUtil.addMsg((InitOutParam)this.getInitOutParam(), (Long)midId, (String)String.valueOf(id), (String)msg.toString());
        }
    }

    private void checkRegularDateValidate(DynamicObject dynamicObject, Date entryDate, StringBuilder msg) {
        Date preRegularDate;
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("endDate");
        String startDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u3002", (String)"HRPITrialPeriodInitServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(entryDate, startDate, msg, startDateStr, "1");
        Date realRegularDate = dynamicObject.getDate("realregulardate");
        if (realRegularDate != null) {
            String rrDateStr1 = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u65e9\u4e8e\u6700\u5927\u65e5\u671f\u201c2999-12-31\u201d\u3002", (String)"HRPITrialPeriodInitServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            CommonServiceUtil.checkDate(realRegularDate, HRBaseUtils.getMaxEndDate(), msg, rrDateStr1, "1");
            String rrDateStr2 = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u3002", (String)"HRPITrialPeriodInitServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            CommonServiceUtil.checkDate(entryDate, realRegularDate, msg, rrDateStr2, "1");
        }
        if ((preRegularDate = dynamicObject.getDate("preregulardate")) != null) {
            String prDateStr2 = ResManager.loadKDString((String)"\u9884\u8f6c\u6b63\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u3002", (String)"HRPITrialPeriodInitServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            CommonServiceUtil.checkDate(entryDate, preRegularDate, msg, prDateStr2, "1");
        }
        if (Objects.isNull(endDate) && Objects.isNull(realRegularDate)) {
            CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u548c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"HRPITrialPeriodInitServiceImpl_12", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.nonNull(endDate) && Objects.nonNull(realRegularDate) && (DateUtil.compareDate(endDate, HRBaseUtils.getMaxEndDate()) != 0 || DateUtil.compareDate(realRegularDate, HRBaseUtils.getMaxEndDate()) != 0)) {
            if (DateUtil.compareDate(endDate, startDate) == 0 && DateUtil.compareDate(endDate, realRegularDate) == 0) {
                return;
            }
            if (DateUtil.compareDate(endDate, HRDateTimeUtils.addDay((Date)realRegularDate, (long)-1L)) != 0) {
                CommonServiceUtil.addErrorMsg(msg, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u7b49\u4e8e\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u524d\u4e00\u5929\u3002", (String)"HRPITrialPeriodInitServiceImpl_11", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void initData(List<DynamicObject> data) {
        CommonServiceUtil.initEmpAndNewPerson(data, "startdate", null);
    }

    @Override
    public boolean businessSave(Map<String, Object> map, Map<String, Object> dysMap) {
        LOGGER.info("HRPITrialPeriodInitServiceImpl#businessSave start");
        List data = (List)dysMap.get("data");
        Map idmapping = (Map)dysMap.get("idmapping");
        MainEntityType trialPeriodType = EntityMetadataCache.getDataEntityType((String)"hrpi_trialperiod");
        DynamicObjectCollection trialPeriodCollection = new DynamicObjectCollection((DynamicObjectType)trialPeriodType, null);
        Map outMessageMap = this.getInitOutParam().getData();
        MainEntityType trialPeriodRstType = EntityMetadataCache.getDataEntityType((String)"hrpi_trialperiodrst");
        String[] needImpPros = this.getImportFields((DynamicObjectType)trialPeriodType);
        DynamicObjectCollection trialPeriodRstCollection = new DynamicObjectCollection((DynamicObjectType)trialPeriodRstType, null);
        long[] longIds = ORM.create().genLongIds("hrpi_trialperiodrst", data.size());
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject item = (DynamicObject)data.get(i);
            if (!InitValidateUtil.checkDateStatus((Map)outMessageMap, (Map)idmapping, (DynamicObject)item)) continue;
            this.dealEndDateAndRealregularDate(item);
            DynamicObject newRewardDy = CommonServiceUtil.buildDy((DynamicObjectType)trialPeriodType, (DynamicObject)data.get(i), needImpPros);
            newRewardDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            newRewardDy.set("bsed", (Object)item.getDate("startdate"));
            DynamicObject employeeDynamicObject = item.getDynamicObject("employee");
            newRewardDy.set("entrydate", employeeDynamicObject.get("startdate"));
            CommonServiceUtil.setEmpAndNewPerson(newRewardDy, item);
            newRewardDy.set("businessstatus", (Object)"1");
            this.caculatePreregulardate(item, newRewardDy);
            DynamicObject newRstDy = (DynamicObject)trialPeriodRstType.createInstance();
            InitValidateUtil.wrapCommonFieldInit((DynamicObject)newRstDy);
            newRstDy.set("initbatch", (Object)this.getInitInParam().getBatchNumber());
            newRstDy.set("probationid", (Object)newRewardDy.getLong("id"));
            newRstDy.set("id", (Object)longIds[i]);
            newRstDy.set("person", newRewardDy.get("person"));
            newRstDy.set("employee", newRewardDy.get("employee"));
            newRstDy.set("bsed", (Object)newRewardDy.getDate("bsed"));
            newRstDy.set("probationrst", newRewardDy.get("trialperiodrst"));
            newRstDy.set("startdate", (Object)item.getDate("startdate"));
            newRstDy.set("enddate", (Object)item.getDate("enddate"));
            newRstDy.set("businessstatus", (Object)"1");
            newRstDy.set("sysenddate", item.get("sysenddate"));
            trialPeriodCollection.add((Object)newRewardDy);
            trialPeriodRstCollection.add((Object)newRstDy);
        }
        if (!CollectionUtils.isEmpty((Collection)trialPeriodCollection)) {
            Map<String, Object> paramMap = this.buildDatasByCollection(trialPeriodCollection, trialPeriodRstCollection);
            Map<String, Object> result = this.personGenericService.saveBatch(paramMap);
            return (Boolean)result.get("success");
        }
        return true;
    }

    private void dealEndDateAndRealregularDate(DynamicObject item) {
        Date realregulardate = item.getDate("realregulardate");
        Date enddate = item.getDate("enddate");
        Date startdate = item.getDate("startdate");
        if (null != realregulardate && null == enddate) {
            if (DateUtil.compareDate(realregulardate, HRBaseUtils.getMaxEndDate()) == 0 || DateUtil.compareDate(realregulardate, startdate) == 0) {
                item.set("enddate", (Object)realregulardate);
                item.set("sysenddate", (Object)realregulardate);
            } else {
                item.set("enddate", (Object)HRDateTimeUtils.addDay((Date)realregulardate, (long)-1L));
            }
        } else if (null != enddate && null == realregulardate) {
            if (DateUtil.compareDate(enddate, HRBaseUtils.getMaxEndDate()) == 0 || DateUtil.compareDate(enddate, startdate) == 0) {
                item.set("realregulardate", (Object)enddate);
                item.set("sysenddate", (Object)enddate);
            } else {
                item.set("realregulardate", (Object)HRDateTimeUtils.addDay((Date)enddate, (long)1L));
            }
        }
    }

    private void caculatePreregulardate(DynamicObject item, DynamicObject newRewardDy) {
        if (newRewardDy.getDate("preregulardate") == null) {
            Date startdate;
            int probation = newRewardDy.getInt("probation");
            int probationunit = newRewardDy.getInt("probationunit");
            Date date = startdate = item.getDate("startdate");
            if (startdate != null) {
                switch (probationunit) {
                    case 1: {
                        date = HRDateTimeUtils.addMonth((Date)startdate, (int)probation);
                        break;
                    }
                    case 2: {
                        date = HRDateTimeUtils.addDay((Date)startdate, (long)(probation * 7));
                        break;
                    }
                    case 3: {
                        date = HRDateTimeUtils.addDay((Date)startdate, (long)probation);
                        break;
                    }
                }
                newRewardDy.set("preregulardate", (Object)date);
            }
        }
    }

    private void checkDateValidate(DynamicObject item, StringBuilder msg) {
        Date startDate = item.getDate("startdate");
        Date endDate = item.getDate("enddate");
        String sdDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HRPITrialPeriodInitServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(startDate, new Date(), msg, sdDateStr, "1");
        String bsDateStr = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"HRPITrialPeriodInitServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(startDate, endDate, msg, bsDateStr, "1");
        Date bigDate = HRBaseUtils.getMaxEndDate();
        String bigDateStr = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c2999-12-31\u201d\u3002", (String)"HRPITrialPeriodInitServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        CommonServiceUtil.checkDate(endDate, bigDate, msg, bigDateStr, "1");
    }

    protected void rollbackAll() {
        super.rollbackAll();
        this.rollbackOtherTableAll("hrpi_trialperiodrst");
    }

    public void changeStatus() {
        super.changeStatus();
        this.changeOtherTableStatus("hrpi_trialperiodrst");
        this.changeIsProbationStatus();
    }

    private void changeIsProbationStatus() {
        String targetStatus = this.getTargetStatus();
        if (HRStringUtils.equals((String)targetStatus, (String)"2")) {
            String entityCode = this.getInitInParam().getEntityNumber();
            QFilter[] batchQFiler = new QFilter[]{new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter("initstatus", "=", (Object)this.getTargetStatus())};
            int count = new ORMImpl().count("QueryServiceHelper." + entityCode, entityCode, batchQFiler);
            int pageCount = (int)Math.ceil((double)count / 10000.0);
            LOGGER.info("changestatus:initbatch={}, entityCode={}, pageCount={}, length={}", new Object[]{this.getInitInParam().getBatchNumber(), entityCode, pageCount, count});
            if (count > 0) {
                for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                    DynamicObject[] trialPeriodDynArr = BusinessDataServiceHelper.load((String)entityCode, (String)"employee", (QFilter[])batchQFiler, (String)"id", (int)0, (int)10000);
                    List employeeIdList = Arrays.stream(trialPeriodDynArr).map(dyn -> dyn.getLong("employee.id")).collect(Collectors.toList());
                    QFilter employeeFilter = new QFilter("employee", "in", employeeIdList);
                    QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
                    HRBaseServiceHelper empEntrelServiceHelper = new HRBaseServiceHelper("hrpi_empentrel");
                    DynamicObject[] empEntrelDynArr = empEntrelServiceHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter, dataStatusFilter});
                    this.changeIsProbation(empEntrelDynArr);
                    SaveServiceHelper.save((DynamicObject[])empEntrelDynArr);
                }
            }
        }
    }

    private void changeIsProbation(DynamicObject[] dynamicObjects) {
        Date now = new Date();
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("isprobation", (Object)"1");
            dynamicObject.set("modifytime", (Object)now);
        }
    }
}

