/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.privacy;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.privacy.IPrivacyDataPermissionService;
import kd.bos.db.privacy.IPrivacyEncryptService;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.service.PrivacyCenterService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HRPrivacyService
extends PrivacyCenterService {
    private static final Log LOGGER = LogFactory.getLog(PrivacyCenterService.class);

    public Map<String, List<Map<String, Object>>> getDesensitizeValues(String operateType, String entityNum, DynamicObject[] dynamicObjects) {
        String localeId = RequestContext.get().getLang().toString();
        if (dynamicObjects == null) {
            LOGGER.warn("No object need to desensitize");
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        if (PrivacyDataCenterManager.isEnable()) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                DataEntityPropertyCollection plainProps = dynamicObject.getDataEntityType().getProperties();
                List entityList = result.computeIfAbsent(entityNum, value -> new ArrayList());
                HashMap entityMap = Maps.newHashMapWithExpectedSize((int)plainProps.size());
                DynamicObject dynamicObjectTrue = BusinessDataServiceHelper.newDynamicObject((String)entityNum);
                DataEntityPropertyCollection props = dynamicObjectTrue.getDataEntityType().getProperties();
                plainProps.forEach(plainProp -> {
                    String fieldIdent = plainProp.getName();
                    LOGGER.debug("desensitize object:{},field:{}", (Object)entityNum, (Object)fieldIdent);
                    if (!StringUtils.isEmpty((String)entityNum) && !StringUtils.isEmpty((String)fieldIdent)) {
                        Object value = dynamicObject.get(fieldIdent);
                        if (this.isDesensitizeField((IDataEntityProperty)props.get((Object)fieldIdent), localeId, operateType, dynamicObjectTrue)) {
                            value = this.doDesensitize(operateType, entityNum, localeId, dynamicObject, fieldIdent, value);
                        }
                        entityMap.put(fieldIdent, value);
                    }
                });
                entityList.add(entityMap);
            }
        } else {
            for (DynamicObject dynamicObject : dynamicObjects) {
                List entityList = result.computeIfAbsent(entityNum, value -> new ArrayList());
                entityList.add(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
            }
        }
        return result;
    }

    public Object doDesensitize(String operateType, String entityNum, String localeId, DynamicObject dynamicObject, String fieldIdent, Object value) {
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        IPrivacyDataPermissionService permissionService = PrivacyDataCenterManager.getPermissionService();
        String strategy = permissionService.getDesensitizeStrategy(entityNum, fieldIdent, operateType);
        return "PLAINTEXT".equals(strategy) ? value : service.getDesensitizeValue(entityNum, fieldIdent, localeId, (Object)dynamicObject, value);
    }

    public Map<String, List<Map<String, Object>>> getDesensitizeValuesNoPlain(String operateType, DynamicObject[] dynamicObjects) {
        String localeId = RequestContext.get().getLang().toString();
        if (dynamicObjects == null) {
            LOGGER.warn("No object need to desensitize");
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        if (PrivacyDataCenterManager.isEnable()) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                IDataEntityType entityType = dynamicObject.getDataEntityType();
                if (null == entityType) {
                    LOGGER.warn("No entity type, dynamicObject:{}", (Object)dynamicObject.toString());
                    continue;
                }
                String entityNum = this.getEntityNumber(entityType);
                DataEntityPropertyCollection props = entityType.getProperties();
                List entityList = result.computeIfAbsent(entityNum, value -> new ArrayList());
                HashMap entityMap = Maps.newHashMapWithExpectedSize((int)props.size());
                props.forEach(prop -> {
                    String fieldIdent = prop.getName();
                    LOGGER.debug("desensitize object:{},field:{}", (Object)entityNum, (Object)fieldIdent);
                    if (!StringUtils.isEmpty((String)entityNum) && !StringUtils.isEmpty((String)fieldIdent)) {
                        Object value = dynamicObject.get(fieldIdent);
                        if (this.isDesensitizeField((IDataEntityProperty)prop, localeId, operateType, dynamicObject)) {
                            value = this.doDesensitize(operateType, entityNum, localeId, dynamicObject, fieldIdent, value);
                        }
                        entityMap.put(fieldIdent, value);
                    }
                });
                entityList.add(entityMap);
            }
        } else {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String entityNum = this.getEntityNumber(dynamicObject.getDataEntityType());
                List entityList = result.computeIfAbsent(entityNum, value -> new ArrayList());
                entityList.add(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
            }
        }
        return result;
    }

    public Map<String, List<Map<String, Object>>> getDesensitizeValuesNoPlain(DynamicObject[] dynamicObjects) {
        return this.getDesensitizeValuesNoPlain("FORM", dynamicObjects);
    }

    private String getEntityNumber(IDataEntityType entityType) {
        String entityNum = null;
        while (entityType != null) {
            entityNum = entityType instanceof QueryEntityType ? ((QueryEntityType)entityType).getEntityName() : entityType.getName();
            entityType = entityType.getParent();
        }
        return entityNum;
    }
}

