/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.generic.IPersonGenericService;
import kd.hrmp.hrpi.common.util.InitValidateUtil;

public class AddWorkRoleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AddWorkRoleTask.class);
    private final IPersonGenericService personGenericService = HRPIServiceFactory.personGenericService;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String props = "id,bsed,person,description,enddate,position,position.workrole,position.workrole.mainpeoincharge,position.workrole.adminorg,depemp,businessstatus,employee,adminorg,sysenddate,startdate,cmpemp,stdposition,apositiontype,initbatch";
        LOGGER.info("handleWorkRoleStart");
        int batchCount = 1000;
        List<Long> temp = null;
        DynamicObject[] depArray = null;
        long id = 0L;
        try {
            while ((temp = HRPIDepempRepository.queryWorkRole(id, batchCount)).size() > 0) {
                depArray = HRPIDepempRepository.listEmpposOrgrelDysByProps(temp, props);
                DynamicObjectCollection workRoles = this.addNewWorkRole(depArray);
                Map<String, Object> paramMap = this.buildDatasByCollection(workRoles);
                this.personGenericService.saveBatch(paramMap);
                if (temp.size() >= batchCount) {
                    id = temp.get(temp.size() - 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("customBatchWorkRole_ex", (Throwable)ex);
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("2XQ/TJMOURJY");
        scheduleManager.disableSchedule("2XQ/PY/W/FPX");
        LOGGER.info("handleWorkRoleFinish");
    }

    private Map<String, Object> buildDatasByCollection(DynamicObjectCollection collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)10);
        HashMap item = Maps.newHashMapWithExpectedSize((int)1);
        item.put("hisDyns", collections);
        datas.add(item);
        paramMap.put("caller", "initialize");
        paramMap.put("data", datas);
        paramMap.put("mustAllSuccess", Boolean.FALSE);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }

    private DynamicObjectCollection addNewWorkRole(DynamicObject[] depArray) {
        MainEntityType workRoleType = EntityMetadataCache.getDataEntityType((String)"hrpi_personrolerel");
        Map<Object, Object> postMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection workRoleCollection = new DynamicObjectCollection((DynamicObjectType)workRoleType, null);
        long[] workRoleIds = ORM.create().genLongIds((IDataEntityType)workRoleType, depArray.length);
        List postPkId = Arrays.stream(depArray).filter(dy -> dy.getLong("position.id") != 0L).map(dy -> dy.getLong("position.id")).collect(Collectors.toList());
        HRBaseServiceHelper postHelper = new HRBaseServiceHelper("hbpm_positionhr");
        Object[] postDys = postHelper.query("id,workrole,workrole.mainpeoincharge,workrole.adminorg", new QFilter[]{new QFilter("id", "in", postPkId)});
        if (HRArrayUtils.isNotEmpty((Object[])postDys)) {
            postMap = Arrays.stream(postDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        }
        for (int idx = 0; idx < depArray.length; ++idx) {
            long id = workRoleIds[idx];
            DynamicObject depDy = depArray[idx];
            DynamicObject workRoleDy = (DynamicObject)workRoleType.createInstance();
            workRoleDy.set("id", (Object)id);
            Date startDate = depDy.getDate("startdate");
            Date endDate = depDy.getDate("enddate");
            Date sysEndDate = depDy.getDate("sysenddate");
            long postId = depDy.getLong("position.id");
            if (postId != 0L) {
                DynamicObject roleDy = (DynamicObject)postMap.get(postId);
                if (roleDy == null) continue;
                workRoleDy.set("role", roleDy.get("workrole"));
                workRoleDy.set("mainpeoincharge", roleDy.get("workrole.mainpeoincharge"));
                workRoleDy.set("adminorg", roleDy.get("workrole.adminorg"));
            }
            workRoleDy.set("bsed", depDy.get("bsed"));
            workRoleDy.set("businessstatus", depDy.get("businessstatus"));
            workRoleDy.set("initbatch", depDy.get("initbatch"));
            workRoleDy.set("initstatus", (Object)"2");
            workRoleDy.set("employee", depDy.get("employee"));
            workRoleDy.set("person", depDy.get("person"));
            workRoleDy.set("cmpemp", depDy.get("cmpemp"));
            workRoleDy.set("depemp", depDy.get("depemp"));
            workRoleDy.set("startdate", (Object)startDate);
            workRoleDy.set("enddate", (Object)endDate);
            workRoleDy.set("sysenddate", (Object)sysEndDate);
            InitValidateUtil.wrapCommonFieldProcessed((DynamicObject)workRoleDy);
            workRoleCollection.add((Object)workRoleDy);
        }
        return workRoleCollection;
    }
}

