/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;

public class ChargePersonUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ChargePersonUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOG.info("ChargePersonUpgradeTask start:");
        try (TXHandle required = TX.required();){
            try {
                new ChargeApplicationImpl().dataUpgrade();
                ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.disableJob("3=6M+GVFQ6SE");
                LOG.info("ChargePersonUpgradeTask disable job:3=6M+GVFQ6SE");
                scheduleManager.disableSchedule("3=6QYD+016BL");
                LOG.info("ChargePersonUpgradeTask disable schedule:3=6QYD+016BL");
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error((Throwable)ex);
                throw ex;
            }
        }
        LOG.info("ChargePersonUpgradeTask end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }
}

