/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.HisModelParamUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import org.apache.commons.lang.time.StopWatch;

public class CorrectionInitQuitEmpDataTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(CorrectionInitQuitEmpDataTask.class);
    private static final HRBaseServiceHelper LABORRELSTATUS_HELPER = new HRBaseServiceHelper("hbss_laborrelstatus");
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");
    private static final HRBaseServiceHelper CMPEMP_HELPER = new HRBaseServiceHelper("hrpi_cmpemp");
    private static final HRBaseServiceHelper MANAGINGSCOPE_HELPER = new HRBaseServiceHelper("hrpi_managingscope");
    private static final int TOP = 1000;
    private final Map<Long, Long> relationLabrelstatusMap = new HashMap<Long, Long>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("CorrectionInitQuitEmpDataTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.doExecute(map);
        }
        finally {
            stopWatch.stop();
            LOGGER.info("CorrectionInitQuitEmpDataTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void doExecute(Map<String, Object> map) {
        long eventId = ORM.create().genLongId(EMPLOYEE_HELPER.getEntityName());
        this.initLaborrelstatus();
        long id = this.initId(map);
        String qcp = map.get("empentrel") == null ? ">" : "=";
        try {
            DynamicObject[] dyArray;
            while ((dyArray = this.queryQuitEmpentrel(id, qcp)) != null && dyArray.length > 0) {
                Set<Long> employeeIdSet = Arrays.stream(dyArray).map(arg -> arg.getLong("employee_id")).collect(Collectors.toSet());
                this.filterNeedUpdateEmployee(employeeIdSet);
                if (!employeeIdSet.isEmpty()) {
                    this.doCorrectionExecute(employeeIdSet, eventId);
                }
                if (dyArray.length >= 1000) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_correctionInitQuitEmpDataTask_ex", (Throwable)ex);
        }
    }

    private long initId(Map<String, Object> map) {
        String empentrelIdStr = (String)map.get("empentrel");
        return HRStringUtils.isEmpty((String)empentrelIdStr) ? 0L : Long.parseLong(empentrelIdStr);
    }

    private void initLaborrelstatus() {
        DynamicObject[] endPrdLabrelstatusDyArr;
        DynamicObject[] ingPrdLabrelstatusDyArr = LABORRELSTATUS_HELPER.query("id,laborreltypecls", new QFilter[]{new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING), new QFilter("labrelstatuscls", "=", (Object)HRPIValueConstants.LABRELSTATUSCLS_ON)}, "issyspreset desc");
        HashMap<Long, Long> laborreltypeclsKeyIngLabrelstatusMap = new HashMap<Long, Long>(16);
        for (DynamicObject ingPrdLabrelstatusDy : ingPrdLabrelstatusDyArr) {
            long ingLabrelstatusId = ingPrdLabrelstatusDy.getLong("id");
            DynamicObjectCollection laborreltypeclsDyColl = ingPrdLabrelstatusDy.getDynamicObjectCollection("laborreltypecls");
            for (DynamicObject laborreltypeclsBaseDy : laborreltypeclsDyColl) {
                DynamicObject laborreltypeclsDy = laborreltypeclsBaseDy.getDynamicObject("fbasedataid");
                long laborreltypeclsId = laborreltypeclsDy.getLong("id");
                laborreltypeclsKeyIngLabrelstatusMap.putIfAbsent(laborreltypeclsId, ingLabrelstatusId);
            }
        }
        for (DynamicObject endPrdLabrelstatusDy : endPrdLabrelstatusDyArr = LABORRELSTATUS_HELPER.query("id,laborreltypecls", new QFilter[]{new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_END)})) {
            long endLabrelstatusId = endPrdLabrelstatusDy.getLong("id");
            DynamicObjectCollection laborreltypeclsDyColl = endPrdLabrelstatusDy.getDynamicObjectCollection("laborreltypecls");
            for (DynamicObject laborreltypeclsBaseDy : laborreltypeclsDyColl) {
                DynamicObject laborreltypeclsDy = laborreltypeclsBaseDy.getDynamicObject("fbasedataid");
                long laborreltypeclsId = laborreltypeclsDy.getLong("id");
                String laborreltypeclsName = laborreltypeclsDy.getString("name");
                Long ingLabrelstatusId = (Long)laborreltypeclsKeyIngLabrelstatusMap.get(laborreltypeclsId);
                if (ingLabrelstatusId == null) {
                    LOGGER.info("CorrectionInitQuitEmpDataTask#initLaborrelstatus laborreltypecls:{} cant match ingLabrelstatus.", (Object)laborreltypeclsName);
                    continue;
                }
                this.relationLabrelstatusMap.putIfAbsent(endLabrelstatusId, ingLabrelstatusId);
            }
        }
    }

    private DynamicObject[] queryQuitEmpentrel(long id, String qcp) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initdatasourceFilter = new QFilter("initdatasource", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter initbatchFilter = new QFilter("initbatch", ">", (Object)0);
        QFilter labrelstatusprdFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
        QFilter idFilter = new QFilter("id", qcp, (Object)id);
        QFilter[] qFilters = new QFilter[]{idFilter, statusFilter, iscurrFilter, initdatasourceFilter, initbatchFilter, initstatusFilter, labrelstatusprdFilter};
        return EMPENTREL_HELPER.query("employee", qFilters, "id", 1000);
    }

    private void filterNeedUpdateEmployee(Set<Long> employeeIdSet) {
        QFilter boidFilter = new QFilter("boid", "in", employeeIdSet);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"2");
        DynamicObject[] loseffectEmployeeArr = EMPLOYEE_HELPER.query("boid", new QFilter[]{boidFilter, statusFilter});
        if (loseffectEmployeeArr != null && loseffectEmployeeArr.length > 0) {
            Set loseffectEmployeeIdSet = Arrays.stream(loseffectEmployeeArr).map(arg -> arg.getLong("boid")).collect(Collectors.toSet());
            LOGGER.info("CorrectionInitQuitEmpDataTask#filterNeedUpdateEmployee loseffectEmployeeIdSet:{}", loseffectEmployeeIdSet);
            employeeIdSet.removeAll(loseffectEmployeeIdSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCorrectionExecute(Set<Long> employeeIdSet, long eventId) {
        List<DynamicObjectCollection> dyCollList = this.buildCorrectionData(employeeIdSet);
        try (TXHandle txHandle = TX.requiresNew();){
            HisVersionParamListBo params = HisModelParamUtil.createHisVersionParamListBo(dyCollList, eventId);
            HisResponse response = HisModelController.getInstance().batchHisVersionChange(params);
            if (!HRStringUtils.equals((String)response.getCode(), (String)"200")) {
                LOGGER.info("CorrectionInitQuitEmpDataTask#doCorrectionExecute ==> request fail", (Object)response.getErrorMessage());
                txHandle.markRollback();
            }
        }
    }

    private List<DynamicObjectCollection> buildCorrectionData(Set<Long> employeeIdSet) {
        Map<Long, DynamicObject> sourceEmployeeDyMap = this.queryNowVersionEmployee(employeeIdSet);
        Map<Long, DynamicObject> sourceEmpentrelDyMap = this.queryNowVersionEmpentrel(employeeIdSet);
        Map<Long, List<DynamicObject>> sourceCmpempDyMap = this.queryNowVersionCmpemp(employeeIdSet);
        Map<Long, List<DynamicObject>> sourceManagingscopeDyMap = this.queryNowVersionManagingscope(employeeIdSet);
        ArrayList<DynamicObjectCollection> dyCollList = new ArrayList<DynamicObjectCollection>(10);
        DynamicObjectCollection copyEmployeeDyColl = new DynamicObjectCollection();
        DynamicObjectCollection copyEmpentrelDyColl = new DynamicObjectCollection();
        DynamicObjectCollection copyCmpempDyColl = new DynamicObjectCollection();
        DynamicObjectCollection copyManagingscopeDyColl = new DynamicObjectCollection();
        for (Long employeeId : employeeIdSet) {
            DynamicObject copyHisEmployeeDy = this.copyAndSetHisEmployee(employeeId, sourceEmployeeDyMap);
            DynamicObject copyNewVersionEmployeeDy = this.copyAndSetNewVersionEmployee(employeeId, sourceEmployeeDyMap);
            DynamicObject copyHisEmpentrelDy = this.copyAndSetHisEmpentrel(employeeId, sourceEmpentrelDyMap);
            DynamicObject copyNewVersionEmpentrelDy = this.copyAndSetNewVersionEmpentrel(employeeId, sourceEmpentrelDyMap);
            List<DynamicObject> copyHisCmpempDyList = this.copyAndSetHisCmpemp(employeeId, sourceCmpempDyMap);
            List<DynamicObject> copyNewVersionCmpempDyList = this.copyAndSetNewVersionCmpemp(employeeId, sourceCmpempDyMap);
            List<DynamicObject> copyHisManagingscopeDyList = this.copyAndSetHisManagingscope(employeeId, sourceManagingscopeDyMap);
            List<DynamicObject> copyNewVersionManagingscopeDyList = this.copyAndSetNewVersionManagingscope(employeeId, sourceManagingscopeDyMap);
            copyEmployeeDyColl.add((Object)copyHisEmployeeDy);
            copyEmployeeDyColl.add((Object)copyNewVersionEmployeeDy);
            copyEmpentrelDyColl.add((Object)copyHisEmpentrelDy);
            copyEmpentrelDyColl.add((Object)copyNewVersionEmpentrelDy);
            if (!CollectionUtils.isEmpty(copyHisCmpempDyList)) {
                copyCmpempDyColl.addAll(copyHisCmpempDyList);
            }
            if (!CollectionUtils.isEmpty(copyNewVersionCmpempDyList)) {
                copyCmpempDyColl.addAll(copyNewVersionCmpempDyList);
            }
            if (!CollectionUtils.isEmpty(copyHisManagingscopeDyList)) {
                copyManagingscopeDyColl.addAll(copyHisManagingscopeDyList);
            }
            if (CollectionUtils.isEmpty(copyNewVersionManagingscopeDyList)) continue;
            copyManagingscopeDyColl.addAll(copyNewVersionManagingscopeDyList);
        }
        dyCollList.add(copyEmployeeDyColl);
        dyCollList.add(copyEmpentrelDyColl);
        dyCollList.add(copyCmpempDyColl);
        dyCollList.add(copyManagingscopeDyColl);
        return dyCollList;
    }

    private Map<Long, DynamicObject> queryNowVersionEmployee(Set<Long> employeeIdSet) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter boidFilter = new QFilter("boid", "in", employeeIdSet);
        DynamicObject[] sourceEmployeeDyArr = EMPLOYEE_HELPER.loadDynamicObjectArray(new QFilter[]{statusFilter, iscurrFilter, boidFilter});
        return Arrays.stream(sourceEmployeeDyArr).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
    }

    private Map<Long, DynamicObject> queryNowVersionEmpentrel(Set<Long> employeeIdSet) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter employeeFilter = new QFilter("employee", "in", employeeIdSet);
        DynamicObject[] sourceEmpentrelDyArr = EMPENTREL_HELPER.loadDynamicObjectArray(new QFilter[]{statusFilter, iscurrFilter, employeeFilter});
        return Arrays.stream(sourceEmpentrelDyArr).collect(Collectors.toMap(dy -> dy.getLong("employee_id"), dy -> dy));
    }

    private Map<Long, List<DynamicObject>> queryNowVersionCmpemp(Set<Long> employeeIdSet) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter employeeFilter = new QFilter("employee", "in", employeeIdSet);
        DynamicObject[] sourceCmpempDyArr = CMPEMP_HELPER.loadDynamicObjectArray(new QFilter[]{statusFilter, iscurrFilter, employeeFilter});
        return Arrays.stream(sourceCmpempDyArr).collect(Collectors.groupingBy(dy -> dy.getLong("employee_id")));
    }

    private Map<Long, List<DynamicObject>> queryNowVersionManagingscope(Set<Long> employeeIdSet) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter employeeFilter = new QFilter("employee", "in", employeeIdSet);
        DynamicObject[] sourceManagingscopeDyArr = MANAGINGSCOPE_HELPER.loadDynamicObjectArray(new QFilter[]{statusFilter, iscurrFilter, employeeFilter});
        return Arrays.stream(sourceManagingscopeDyArr).collect(Collectors.groupingBy(dy -> dy.getLong("employee_id")));
    }

    private DynamicObject copyAndSetHisEmployee(Long employeeId, Map<Long, DynamicObject> sourceEmployeeDyMap) {
        DynamicObject sourceEmployeeDy = sourceEmployeeDyMap.get(employeeId);
        DynamicObject copyHisEmployeeDy = EMPLOYEE_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sourceEmployeeDy, (DynamicObject)copyHisEmployeeDy);
        long laborrelstatusId = sourceEmployeeDy.getLong("laborrelstatus.id");
        Long ingLabrelstatusId = this.relationLabrelstatusMap.getOrDefault(laborrelstatusId, 0L);
        copyHisEmployeeDy.set("laborrelstatus", (Object)ingLabrelstatusId);
        copyHisEmployeeDy.set("laborrelstatus_id", (Object)ingLabrelstatusId);
        copyHisEmployeeDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
        copyHisEmployeeDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
        copyHisEmployeeDy.set("bsled", sourceEmployeeDy.get("enddate"));
        return copyHisEmployeeDy;
    }

    private DynamicObject copyAndSetHisEmpentrel(Long employeeId, Map<Long, DynamicObject> sourceEmpentrelDyMap) {
        DynamicObject sourceEmpentrelDy = sourceEmpentrelDyMap.get(employeeId);
        DynamicObject copyHisEmpentrelDy = EMPENTREL_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sourceEmpentrelDy, (DynamicObject)copyHisEmpentrelDy);
        long laborrelstatusId = sourceEmpentrelDy.getLong("laborrelstatus.id");
        Long ingLabrelstatusId = this.relationLabrelstatusMap.getOrDefault(laborrelstatusId, 0L);
        copyHisEmpentrelDy.set("laborrelstatus", (Object)ingLabrelstatusId);
        copyHisEmpentrelDy.set("laborrelstatus_id", (Object)ingLabrelstatusId);
        copyHisEmpentrelDy.set("labrelstatusprd", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        copyHisEmpentrelDy.set("labrelstatusprd_id", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        copyHisEmpentrelDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
        copyHisEmpentrelDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
        copyHisEmpentrelDy.set("bsled", sourceEmpentrelDy.get("enddate"));
        return copyHisEmpentrelDy;
    }

    private List<DynamicObject> copyAndSetHisCmpemp(Long employeeId, Map<Long, List<DynamicObject>> sourceCmpempDyMap) {
        List<DynamicObject> sourceCmpEmpDyList = sourceCmpempDyMap.get(employeeId);
        if (CollectionUtils.isEmpty(sourceCmpEmpDyList)) {
            return null;
        }
        return sourceCmpEmpDyList.stream().map(sourceCmpEmpDy -> {
            DynamicObject copyHisCmpempDy = CMPEMP_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceCmpEmpDy, (DynamicObject)copyHisCmpempDy);
            copyHisCmpempDy.set("businessstatus", (Object)"1");
            copyHisCmpempDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
            copyHisCmpempDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
            copyHisCmpempDy.set("bsled", sourceCmpEmpDy.get("enddate"));
            return copyHisCmpempDy;
        }).collect(Collectors.toList());
    }

    private List<DynamicObject> copyAndSetHisManagingscope(Long employeeId, Map<Long, List<DynamicObject>> sourceManagingscopeDyMap) {
        List<DynamicObject> sourceManagingscopeDyList = sourceManagingscopeDyMap.get(employeeId);
        if (CollectionUtils.isEmpty(sourceManagingscopeDyList)) {
            return null;
        }
        return sourceManagingscopeDyList.stream().map(sourceManagingscopeDy -> {
            DynamicObject copyHisManagingscopeDy = MANAGINGSCOPE_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceManagingscopeDy, (DynamicObject)copyHisManagingscopeDy);
            copyHisManagingscopeDy.set("businessstatus", (Object)"1");
            copyHisManagingscopeDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
            copyHisManagingscopeDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
            copyHisManagingscopeDy.set("bsled", sourceManagingscopeDy.get("enddate"));
            return copyHisManagingscopeDy;
        }).collect(Collectors.toList());
    }

    private DynamicObject copyAndSetNewVersionEmployee(Long employeeId, Map<Long, DynamicObject> sourceEmployeeDyMap) {
        DynamicObject sourceEmployeeDy = sourceEmployeeDyMap.get(employeeId);
        DynamicObject copyNewVersionEmployeeDy = EMPLOYEE_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sourceEmployeeDy, (DynamicObject)copyNewVersionEmployeeDy);
        copyNewVersionEmployeeDy.set("bsed", sourceEmployeeDy.get("sysenddate"));
        return copyNewVersionEmployeeDy;
    }

    private DynamicObject copyAndSetNewVersionEmpentrel(Long employeeId, Map<Long, DynamicObject> sourceEmpentrelDyMap) {
        DynamicObject sourceEmpentrelDy = sourceEmpentrelDyMap.get(employeeId);
        DynamicObject copyNewVersionEmpentrelDy = EMPENTREL_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)sourceEmpentrelDy, (DynamicObject)copyNewVersionEmpentrelDy);
        copyNewVersionEmpentrelDy.set("bsed", sourceEmpentrelDy.get("sysenddate"));
        return copyNewVersionEmpentrelDy;
    }

    private List<DynamicObject> copyAndSetNewVersionCmpemp(Long employeeId, Map<Long, List<DynamicObject>> sourceCmpempDyMap) {
        List<DynamicObject> sourceCmpEmpDyList = sourceCmpempDyMap.get(employeeId);
        if (CollectionUtils.isEmpty(sourceCmpEmpDyList)) {
            return null;
        }
        return sourceCmpEmpDyList.stream().map(sourceCmpEmpDy -> {
            DynamicObject copyNewVersionCmpempDy = CMPEMP_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceCmpEmpDy, (DynamicObject)copyNewVersionCmpempDy);
            copyNewVersionCmpempDy.set("bsed", sourceCmpEmpDy.get("sysenddate"));
            return copyNewVersionCmpempDy;
        }).collect(Collectors.toList());
    }

    private List<DynamicObject> copyAndSetNewVersionManagingscope(Long employeeId, Map<Long, List<DynamicObject>> sourceManagingscopeDyMap) {
        List<DynamicObject> sourceManagingscopeDyList = sourceManagingscopeDyMap.get(employeeId);
        if (CollectionUtils.isEmpty(sourceManagingscopeDyList)) {
            return null;
        }
        return sourceManagingscopeDyList.stream().map(sourceManagingscopeDy -> {
            DynamicObject copyNewVersionManagingscopeDy = MANAGINGSCOPE_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)sourceManagingscopeDy, (DynamicObject)copyNewVersionManagingscopeDy);
            copyNewVersionManagingscopeDy.set("bsed", sourceManagingscopeDy.get("sysenddate"));
            return copyNewVersionManagingscopeDy;
        }).collect(Collectors.toList());
    }
}

